/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.RequiredPropertiesManager;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.AttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredPropertiesEditor
extends OperationDetailsAspectEditor {
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<RequiredProperty> fRequiredProperties;
    private TreeViewer fPropertiesViewer;
    private List<TypeCategory> fCategories;
    private Map<ModeledElement, RequiredProperty> fPropertyTypeMap;
    private List<Attribute> fBuiltInAttributes;
    private List<WFWorkflow> fWorkflows;
    private List<WorkflowBinding> fBindings;
    private Map<ModeledElement, List<TypeState>> fTypeWorkflowMap;
    private TypeCategory fUnspecified;
    private RequiredProperty fRootProperty;

    public void restoreState(IMemento memento) {
        String type;
        String typeCategory;
        IMemento properties;
        this.fRequiredProperties = new ArrayList<RequiredProperty>();
        this.fPropertyTypeMap = new HashMap<ModeledElement, RequiredProperty>();
        IMemento[] iMementoArray = memento.getChildren("properties");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            properties = iMementoArray[n2];
            typeCategory = properties.getString("workItemTypeCategory");
            type = properties.getString("workItemType");
            if (typeCategory == null && type == null) {
                this.fRootProperty = new RequiredProperty(new ModeledElement(){

                    public String getIdentifier() {
                        return "rootProperty";
                    }
                });
                IMemento[] iMementoArray2 = properties.getChildren("property");
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento property = iMementoArray2[n4];
                    String id = property.getString("id");
                    if (id != null) {
                        this.fRootProperty.addRequiredAttribute(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier(), this.getAttributeName(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier())));
                    }
                    ++n4;
                }
            } else {
                ModeledElement typeOrCategory;
                if (typeCategory != null) {
                    typeOrCategory = this.findOrCreateTypeCategory(typeCategory);
                } else {
                    typeOrCategory = this.findType(type);
                    if (typeOrCategory == null) {
                        typeOrCategory = this.createTypeInUnspecifiedCategory(type);
                    }
                }
                RequiredProperty prop = new RequiredProperty(typeOrCategory);
                IMemento[] iMementoArray3 = properties.getChildren("property");
                int id = iMementoArray3.length;
                int n5 = 0;
                while (n5 < id) {
                    IMemento property = iMementoArray3[n5];
                    String id2 = property.getString("id");
                    if (id2 != null) {
                        prop.addRequiredAttribute(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)id2).getStringIdentifier(), this.getAttributeName(WorkItemAttributes.getPropertyIdentifier((String)id2).getStringIdentifier())));
                    }
                    ++n5;
                }
                this.fRequiredProperties.add(prop);
                this.fPropertyTypeMap.put(typeOrCategory, prop);
            }
            ++n2;
        }
        this.fTypeWorkflowMap = new HashMap<ModeledElement, List<TypeState>>();
        iMementoArray = memento.getChildren("workflowProperties");
        n = iMementoArray.length;
        n2 = 0;
        while (n2 < n) {
            properties = iMementoArray[n2];
            typeCategory = properties.getString("workItemTypeCategory");
            type = properties.getString("workItemType");
            String stateId = properties.getString("stateId");
            if (stateId != null && (type != null || typeCategory != null)) {
                ModeledElement typeOrCategory;
                TypeState typeState = null;
                if (typeCategory != null) {
                    typeOrCategory = this.findOrCreateTypeCategory(typeCategory);
                } else {
                    typeOrCategory = this.findType(type);
                    if (typeOrCategory == null) {
                        typeOrCategory = this.createTypeInUnspecifiedCategory(type);
                    }
                }
                WFWorkflow.WFState s = this.getState(typeOrCategory, stateId);
                if (s != null) {
                    typeState = this.findOrCreateTypeState(typeOrCategory, s);
                    RequiredWorkflowProperty prop = new RequiredWorkflowProperty(typeState);
                    IMemento[] iMementoArray4 = properties.getChildren("property");
                    int n6 = iMementoArray4.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        IMemento property = iMementoArray4[n7];
                        String id = property.getString("id");
                        if (id != null) {
                            prop.addRequiredAttribute(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier(), this.getAttributeName(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier())));
                        }
                        ++n7;
                    }
                    this.fRequiredProperties.add(prop);
                    this.fPropertyTypeMap.put(typeState, prop);
                }
            }
            ++n2;
        }
    }

    private TypeCategory.Type createTypeInUnspecifiedCategory(String typeId) {
        if (this.fUnspecified == null) {
            this.fUnspecified = new TypeCategory(Messages.RequiredPropertiesEditor_UNSPECIFIED);
            this.fCategories.add(this.fUnspecified);
        }
        TypeCategory typeCategory = this.fUnspecified;
        typeCategory.getClass();
        TypeCategory.Type type = new TypeCategory.Type(typeCategory, typeId, typeId, null, null, new ArrayList<String>());
        this.fUnspecified.addType(type);
        return type;
    }

    private TypeCategory findOrCreateTypeCategory(String typeCategoryId) {
        if (this.fCategories == null || typeCategoryId == null) {
            return null;
        }
        for (TypeCategory t : this.fCategories) {
            if (!typeCategoryId.equals(t.getIdentifier())) continue;
            return t;
        }
        TypeCategory typeCategory = new TypeCategory(typeCategoryId);
        this.fCategories.add(typeCategory);
        return typeCategory;
    }

    private TypeCategory.Type findType(String typeId) {
        if (this.fCategories == null || typeId == null) {
            return null;
        }
        for (TypeCategory cat : this.fCategories) {
            for (TypeCategory.Type t : cat.getTypes()) {
                if (!t.getId().equals(typeId)) continue;
                return t;
            }
        }
        return null;
    }

    private TypeState findOrCreateTypeState(ModeledElement typeOrCategory, WFWorkflow.WFState state) {
        TypeState ts2;
        List<TypeState> list = this.fTypeWorkflowMap.get(typeOrCategory);
        if (list != null) {
            for (TypeState ts2 : list) {
                if (ts2.getState() != state) continue;
                return ts2;
            }
        }
        ts2 = new TypeState(typeOrCategory, state);
        if (this.fTypeWorkflowMap.get(typeOrCategory) == null) {
            this.fTypeWorkflowMap.put(typeOrCategory, new ArrayList());
        }
        this.fTypeWorkflowMap.get(typeOrCategory).add(ts2);
        return ts2;
    }

    private void initializeWorkflows() {
        ModelElement workflowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        this.fWorkflows = workflowElement != null ? WorkflowManager.readWorkflows(workflowElement) : Collections.emptyList();
        ModelElement bindingElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding");
        this.fBindings = bindingElement != null ? WorkflowBindingManager.readWorkflowBindings(bindingElement) : Collections.emptyList();
    }

    private WFWorkflow.WFState getState(ModeledElement typeOrCategory, String stateId) {
        if (this.fWorkflows == null) {
            this.initializeWorkflows();
        }
        String categoryId = null;
        if (typeOrCategory instanceof TypeCategory) {
            categoryId = ((TypeCategory)typeOrCategory).getIdentifier();
        } else if (typeOrCategory instanceof TypeCategory.Type) {
            categoryId = this.findCategory((TypeCategory.Type)typeOrCategory).getIdentifier();
        }
        String workflowId = null;
        for (WorkflowBinding b : this.fBindings) {
            if (!b.getCategoryId().equals(categoryId)) continue;
            workflowId = b.getWorkflowId();
            break;
        }
        for (WFWorkflow w : this.fWorkflows) {
            if (!w.getIdentifier().equals(workflowId)) continue;
            for (WFWorkflow.WFState s : w.getStates()) {
                if (!s.getId().equals(stateId)) continue;
                return s;
            }
        }
        return null;
    }

    private List<Attribute> getBuiltInAttributes() {
        if (this.fBuiltInAttributes == null) {
            final IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
            final ArrayList attributes = new ArrayList();
            if (processItem instanceof IProcessArea) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IProcessArea processArea = (IProcessArea)processItem;
                            ITeamRepository teamRepository = (ITeamRepository)processItem.getOrigin();
                            IWorkItemClient workitemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                            try {
                                List builtInAttributes = workitemClient.findBuiltInAttributes(processArea.getProjectArea(), monitor);
                                attributes.addAll(workitemClient.getAuditableCommon().resolveAuditablesPermissionAware(builtInAttributes, IAttribute.SMALL_PROFILE, monitor));
                            }
                            catch (TeamRepositoryException e) {
                                WorkItemIDEUIPlugin.getDefault().log(Messages.RequiredPropertiesEditor_ERROR_RETRIEVING_ATTRIBUTES, e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.RequiredPropertiesEditor_ERROR_RETRIEVING_ATTRIBUTES, e);
                    return Collections.emptyList();
                }
                catch (InterruptedException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.RequiredPropertiesEditor_ERROR_RETRIEVING_ATTRIBUTES, e);
                    return Collections.emptyList();
                }
                this.fBuiltInAttributes = new ArrayList<Attribute>();
                for (IAttribute a : attributes) {
                    if (a.isInternal()) continue;
                    Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)a.getIdentifier());
                    this.fBuiltInAttributes.add(new Attribute(ident.getStringIdentifier(), a.getDisplayName()));
                }
            } else if (processItem instanceof IProcessDefinition) {
                this.fBuiltInAttributes = new ArrayList<Attribute>();
                AttributeDescriptor[] attributeDescriptorArray = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS;
                int n = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeDescriptor desc = attributeDescriptorArray[n2];
                    if (!desc.isInternal()) {
                        Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)desc.getIdentifier());
                        this.fBuiltInAttributes.add(new Attribute(ident.getStringIdentifier(), desc.getDisplayName()));
                    }
                    ++n2;
                }
            } else {
                throw new UnsupportedOperationException(Messages.RequiredPropertiesEditor_NEITHER_AREA_NOR_DEFINITION);
            }
        }
        return this.fBuiltInAttributes;
    }

    private String getAttributeName(String attributeId) {
        for (Attribute a : this.getBuiltInAttributes()) {
            if (!a.getId().equals(attributeId)) continue;
            return a.getName();
        }
        for (TypeCategory cat : this.fCategories) {
            for (TypeCategory.CustomAttribute c : cat.getCustomAttributes()) {
                if (!c.getId().equals(attributeId)) continue;
                return c.getName();
            }
        }
        return attributeId;
    }

    public boolean saveState(IMemento memento) {
        if (this.fRequiredProperties.size() == 0) {
            return false;
        }
        for (RequiredProperty prop : this.fRequiredProperties) {
            IMemento attr;
            IMemento properties;
            if (prop instanceof RequiredWorkflowProperty) {
                if (prop.getRequiredAttributes().isEmpty()) continue;
                properties = memento.createChild("workflowProperties");
                properties.putString("stateId", ((RequiredWorkflowProperty)prop).getState().getId());
                if (prop.getTypeOrCategory() instanceof TypeCategory) {
                    properties.putString("workItemTypeCategory", prop.getTypeOrCategory().getIdentifier());
                } else {
                    if (!(prop.getTypeOrCategory() instanceof TypeCategory.Type)) continue;
                    properties.putString("workItemType", prop.getTypeOrCategory().getIdentifier());
                }
                for (Attribute a : prop.getRequiredAttributes()) {
                    attr = properties.createChild("property");
                    attr.putString("id", a.getId());
                }
                continue;
            }
            properties = memento.createChild("properties");
            if (prop.getTypeOrCategory() instanceof TypeCategory) {
                properties.putString("workItemTypeCategory", prop.getTypeOrCategory().getIdentifier());
            } else if (prop.getTypeOrCategory() instanceof TypeCategory.Type) {
                properties.putString("workItemType", prop.getTypeOrCategory().getIdentifier());
            } else if (this.fRootProperty == null || this.fRootProperty.getRequiredAttributes().isEmpty()) continue;
            for (Attribute a : prop.getRequiredAttributes()) {
                attr = properties.createChild("property");
                attr.putString("id", a.getId());
            }
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Tree t = new Tree(parent, 67586);
        t.setLayoutData((Object)new GridData(4, 4, true, true));
        t.setHeaderVisible(true);
        TreeColumn c = new TreeColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(Messages.RequiredPropertiesEditor_CATEGORY_OR_TYPE_LABEL);
        c = new TreeColumn(t, 0);
        c.setWidth(200);
        c.setResizable(true);
        c.setText(Messages.RequiredPropertiesEditor_ATTRIBUTES_LABEL);
        this.fPropertiesViewer = new TreeViewer(t);
        this.fPropertiesViewer.setColumnProperties(new String[]{Messages.RequiredPropertiesEditor_PROPERTY, Messages.RequiredPropertiesEditor_ATTRIBUTES});
        this.fPropertiesViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (cell.getColumnIndex() == 0 && element instanceof TypeCategory.Type) {
                    if (((TypeCategory.Type)element).getIcon() != null) {
                        cell.setImage(this.getImage(element, ((TypeCategory.Type)element).getIcon()));
                    } else {
                        cell.setImage(null);
                    }
                    cell.setText(((TypeCategory.Type)element).getName());
                } else if (cell.getColumnIndex() == 0 && element instanceof TypeCategory) {
                    cell.setText(((TypeCategory)element).getIdentifier());
                    cell.setImage(JazzResources.getImage((ResourceManager)RequiredPropertiesEditor.this.fResourceManager, (ImageDescriptor)ImagePool.TYPE_CATEGORY, null));
                } else if (cell.getColumnIndex() == 0 && element instanceof TypeState) {
                    TypeState state = (TypeState)element;
                    cell.setText(state.getState().getName());
                    if (state.getState().getIcon() != null) {
                        cell.setImage(this.getImage(element, state.getState().getIcon()));
                    } else {
                        cell.setImage(null);
                    }
                } else if (cell.getColumnIndex() == 1) {
                    String attributes = this.getAttributes((ModeledElement)element);
                    cell.setText(attributes);
                    if (RequiredPropertiesEditor.this.fPropertyTypeMap.get(element) == null || ((RequiredProperty)RequiredPropertiesEditor.this.fPropertyTypeMap.get(element)).getRequiredAttributes().isEmpty()) {
                        cell.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
                        cell.getViewerRow().setForeground(0, WorkItemIDEUIPlugin.getDefault().getMidShadow());
                    } else {
                        cell.setForeground(null);
                        cell.getViewerRow().setForeground(0, null);
                    }
                }
            }

            private String getAttributes(ModeledElement element) {
                RequiredProperty prop;
                HashSet<Attribute> attributes = new HashSet<Attribute>();
                HashSet<Attribute> inheritedAttributes = new HashSet<Attribute>();
                if (element instanceof TypeCategory) {
                    prop = (RequiredProperty)RequiredPropertiesEditor.this.fPropertyTypeMap.get(element);
                    if (prop != null) {
                        attributes.addAll(prop.getRequiredAttributes());
                    }
                    if (RequiredPropertiesEditor.this.fRootProperty != null) {
                        inheritedAttributes.addAll(RequiredPropertiesEditor.this.fRootProperty.getRequiredAttributes());
                    }
                } else if (element instanceof TypeCategory.Type) {
                    prop = (RequiredProperty)RequiredPropertiesEditor.this.fPropertyTypeMap.get(element);
                    if (prop != null) {
                        attributes.addAll(prop.getRequiredAttributes());
                    }
                    TypeCategory parentElement = RequiredPropertiesEditor.this.findCategory((TypeCategory.Type)element);
                    RequiredProperty parent = (RequiredProperty)RequiredPropertiesEditor.this.fPropertyTypeMap.get(parentElement);
                    if (parent != null) {
                        inheritedAttributes.addAll(parent.getRequiredAttributes());
                    }
                    if (RequiredPropertiesEditor.this.fRootProperty != null) {
                        inheritedAttributes.addAll(RequiredPropertiesEditor.this.fRootProperty.getRequiredAttributes());
                    }
                } else if (element instanceof TypeState) {
                    TypeState typeState = (TypeState)element;
                    RequiredProperty prop2 = (RequiredProperty)RequiredPropertiesEditor.this.fPropertyTypeMap.get(element);
                    if (prop2 != null) {
                        attributes.addAll(prop2.getRequiredAttributes());
                    }
                    TypeState parentElement = null;
                    if (typeState.getType() instanceof TypeCategory.Type) {
                        parentElement = RequiredPropertiesEditor.this.findOrCreateTypeState(RequiredPropertiesEditor.this.findCategory((TypeCategory.Type)typeState.getType()), typeState.getState());
                        RequiredProperty parent = (RequiredProperty)RequiredPropertiesEditor.this.fPropertyTypeMap.get(parentElement);
                        if (parent != null) {
                            inheritedAttributes.addAll(parent.getRequiredAttributes());
                        }
                    }
                }
                String result = "";
                ArrayList atts = new ArrayList(attributes);
                Collections.sort(atts, new Comparator<Attribute>(){

                    @Override
                    public int compare(Attribute o1, Attribute o2) {
                        if (o1.getName() != null && o2.getName() != null) {
                            return Collator.getInstance().compare(o1.getName(), o2.getName());
                        }
                        return -1;
                    }
                });
                for (Attribute a : atts) {
                    result = NLS.bind((String)Messages.RequiredPropertiesEditor_LIST_ELEMENT, (Object)result, (Object[])new Object[]{a.getName()});
                }
                result = atts.isEmpty() ? Messages.RequiredPropertiesEditor_NONE : result.substring(2);
                if (!inheritedAttributes.isEmpty()) {
                    String inheritedResult = "";
                    ArrayList inherited = new ArrayList(inheritedAttributes);
                    Collections.sort(inherited, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute o1, Attribute o2) {
                            if (o1.getName() != null && o2.getName() != null) {
                                return Collator.getInstance().compare(o1.getName(), o2.getName());
                            }
                            return -1;
                        }
                    });
                    for (Attribute a : inherited) {
                        inheritedResult = NLS.bind((String)Messages.RequiredPropertiesEditor_LIST_ELEMENT, (Object)inheritedResult, (Object[])new Object[]{a.getName()});
                    }
                    inheritedResult = inheritedResult.substring(2);
                    result = NLS.bind((String)Messages.RequiredPropertiesEditor_LIST_INHERITED, (Object)result, (Object[])new Object[]{inheritedResult});
                }
                return result;
            }

            private Image getImage(final Object element, String iconPath) {
                return AspectEditorUtil.getImage(RequiredPropertiesEditor.this.getAspect().getProcessContainerWorkingCopy(), iconPath, RequiredPropertiesEditor.this.fResourceManager, new Runnable(){

                    public void run() {
                        this.fireChanged(element);
                    }
                });
            }

            private void fireChanged(Object element) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
            }
        });
        this.fPropertiesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                List list;
                if (parentElement instanceof TypeCategory) {
                    ArrayList<TypeCategory.Type> types = new ArrayList<TypeCategory.Type>();
                    types.addAll(((TypeCategory)parentElement).getTypes());
                    types.addAll(0, RequiredPropertiesEditor.this.findTypeStates((TypeCategory)parentElement));
                    return types.toArray();
                }
                if (parentElement instanceof TypeCategory.Type && (list = RequiredPropertiesEditor.this.findTypeStates((TypeCategory.Type)parentElement)) != null) {
                    return list.toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof TypeCategory.Type) {
                    return RequiredPropertiesEditor.this.findCategory((TypeCategory.Type)element);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                if (RequiredPropertiesEditor.this.fCategories != null) {
                    return RequiredPropertiesEditor.this.fCategories.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fPropertiesViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RequiredPropertiesEditor.this.editProperty((IStructuredSelection)event.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action edit = new Action(Messages.RequiredPropertiesEditor_EDIT){

            public void run() {
                RequiredPropertiesEditor.this.editProperty((IStructuredSelection)RequiredPropertiesEditor.this.fPropertiesViewer.getSelection());
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)edit){
            private final /* synthetic */ IAction val$edit;
            {
                this.val$edit = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (RequiredPropertiesEditor.this.fPropertiesViewer != null && ((IStructuredSelection)RequiredPropertiesEditor.this.fPropertiesViewer.getSelection()).size() == 1) {
                    manager.add(this.val$edit);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fPropertiesViewer.getControl());
        this.fPropertiesViewer.getControl().setMenu(menu);
        final Button editButton = toolkit.createButton(parent, Messages.RequiredPropertiesEditor_EDIT, 0x800000);
        GridData data = new GridData(0x1000000, 128, false, false);
        data.verticalIndent = this.fPropertiesViewer.getTree().getHeaderHeight();
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredPropertiesEditor.this.editProperty((IStructuredSelection)RequiredPropertiesEditor.this.fPropertiesViewer.getSelection());
            }
        });
        editButton.setEnabled(false);
        this.fPropertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!editButton.isDisposed()) {
                    editButton.setEnabled(((IStructuredSelection)RequiredPropertiesEditor.this.fPropertiesViewer.getSelection()).size() == 1);
                }
            }
        });
        this.fPropertiesViewer.setInput(this.fCategories);
    }

    private TypeCategory findCategory(TypeCategory.Type type) {
        for (TypeCategory c : this.fCategories) {
            if (!c.getTypes().contains(type)) continue;
            return c;
        }
        return null;
    }

    private List<TypeState> findTypeStates(ModeledElement typeOrCategory) {
        if (this.fWorkflows == null) {
            this.initializeWorkflows();
        }
        String categoryId = null;
        if (typeOrCategory instanceof TypeCategory) {
            categoryId = ((TypeCategory)typeOrCategory).getIdentifier();
        } else if (typeOrCategory instanceof TypeCategory.Type) {
            categoryId = this.findCategory((TypeCategory.Type)typeOrCategory).getIdentifier();
        }
        String workflowId = null;
        for (WorkflowBinding b : this.fBindings) {
            if (!b.getCategoryId().equals(categoryId)) continue;
            workflowId = b.getWorkflowId();
            break;
        }
        for (WFWorkflow w : this.fWorkflows) {
            if (!w.getIdentifier().equals(workflowId)) continue;
            ArrayList<TypeState> result = new ArrayList<TypeState>();
            for (WFWorkflow.WFState s : w.getStates()) {
                TypeState ts = this.findOrCreateTypeState(typeOrCategory, s);
                result.add(ts);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void editProperty(IStructuredSelection selection) {
        EditPropertyDialog d;
        TypeCategory category;
        ModeledElement element;
        ModeledElement el = element = (ModeledElement)selection.getFirstElement();
        if (element instanceof TypeState) {
            el = ((TypeState)element).getType();
        }
        TypeCategory.Type type = null;
        if (el instanceof TypeCategory) {
            category = (TypeCategory)el;
        } else {
            type = (TypeCategory.Type)el;
            category = this.findCategory(type);
        }
        RequiredProperty property = this.fPropertyTypeMap.get(element);
        RequiredProperty parentProperty = null;
        if (type != null) {
            parentProperty = this.fPropertyTypeMap.get(category);
        }
        if ((d = new EditPropertyDialog(Display.getCurrent().getActiveShell(), NLS.bind((String)Messages.RequiredPropertiesEditor_EDIT_PROPERTY, (Object)element.getName(), (Object[])new Object[0]), category, property, parentProperty, this.fRootProperty, this.getBuiltInAttributes(), this.fResourceManager)).open() == 0) {
            Collection<Attribute> selectedAttributes = d.getSelectedAttributes();
            if ((property == null || property.getRequiredAttributes().isEmpty()) && selectedAttributes.isEmpty()) {
                return;
            }
            if (property != null && property.getRequiredAttributes().containsAll(selectedAttributes) && selectedAttributes.containsAll(property.getRequiredAttributes())) {
                return;
            }
            if (property == null) {
                property = element instanceof TypeState ? new RequiredWorkflowProperty((TypeState)element) : new RequiredProperty(element);
                this.fRequiredProperties.add(property);
                this.fPropertyTypeMap.put(element, property);
            }
            property.getRequiredAttributes().clear();
            property.getRequiredAttributes().addAll(selectedAttributes);
            this.setDirty();
            this.fPropertiesViewer.refresh();
        }
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    private void readCategories() {
        ModelElement typeElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        this.fCategories = TypeManager.readTypeCategories(typeElement);
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readCategories();
    }

    private static class Attribute {
        private String fId;
        private String fName;

        public Attribute(String id, String name) {
            this.fId = id;
            this.fName = name;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean equals(Object o) {
            if (o instanceof Attribute) {
                return ((Attribute)o).fId.equals(this.fId);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.fId.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditPropertyDialog
    extends ProcessAttachmentIconSelectionDialog {
        private CheckboxTableViewer fAttributeViewer;
        private List<Attribute> fAllAttributes;
        private RequiredProperty fProperty;
        private RequiredProperty fParentProperty;
        private Set<Attribute> fRequired;
        private Set<Attribute> fInherited;

        public EditPropertyDialog(Shell parentShell, String title, TypeCategory category, RequiredProperty property, RequiredProperty parentProperty, RequiredProperty rootProperty, List<Attribute> builtInAttributes, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fParentProperty = parentProperty;
            this.fProperty = property;
            HashSet<Attribute> attributes = new HashSet<Attribute>();
            for (Attribute attribute : builtInAttributes) {
                if (!RequiredPropertiesManager.SUPPORTED_BUILT_IN_ATTRIBUTES.contains(WorkItemAttributes.getAttributeId((Identifier)Identifier.create(IAttribute.class, (String)attribute.getId())))) continue;
                attributes.add(attribute);
            }
            for (TypeCategory.CustomAttribute attr : category.getCustomAttributes()) {
                if (!RequiredPropertiesManager.isSupportedCustomAttributeType((String)attr.getAttributeType())) continue;
                attributes.add(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)attr.getId()).getStringIdentifier(), attr.getName()));
            }
            this.fRequired = this.fProperty != null ? new HashSet<Attribute>(this.fProperty.getRequiredAttributes()) : new HashSet();
            HashSet<Attribute> hashSet = this.fInherited = this.fParentProperty != null ? new HashSet<Attribute>(this.fParentProperty.getRequiredAttributes()) : new HashSet();
            if (rootProperty != null) {
                this.fInherited.addAll(rootProperty.getRequiredAttributes());
            }
            attributes.addAll(this.fRequired);
            attributes.addAll(this.fInherited);
            this.fAllAttributes = new ArrayList<Attribute>(attributes);
            final Collator collator = Collator.getInstance();
            collator.setStrength(1);
            Collections.sort(this.fAllAttributes, new Comparator<Attribute>(){

                @Override
                public int compare(Attribute o1, Attribute o2) {
                    String name1 = o1.getName() != null ? o1.getName() : o1.getId();
                    String name2 = o2.getName() != null ? o2.getName() : o2.getId();
                    return collator.compare(name1, name2);
                }
            });
        }

        @Override
        protected void iconChanged() {
            this.validate();
        }

        protected Collection<Attribute> getSelectedAttributes() {
            return this.fRequired;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.RequiredPropertiesEditor_SELECT_PROPERTIES);
            GridData data = new GridData(4, 4, true, false, 2, 1);
            l.setLayoutData((Object)data);
            Table t = new Table(parent, 67616);
            data = new GridData(4, 4, true, true, 2, 1);
            data.verticalIndent = 5;
            t.setLayoutData((Object)data);
            TableColumn c = new TableColumn(t, 0);
            c.setWidth(300);
            this.fAttributeViewer = new CheckboxTableViewer(t);
            this.fAttributeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof Attribute) {
                        if (EditPropertyDialog.this.fInherited.contains(cell.getElement()) && !EditPropertyDialog.this.fRequired.contains(cell.getElement())) {
                            cell.setText(NLS.bind((String)Messages.RequiredPropertiesEditor_PROPERTY_INHERITED, (Object)((Attribute)cell.getElement()).getName(), (Object[])new Object[0]));
                            cell.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
                        } else {
                            cell.setText(((Attribute)cell.getElement()).getName());
                            cell.setForeground(null);
                        }
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fAttributeViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return EditPropertyDialog.this.fAllAttributes.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.fAttributeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getChecked()) {
                        EditPropertyDialog.this.fRequired.add((Attribute)event.getElement());
                    } else {
                        EditPropertyDialog.this.fRequired.remove(event.getElement());
                    }
                    EditPropertyDialog.this.fAttributeViewer.refresh();
                }
            });
            this.fAttributeViewer.setInput(this.fAllAttributes);
            this.fAttributeViewer.setCheckedElements(this.fRequired.toArray());
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredProperty {
        private ModeledElement fTypeOrCategory;
        private List<Attribute> fRequiredAttributes;

        public RequiredProperty(ModeledElement typeOrCategory) {
            this.fTypeOrCategory = typeOrCategory;
            this.fRequiredAttributes = new ArrayList<Attribute>();
        }

        public ModeledElement getTypeOrCategory() {
            return this.fTypeOrCategory;
        }

        public List<Attribute> getRequiredAttributes() {
            return this.fRequiredAttributes;
        }

        public void addRequiredAttribute(Attribute attribute) {
            this.fRequiredAttributes.add(attribute);
        }
    }

    private static class RequiredWorkflowProperty
    extends RequiredProperty {
        private WFWorkflow.WFState fState;

        public RequiredWorkflowProperty(TypeState typeState) {
            super(typeState.getType());
            this.fState = typeState.getState();
        }

        public WFWorkflow.WFState getState() {
            return this.fState;
        }
    }

    private static class TypeState
    extends ModeledElement {
        private WFWorkflow.WFState fState;
        private ModeledElement fType;

        public TypeState(ModeledElement typeOrCategory, WFWorkflow.WFState state) {
            this.fType = typeOrCategory;
            this.fState = state;
        }

        public String getIdentifier() {
            return String.valueOf(this.fType.getIdentifier()) + "#" + this.fState.getId();
        }

        public String getName() {
            return NLS.bind((String)Messages.RequiredPropertiesEditor_TYPESTATE_NAME, (Object)this.fType.getName(), (Object[])new Object[]{this.fState.getName()});
        }

        public WFWorkflow.WFState getState() {
            return this.fState;
        }

        public ModeledElement getType() {
            return this.fType;
        }
    }
}

