/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.AttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.teamoperation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESignaturesAspectEditor
extends OperationDetailsAspectEditor {
    private static final String APPROVALS_PREFIX = "approvals/";
    private static final String WORKFLOW_PREFIX = "workflow/";
    private static final String PROPERTY = "property";
    private static final String ID = "id";
    private static final String WORK_ITEM_TYPE = "workItemType";
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<SignatureProperty> fSignatureProperties;
    private TreeViewer fPropertiesViewer;
    private List<TypeCategory> fCategories;
    private Map<ModeledElement, SignatureProperty> fPropertyTypeMap;
    private List<Attribute> fBuiltInAttributes;
    private TypeCategory fUnspecified;
    private List<WFWorkflow> fWorkflows;
    private List<WorkflowBinding> fBindings;

    public void restoreState(IMemento memento) {
        this.fSignatureProperties = new ArrayList<SignatureProperty>();
        this.fPropertyTypeMap = new HashMap<ModeledElement, SignatureProperty>();
        IMemento[] iMementoArray = memento.getChildren(WORK_ITEM_TYPE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento properties = iMementoArray[n2];
            String type = properties.getString(ID);
            if (type != null) {
                TypeCategory.Type typeOrCategory = this.findType(type);
                if (typeOrCategory == null) {
                    typeOrCategory = this.createTypeInUnspecifiedCategory(type);
                }
                SignatureProperty prop = new SignatureProperty(typeOrCategory);
                IMemento[] iMementoArray2 = properties.getChildren(PROPERTY);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento property = iMementoArray2[n4];
                    String id = property.getString(ID);
                    if (id != null) {
                        prop.addSignatureAttribute(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier(), this.getAttributeName(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier())));
                    }
                    ++n4;
                }
                this.fSignatureProperties.add(prop);
                this.fPropertyTypeMap.put(typeOrCategory, prop);
            }
            ++n2;
        }
    }

    private TypeCategory.Type createTypeInUnspecifiedCategory(String typeId) {
        if (this.fUnspecified == null) {
            this.fUnspecified = new TypeCategory(Messages.ESignaturesAspectEditor_UNSPECIFIED_CATEGORY);
            this.fCategories.add(this.fUnspecified);
        }
        TypeCategory typeCategory = this.fUnspecified;
        typeCategory.getClass();
        TypeCategory.Type type = new TypeCategory.Type(typeCategory, typeId, typeId, null, null, new ArrayList<String>());
        this.fUnspecified.addType(type);
        return type;
    }

    private TypeCategory.Type findType(String typeId) {
        if (this.fCategories == null || typeId == null) {
            return null;
        }
        for (TypeCategory cat : this.fCategories) {
            for (TypeCategory.Type t : cat.getTypes()) {
                if (!t.getId().equals(typeId)) continue;
                return t;
            }
        }
        return null;
    }

    private List<Attribute> getBuiltInAttributes() {
        if (this.fBuiltInAttributes == null) {
            final IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
            final ArrayList attributes = new ArrayList();
            if (processItem instanceof IProcessArea) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IProcessArea processArea = (IProcessArea)processItem;
                            ITeamRepository teamRepository = (ITeamRepository)processItem.getOrigin();
                            IWorkItemClient workitemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                            try {
                                List builtInAttributes = workitemClient.findBuiltInAttributes(processArea.getProjectArea(), monitor);
                                attributes.addAll(workitemClient.getAuditableCommon().resolveAuditablesPermissionAware(builtInAttributes, IAttribute.SMALL_PROFILE, monitor));
                            }
                            catch (TeamRepositoryException e) {
                                WorkItemIDEUIPlugin.getDefault().log(Messages.ESignaturesAspectEditor_ERROR_RETRIEVING_ATTRIBUTES, e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.ESignaturesAspectEditor_ERROR_RETRIEVING_ATTRIBUTES, e);
                    return Collections.emptyList();
                }
                catch (InterruptedException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.ESignaturesAspectEditor_ERROR_RETRIEVING_ATTRIBUTES, e);
                    return Collections.emptyList();
                }
                this.fBuiltInAttributes = new ArrayList<Attribute>();
                for (IAttribute a : attributes) {
                    if (a.isInternal()) continue;
                    Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)a.getIdentifier());
                    this.fBuiltInAttributes.add(new Attribute(ident.getStringIdentifier(), a.getDisplayName()));
                }
            } else if (processItem instanceof IProcessDefinition) {
                this.fBuiltInAttributes = new ArrayList<Attribute>();
                AttributeDescriptor[] attributeDescriptorArray = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS;
                int n = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeDescriptor desc = attributeDescriptorArray[n2];
                    if (!desc.isInternal()) {
                        Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)desc.getIdentifier());
                        this.fBuiltInAttributes.add(new Attribute(ident.getStringIdentifier(), desc.getDisplayName()));
                    }
                    ++n2;
                }
            } else {
                throw new UnsupportedOperationException(Messages.ESignaturesAspectEditor_NEITHER_AREA_NOR_DEFINITION);
            }
        }
        return this.fBuiltInAttributes;
    }

    private String getAttributeName(String attributeId) {
        if (attributeId.startsWith(APPROVALS_PREFIX)) {
            String typeIdentifier = attributeId.substring(APPROVALS_PREFIX.length());
            return WorkItemApprovals.getType((String)typeIdentifier).getDisplayName();
        }
        if (attributeId.startsWith(WORKFLOW_PREFIX)) {
            String actionId = attributeId.substring(WORKFLOW_PREFIX.length());
            for (WFWorkflow w : this.fWorkflows) {
                for (WFWorkflow.WFAction a : w.getActions()) {
                    if (!a.getId().equals(actionId)) continue;
                    return a.getName();
                }
            }
        }
        for (Attribute a : this.getBuiltInAttributes()) {
            if (!a.getId().equals(attributeId)) continue;
            return a.getName();
        }
        for (TypeCategory cat : this.fCategories) {
            for (TypeCategory.CustomAttribute c : cat.getCustomAttributes()) {
                if (!c.getId().equals(attributeId)) continue;
                return c.getName();
            }
        }
        return attributeId;
    }

    public boolean saveState(IMemento memento) {
        if (this.fSignatureProperties.size() == 0) {
            return false;
        }
        HashMap map = new HashMap();
        for (SignatureProperty signatureProperty : this.fSignatureProperties) {
            String key = signatureProperty.getTypeOrCategory().getIdentifier();
            if (map.get(key) == null) {
                map.put(key, new HashSet());
            }
            Set list = (Set)map.get(key);
            for (Attribute a : signatureProperty.getSignatureAttributes()) {
                list.add(a.getId());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            IMemento type = memento.createChild(WORK_ITEM_TYPE);
            type.putString(ID, (String)entry.getKey());
            for (String p : (Set)entry.getValue()) {
                IMemento prop = type.createChild(PROPERTY);
                prop.putString(ID, p);
            }
        }
        return true;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Tree t = new Tree(parent, 67586);
        t.setLayoutData((Object)new GridData(4, 4, true, true));
        t.setHeaderVisible(true);
        TreeColumn c = new TreeColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(Messages.ESignaturesAspectEditor_TYPE);
        c = new TreeColumn(t, 0);
        c.setWidth(200);
        c.setResizable(true);
        c.setText(Messages.ESignaturesAspectEditor_PROPERTIES);
        this.fPropertiesViewer = new TreeViewer(t);
        this.fPropertiesViewer.setColumnProperties(new String[]{Messages.ESignaturesAspectEditor_TYPE, Messages.ESignaturesAspectEditor_PROPERTIES});
        this.fPropertiesViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (cell.getColumnIndex() == 0 && element instanceof TypeCategory.Type) {
                    if (((TypeCategory.Type)element).getIcon() != null) {
                        cell.setImage(this.getImage(element, ((TypeCategory.Type)element).getIcon()));
                    } else {
                        cell.setImage(null);
                    }
                    cell.setText(((TypeCategory.Type)element).getName());
                } else if (cell.getColumnIndex() == 1) {
                    String attributes = this.getAttributes((ModeledElement)element);
                    cell.setText(attributes);
                    if (ESignaturesAspectEditor.this.fPropertyTypeMap.get(element) == null || ((SignatureProperty)ESignaturesAspectEditor.this.fPropertyTypeMap.get(element)).getSignatureAttributes().isEmpty()) {
                        cell.setForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
                        cell.getViewerRow().setForeground(0, WorkItemIDEUIPlugin.getDefault().getMidShadow());
                    } else {
                        cell.setForeground(null);
                        cell.getViewerRow().setForeground(0, null);
                    }
                }
            }

            private String getAttributes(ModeledElement element) {
                HashSet<Attribute> attributes = new HashSet<Attribute>();
                SignatureProperty prop = (SignatureProperty)ESignaturesAspectEditor.this.fPropertyTypeMap.get(element);
                if (prop != null) {
                    attributes.addAll(prop.getSignatureAttributes());
                }
                String result = "";
                ArrayList atts = new ArrayList(attributes);
                Collections.sort(atts, new Comparator<Attribute>(){

                    @Override
                    public int compare(Attribute o1, Attribute o2) {
                        if (o1.getName() != null && o2.getName() != null) {
                            return Collator.getInstance().compare(o1.getName(), o2.getName());
                        }
                        return -1;
                    }
                });
                for (Attribute a : atts) {
                    String name = a.getName();
                    if (a.getId().startsWith(ESignaturesAspectEditor.WORKFLOW_PREFIX)) {
                        name = NLS.bind((String)Messages.ESignaturesAspectEditor_ACTION_NAME, (Object)name, (Object[])new Object[0]);
                    } else if (a.getId().startsWith(ESignaturesAspectEditor.APPROVALS_PREFIX)) {
                        name = NLS.bind((String)Messages.ESignaturesAspectEditor_APPROVAL_NAME, (Object)name, (Object[])new Object[0]);
                    }
                    result = NLS.bind((String)Messages.ESignaturesAspectEditor_LIST_OF_PROPERTIES, (Object)result, (Object[])new Object[]{name});
                }
                result = atts.isEmpty() ? Messages.ESignaturesAspectEditor_NONE : result.substring(2);
                return result;
            }

            private Image getImage(final Object element, String iconPath) {
                return AspectEditorUtil.getImage(ESignaturesAspectEditor.this.getAspect().getProcessContainerWorkingCopy(), iconPath, ESignaturesAspectEditor.this.fResourceManager, new Runnable(){

                    public void run() {
                        this.fireChanged(element);
                    }
                });
            }

            private void fireChanged(Object element) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
            }
        });
        this.fPropertiesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof TypeCategory.Type) {
                    return ESignaturesAspectEditor.this.findCategory((TypeCategory.Type)element);
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                if (ESignaturesAspectEditor.this.fCategories != null) {
                    ArrayList<TypeCategory.Type> types = new ArrayList<TypeCategory.Type>();
                    for (TypeCategory c : ESignaturesAspectEditor.this.fCategories) {
                        types.addAll(c.getTypes());
                    }
                    return types.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fPropertiesViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ESignaturesAspectEditor.this.editProperty((IStructuredSelection)event.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action edit = new Action(Messages.ESignaturesAspectEditor_EDIT){

            public void run() {
                ESignaturesAspectEditor.this.editProperty((IStructuredSelection)ESignaturesAspectEditor.this.fPropertiesViewer.getSelection());
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)edit){
            private final /* synthetic */ IAction val$edit;
            {
                this.val$edit = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (ESignaturesAspectEditor.this.fPropertiesViewer != null && ((IStructuredSelection)ESignaturesAspectEditor.this.fPropertiesViewer.getSelection()).size() == 1) {
                    manager.add(this.val$edit);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fPropertiesViewer.getControl());
        this.fPropertiesViewer.getControl().setMenu(menu);
        final Button editButton = toolkit.createButton(parent, Messages.ESignaturesAspectEditor_EDIT, 0x800000);
        GridData data = new GridData(0x1000000, 128, false, false);
        data.verticalIndent = this.fPropertiesViewer.getTree().getHeaderHeight();
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ESignaturesAspectEditor.this.editProperty((IStructuredSelection)ESignaturesAspectEditor.this.fPropertiesViewer.getSelection());
            }
        });
        editButton.setEnabled(false);
        this.fPropertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!editButton.isDisposed()) {
                    editButton.setEnabled(((IStructuredSelection)ESignaturesAspectEditor.this.fPropertiesViewer.getSelection()).size() == 1);
                }
            }
        });
        this.fPropertiesViewer.setInput(this.fCategories);
    }

    private TypeCategory findCategory(TypeCategory.Type type) {
        for (TypeCategory c : this.fCategories) {
            if (!c.getTypes().contains(type)) continue;
            return c;
        }
        return null;
    }

    private void editProperty(IStructuredSelection selection) {
        TypeCategory category;
        ModeledElement element;
        ModeledElement el = element = (ModeledElement)selection.getFirstElement();
        TypeCategory.Type type = null;
        if (el instanceof TypeCategory) {
            category = (TypeCategory)el;
        } else {
            type = (TypeCategory.Type)el;
            category = this.findCategory(type);
        }
        SignatureProperty property = this.fPropertyTypeMap.get(element);
        EditPropertyDialog d = new EditPropertyDialog(Display.getCurrent().getActiveShell(), NLS.bind((String)Messages.ESignaturesAspectEditor_EDIT_TYPE, (Object)element.getName(), (Object[])new Object[0]), category, property, this.getBuiltInAttributes(), this.fWorkflows, this.fBindings, this.fResourceManager);
        if (d.open() == 0) {
            Collection<Attribute> selectedAttributes = d.getSelectedAttributes();
            if ((property == null || property.getSignatureAttributes().isEmpty()) && selectedAttributes.isEmpty()) {
                return;
            }
            if (property != null && property.getSignatureAttributes().containsAll(selectedAttributes) && selectedAttributes.containsAll(property.getSignatureAttributes())) {
                return;
            }
            if (property == null) {
                property = new SignatureProperty(element);
                this.fSignatureProperties.add(property);
                this.fPropertyTypeMap.put(element, property);
            }
            property.getSignatureAttributes().clear();
            property.getSignatureAttributes().addAll(selectedAttributes);
            this.setDirty();
            this.fPropertiesViewer.refresh();
        }
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    private void readCategories() {
        ModelElement typeElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        this.fCategories = TypeManager.readTypeCategories(typeElement);
    }

    private void readWorkflows() {
        this.fWorkflows = WorkflowManager.readWorkflows(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow"));
        this.fBindings = WorkflowBindingManager.readWorkflowBindings(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding"));
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readCategories();
        this.readWorkflows();
    }

    private static boolean isSupportedSignatureAttribute(String propertyId) {
        return propertyId.startsWith(APPROVALS_PREFIX);
    }

    private static class Attribute {
        private String fId;
        private String fName;

        public Attribute(String id, String name) {
            this.fId = id;
            this.fName = name;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean equals(Object o) {
            if (o instanceof Attribute) {
                return ((Attribute)o).fId.equals(this.fId);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.fId.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditPropertyDialog
    extends ProcessAttachmentIconSelectionDialog {
        private CheckboxTreeViewer fAttributeViewer;
        private List<Attribute> fAllAttributes;
        private SignatureProperty fProperty;
        private Set<Attribute> fSignature;
        private List<Attribute> fApprovalAttributes;
        private List<Attribute> fWorkflowAttributes;

        public EditPropertyDialog(Shell parentShell, String title, TypeCategory category, SignatureProperty property, List<Attribute> builtInAttributes, List<WFWorkflow> workflows, List<WorkflowBinding> bindings, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fProperty = property;
            HashSet<Attribute> attributes = new HashSet<Attribute>();
            for (Attribute attribute : builtInAttributes) {
                if (!ESignaturesAspectEditor.isSupportedSignatureAttribute(attribute.getId())) continue;
                attributes.add(attribute);
            }
            for (TypeCategory.CustomAttribute attr : category.getCustomAttributes()) {
                if (!ESignaturesAspectEditor.isSupportedSignatureAttribute(attr.getId())) continue;
                attributes.add(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)attr.getId()).getStringIdentifier(), attr.getName()));
            }
            this.fApprovalAttributes = new ArrayList<Attribute>();
            this.fApprovalAttributes.add(new Attribute(ESignaturesAspectEditor.APPROVALS_PREFIX + WorkItemApprovals.APPROVAL_TYPE.getIdentifier(), WorkItemApprovals.APPROVAL_TYPE.getDisplayName()));
            this.fApprovalAttributes.add(new Attribute(ESignaturesAspectEditor.APPROVALS_PREFIX + WorkItemApprovals.REVIEW_TYPE.getIdentifier(), WorkItemApprovals.REVIEW_TYPE.getDisplayName()));
            this.fApprovalAttributes.add(new Attribute(ESignaturesAspectEditor.APPROVALS_PREFIX + WorkItemApprovals.VERIFICATION_TYPE.getIdentifier(), WorkItemApprovals.VERIFICATION_TYPE.getDisplayName()));
            this.fWorkflowAttributes = new ArrayList<Attribute>();
            for (WorkflowBinding binding : bindings) {
                if (!binding.getCategoryId().equals(category.getIdentifier())) continue;
                for (WFWorkflow workflow : workflows) {
                    if (!binding.getWorkflowId().equals(workflow.getId())) continue;
                    for (WFWorkflow.WFAction a : workflow.getActions()) {
                        this.fWorkflowAttributes.add(new Attribute(ESignaturesAspectEditor.WORKFLOW_PREFIX + a.getId(), a.getName()));
                    }
                }
            }
            this.fSignature = this.fProperty != null ? new HashSet<Attribute>(this.fProperty.getSignatureAttributes()) : new HashSet();
            HashSet<Attribute> diff = new HashSet<Attribute>(this.fSignature);
            diff.removeAll(attributes);
            diff.removeAll(this.fApprovalAttributes);
            diff.removeAll(this.fWorkflowAttributes);
            attributes.addAll(diff);
            this.fAllAttributes = new ArrayList<Attribute>(attributes);
            final Collator collator = Collator.getInstance();
            collator.setStrength(1);
            Comparator<Attribute> comparator = new Comparator<Attribute>(){

                @Override
                public int compare(Attribute o1, Attribute o2) {
                    String name1 = o1.getName() != null ? o1.getName() : o1.getId();
                    String name2 = o2.getName() != null ? o2.getName() : o2.getId();
                    return collator.compare(name1, name2);
                }
            };
            Collections.sort(this.fAllAttributes, comparator);
            Collections.sort(this.fApprovalAttributes, comparator);
            Collections.sort(this.fWorkflowAttributes, comparator);
        }

        @Override
        protected void iconChanged() {
            this.validate();
        }

        protected Collection<Attribute> getSelectedAttributes() {
            return this.fSignature;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.ESignaturesAspectEditor_SELECT_PROPERTIES_MESSAGE);
            GridData data = new GridData(4, 4, true, false, 2, 1);
            l.setLayoutData((Object)data);
            Tree t = new Tree(parent, 67616);
            data = new GridData(4, 4, true, true, 2, 1);
            data.verticalIndent = 5;
            t.setLayoutData((Object)data);
            TreeColumn c = new TreeColumn(t, 0);
            c.setWidth(300);
            this.fAttributeViewer = new CheckboxTreeViewer(t);
            this.fAttributeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof Attribute) {
                        cell.setText(((Attribute)cell.getElement()).getName());
                        cell.setForeground(null);
                    } else if (ESignaturesAspectEditor.APPROVALS_PREFIX.equals(cell.getElement())) {
                        cell.setText(Messages.ESignaturesAspectEditor_APPROVAL);
                    } else if (ESignaturesAspectEditor.WORKFLOW_PREFIX.equals(cell.getElement())) {
                        cell.setText(Messages.ESignaturesAspectEditor_WORKFLOW_ACTION);
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fAttributeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    ArrayList<String> elements = new ArrayList<String>(EditPropertyDialog.this.fAllAttributes);
                    elements.add(0, ESignaturesAspectEditor.WORKFLOW_PREFIX);
                    elements.add(0, ESignaturesAspectEditor.APPROVALS_PREFIX);
                    return elements.toArray();
                }

                public boolean hasChildren(Object element) {
                    return this.getChildren(element).length > 0;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    if (ESignaturesAspectEditor.APPROVALS_PREFIX.equals(parentElement)) {
                        return EditPropertyDialog.this.fApprovalAttributes.toArray();
                    }
                    if (ESignaturesAspectEditor.WORKFLOW_PREFIX.equals(parentElement)) {
                        return EditPropertyDialog.this.fWorkflowAttributes.toArray();
                    }
                    return new Object[0];
                }
            });
            this.fAttributeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getElement() instanceof String && event.getChecked()) {
                        EditPropertyDialog.this.fAttributeViewer.setChecked(event.getElement(), false);
                    }
                    if (event.getElement() instanceof Attribute) {
                        if (event.getChecked()) {
                            EditPropertyDialog.this.fSignature.add((Attribute)event.getElement());
                        } else {
                            EditPropertyDialog.this.fSignature.remove(event.getElement());
                        }
                    }
                    EditPropertyDialog.this.fAttributeViewer.refresh();
                }
            });
            this.fAttributeViewer.setInput((Object)new Object[0]);
            this.fAttributeViewer.expandAll();
            this.fAttributeViewer.setCheckedElements(this.fSignature.toArray());
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SignatureProperty {
        private ModeledElement fTypeOrCategory;
        private List<Attribute> fSignatureAttributes;

        public SignatureProperty(ModeledElement typeOrCategory) {
            this.fTypeOrCategory = typeOrCategory;
            this.fSignatureAttributes = new ArrayList<Attribute>();
        }

        public ModeledElement getTypeOrCategory() {
            return this.fTypeOrCategory;
        }

        public List<Attribute> getSignatureAttributes() {
            return this.fSignatureAttributes;
        }

        public void addSignatureAttribute(Attribute attribute) {
            this.fSignatureAttributes.add(attribute);
        }
    }
}

