/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.quickinformation.Quickinformation;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.QuickInformationManager;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickinformationAspectPart
extends TeamFormPart {
    private List<String> fPartIds;
    private TableViewer fQuickViewer;
    private Quickinformation fQuickinfo;
    private Button fAddEntry;
    private IDirtyStateTracker fTracker;
    List<IEndPointDescriptor> fEndPoints;
    private static final String TITLE_LABEL = Messages.QuickinformationAspectPart_TITLE_LABEL;
    private static final String KIND_LABEL = Messages.QuickinformationAspectPart_KIND_LABEL;
    private static final String LINKTARGET_LABEL = Messages.QuickinformationAspectPart_LINKTARGET_LABEL;
    private static final String ENDPOINT_LABEL = Messages.QuickinformationAspectPart_ENDPOINT_LABEL;
    private static final String LINKTARGET = "linkTarget";
    private static final String ENDPOINTID = "endpointId";
    private static List<String> NO_ENDPOINT_KINDS = new ArrayList<String>(Arrays.asList("com.ibm.team.workitem.quickinformation.kind.artifact", "com.ibm.team.workitem.quickinformation.kind.subscriber", "com.ibm.team.workitem.quickinformation.kind.approval", "com.ibm.team.workitem.quickinformation.kind.collector", "com.ibm.team.workitem.quickinformation.kind.potentialDuplicates", "Hidden"));
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Quickinformation.QuickinformationChangeListener fListener = new Quickinformation.QuickinformationChangeListener(){

        public void quickinformationChanged(final Quickinformation.QuickinformationChangeEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    QuickinformationAspectPart.this.fQuickViewer.refresh();
                    if (e.getChanged() != null) {
                        QuickinformationAspectPart.this.fQuickViewer.setSelection((ISelection)new StructuredSelection(e.getChanged()), true);
                        QuickinformationAspectPart.this.fQuickViewer.getTable().setFocus();
                    }
                }
            });
        }
    };

    QuickinformationAspectPart(IDirtyStateTracker tracker) {
        this.fTracker = tracker;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite viewer = toolkit.createComposite(parent, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = toolkit.createComposite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        this.createViewer(viewer, buttonBar);
    }

    private void createViewer(Composite viewer, Composite buttonBar) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        viewer.setLayout((Layout)layout);
        Table t = new Table(viewer, 68354);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.heightHint = t.getItemHeight() * 12;
        data.widthHint = 400;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(180);
        c.setResizable(true);
        c.setText(TITLE_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(120);
        c.setResizable(true);
        c.setText(KIND_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(280);
        c.setResizable(true);
        c.setText(LINKTARGET_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(300);
        c.setResizable(true);
        c.setText(ENDPOINT_LABEL);
        this.fQuickViewer = new TableViewer(t);
        this.fQuickViewer.setColumnProperties(new String[]{TITLE_LABEL, KIND_LABEL, LINKTARGET_LABEL, ENDPOINT_LABEL});
        this.fQuickViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Quickinformation.QuickEntry) {
                    IEndPointDescriptor desc;
                    String endpoint;
                    if (columnIndex == 0) {
                        return ((Quickinformation.QuickEntry)element).getTitle();
                    }
                    if (columnIndex == 1) {
                        String kind = ((Quickinformation.QuickEntry)element).getKind();
                        if (kind != null) {
                            return QuickInformationManager.getDisplayName(kind);
                        }
                        return kind;
                    }
                    if (columnIndex == 2) {
                        return ((Quickinformation.QuickEntry)element).getProperty(QuickinformationAspectPart.LINKTARGET);
                    }
                    if (columnIndex == 3 && (endpoint = ((Quickinformation.QuickEntry)element).getProperty(QuickinformationAspectPart.ENDPOINTID)) != null && (desc = QuickinformationAspectPart.getFromXMLString(endpoint)) != null) {
                        return QuickinformationAspectPart.getDialogString(desc);
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                IEndPointDescriptor desc;
                String endpoint;
                if (columnIndex == 3 && (endpoint = ((Quickinformation.QuickEntry)element).getProperty(QuickinformationAspectPart.ENDPOINTID)) != null && (desc = QuickinformationAspectPart.getFromXMLString(endpoint)) != null) {
                    ImageDescriptor image = WorkItemUI.getImageDescriptor((URL)desc.getIcon());
                    return JazzResources.getImage((ResourceManager)QuickinformationAspectPart.this.fResourceManager, (ImageDescriptor)image, null);
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.fQuickViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Quickinformation) {
                    return ((Quickinformation)inputElement).getPresentations().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        layout = new GridLayout();
        layout.marginTop = this.fQuickViewer.getTable().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeEntry = toolkit.createButton(buttonBar, Messages.QuickinformationAspectPart_REMOVE, 0x800000);
        removeEntry.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeEntry.setEnabled(false);
        removeEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QuickinformationAspectPart.this.fQuickViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)QuickinformationAspectPart.this.fQuickViewer.getSelection();
                    boolean removedAny = false;
                    for (Object o : sel.toList()) {
                        if (!(o instanceof Quickinformation.QuickEntry)) continue;
                        QuickinformationAspectPart.this.fQuickinfo.removePresentation((Quickinformation.QuickEntry)o);
                        removedAny = true;
                    }
                    if (removedAny) {
                        QuickinformationAspectPart.this.setDirty();
                    }
                }
            }
        });
        this.fAddEntry = toolkit.createButton(buttonBar, Messages.QuickinformationAspectPart_ADD, 0x800000);
        this.fAddEntry.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditEntryDialog d = new AddEditEntryDialog(Display.getCurrent().getActiveShell(), Messages.QuickinformationAspectPart_ADD_PRESENTATION, null, null, new HashMap<String, String>(), QuickinformationAspectPart.this.getKinds(), QuickinformationAspectPart.this.fPartIds, QuickinformationAspectPart.this.getEndPoints(), QuickinformationAspectPart.this.fResourceManager);
                if (d.open() == 0) {
                    String title = d.getTitle();
                    String kind = d.getKind();
                    Map<String, String> properties = d.getProperties();
                    Quickinformation quickinformation = QuickinformationAspectPart.this.fQuickinfo;
                    quickinformation.getClass();
                    Quickinformation.QuickEntry entry = quickinformation.new Quickinformation.QuickEntry(kind, title);
                    for (Map.Entry<String, String> eieiei : properties.entrySet()) {
                        entry.setProperty(eieiei.getKey(), eieiei.getValue());
                    }
                    if (!QuickinformationAspectPart.this.fQuickViewer.getSelection().isEmpty()) {
                        QuickinformationAspectPart.this.fQuickinfo.addPresentation(entry, (Quickinformation.QuickEntry)((IStructuredSelection)QuickinformationAspectPart.this.fQuickViewer.getSelection()).getFirstElement());
                    } else {
                        QuickinformationAspectPart.this.fQuickinfo.addPresentation(entry);
                    }
                    QuickinformationAspectPart.this.setDirty();
                }
            }
        });
        final Button editEnumeration = toolkit.createButton(buttonBar, Messages.QuickinformationAspectPart_EDIT, 0x800000);
        editEnumeration.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editEnumeration.setEnabled(false);
        editEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickinformationAspectPart.this.editEntry();
            }
        });
        AspectEditorUtil.createFiller(buttonBar, toolkit, 6);
        final Button moveUpButton = toolkit.createButton(buttonBar, Messages.QuickinformationAspectPart_MOVE_UP, 0x800000);
        moveUpButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        moveUpButton.setEnabled(false);
        final Button moveDownButton = toolkit.createButton(buttonBar, Messages.QuickinformationAspectPart_MOVE_DOWN, 0x800000);
        moveDownButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        moveDownButton.setEnabled(false);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (QuickinformationAspectPart.this.fQuickViewer.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)QuickinformationAspectPart.this.fQuickViewer.getSelection()).getFirstElement()) instanceof Quickinformation.QuickEntry) {
                    QuickinformationAspectPart.this.fQuickinfo.moveUp((Quickinformation.QuickEntry)o);
                    QuickinformationAspectPart.this.setDirty();
                    QuickinformationAspectPart.this.updateMoveButtons(moveUpButton, moveDownButton);
                }
            }
        });
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (QuickinformationAspectPart.this.fQuickViewer.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)QuickinformationAspectPart.this.fQuickViewer.getSelection()).getFirstElement()) instanceof Quickinformation.QuickEntry) {
                    QuickinformationAspectPart.this.fQuickinfo.moveDown((Quickinformation.QuickEntry)o);
                    QuickinformationAspectPart.this.setDirty();
                    QuickinformationAspectPart.this.updateMoveButtons(moveUpButton, moveDownButton);
                }
            }
        });
        this.fQuickViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeEntry.setEnabled(!QuickinformationAspectPart.this.fQuickViewer.getSelection().isEmpty());
                editEnumeration.setEnabled(((IStructuredSelection)QuickinformationAspectPart.this.fQuickViewer.getSelection()).size() == 1);
                QuickinformationAspectPart.this.updateMoveButtons(moveUpButton, moveDownButton);
            }
        });
        this.fQuickViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)QuickinformationAspectPart.this.fQuickViewer.getSelection()).size() == 1) {
                    QuickinformationAspectPart.this.editEntry();
                }
            }
        });
        this.updateEnablement();
        Utils.updateColumnWidths((Table)this.fQuickViewer.getTable(), (int[])new int[]{-1, -1, -1, 1});
    }

    private void editEntry() {
        Quickinformation.QuickEntry selected = (Quickinformation.QuickEntry)((IStructuredSelection)this.fQuickViewer.getSelection()).getFirstElement();
        AddEditEntryDialog d = new AddEditEntryDialog(Display.getCurrent().getActiveShell(), Messages.QuickinformationAspectPart_EDIT_PRESENTATION, selected.getTitle(), selected.getKind(), new HashMap<String, String>(selected.getProperties()), this.getKinds(), this.fPartIds, this.getEndPoints(), this.fResourceManager);
        if (d.open() == 0) {
            if (!AspectEditorUtil.equals(d.getTitle(), selected.getTitle())) {
                selected.setTitle(d.getTitle());
                this.setDirty();
            }
            if (!AspectEditorUtil.equals(d.getKind(), selected.getKind())) {
                selected.setKind(d.getKind());
                this.setDirty();
            }
            Map<String, String> properties = d.getProperties();
            for (Map.Entry<String, String> eieiei : properties.entrySet()) {
                if (AspectEditorUtil.equals(selected.getProperty(eieiei.getKey()), eieiei.getValue())) continue;
                selected.setProperty(eieiei.getKey(), eieiei.getValue());
                this.setDirty();
            }
            Iterator<String> it = selected.getProperties().keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (properties.containsKey(key)) continue;
                it.remove();
                this.setDirty();
            }
        }
    }

    private void updateMoveButtons(Button moveUp, Button moveDown) {
        boolean moveUpEnabled = false;
        if (!this.fQuickViewer.getSelection().isEmpty() && this.fQuickViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.fQuickViewer.getSelection()).getFirstElement() instanceof Quickinformation.QuickEntry && ((IStructuredSelection)this.fQuickViewer.getSelection()).size() == 1 && this.fQuickinfo.getPresentations().indexOf(((IStructuredSelection)this.fQuickViewer.getSelection()).getFirstElement()) > 0) {
            moveUpEnabled = true;
        }
        moveUp.setEnabled(moveUpEnabled);
        boolean moveDownEnabled = false;
        if (!this.fQuickViewer.getSelection().isEmpty() && this.fQuickViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.fQuickViewer.getSelection()).getFirstElement() instanceof Quickinformation.QuickEntry && ((IStructuredSelection)this.fQuickViewer.getSelection()).size() == 1 && this.fQuickinfo.getPresentations().indexOf(((IStructuredSelection)this.fQuickViewer.getSelection()).getFirstElement()) < this.fQuickinfo.getPresentations().size() - 1) {
            moveDownEnabled = true;
        }
        moveDown.setEnabled(moveDownEnabled);
    }

    private void updateEnablement() {
        if (this.fAddEntry != null && !this.fAddEntry.isDisposed()) {
            this.fAddEntry.setEnabled(this.fQuickinfo != null);
            this.fQuickViewer.getControl().setEnabled(this.fQuickinfo != null);
        }
    }

    public void setPartIds(List<String> partIds) {
        this.fPartIds = partIds;
    }

    private List<IEndPointDescriptor> getEndPoints() {
        if (this.fEndPoints == null) {
            ArrayList<IEndPointDescriptor> endpoints = new ArrayList<IEndPointDescriptor>();
            for (ILinkType type : ILinkTypeRegistry.INSTANCE.allEntries()) {
                if (type.isInternal()) continue;
                if (WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)(type.getSourceEndPointDescriptor() != null ? type.getSourceEndPointDescriptor() : type.getTargetEndPointDescriptor()))) {
                    if ((type.getSourceEndPointDescriptor() == null || type.getSourceEndPointDescriptor().getReferencedItemType() != IWorkItem.ITEM_TYPE) && (type.getTargetEndPointDescriptor() == null || type.getTargetEndPointDescriptor().getReferencedItemType() != IWorkItem.ITEM_TYPE)) continue;
                    endpoints.add(type.getTargetEndPointDescriptor() != null ? type.getTargetEndPointDescriptor() : type.getSourceEndPointDescriptor());
                    continue;
                }
                if (type.getSourceEndPointDescriptor() != null && type.getTargetEndPointDescriptor() != null && type.getTargetEndPointDescriptor().getReferencedItemType() == IWorkItem.ITEM_TYPE) {
                    endpoints.add(type.getSourceEndPointDescriptor());
                }
                if (type.getTargetEndPointDescriptor() == null || type.getSourceEndPointDescriptor() == null || type.getSourceEndPointDescriptor().getReferencedItemType() != IWorkItem.ITEM_TYPE) continue;
                endpoints.add(type.getTargetEndPointDescriptor());
            }
            Collections.sort(endpoints, new Comparator<IEndPointDescriptor>(){

                @Override
                public int compare(IEndPointDescriptor o1, IEndPointDescriptor o2) {
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return Collator.getInstance().compare(o1.getLinkType().getLinkTypeId(), o2.getLinkType().getLinkTypeId());
                }
            });
            this.fEndPoints = endpoints;
        }
        return this.fEndPoints;
    }

    private List<String> getKinds() {
        ArrayList<String> list = new ArrayList<String>(QuickInformationManager.getQuickInformationEntries());
        list.add("Hidden");
        return list;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setInput(Object input) {
        if (this.fQuickinfo != null) {
            this.fQuickinfo.removeListener(this.fListener);
        }
        if (input instanceof Quickinformation) {
            this.fQuickinfo = (Quickinformation)input;
            this.fQuickViewer.setInput((Object)this.fQuickinfo);
            this.fQuickinfo.addListener(this.fListener);
        } else {
            this.fQuickinfo = null;
            this.fQuickViewer.setInput(null);
        }
        this.updateEnablement();
    }

    public void dispose() {
        if (this.fQuickinfo != null) {
            this.fQuickinfo.removeListener(this.fListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private static String getDialogString(IEndPointDescriptor desc) {
        String ret = NLS.bind((String)" - {0}", (Object)desc.getLinkType().getLinkTypeId(), (Object[])new Object[0]);
        String disp = desc.getDisplayName();
        if (WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)desc)) {
            return String.valueOf(disp) + ret;
        }
        if (desc.getDisplayName() != null) {
            if (desc.isSource()) {
                return String.valueOf(disp) + ret;
            }
            return String.valueOf(disp) + ret;
        }
        if (desc.isSource()) {
            return NLS.bind((String)Messages.QuickinformationAspectPart_SOURCE, (Object)ret, (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.QuickinformationAspectPart_TARGET, (Object)ret, (Object[])new Object[0]);
    }

    private static IEndPointDescriptor getFromXMLString(String xml) {
        if (xml == null || !xml.contains("/")) {
            return null;
        }
        String[] split = xml.split("/", 2);
        String linkType = split[0];
        String endpoint = split.length == 2 ? split[1] : "";
        for (ILinkType type : ILinkTypeRegistry.INSTANCE.allEntries()) {
            if (!type.getLinkTypeId().equals(linkType)) continue;
            if ("source".equals(endpoint)) {
                return type.getSourceEndPointDescriptor();
            }
            if ("target".equals(endpoint)) {
                return type.getTargetEndPointDescriptor();
            }
            if (endpoint.equals("")) {
                if (!WorkItemLinkTypes.isSymmetric((ILinkType)type)) {
                    return null;
                }
                return type.getTargetEndPointDescriptor() != null ? type.getTargetEndPointDescriptor() : type.getSourceEndPointDescriptor();
            }
            if (type.getTargetEndPointDescriptor() != null && endpoint.equals(type.getTargetEndPointDescriptor().getId())) {
                return type.getTargetEndPointDescriptor();
            }
            if (type.getSourceEndPointDescriptor() != null && endpoint.equals(type.getSourceEndPointDescriptor().getId())) {
                return type.getSourceEndPointDescriptor();
            }
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddEditEntryDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fTitleField;
        private DecoratedCombo fKindsCombo;
        private Combo fTargetsCombo;
        private Label fTargetLabel;
        private DecoratedCombo fEndpointsCombo;
        private Label fEndpointLabel;
        private String fTitle;
        private Kind fKind;
        private List<Kind> fKinds;
        private List<String> fPartIds;
        private List<IEndPointDescriptor> fEndpoints;
        private Map<String, String> fProperties;

        protected AddEditEntryDialog(Shell parentShell, String dialogTitle, String title, String kind, Map<String, String> properties, List<String> kinds, List<String> partIds, List<IEndPointDescriptor> endpoints, ResourceManager resourceManager) {
            super(parentShell, dialogTitle, null, null, resourceManager);
            this.fTitle = title;
            if (kind != null) {
                this.fKind = new Kind(kind, QuickInformationManager.getDisplayName(kind));
            }
            this.fKinds = new ArrayList<Kind>();
            if (kinds != null) {
                for (String k : kinds) {
                    if (this.fKind != null && k.equals(this.fKind.getId())) {
                        this.fKinds.add(this.fKind);
                        continue;
                    }
                    this.fKinds.add(new Kind(k, QuickInformationManager.getDisplayName(k)));
                }
            }
            Collections.sort(this.fKinds, new Comparator<Kind>(){

                @Override
                public int compare(Kind o1, Kind o2) {
                    String name2;
                    String name1 = o1.getName();
                    if (name1 == null) {
                        name1 = o1.getId();
                    }
                    if ((name2 = o2.getName()) == null) {
                        name2 = o2.getId();
                    }
                    return Collator.getInstance().compare(name1, name2);
                }
            });
            this.fPartIds = partIds == null ? new ArrayList<String>() : new ArrayList<String>(partIds);
            this.fEndpoints = endpoints == null ? new ArrayList<IEndPointDescriptor>() : new ArrayList<IEndPointDescriptor>(endpoints);
            this.fProperties = properties == null ? new HashMap<String, String>() : properties;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    if (AddEditEntryDialog.this.fTitle == null || "".equals(AddEditEntryDialog.this.fTitle.trim())) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.QuickinformationAspectPart_EMPTY_TITLE);
                    }
                    if (AddEditEntryDialog.this.fKind == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.QuickinformationAspectPart_NO_KIND);
                    }
                    if (AddEditEntryDialog.this.getTarget() == null && AddEditEntryDialog.this.showLinkTarget(AddEditEntryDialog.this.fKind)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.QuickinformationAspectPart_NO_LINKTARGET);
                    }
                    if (AddEditEntryDialog.this.getEndPoint() == null && !NO_ENDPOINT_KINDS.contains(AddEditEntryDialog.this.fKind.getId())) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.QuickinformationAspectPart_NO_ENDPOINT);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        private String getTarget() {
            return this.fProperties.get(QuickinformationAspectPart.LINKTARGET);
        }

        private void setTarget(String target) {
            if (target != null) {
                this.fProperties.put(QuickinformationAspectPart.LINKTARGET, target);
            } else {
                this.fProperties.remove(QuickinformationAspectPart.LINKTARGET);
            }
        }

        private void setEndpoint(IEndPointDescriptor endPoint) {
            if (endPoint != null) {
                this.fProperties.put(QuickinformationAspectPart.ENDPOINTID, this.getXMLString(endPoint));
            } else {
                this.fProperties.remove(QuickinformationAspectPart.ENDPOINTID);
            }
        }

        private IEndPointDescriptor getEndPoint() {
            return QuickinformationAspectPart.getFromXMLString(this.fProperties.get(QuickinformationAspectPart.ENDPOINTID));
        }

        public String getTitle() {
            return this.fTitle.trim();
        }

        public String getKind() {
            if (this.fKind == null) {
                return null;
            }
            return this.fKind.getId();
        }

        public Map<String, String> getProperties() {
            return this.fProperties;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.QuickinformationAspectPart_TITLE);
            l.setLayoutData((Object)new GridData());
            this.fTitleField = new Text(parent, 2048);
            if (this.fTitle != null) {
                this.fTitleField.setText(this.fTitle);
            }
            this.fTitleField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fTitleField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditEntryDialog.this.fTitle = AddEditEntryDialog.this.fTitleField.getText().trim();
                    AddEditEntryDialog.this.validate();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.QuickinformationAspectPart_KIND);
            l.setLayoutData((Object)new GridData());
            this.fKindsCombo = new DecoratedCombo(parent, 8, 4);
            AspectEditorUtil.adaptCombo(this.fKindsCombo.getCombo());
            this.fKindsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            this.fKindsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    if (o instanceof Kind) {
                        return ((Kind)o).getName();
                    }
                    return null;
                }
            });
            this.fKindsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object kind = AddEditEntryDialog.this.fKindsCombo.getValue();
                    if (Messages.QuickinformationAspectPart_NONE_KIND.equals(kind)) {
                        AddEditEntryDialog.this.fKind = null;
                    } else {
                        AddEditEntryDialog.this.fKind = (Kind)kind;
                    }
                    AddEditEntryDialog.this.updateEndpointsVisibility();
                    AddEditEntryDialog.this.validate();
                }
            });
            this.fTargetLabel = new Label(parent, 0);
            this.fTargetLabel.setText(Messages.QuickinformationAspectPart_LINKTARGET);
            this.fTargetLabel.setLayoutData((Object)new GridData());
            this.fTargetsCombo = new Combo(parent, 8);
            AspectEditorUtil.adaptCombo(this.fTargetsCombo);
            this.fTargetsCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fTargetsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String target = AddEditEntryDialog.this.fTargetsCombo.getItem(AddEditEntryDialog.this.fTargetsCombo.getSelectionIndex());
                    if (Messages.QuickinformationAspectPart_NONE_TARGET.equals(target)) {
                        AddEditEntryDialog.this.setTarget(null);
                    } else {
                        AddEditEntryDialog.this.setTarget(target);
                    }
                    AddEditEntryDialog.this.validate();
                }
            });
            this.fTargetsCombo.add(Messages.QuickinformationAspectPart_NONE_TARGET);
            for (String p : this.fPartIds) {
                this.fTargetsCombo.add(p);
            }
            int index = -1;
            if (this.getTarget() != null) {
                index = this.fPartIds.indexOf(this.getTarget());
            }
            this.fTargetsCombo.select(index + 1);
            this.fEndpointLabel = new Label(parent, 0);
            this.fEndpointLabel.setText(Messages.QuickinformationAspectPart_ENDPOINT);
            this.fEndpointLabel.setLayoutData((Object)new GridData());
            this.fEndpointsCombo = new DecoratedCombo(parent, 8, 4);
            AspectEditorUtil.adaptCombo(this.fEndpointsCombo.getCombo());
            this.fEndpointsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            this.fEndpointsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    if (o instanceof IEndPointDescriptor) {
                        return QuickinformationAspectPart.getDialogString((IEndPointDescriptor)o);
                    }
                    return null;
                }
            });
            Object[] values = new Object[this.fEndpoints.size() + 1];
            values[0] = Messages.QuickinformationAspectPart_NONE_ENDPOINT;
            int i = 1;
            while (i <= this.fEndpoints.size()) {
                values[i] = this.fEndpoints.get(i - 1);
                ++i;
            }
            this.fEndpointsCombo.setValueSet(values);
            if (this.getEndPoint() == null) {
                this.fEndpointsCombo.setValue((Object)Messages.QuickinformationAspectPart_NONE_ENDPOINT);
            } else {
                this.fEndpointsCombo.setValue((Object)this.getEndPoint());
            }
            this.fEndpointsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object o = AddEditEntryDialog.this.fEndpointsCombo.getValue();
                    if (o instanceof String) {
                        if (Messages.QuickinformationAspectPart_NONE_ENDPOINT.equals(o)) {
                            AddEditEntryDialog.this.setEndpoint(null);
                        } else {
                            AddEditEntryDialog.this.fProperties.put(QuickinformationAspectPart.ENDPOINTID, (String)o);
                        }
                    }
                    if (o instanceof IEndPointDescriptor) {
                        AddEditEntryDialog.this.setEndpoint((IEndPointDescriptor)o);
                    }
                    AddEditEntryDialog.this.validate();
                }
            });
            Object[] valueSet = new Object[this.fKinds.size() + 1];
            valueSet[0] = Messages.QuickinformationAspectPart_NONE_KIND;
            int i2 = 1;
            while (i2 <= this.fKinds.size()) {
                valueSet[i2] = this.fKinds.get(i2 - 1);
                ++i2;
            }
            this.fKindsCombo.setValueSet(valueSet);
            if (this.fKind == null) {
                this.fKindsCombo.setValue((Object)Messages.QuickinformationAspectPart_NONE_KIND);
            } else {
                this.fKindsCombo.setValue((Object)this.fKind);
            }
            this.updateEndpointsVisibility();
        }

        private void updateEndpointsVisibility() {
            if (this.fKind != null && NO_ENDPOINT_KINDS.contains(this.fKind.getId())) {
                this.fEndpointLabel.setVisible(false);
                this.fEndpointsCombo.getLayoutControl().setVisible(false);
                this.fEndpointsCombo.setValue((Object)Messages.QuickinformationAspectPart_NONE_ENDPOINT);
                this.setEndpoint(null);
            } else {
                this.fEndpointLabel.setVisible(true);
                this.fEndpointsCombo.getLayoutControl().setVisible(true);
            }
            if (this.fKind != null && !this.showLinkTarget(this.fKind)) {
                this.fTargetLabel.setVisible(false);
                this.fTargetsCombo.setVisible(false);
                this.fTargetsCombo.select(0);
                this.setTarget(null);
            } else {
                this.fTargetLabel.setVisible(true);
                this.fTargetsCombo.setVisible(true);
            }
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }

        private String getXMLString(IEndPointDescriptor desc) {
            String ret = String.valueOf(desc.getLinkType().getLinkTypeId()) + "/";
            if (WorkItemLinkTypes.isSymmetric((IEndPointDescriptor)desc)) {
                return ret;
            }
            if (desc.getId() != null) {
                return String.valueOf(ret) + desc.getId();
            }
            if (desc.isSource()) {
                return String.valueOf(ret) + "source";
            }
            return String.valueOf(ret) + "target";
        }

        private boolean showLinkTarget(Kind kind) {
            return !"Hidden".equals(this.fKind.getId()) && !"com.ibm.team.workitem.quickinformation.kind.potentialDuplicates".equals(this.fKind.getId());
        }

        private static class Kind {
            private String fId;
            private String fName;

            public Kind(String id, String name) {
                this.fId = id;
                this.fName = name;
            }

            public String getId() {
                return this.fId;
            }

            public String getName() {
                return this.fName;
            }
        }
    }
}

