/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.ClientEvaluationContext;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopyManager;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.Statement;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.AbstractSerializationContext;
import com.ibm.team.workitem.common.internal.expression.EditableStatement;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.expression.ModelElementWrapper;
import com.ibm.team.workitem.common.internal.expression.XMLExpressionSerializer;
import com.ibm.team.workitem.common.internal.query.util.ProcessTemplateCheckVisitor;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQuery;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedQueryManager {
    private static final boolean XML_OMIT_DECLARATION = true;
    private static final int XML_INDENT = 4;
    private final ProcessAspect fAspect;
    private final String fProcessAspectId;
    private final List<IChangeListener> fListeners;
    private List<PredefinedQuery> fPredefinedQueries;

    public PredefinedQueryManager(ProcessAspect aspect, String processAspectId) {
        Assert.isNotNull((Object)aspect);
        Assert.isNotNull((Object)processAspectId);
        this.fAspect = aspect;
        this.fProcessAspectId = processAspectId;
        this.fListeners = new LinkedList<IChangeListener>();
    }

    public List<PredefinedQuery> getQueries() {
        if (this.fPredefinedQueries == null) {
            this.fPredefinedQueries = this.readFromAspect();
        }
        return this.fPredefinedQueries;
    }

    public void applyChanges() {
        this.updateAspect();
        this.notifyDirtyStateChanged(false);
    }

    public void revertChanges() {
        this.fPredefinedQueries = this.readFromAspect();
        this.notifyStructureChanged();
        this.notifyDirtyStateChanged(false);
    }

    private List<PredefinedQuery> readFromAspect() {
        ArrayList<PredefinedQuery> queries = new ArrayList<PredefinedQuery>();
        ModelElement queryRoot = this.fAspect.getConfigurationElement();
        if (queryRoot != null) {
            XMLExpressionSerializer serializer = new XMLExpressionSerializer();
            IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)this.getProcessItem(), IQueryClient.class);
            for (Object element : queryRoot.getChildElements()) {
                ModelElement queryElement = (ModelElement)element;
                if (!queryElement.getName().equals("query")) continue;
                String name = queryElement.getAttribute("name");
                String type = queryElement.getAttribute("type");
                String id = queryElement.getAttribute("id");
                String description = queryElement.getAttribute("description");
                try {
                    Expression expression = serializer.deserialize((IPersistableElement)new ModelElementWrapper(queryElement), (ISerializationContext)new SerializationContext(type));
                    IQueryDescriptor query = queryClient.createQuery(this.getProjectArea(), type, name, expression);
                    query.setId(id);
                    query.setDescription(description);
                    queries.add(new PredefinedQuery(this, query));
                }
                catch (SerializationException e) {
                    Status status = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQueryManager_INVALID_QUERY, (Throwable)e);
                    queries.add(new PredefinedQuery(this, name, (IStatus)status));
                }
            }
        }
        this.checkQueries(queries);
        return queries;
    }

    public void addPredefinedQueries(List<PredefinedQuery> predefinedQueries) {
        this.fPredefinedQueries.addAll(predefinedQueries);
        this.notifyStructureChanged();
    }

    public void removePredefinedQueries(List<PredefinedQuery> predefinedQueries) {
        this.fPredefinedQueries.removeAll(predefinedQueries);
        this.notifyStructureChanged();
    }

    public void addQueries(final List<IQueryDescriptorHandle> queries) {
        IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)this.getProcessItem(), IQueryClient.class);
        final IQueryDescriptorWorkingCopyManager workingCopyManager = queryClient.getWorkingCopyManager();
        UIUpdaterJob job = new UIUpdaterJob(Messages.PredefinedQueryManager_RESOLVING_QUERIES_JOB_MESSAGE){
            private List<PredefinedQuery> fResolved;

            public IStatus runInBackground(IProgressMonitor monitor) {
                ArrayList<PredefinedQuery> predefinedQueries = new ArrayList<PredefinedQuery>(queries.size());
                monitor.beginTask(Messages.PredefinedQueryManager_ADDING_QUERIES, queries.size());
                for (IQueryDescriptorHandle handle : queries) {
                    try {
                        try {
                            workingCopyManager.connect(handle, monitor);
                            IQueryDescriptorWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(handle);
                            EditableStatement editableStatement = workingCopy.getEditableStatement();
                            Statement statement = editableStatement.createLogicalRootStatement();
                            ClientEvaluationContext context = new ClientEvaluationContext(workingCopy.getQueryDescriptor().getProjectArea());
                            ProcessTemplateCheckVisitor visitor = new ProcessTemplateCheckVisitor((IEvaluationContext)context);
                            statement.accept((ProgressExpressionVisitor)visitor, monitor);
                            IQueryDescriptor copy = (IQueryDescriptor)EMFHelper.copy((Object)workingCopy.getQueryDescriptor());
                            copy.setExpression((Expression)statement);
                            predefinedQueries.add(new PredefinedQuery(PredefinedQueryManager.this, copy, visitor.getViolationStatus()));
                            monitor.worked(1);
                        }
                        catch (TeamRepositoryException e) {
                            Status status = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQueryManager_RESOLVING_QUERIES_ERROR, (Throwable)e);
                            workingCopyManager.disconnect(handle);
                            return status;
                        }
                    }
                    finally {
                        workingCopyManager.disconnect(handle);
                    }
                }
                monitor.done();
                this.fResolved = predefinedQueries;
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                PredefinedQueryManager.this.addPredefinedQueries(this.fResolved);
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    private void checkQueries(final ArrayList<PredefinedQuery> queries) {
        UIUpdaterJob job = new UIUpdaterJob(Messages.PredefinedQueryManager_QUERY_VALIDATION_JOB_MESSAGE){
            private HashMap<PredefinedQuery, IStatus> fMap;
            {
                super($anonymous0);
                this.fMap = new HashMap();
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                for (PredefinedQuery predefinedQuery : queries) {
                    IQueryDescriptor query = predefinedQuery.getQueryDescriptor();
                    if (query == null) continue;
                    ClientEvaluationContext context = query.getProjectArea() != null ? new ClientEvaluationContext(query.getProjectArea()) : null;
                    ProcessTemplateCheckVisitor visitor = new ProcessTemplateCheckVisitor((IEvaluationContext)context);
                    try {
                        query.getExpression().accept((ProgressExpressionVisitor)visitor, monitor);
                        if (visitor.getTemplateViolations().isEmpty()) continue;
                        this.fMap.put(predefinedQuery, visitor.getViolationStatus());
                    }
                    catch (TeamRepositoryException e) {
                        Status error = new Status(4, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQueryManager_PROCESS_TEMPLATE_CHECK_FAILED, (Throwable)e);
                        this.fMap.put(predefinedQuery, (IStatus)error);
                    }
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                for (PredefinedQuery predefined : this.fMap.keySet()) {
                    predefined.setStatus(this.fMap.get(predefined));
                }
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    private void updateAspect() {
        XMLExpressionSerializer serializer = new XMLExpressionSerializer();
        StringWriter writer = new StringWriter(4096);
        String startElement = String.format("<%s id=\"%s\" xmlns=\"%s\">\n", this.fAspect.getXmlTag(), this.fProcessAspectId, this.fAspect.getSchemaNamespaceURI());
        writer.append(startElement);
        for (PredefinedQuery query : this.fPredefinedQueries) {
            IQueryDescriptor queryDescriptor = query.getQueryDescriptor();
            if (queryDescriptor == null) continue;
            serializer.serialize((Writer)writer, queryDescriptor, true, 4);
            writer.append("\n");
        }
        writer.append("</configuration-data>\n");
        this.fAspect.update(writer.toString(), true);
    }

    public IProcessItemHandle getProcessItem() {
        return (IProcessItemHandle)this.fAspect.getProcessContainerWorkingCopy().getUnderlyingProcessItem().getItemHandle();
    }

    private IProjectAreaHandle getProjectArea() {
        IProcessItemHandle processItemHandle = this.getProcessItem();
        if (processItemHandle instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)processItemHandle;
        }
        return null;
    }

    public void addListener(IChangeListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyStructureChanged() {
        for (IChangeListener listener : this.fListeners) {
            listener.queryStructureChanged();
            listener.dirtyStateChanged(true);
        }
    }

    public void notifyChanged(PredefinedQuery predefinedQuery, String[] properties) {
        for (IChangeListener listener : this.fListeners) {
            listener.queryChanged(predefinedQuery, properties);
            if (properties.length == 1 && "status".equals(properties[0])) continue;
            this.notifyDirtyStateChanged(true);
        }
    }

    private void notifyDirtyStateChanged(boolean dirty) {
        for (IChangeListener listener : this.fListeners) {
            listener.dirtyStateChanged(dirty);
        }
    }

    public static interface IChangeListener {
        public void queryChanged(PredefinedQuery var1, String[] var2);

        public void queryStructureChanged();

        public void dirtyStateChanged(boolean var1);
    }

    private class SerializationContext
    extends AbstractSerializationContext {
        private String fType;

        public SerializationContext(String queryType) {
            this.fType = queryType;
        }

        protected String getQueryType() {
            if (this.fType == null || "".equals(this.fType)) {
                return "com.ibm.team.workitem.workItemType";
            }
            return this.fType;
        }

        public Object getOrigin() {
            return PredefinedQueryManager.this.getProcessItem().getOrigin();
        }
    }
}

