/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQuery;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;

public class PredefinedQueryLabelProvider
extends CellLabelProvider {
    private static final ImageDescriptor QUERY_ICON = com.ibm.team.workitem.rcp.ui.internal.ImagePool.QUERY_ICON;
    private OverlayIcon fQueryWithWarning;
    private OverlayIcon fQueryWithError;
    private ResourceManager fResourceManager;

    public PredefinedQueryLabelProvider() {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.WARNING_OVR;
        this.fQueryWithWarning = new OverlayIcon(QUERY_ICON, imageDescriptorArray, 16512);
        ImageDescriptor[] imageDescriptorArray2 = new ImageDescriptor[2];
        imageDescriptorArray2[1] = ImagePool.ERROR_OVR;
        this.fQueryWithError = new OverlayIcon(QUERY_ICON, imageDescriptorArray2, 16512);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public boolean isLabelProperty(Object element, String property) {
        return !"desc".equals(property);
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof PredefinedQuery) {
            PredefinedQuery predefinedQuery = (PredefinedQuery)cell.getElement();
            String name = predefinedQuery.getName();
            cell.setText(name != null ? name : "");
            ImageDescriptor imageDescriptor = this.getImageDescriptor(predefinedQuery.getStatus());
            cell.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)imageDescriptor));
        }
    }

    public String getToolTipText(Object element) {
        if (element instanceof PredefinedQuery) {
            PredefinedQuery predefinedQuery = (PredefinedQuery)element;
            return predefinedQuery.getStatus().getMessage();
        }
        return super.getToolTipText(element);
    }

    private ImageDescriptor getImageDescriptor(IStatus status) {
        switch (status.getSeverity()) {
            case 2: {
                return this.fQueryWithWarning;
            }
            case 4: {
                return this.fQueryWithError;
            }
        }
        return QUERY_ICON;
    }

    public void dispose() {
        this.fResourceManager.dispose();
        super.dispose();
    }
}

