/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.queries.PredefinedQuery;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PredefinedQueryDetailsSection
implements ISelectionChangedListener {
    private static final IStatus EMPTY_INFO_STATUS = new Status(1, "com.ibm.team.workitem.ide.ui", Messages.PredefinedQueryDetailsSection_SECTION_INFO);
    private static final String ESCAPED_EXPLANATION = XMLString.createFromPlainText((String)Messages.PredefinedQueryDetailsSection_INFO_LINK_EXPLAIN_TEXT).getXMLText();
    private PredefinedQuery fCurrentQuery;
    private LocalResourceManager fResourceManager;
    private Label fImageLabel;
    private Link fInfoLink;
    private Text fNameText;
    private Text fDescriptionText;
    private Text fIdentifierText;

    public void createContent(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 3, 0).applyTo(parent);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite statusComposite = toolkit.createComposite(parent);
        this.createStatusComposite(statusComposite, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)statusComposite);
        toolkit.createLabel(parent, Messages.PredefinedQueryDetailsSection_NAME_LABEL);
        this.fNameText = toolkit.createText(parent, "", 2048);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PredefinedQueryDetailsSection.this.modelUpdateName();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNameText);
        toolkit.createLabel(parent, Messages.PredefinedQueryDetailsSection_IDENTIFIER_LABEL);
        this.fIdentifierText = toolkit.createText(parent, "", 2048);
        this.fIdentifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PredefinedQueryDetailsSection.this.modelUpdateIdentifier();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fIdentifierText);
        toolkit.createLabel(parent, Messages.PredefinedQueryDetailsSection_DESCRIPTION_LABEL);
        this.fDescriptionText = toolkit.createText(parent, "", 2114);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PredefinedQueryDetailsSection.this.modelUpdateDescription();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fDescriptionText);
        this.update();
    }

    private void createStatusComposite(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(0, 0, 0, 5).applyTo(parent);
        this.fImageLabel = toolkit.createLabel(parent, "");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.fImageLabel);
        this.fInfoLink = new Link(parent, toolkit.getOrientation());
        this.fInfoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PredefinedQueryDetailsSection.this.handleExplainWhy();
            }
        });
        int minWidth = Utils.convertWidthInCharsToPixels((Control)this.fInfoLink, (int)25);
        int minHeight = Utils.convertHeightInCharsToPixels((Control)this.fInfoLink, (int)2);
        GridDataFactory.fillDefaults().hint(minWidth, minHeight).grab(true, false).applyTo((Control)this.fInfoLink);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selected;
        this.fCurrentQuery = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof PredefinedQuery) {
            this.fCurrentQuery = (PredefinedQuery)selected;
        }
        this.update();
    }

    private void update() {
        if (this.fCurrentQuery != null) {
            this.updateStatus(this.fCurrentQuery.getStatus());
            this.updateText(this.fNameText, this.fCurrentQuery.getName(), true);
            this.updateText(this.fDescriptionText, this.fCurrentQuery.getDescription(), true);
            this.updateText(this.fIdentifierText, this.fCurrentQuery.getIdentifier(), true);
        } else {
            this.updateStatus(EMPTY_INFO_STATUS);
            this.updateText(this.fNameText, "", false);
            this.updateText(this.fDescriptionText, "", false);
            this.updateText(this.fIdentifierText, "", false);
        }
    }

    private void updateText(Text text, String value, boolean enabled) {
        text.setText(value != null ? value : "");
        text.setEnabled(enabled);
    }

    private void updateStatus(IStatus status) {
        this.fImageLabel.setImage(this.createImage(status));
        if (status instanceof MultiStatus && status.matches(6)) {
            String link = NLS.bind((String)"<a>{0}</a>", (Object)ESCAPED_EXPLANATION, (Object[])new Object[0]);
            String label = NLS.bind((String)Messages.PredefinedQueryDetailsSection_EXPLANATION_LINK_FORMAT, (Object)status.getMessage(), (Object[])new Object[]{link});
            this.fInfoLink.setText(label);
        } else {
            this.fInfoLink.setText(status.getMessage());
        }
    }

    private void modelUpdateName() {
        if (this.fCurrentQuery != null) {
            this.fCurrentQuery.setName(this.fNameText.getText());
            this.updateStatus(this.fCurrentQuery.getStatus());
        }
    }

    private void modelUpdateDescription() {
        if (this.fCurrentQuery != null) {
            this.fCurrentQuery.setDescription(this.fDescriptionText.getText());
        }
    }

    private void modelUpdateIdentifier() {
        if (this.fCurrentQuery != null) {
            this.fCurrentQuery.setIdentifier(this.fIdentifierText.getText());
            this.updateStatus(this.fCurrentQuery.getStatus());
        }
    }

    private void handleExplainWhy() {
        if (this.fCurrentQuery.getStatus() instanceof MultiStatus) {
            MultiStatus status = (MultiStatus)this.fCurrentQuery.getStatus();
            ListDialog listDialog = new ListDialog(this.fInfoLink.getShell());
            listDialog.setAddCancelButton(false);
            listDialog.setTitle(Messages.PredefinedQueryDetailsSection_VALIDATION_ERROR_DIALOG_TITLE);
            listDialog.setMessage(status.getMessage());
            listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            listDialog.setLabelProvider((ILabelProvider)new StatusLabelProvider());
            listDialog.setInput((Object)status.getChildren());
            listDialog.open();
        }
    }

    private Image createImage(IStatus status) {
        return this.fResourceManager.createImage(this.getImageDescriptor(status));
    }

    private ImageDescriptor getImageDescriptor(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                return ImagePool.SUCCESS_ICON;
            }
            case 2: {
                return ImagePool.WARNING_ICON;
            }
            case 4: {
                return ImagePool.ERROR_ICON;
            }
        }
        return ImagePool.INFO_ICON;
    }

    private class StatusLabelProvider
    extends LabelProvider {
        private StatusLabelProvider() {
        }

        public String getText(Object element) {
            IStatus status = (IStatus)element;
            return status.getMessage();
        }

        public Image getImage(Object element) {
            IStatus status = (IStatus)element;
            return PredefinedQueryDetailsSection.this.createImage(status);
        }
    }
}

