/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.oslc;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.workitem.common.internal.StateGroups;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.oslc.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowBindingManager;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WorkflowManager;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeBindingAspectEditor
extends ProcessAspectEditor {
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String OSLC_TYPES = "com.ibm.team.workitem.configuration.oslc.types";
    private static final String ID = "id";
    private static final String TYPE_BINDING_ELEMENT = "typeBinding";
    private static final String OSLC_TYPE_ATTRIBUTE = "oslcTypeId";
    private static final String WORKITEM_TYPE_ATTRIBUTE = "workItemTypeId";
    private static final String OSLC_DEFECT = "defect";
    private static final String OSLC_PLANITEM = "planItem";
    private static final String NONE = Messages.TypeBindingAspectEditor_NONE;
    private String fConfigurationDataId;
    private List<TypeCategory.Type> fTypes;
    private List<TypeCategory> fTypeCategories;
    private Map<TypeCategory.Type, WFWorkflow> fWorkflowMap;
    private TypeCategory.Type fDefect;
    private TypeCategory.Type fPlanItem;
    private StateGroups fStateGroups;
    private DecoratedCombo fDefectCombo;
    private DecoratedCombo fPlanItemCombo;
    private DecoratedCombo fPlanItemReadyForTestingStateCombo;
    private DecoratedCombo fDefectReadyForTestingStateCombo;
    private DecoratedCombo fDefectReadyForTestingResolutionCombo;

    public TypeBindingAspectEditor(String processAspectId) {
        this.fConfigurationDataId = processAspectId;
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.init();
    }

    private void init() {
        this.fDefect = null;
        this.fPlanItem = null;
        this.fStateGroups = new StateGroups();
        List<TypeCategory.Type> types = this.getTypes();
        TypeCategory nullCategory = new TypeCategory("");
        ModelElement root = this.getAspect().getConfigurationElement();
        if (root != null) {
            for (ModelElement data : root.getChildElements()) {
                if (!CONFIGURATION_ELEMENT.equals(data.getName())) continue;
                String configurationId = data.getAttribute(ID);
                if (OSLC_TYPES.equals(configurationId)) {
                    for (ModelElement element : data.getChildElements()) {
                        String oslc = element.getAttribute(OSLC_TYPE_ATTRIBUTE);
                        if (oslc == null) continue;
                        String jazz = element.getAttribute(WORKITEM_TYPE_ATTRIBUTE);
                        if (jazz != null && "".equals(jazz.trim())) {
                            jazz = null;
                        }
                        if (OSLC_DEFECT.equals(oslc)) {
                            for (TypeCategory.Type t : types) {
                                if (!t.getIdentifier().equals(jazz)) continue;
                                this.fDefect = t;
                                break;
                            }
                            if (this.fDefect != null || jazz == null) continue;
                            TypeCategory typeCategory = nullCategory;
                            typeCategory.getClass();
                            this.fDefect = new TypeCategory.Type(typeCategory, jazz, jazz, null, null, Collections.<String>emptyList());
                            continue;
                        }
                        if (!OSLC_PLANITEM.equals(oslc)) continue;
                        for (TypeCategory.Type t : types) {
                            if (!t.getIdentifier().equals(jazz)) continue;
                            this.fPlanItem = t;
                            break;
                        }
                        if (this.fPlanItem != null || jazz == null) continue;
                        TypeCategory typeCategory = nullCategory;
                        typeCategory.getClass();
                        this.fPlanItem = new TypeCategory.Type(typeCategory, jazz, jazz, null, null, Collections.<String>emptyList());
                    }
                    continue;
                }
                if (!"com.ibm.team.workitem.configuration.stateGroups".equals(configurationId)) continue;
                this.fStateGroups = StateGroups.readFromModelElement((ModelElement)data);
            }
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().numColumns(6).applyTo(parent);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        AspectEditorLabelProvider labelProvider = new AspectEditorLabelProvider(this.getAspect(), (ResourceManager)resourceManager);
        this.createDefectCombo(parent, toolkit, labelProvider);
        this.createDefectReadyForTestingStateCombo(parent, toolkit, labelProvider);
        this.createDefectReadyForTestingResolutionCombo(parent, toolkit, labelProvider);
        this.createPlanItemCombo(parent, toolkit, labelProvider);
        this.createPlanItemReadyForTestingStateCombo(parent, toolkit, labelProvider);
        Label fillLabel = toolkit.createLabel(parent, "");
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)fillLabel);
        this.updateComboValues();
    }

    private void createDefectCombo(Composite parent, FormToolkit toolkit, LabelProvider labelProvider) {
        Label typeLabel = toolkit.createLabel(parent, Messages.TypeBindingAspectEditor_DEFECT);
        GridDataFactory.swtDefaults().applyTo((Control)typeLabel);
        this.fDefectCombo = new DecoratedCombo(parent, 8, 1);
        toolkit.adapt((Control)this.fDefectCombo.getCombo(), true, false);
        this.fDefectCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = TypeBindingAspectEditor.this.fDefectCombo.getValue();
                if (value instanceof TypeCategory.Type) {
                    if (TypeBindingAspectEditor.this.fDefect != value) {
                        TypeBindingAspectEditor.this.fDefect = (TypeCategory.Type)value;
                        TypeBindingAspectEditor.this.setDirty();
                    }
                } else if (NONE.equals(value) && TypeBindingAspectEditor.this.fDefect != null) {
                    TypeBindingAspectEditor.this.fDefect = null;
                    TypeBindingAspectEditor.this.setDirty();
                }
                TypeBindingAspectEditor.this.updateReadyForTestingStateCombo();
            }
        });
        this.fDefectCombo.setLabelProvider((ILabelProvider)labelProvider);
        GridDataFactory.fillDefaults().applyTo(this.fDefectCombo.getLayoutControl());
    }

    private void createDefectReadyForTestingStateCombo(Composite parent, FormToolkit toolkit, LabelProvider labelProvider) {
        Label defectReadyForTestingStateLabel = toolkit.createLabel(parent, Messages.TypeBindingAspectEditor_READY_FOR_TESTING_STATE);
        GridDataFactory.swtDefaults().applyTo((Control)defectReadyForTestingStateLabel);
        this.fDefectReadyForTestingStateCombo = new DecoratedCombo(parent, 8, 1);
        toolkit.adapt((Control)this.fDefectReadyForTestingStateCombo.getCombo(), true, false);
        this.fDefectReadyForTestingStateCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = TypeBindingAspectEditor.this.fDefectReadyForTestingStateCombo.getValue();
                if (value instanceof WFWorkflow.WFState) {
                    if (TypeBindingAspectEditor.this.setReadyForTestingState("com.ibm.team.rqm.stateGroup.readyForTesting.defect", (WFWorkflow.WFState)value)) {
                        TypeBindingAspectEditor.this.setDirty();
                    }
                } else if (NONE.equals(value) && TypeBindingAspectEditor.this.setReadyForTestingState("com.ibm.team.rqm.stateGroup.readyForTesting.defect", null)) {
                    TypeBindingAspectEditor.this.setDirty();
                }
            }
        });
        this.fDefectReadyForTestingStateCombo.setLabelProvider((ILabelProvider)labelProvider);
        GridDataFactory.fillDefaults().applyTo(this.fDefectReadyForTestingStateCombo.getLayoutControl());
    }

    private void createDefectReadyForTestingResolutionCombo(Composite parent, FormToolkit toolkit, LabelProvider labelProvider) {
        Label defectReadyForTestingStateLabel = toolkit.createLabel(parent, Messages.TypeBindingAspectEditor_RESOLUTION_LABEL);
        GridDataFactory.swtDefaults().applyTo((Control)defectReadyForTestingStateLabel);
        this.fDefectReadyForTestingResolutionCombo = new DecoratedCombo(parent, 8, 1);
        toolkit.adapt((Control)this.fDefectReadyForTestingResolutionCombo.getCombo(), true, false);
        this.fDefectReadyForTestingResolutionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = TypeBindingAspectEditor.this.fDefectReadyForTestingResolutionCombo.getValue();
                if (value instanceof WFWorkflow.WFResolution) {
                    if (TypeBindingAspectEditor.this.setReadyForTestingResolution("com.ibm.team.rqm.stateGroup.readyForTesting.defect", (WFWorkflow.WFResolution)value)) {
                        TypeBindingAspectEditor.this.setDirty();
                    }
                } else if (NONE.equals(value) && TypeBindingAspectEditor.this.setReadyForTestingResolution("com.ibm.team.rqm.stateGroup.readyForTesting.defect", null)) {
                    TypeBindingAspectEditor.this.setDirty();
                }
            }
        });
        this.fDefectReadyForTestingResolutionCombo.setLabelProvider((ILabelProvider)labelProvider);
        GridDataFactory.fillDefaults().applyTo(this.fDefectReadyForTestingResolutionCombo.getLayoutControl());
    }

    private void createPlanItemCombo(Composite parent, FormToolkit toolkit, LabelProvider labelProvider) {
        Label planItemLabel = toolkit.createLabel(parent, Messages.TypeBindingAspectEditor_PLAN_ITEM);
        GridDataFactory.swtDefaults().applyTo((Control)planItemLabel);
        this.fPlanItemCombo = new DecoratedCombo(parent, 8, 1);
        toolkit.adapt((Control)this.fPlanItemCombo.getCombo(), true, false);
        this.fPlanItemCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = TypeBindingAspectEditor.this.fPlanItemCombo.getValue();
                if (value instanceof TypeCategory.Type) {
                    if (TypeBindingAspectEditor.this.fPlanItem != value) {
                        TypeBindingAspectEditor.this.fPlanItem = (TypeCategory.Type)value;
                        TypeBindingAspectEditor.this.setReadyForTestingState("com.ibm.team.rqm.stateGroup.readyForTesting", null);
                        TypeBindingAspectEditor.this.setDirty();
                    }
                } else if (NONE.equals(value) && TypeBindingAspectEditor.this.fPlanItem != null) {
                    TypeBindingAspectEditor.this.fPlanItem = null;
                    TypeBindingAspectEditor.this.setDirty();
                }
                TypeBindingAspectEditor.this.updateReadyForTestingStateCombo();
            }
        });
        this.fPlanItemCombo.setLabelProvider((ILabelProvider)labelProvider);
        GridDataFactory.fillDefaults().applyTo(this.fPlanItemCombo.getLayoutControl());
    }

    private void createPlanItemReadyForTestingStateCombo(Composite parent, FormToolkit toolkit, LabelProvider labelProvider) {
        Label readyForTestingStateLabel = toolkit.createLabel(parent, Messages.TypeBindingAspectEditor_READY_FOR_TESTING_STATE);
        GridDataFactory.swtDefaults().applyTo((Control)readyForTestingStateLabel);
        this.fPlanItemReadyForTestingStateCombo = new DecoratedCombo(parent, 8, 1);
        toolkit.adapt((Control)this.fPlanItemReadyForTestingStateCombo.getCombo(), true, false);
        this.fPlanItemReadyForTestingStateCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value = TypeBindingAspectEditor.this.fPlanItemReadyForTestingStateCombo.getValue();
                if (value instanceof WFWorkflow.WFState) {
                    if (TypeBindingAspectEditor.this.setReadyForTestingState("com.ibm.team.rqm.stateGroup.readyForTesting", (WFWorkflow.WFState)value)) {
                        TypeBindingAspectEditor.this.setDirty();
                    }
                } else if (NONE.equals(value) && TypeBindingAspectEditor.this.setReadyForTestingState("com.ibm.team.rqm.stateGroup.readyForTesting", null)) {
                    TypeBindingAspectEditor.this.setDirty();
                }
            }
        });
        this.fPlanItemReadyForTestingStateCombo.setLabelProvider((ILabelProvider)labelProvider);
        GridDataFactory.fillDefaults().applyTo(this.fPlanItemReadyForTestingStateCombo.getLayoutControl());
    }

    private void updateComboValues() {
        List<TypeCategory.Type> types = this.getTypes();
        if (this.fDefectCombo != null && !this.fDefectCombo.getCombo().isDisposed()) {
            this.fDefectCombo.setValueSet(types.toArray());
            if (this.fDefect != null) {
                this.fDefectCombo.setValue((Object)this.fDefect);
            } else {
                this.fDefectCombo.setValue((Object)NONE);
            }
        }
        if (this.fPlanItemCombo != null && !this.fPlanItemCombo.getCombo().isDisposed()) {
            this.fPlanItemCombo.setValueSet(types.toArray());
            if (this.fPlanItem != null) {
                this.fPlanItemCombo.setValue((Object)this.fPlanItem);
            } else {
                this.fPlanItemCombo.setValue((Object)NONE);
            }
        }
        this.updateReadyForTestingStateCombo();
    }

    private void updateReadyForTestingStateCombo() {
        WFWorkflow.WFState state;
        if (this.fDefectReadyForTestingStateCombo != null && !this.fDefectReadyForTestingStateCombo.getCombo().isDisposed()) {
            this.fDefectReadyForTestingStateCombo.setValueSet(this.addNone(this.getWFStates(this.fDefect)));
            state = this.getReadyForTestingState(this.fDefect, "com.ibm.team.rqm.stateGroup.readyForTesting.defect");
            if (state != null) {
                this.fDefectReadyForTestingStateCombo.setValue((Object)state);
            } else {
                this.fDefectReadyForTestingStateCombo.setValue((Object)NONE);
            }
        }
        if (this.fDefectReadyForTestingResolutionCombo != null && !this.fDefectReadyForTestingResolutionCombo.getCombo().isDisposed()) {
            this.fDefectReadyForTestingResolutionCombo.setValueSet(this.addNone(this.getWFResolutions(this.fDefect)));
            WFWorkflow.WFResolution resolution = this.getReadyForTestingResolution(this.fDefect, "com.ibm.team.rqm.stateGroup.readyForTesting.defect");
            if (resolution != null) {
                this.fDefectReadyForTestingResolutionCombo.setValue((Object)resolution);
            } else {
                this.fDefectReadyForTestingResolutionCombo.setValue((Object)NONE);
            }
        }
        if (this.fPlanItemReadyForTestingStateCombo != null && !this.fPlanItemReadyForTestingStateCombo.getCombo().isDisposed()) {
            this.fPlanItemReadyForTestingStateCombo.setValueSet(this.addNone(this.getWFStates(this.fPlanItem)));
            state = this.getReadyForTestingState(this.fPlanItem, "com.ibm.team.rqm.stateGroup.readyForTesting");
            if (state != null) {
                this.fPlanItemReadyForTestingStateCombo.setValue((Object)state);
            } else {
                this.fPlanItemReadyForTestingStateCombo.setValue((Object)NONE);
            }
        }
    }

    private Object[] addNone(List<?> values) {
        ArrayList<String> newValues = new ArrayList<String>();
        newValues.add(NONE);
        newValues.addAll(values);
        return newValues.toArray();
    }

    private WFWorkflow.WFState getReadyForTestingState(TypeCategory.Type type, String stateGroupId) {
        String stateId;
        Map<TypeCategory.Type, WFWorkflow> workflowMap = this.getWorkflowMap();
        WFWorkflow workflow = workflowMap.get(type);
        if (workflow != null && (stateId = this.getReadyForTestingState(stateGroupId)) != null) {
            for (WFWorkflow.WFState state : workflow.getStates()) {
                if (!state.getIdentifier().equals(stateId)) continue;
                return state;
            }
        }
        return null;
    }

    private WFWorkflow.WFResolution getReadyForTestingResolution(TypeCategory.Type type, String stateGroupId) {
        String resolutionId;
        Map<TypeCategory.Type, WFWorkflow> workflowMap = this.getWorkflowMap();
        WFWorkflow workflow = workflowMap.get(type);
        if (workflow != null && (resolutionId = this.getReadyForTestingResolution(stateGroupId)) != null) {
            for (WFWorkflow.WFResolution resolution : workflow.getResolutions()) {
                if (!resolution.getId().equals(resolutionId)) continue;
                return resolution;
            }
        }
        return null;
    }

    private String getReadyForTestingState(String stateGroupId) {
        StateGroups.StateGroup stateGroup = this.getReadyForTestingStateGroup(stateGroupId);
        List stateIds = stateGroup.getStateIds();
        if (stateIds.isEmpty()) {
            return null;
        }
        return ((Identifier)stateIds.get(0)).getStringIdentifier();
    }

    private String getReadyForTestingResolution(String stateGroupId) {
        StateGroups.StateGroup stateGroup = this.getReadyForTestingStateGroup(stateGroupId);
        List resolutionIds = stateGroup.getResolutionIds();
        if (resolutionIds.isEmpty()) {
            return null;
        }
        return ((Identifier)resolutionIds.get(0)).getStringIdentifier();
    }

    private boolean setReadyForTestingState(String stateGroupId, WFWorkflow.WFState value) {
        String newState = value == null ? null : value.getIdentifier();
        String currentState = this.getReadyForTestingState(stateGroupId);
        if (this.equals(currentState, newState)) {
            return false;
        }
        StateGroups.StateGroup stateGroup = this.getReadyForTestingStateGroup(stateGroupId);
        stateGroup.clearStates();
        stateGroup.addState(newState);
        return true;
    }

    private boolean setReadyForTestingResolution(String stateGroupId, WFWorkflow.WFResolution value) {
        String newResolution = value == null ? null : value.getId();
        String currentResolution = this.getReadyForTestingResolution(stateGroupId);
        if (this.equals(currentResolution, newResolution)) {
            return false;
        }
        StateGroups.StateGroup stateGroup = this.getReadyForTestingStateGroup(stateGroupId);
        stateGroup.clearResolutions();
        stateGroup.addResolution(newResolution);
        return true;
    }

    private StateGroups.StateGroup getReadyForTestingStateGroup(String stateGroupId) {
        StateGroups.StateGroup stateGroup = this.fStateGroups.getStateGroup(stateGroupId);
        if (stateGroup == null) {
            stateGroup = new StateGroups.StateGroup(stateGroupId, null);
            this.fStateGroups.add(stateGroup);
        }
        return stateGroup;
    }

    public void revert() {
        this.init();
        this.updateComboValues();
    }

    public void dispose() {
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        IMemento child;
        if (this.fDefect == null && this.fPlanItem == null) {
            return false;
        }
        memento.putString(ID, this.fConfigurationDataId);
        String namespace = this.getAspect().getSchemaNamespaceURI();
        if (namespace != null) {
            memento.putString("xmlns", namespace);
        }
        IMemento configuration = memento.createChild(CONFIGURATION_ELEMENT);
        configuration.putString(ID, OSLC_TYPES);
        if (this.fDefect != null) {
            child = configuration.createChild(TYPE_BINDING_ELEMENT);
            child.putString(OSLC_TYPE_ATTRIBUTE, OSLC_DEFECT);
            child.putString(WORKITEM_TYPE_ATTRIBUTE, this.fDefect.getIdentifier());
        }
        if (this.fPlanItem != null) {
            child = configuration.createChild(TYPE_BINDING_ELEMENT);
            child.putString(OSLC_TYPE_ATTRIBUTE, OSLC_PLANITEM);
            child.putString(WORKITEM_TYPE_ATTRIBUTE, this.fPlanItem.getIdentifier());
        }
        IMemento stateGroupConfiguration = memento.createChild(CONFIGURATION_ELEMENT);
        stateGroupConfiguration.putString(ID, "com.ibm.team.workitem.configuration.stateGroups");
        this.fStateGroups.storeToMemento(stateGroupConfiguration);
        return true;
    }

    private List<TypeCategory> readTypeCategories() {
        if (this.fTypeCategories == null) {
            ModelElement typeElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
            this.fTypeCategories = TypeManager.readTypeCategories(typeElement);
        }
        return this.fTypeCategories;
    }

    private List<WFWorkflow> readWorkflows() {
        ModelElement workflowElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflow");
        if (workflowElement != null) {
            return WorkflowManager.readWorkflows(workflowElement);
        }
        return new ArrayList<WFWorkflow>();
    }

    private List<WorkflowBinding> readWorkflowBindings() {
        ModelElement bindingElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workflowBinding");
        if (bindingElement != null) {
            return WorkflowBindingManager.readWorkflowBindings(bindingElement);
        }
        return Collections.emptyList();
    }

    private List<WFWorkflow.WFState> getWFStates(TypeCategory.Type type) {
        Map<TypeCategory.Type, WFWorkflow> workflowMap = this.getWorkflowMap();
        WFWorkflow workflow = workflowMap.get(type);
        if (workflow != null) {
            return workflow.getStates();
        }
        return Collections.emptyList();
    }

    private List<WFWorkflow.WFResolution> getWFResolutions(TypeCategory.Type type) {
        Map<TypeCategory.Type, WFWorkflow> workflowMap = this.getWorkflowMap();
        WFWorkflow workflow = workflowMap.get(type);
        if (workflow != null) {
            return workflow.getResolutions();
        }
        return Collections.emptyList();
    }

    private List<TypeCategory.Type> getTypes() {
        if (this.fTypes == null) {
            ArrayList<TypeCategory.Type> orderedTypes = new ArrayList<TypeCategory.Type>(this.getWorkflowMap().keySet());
            final Collator collator = Collator.getInstance();
            Collections.sort(orderedTypes, new Comparator<TypeCategory.Type>(){

                @Override
                public int compare(TypeCategory.Type o1, TypeCategory.Type o2) {
                    if (o1 == null || o1.getName() == null) {
                        return -1;
                    }
                    if (o2 == null || o2.getName() == null) {
                        return 1;
                    }
                    return collator.compare(o1.getName(), o2.getName());
                }
            });
            this.fTypes = orderedTypes;
        }
        return this.fTypes;
    }

    private Map<TypeCategory.Type, WFWorkflow> getWorkflowMap() {
        if (this.fWorkflowMap == null) {
            HashMap<TypeCategory.Type, WFWorkflow> map = new HashMap<TypeCategory.Type, WFWorkflow>();
            List<WFWorkflow> workflows = this.readWorkflows();
            HashMap<String, WFWorkflow> workflowMap = new HashMap<String, WFWorkflow>();
            for (WFWorkflow wfWorkflow : workflows) {
                workflowMap.put(wfWorkflow.getIdentifier(), wfWorkflow);
            }
            List<WorkflowBinding> bindings = this.readWorkflowBindings();
            HashMap<String, WFWorkflow> bindingMap = new HashMap<String, WFWorkflow>();
            for (WorkflowBinding workflowBinding : bindings) {
                WFWorkflow workflow = (WFWorkflow)workflowMap.get(workflowBinding.getWorkflowId());
                bindingMap.put(workflowBinding.getCategoryId(), workflow);
            }
            List<TypeCategory> typeCategories = this.readTypeCategories();
            for (TypeCategory typeCategory : typeCategories) {
                WFWorkflow workflow = (WFWorkflow)bindingMap.get(typeCategory.getIdentifier());
                for (TypeCategory.Type type : typeCategory.getTypes()) {
                    map.put(type, workflow);
                }
            }
            this.fWorkflowMap = map;
        }
        return this.fWorkflowMap;
    }

    private boolean equals(String value1, String value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }
}

