/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration;

import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIEnumeration
extends ModeledElement {
    static final String LITERAL_PREFIX = ".literal.l";
    private final String fAttributeTypeId;
    private final List<UILiteral> fLiterals = new ArrayList<UILiteral>();
    private final List<EnumerationChangeListener> fListeners = new ArrayList<EnumerationChangeListener>();
    private int fMaxId = 0;

    public UIEnumeration(String attributeTypeId) {
        this.fAttributeTypeId = attributeTypeId;
    }

    @Override
    public String getIdentifier() {
        return this.getAttributeTypeId();
    }

    public String getAttributeTypeId() {
        return this.fAttributeTypeId;
    }

    void addLiteral(UILiteral literal) {
        int id = AspectEditorUtil.getIdNumberSuffix(literal.getId());
        if (id > this.fMaxId) {
            this.fMaxId = id;
        }
        this.fLiterals.add(literal);
        this.notifyListeners(literal);
    }

    void addLiteral(UILiteral literal, UILiteral beforeIt) {
        int id = AspectEditorUtil.getIdNumberSuffix(literal.getId());
        if (id > this.fMaxId) {
            this.fMaxId = id;
        }
        if (beforeIt != null && this.fLiterals.indexOf(beforeIt) > -1) {
            this.fLiterals.add(this.fLiterals.indexOf(beforeIt) + 1, literal);
        } else {
            this.fLiterals.add(literal);
        }
        this.notifyListeners(literal);
    }

    public void moveUp(UILiteral literal) {
        int current = this.fLiterals.indexOf(literal);
        if (current < 1) {
            return;
        }
        this.fLiterals.set(current, this.fLiterals.get(current - 1));
        this.fLiterals.set(current - 1, literal);
        this.notifyListeners(literal);
    }

    public void moveDown(UILiteral literal) {
        int current = this.fLiterals.indexOf(literal);
        if (current > this.fLiterals.size() - 1) {
            return;
        }
        this.fLiterals.set(current, this.fLiterals.get(current + 1));
        this.fLiterals.set(current + 1, literal);
        this.notifyListeners(literal);
    }

    public void removeLiteral(UILiteral literal) {
        this.fLiterals.remove(literal);
        this.notifyListeners(literal);
    }

    public List<UILiteral> getLiterals() {
        return this.fLiterals;
    }

    public String generateLiteralId() {
        ++this.fMaxId;
        int id = this.fMaxId;
        return String.valueOf(this.getAttributeTypeId()) + LITERAL_PREFIX + id;
    }

    public void notifyListeners(Object changed) {
        EnumerationChangeEvent event = new EnumerationChangeEvent(changed);
        for (EnumerationChangeListener listener : this.fListeners) {
            listener.enumerationChanged(event);
        }
    }

    public void addListener(EnumerationChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(EnumerationChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public UIEnumeration duplicate(String attributeTypeId) {
        UIEnumeration copy = new UIEnumeration(attributeTypeId);
        for (UILiteral lit : this.fLiterals) {
            new UILiteral(copy, copy.generateLiteralId(), lit.getName(), lit.getIcon(), lit.isDefault(), lit.isNull());
        }
        return copy;
    }

    public static class EnumerationChangeEvent {
        private Object fChanged;

        public EnumerationChangeEvent(Object changed) {
            this.fChanged = changed;
        }

        public Object getChanged() {
            return this.fChanged;
        }
    }

    public static interface EnumerationChangeListener {
        public void enumerationChanged(EnumerationChangeEvent var1);
    }

    public static class UILiteral {
        private String fId;
        private String fName;
        private String fIcon;
        private boolean isDefault;
        private boolean isNull;
        private UIEnumeration fEnumeration;

        public UILiteral(UIEnumeration enumeration, String id, String name, String icon, boolean isDefault, boolean isNull) {
            this(enumeration, id, name, icon, isDefault, isNull, null);
        }

        public UILiteral(UIEnumeration enumeration, String id, String name, String icon, boolean isDefault, boolean isNull, UILiteral beforeIt) {
            this.fEnumeration = enumeration;
            this.fId = id;
            this.fName = name;
            this.fIcon = icon;
            this.isDefault = isDefault;
            this.isNull = isNull;
            if (beforeIt != null) {
                this.fEnumeration.addLiteral(this, beforeIt);
            } else {
                this.fEnumeration.addLiteral(this);
            }
        }

        public String getId() {
            return this.fId;
        }

        public void setId(String id) {
            this.fId = id;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
            this.fEnumeration.notifyListeners(this);
        }

        public String getIcon() {
            return this.fIcon;
        }

        public void setIcon(String icon) {
            this.fIcon = icon;
            this.fEnumeration.notifyListeners(this);
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isNull() {
            return this.isNull;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
            this.fEnumeration.notifyListeners(null);
        }

        public void setNull(boolean isNull) {
            this.isNull = isNull;
            this.fEnumeration.notifyListeners(null);
        }
    }
}

