/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IconsPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.EnumerationPart;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.UIEnumeration;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.enumeration.UIEnumerationManager;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationAspectEditor
extends AbstractWorkItemAspectEditor
implements IPrefixProvider {
    public static final String ENUMERATION_PREFIX = "enumeration";
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.EnumerationAspectEditor_CHOOSE_ENUMERATION;
        }

        public String getSameIdMessage() {
            return Messages.EnumerationAspectEditor_SAME_ID;
        }

        public String getEnterIdMessage() {
            return Messages.EnumerationAspectEditor_ENTER_ENUMERATION_ID;
        }
    };
    private EnumerationPart fEnumeration;
    private IconsPart fIconsPart;
    private ManagedForm fManagedForm;

    EnumerationAspectEditor(String configurationDataId) {
        super(configurationDataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.enumeration_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        UIEnumerationManager.writeEnumerations(memento, elements);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fManagedForm = new ManagedForm(toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm form = this.fManagedForm.getForm();
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 200).applyTo((Control)form);
        Composite body = form.getBody();
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        body.setLayout((Layout)layout);
        this.fEnumeration = new EnumerationPart(this, this);
        TeamFormSectionPart enumerationSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 256, Messages.EnumerationAspectEditor_ENUMERATION, new TeamFormPart[]{this.fEnumeration});
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        enumerationSection.getSection().setLayoutData((Object)formData);
        this.fManagedForm.addPart((IFormPart)enumerationSection);
        this.fIconsPart = new IconsPart(this);
        TeamFormSectionPart iconsSection = new TeamFormSectionPart((IManagedForm)this.fManagedForm, 258, Messages.EnumerationAspectEditor_ICONS, new TeamFormPart[]{this.fIconsPart});
        FormData iconData = new FormData();
        iconData.left = new FormAttachment(0);
        iconData.right = new FormAttachment(100);
        iconData.top = new FormAttachment((Control)enumerationSection.getSection());
        iconData.bottom = new FormAttachment(100);
        iconsSection.getSection().setLayoutData((Object)iconData);
        this.fManagedForm.addPart((IFormPart)iconsSection);
    }

    @Override
    public String getIconPrefix() {
        return "/enumeration";
    }

    @Override
    public ITeamRepository getRepository() {
        return (ITeamRepository)this.getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin();
    }

    @Override
    public IProcessContainerWorkingCopy getProcessContainer() {
        return this.getProcessContainerWorkingCopy();
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }

    @Override
    protected ModeledElement createNewElement() {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.EnumerationAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager()){

            protected boolean checkIdLength() {
                return true;
            }

            protected int getMaxPrefixLength() {
                return ".literal.l".length();
            }
        };
        if (d.open() != 0) {
            return null;
        }
        return new UIEnumeration(d.getId());
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fManagedForm.setInput((Object)newElement);
    }

    @Override
    protected boolean canDuplicate() {
        return true;
    }

    @Override
    protected ModeledElement duplicateElement(ModeledElement original) {
        ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog d = new ProcessAttachmentIconSelectionDialog.ModeledElementIdSelectionDialog(Display.getDefault().getActiveShell(), Messages.EnumerationAspectEditor_ENTER_ID, this.getMessageProvider(), this.getAllElements(), this.getResourceManager()){

            protected boolean checkIdLength() {
                return true;
            }

            protected int getMaxPrefixLength() {
                return ".literal.l".length();
            }
        };
        if (d.open() != 0) {
            return null;
        }
        return ((UIEnumeration)original).duplicate(d.getId());
    }

    @Override
    protected boolean canRemove() {
        return true;
    }

    @Override
    protected boolean removeElement(ModeledElement element) {
        String message = NLS.bind((String)Messages.EnumerationAspectEditor_REMOVING_WARNING, (Object)element.getIdentifier(), (Object[])new Object[0]);
        return MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.EnumerationAspectEditor_REMOVE, (String)message);
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        return UIEnumerationManager.readEnumerations(configurationElement);
    }

    @Override
    protected void doDispose() {
        if (this.fManagedForm != null) {
            this.fManagedForm.dispose();
            this.fManagedForm = null;
        }
    }
}

