/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.AttributeTypePresentationIdBindingManager;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorPresentation;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.KeyValuePairDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorTabs;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationsManager;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPresentationAspectPart
extends TeamFormPart {
    private static final String SHAREDUNLOCKED_COLOR = "com.ibm.team.workitem.ide.ui.SHAREDUNLOCKED";
    private Map<String, List<AbstractPresentationDescriptor>> fPresentationsMap;
    private Map<String, Set<TabDescriptor>> fSectionDependencyCache = new HashMap<String, Set<TabDescriptor>>();
    private Map<String, Set<String>> fEditorDependencyCache = new HashMap<String, Set<String>>();
    private Set<String> fUnlockedPresentations = new HashSet<String>();
    private Set<String> fUnlockedSections = new HashSet<String>();
    private TreeViewer fPresentationViewer;
    private EditorPresentation fEPresentation;
    private IDirtyStateTracker fTracker;
    private Map<AbstractPresentationDescriptor, AbstractPresentationDescriptor> fParents = new HashMap<AbstractPresentationDescriptor, AbstractPresentationDescriptor>();
    private static final String NONE = Messages.EditorPresentationAspectPart_NONE;
    private static final String KEY_LABEL = Messages.EditorPresentationAspectPart_KEY_LABEL;
    private static final String VALUE_LABEL = Messages.EditorPresentationAspectPart_VALUE_LABEL;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<EditorPresentation.Attribute> fAttributes;
    private List<String> fSectionIds;
    private List<String> fTabIds;
    private Map<String, String> fTabLayouts;
    private Button fAddTab;
    private List<String> fEditorIds;
    private boolean fShowIds;
    private boolean fIdToggle;
    private Button fIdToobleButton;
    private Button fAddHeader;

    EditorPresentationAspectPart(IDirtyStateTracker tracker) {
        this.fTracker = tracker;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getSite().getToolkit();
        Composite viewer = toolkit.createComposite(parent, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = toolkit.createComposite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        this.createViewer(viewer, buttonBar);
    }

    private static IStatus isValid(String kind, EditorPresentation.Attribute attribute) {
        String message;
        String attributeTypeNames;
        if (kind != null && attribute != null) {
            List<String> supportedTypes = PresentationsManager.getAttributeTypes(kind);
            if (!supportedTypes.isEmpty()) {
                boolean supported = false;
                for (String type : supportedTypes) {
                    if (type.equals("com.ibm.team.workitem.attributeType.enumerationTypes") && AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
                        supported = true;
                        break;
                    }
                    if (!type.equals(attribute.getAttributeType())) continue;
                    supported = true;
                    break;
                }
                if (!supported) {
                    attributeTypeNames = "";
                    for (String type : supportedTypes) {
                        attributeTypeNames = NLS.bind((String)Messages.EditorPresentationAspectPart_LIST_ATTRIBUTE_NAMES, (Object)attributeTypeNames, (Object[])new Object[]{type});
                    }
                    if (attributeTypeNames.length() > 2) {
                        attributeTypeNames = attributeTypeNames.substring(2);
                    }
                    String name = PresentationsManager.getDisplayName(kind);
                    String message2 = NLS.bind((String)Messages.EditorPresentationAspectPart_KIND_DOES_NOT_SUPPORT_ATTRIBUTE, (Object)name, (Object[])new Object[]{attribute.getDisplayName(), attribute.getAttributeType(), attributeTypeNames});
                    return new Status(4, "com.ibm.team.workitem.ide.ui", message2);
                }
            }
            if (!PresentationsManager.needsAttribute(kind)) {
                String name = PresentationsManager.getDisplayName(kind);
                return new Status(1, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.EditorPresentationAspectPart_KIND_DOES_NOT_NEED_ATTRIBUTE, (Object)name, (Object[])new Object[0]));
            }
        }
        if (kind == null && attribute != null) {
            String aKind = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)attribute.getAttributeType());
            if (aKind != null) {
                String name = PresentationsManager.getDisplayName(aKind);
                return new Status(1, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.EditorPresentationAspectPart_ATTRIBUTE_USES_DEFAULT_KIND, (Object)attribute.getDisplayName(), (Object[])new Object[]{name}));
            }
            Set<String> possibleKinds = PresentationsManager.getPossibleKinds(attribute.getAttributeType());
            String kindNames = "";
            for (String k : possibleKinds) {
                kindNames = NLS.bind((String)Messages.EditorPresentationAspectPart_LIST_POSSIBLE_KINDS, (Object)kindNames, (Object[])new Object[]{PresentationsManager.getDisplayName(k)});
            }
            if (kindNames.length() > 2) {
                kindNames = kindNames.substring(2);
            }
            message = NLS.bind((String)Messages.EditorPresentationAspectPart_ATTRIBUTE_NO_DEFAULT_KIND, (Object)attribute.getDisplayName(), (Object[])new Object[]{kindNames});
            return new Status(4, "com.ibm.team.workitem.ide.ui", message);
        }
        if (kind != null && attribute == null && PresentationsManager.needsAttribute(kind)) {
            String name = PresentationsManager.getDisplayName(kind);
            List<String> supportedTypes = PresentationsManager.getAttributeTypes(kind);
            attributeTypeNames = "";
            for (String type : supportedTypes) {
                attributeTypeNames = NLS.bind((String)Messages.EditorPresentationAspectPart_LIST_ATTRIBUTE_NAMES, (Object)attributeTypeNames, (Object[])new Object[]{type});
            }
            if (attributeTypeNames.length() > 2) {
                attributeTypeNames = attributeTypeNames.substring(2);
            }
            message = NLS.bind((String)Messages.EditorPresentationAspectPart_KIND_NEEDS_ATTRIBUTE_OF_TYPE, (Object)name, (Object[])new Object[]{attributeTypeNames});
            return new Status(4, "com.ibm.team.workitem.ide.ui", message);
        }
        return Status.OK_STATUS;
    }

    private void createViewer(Composite viewer, Composite buttonBar) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        viewer.setLayout((Layout)layout);
        Tree t = new Tree(viewer, 67586);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.heightHint = t.getItemHeight() * 12;
        t.setLayoutData((Object)data);
        this.fPresentationViewer = new TreeViewer(t);
        this.fPresentationViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                TabDescriptor desc;
                Object element = cell.getElement();
                if (element instanceof TabDescriptor) {
                    desc = (TabDescriptor)element;
                    if (EditorPresentationAspectPart.this.isHeaderTab((AbstractPresentationDescriptor)desc)) {
                        cell.setText(Messages.EditorPresentationAspectPart_EDITOR_HEADER_LABEL);
                        cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)ImagePool.HEADER, null));
                        cell.setForeground(Display.getDefault().getSystemColor(17));
                        return;
                    }
                    String text = desc.getTitle();
                    String id = "";
                    if (EditorPresentationAspectPart.this.showIds()) {
                        id = NLS.bind((String)" ({0})", (Object)desc.getElementId(), (Object[])new Object[0]);
                    }
                    String shared = "";
                    if (EditorPresentationAspectPart.this.isAShared((AbstractPresentationDescriptor)desc)) {
                        shared = NLS.bind((String)" [{0}]", (Object)Messages.EditorPresentationAspectPart_CONTENT_SHARED, (Object[])new Object[0]);
                    }
                    cell.setText(NLS.bind((String)"{0}{1}{2}", (Object)text, (Object[])new Object[]{id, shared}));
                    cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)ImagePool.TAB, null));
                    cell.setForeground(Display.getDefault().getSystemColor(24));
                }
                if (element instanceof SectionDescriptor) {
                    desc = (SectionDescriptor)element;
                    AbstractPresentationDescriptor tab = (AbstractPresentationDescriptor)EditorPresentationAspectPart.this.fParents.get(desc);
                    boolean isHeader = EditorPresentationAspectPart.this.isHeaderTab(tab);
                    String title = isHeader ? Messages.EditorPresentationAspectPart_HEADER_SECTION_LABEL : desc.getTitle();
                    String descr = "";
                    if (!isHeader) {
                        descr = EditorPresentationAspectPart.this.showIds() ? NLS.bind((String)"- {0}: {1} ({2})", (Object)Messages.EditorPresentationAspectPart_LAYOUT_SLOT, (Object[])new Object[]{desc.getSlot() != null ? WorkItemEditorTabs.getSlotName(desc.getSlot()) : Messages.EditorPresentationAspectPart_NONE_ENTRY, desc.getElementId()}) : NLS.bind((String)"({0}: {1})", (Object)Messages.EditorPresentationAspectPart_LAYOUT_SLOT, (Object[])new Object[]{desc.getSlot() != null ? WorkItemEditorTabs.getSlotName(desc.getSlot()) : Messages.EditorPresentationAspectPart_NONE_ENTRY});
                    } else if (EditorPresentationAspectPart.this.showIds()) {
                        descr = NLS.bind((String)"- ({0})", (Object)desc.getElementId(), (Object[])new Object[0]);
                    }
                    String shared = "";
                    if (EditorPresentationAspectPart.this.isAShared((AbstractPresentationDescriptor)desc)) {
                        shared = NLS.bind((String)" [{0}]", (Object)Messages.EditorPresentationAspectPart_CONTENT_SHARED, (Object[])new Object[0]);
                    }
                    if ("".equals(descr) && !"".equals(shared)) {
                        shared = shared.substring(1);
                    }
                    cell.setText(NLS.bind((String)"{0} {1}{2}", (Object)title, (Object[])new Object[]{descr, shared}));
                    cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)ImagePool.SECTION, null));
                    if (isHeader) {
                        cell.setForeground(Display.getDefault().getSystemColor(17));
                    } else {
                        cell.setForeground(EditorPresentationAspectPart.this.getCellForeground((AbstractPresentationDescriptor)desc));
                    }
                }
                if (element instanceof PresentationDescriptor) {
                    desc = (PresentationDescriptor)element;
                    String kind = desc.getKind();
                    EditorPresentation.Attribute attribute = EditorPresentationAspectPart.this.findAttribute((PresentationDescriptor)desc);
                    if (kind == null && attribute != null) {
                        kind = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)attribute.getAttributeType());
                    }
                    String attrName = "";
                    String kindName = "";
                    String label = "";
                    if (desc.getLabel() != null) {
                        label = NLS.bind((String)"{0}: ", (Object)desc.getLabel(), (Object[])new Object[0]);
                    }
                    if (attribute != null) {
                        attrName = attribute.getDisplayName();
                        if (kind != null) {
                            kindName = NLS.bind((String)" ({0})", (Object)PresentationsManager.getDisplayName(kind), (Object[])new Object[0]);
                        }
                    } else {
                        kindName = kind != null ? PresentationsManager.getDisplayName(kind) : Messages.EditorPresentationAspectPart_UNKNOWN_ENTRY;
                    }
                    String id = "";
                    if (EditorPresentationAspectPart.this.showIds() && desc.getId() != null) {
                        id = NLS.bind((String)"({0}: {1})", (Object)Messages.EditorPresentationAspectPart_ID, (Object[])new Object[]{desc.getId()});
                    }
                    cell.setText(NLS.bind((String)"{0}{1}{2} {3}", (Object)label, (Object[])new Object[]{attrName, kindName, id}));
                    if (desc.getKind() != null && desc.getKind().equals("com.ibm.team.workitem.kind.separator")) {
                        cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)ImagePool.SEPARATOR, null));
                    } else {
                        IStatus stat = EditorPresentationAspectPart.isValid(desc.getKind(), attribute);
                        if (stat.getSeverity() == 4) {
                            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                            imageDescriptorArray[1] = ImagePool.ERROR_OVR;
                            OverlayIcon overlayed = new OverlayIcon(ImagePool.PRESENTATION, imageDescriptorArray, 17408);
                            cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)overlayed, null));
                        } else if (stat.getSeverity() == 2) {
                            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                            imageDescriptorArray[1] = ImagePool.WARNING_OVR;
                            OverlayIcon overlayed = new OverlayIcon(ImagePool.PRESENTATION, imageDescriptorArray, 17408);
                            cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)overlayed, null));
                        } else {
                            cell.setImage(JazzResources.getImage((ResourceManager)EditorPresentationAspectPart.this.fResourceManager, (ImageDescriptor)ImagePool.PRESENTATION, null));
                        }
                    }
                    cell.setForeground(EditorPresentationAspectPart.this.getCellForeground((AbstractPresentationDescriptor)desc));
                }
            }
        });
        this.fPresentationViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof TabDescriptor) {
                    TabDescriptor desc = (TabDescriptor)parentElement;
                    ArrayList<SectionDescriptor> children = new ArrayList<SectionDescriptor>();
                    List list = (List)EditorPresentationAspectPart.this.fPresentationsMap.get(desc.getElementId());
                    if (list != null) {
                        for (AbstractPresentationDescriptor d : list) {
                            if (!(d instanceof SectionDescriptor)) continue;
                            children.add((SectionDescriptor)d);
                            EditorPresentationAspectPart.this.fParents.put(d, desc);
                        }
                    }
                    return children.toArray();
                }
                if (parentElement instanceof SectionDescriptor) {
                    SectionDescriptor desc = (SectionDescriptor)parentElement;
                    ArrayList<PresentationDescriptor> children = new ArrayList<PresentationDescriptor>();
                    List list = (List)EditorPresentationAspectPart.this.fPresentationsMap.get(desc.getElementId());
                    if (list != null) {
                        for (AbstractPresentationDescriptor d : list) {
                            if (!(d instanceof PresentationDescriptor)) continue;
                            children.add((PresentationDescriptor)d);
                            EditorPresentationAspectPart.this.fParents.put(d, desc);
                        }
                    }
                    return children.toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<TabDescriptor> elements = new ArrayList<TabDescriptor>();
                List list = (List)EditorPresentationAspectPart.this.fPresentationsMap.get(EditorPresentationAspectPart.this.fEPresentation.getIdentifier());
                if (list != null) {
                    for (AbstractPresentationDescriptor d : list) {
                        if (!(d instanceof TabDescriptor)) continue;
                        elements.add((TabDescriptor)d);
                    }
                }
                return elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        new TooltipSupport(this.fPresentationViewer.getControl(), false, false){

            protected Object mapElement(int x, int y) {
                Object data;
                TreeItem item = EditorPresentationAspectPart.this.fPresentationViewer.getTree().getItem(new Point(x, y));
                if (item != null && (data = item.getData()) instanceof PresentationDescriptor) {
                    return data;
                }
                return null;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                IStatus status;
                if (element instanceof PresentationDescriptor && ((status = EditorPresentationAspectPart.isValid(((PresentationDescriptor)element).getKind(), EditorPresentationAspectPart.this.findAttribute((PresentationDescriptor)element))).getSeverity() == 4 || status.getSeverity() == 2)) {
                    return status.getMessage();
                }
                return null;
            }
        };
        layout = new GridLayout();
        buttonBar.setLayout((Layout)layout);
        final Button editEntry = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_EDIT, 0x800000);
        editEntry.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editEntry.setEnabled(false);
        editEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.editEntry();
            }
        });
        AspectEditorUtil.createFiller(buttonBar, toolkit, 0);
        final Button addPresentation = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_ADD_PRESENTATION, 0x800000);
        addPresentation.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addPresentation.setEnabled(false);
        addPresentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.addPresentation();
            }
        });
        final Button addSection = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_ADD_SECTION, 0x800000);
        addSection.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addSection.setEnabled(false);
        addSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.addSection();
            }
        });
        this.fAddTab = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_ADD_TAB, 0x800000);
        this.fAddTab.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddTab.setEnabled(false);
        this.fAddTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.addTab();
            }
        });
        this.fAddHeader = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_ADD_HEADER, 0x800000);
        this.fAddHeader.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAddHeader.setEnabled(false);
        this.fAddHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.addHeader();
            }
        });
        AspectEditorUtil.createFiller(buttonBar, toolkit, 0);
        final Button duplicateEntry = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_DUPLICATE, 0x800000);
        duplicateEntry.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        duplicateEntry.setEnabled(false);
        duplicateEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.duplicateEntry();
            }
        });
        final Button removeEntry = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_REMOVE, 0x800000);
        removeEntry.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeEntry.setEnabled(false);
        removeEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.removeEntry();
            }
        });
        AspectEditorUtil.createFiller(buttonBar, toolkit, 6);
        final Button moveUpButton = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_MOVE_UP, 0x800000);
        moveUpButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        moveUpButton.setEnabled(false);
        final Button moveDownButton = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_MOVE_DOWN, 0x800000);
        moveDownButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        moveDownButton.setEnabled(false);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (EditorPresentationAspectPart.this.fPresentationViewer.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement()) instanceof AbstractPresentationDescriptor) {
                    EditorPresentationAspectPart.this.moveUp((AbstractPresentationDescriptor)o);
                    EditorPresentationAspectPart.this.setDirty();
                    EditorPresentationAspectPart.this.updateMoveButtons(moveUpButton, moveDownButton);
                }
            }
        });
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object o;
                if (EditorPresentationAspectPart.this.fPresentationViewer.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement()) instanceof AbstractPresentationDescriptor) {
                    EditorPresentationAspectPart.this.moveDown((AbstractPresentationDescriptor)o);
                    EditorPresentationAspectPart.this.setDirty();
                    EditorPresentationAspectPart.this.updateMoveButtons(moveUpButton, moveDownButton);
                }
            }
        });
        this.fIdToobleButton = toolkit.createButton(buttonBar, Messages.EditorPresentationAspectPart_SHOW_IDS, 32);
        this.fIdToobleButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fIdToobleButton.setEnabled(false);
        this.fIdToobleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPresentationAspectPart.this.fIdToggle = EditorPresentationAspectPart.this.fIdToobleButton.getSelection();
                EditorPresentationAspectPart.this.fPresentationViewer.refresh();
            }
        });
        this.fPresentationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeEntry.setEnabled(!EditorPresentationAspectPart.this.fPresentationViewer.getSelection().isEmpty());
                boolean isHeaderTab = false;
                if (((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).size() == 1 && ((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement() instanceof TabDescriptor && EditorPresentationAspectPart.this.isHeaderTab((AbstractPresentationDescriptor)((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement())) {
                    isHeaderTab = true;
                }
                editEntry.setEnabled(!isHeaderTab && ((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).size() == 1);
                addPresentation.setEnabled(EditorPresentationAspectPart.this.validAddPresentationSelection());
                boolean isHeaderSection = false;
                if (((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).size() == 1 && ((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement() instanceof SectionDescriptor && EditorPresentationAspectPart.this.isHeaderTab((AbstractPresentationDescriptor)EditorPresentationAspectPart.this.fParents.get(((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement()))) {
                    isHeaderSection = true;
                }
                addSection.setEnabled(EditorPresentationAspectPart.this.validAddSectionSelection());
                duplicateEntry.setEnabled((!isHeaderSection || EditorPresentationAspectPart.this.isAShared((AbstractPresentationDescriptor)((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement())) && !isHeaderTab && EditorPresentationAspectPart.this.validDuplicateSelection());
                EditorPresentationAspectPart.this.updateMoveButtons(moveUpButton, moveDownButton);
            }
        });
        this.fPresentationViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).size() == 1) {
                    if (EditorPresentationAspectPart.this.isHeaderTab((AbstractPresentationDescriptor)((IStructuredSelection)EditorPresentationAspectPart.this.fPresentationViewer.getSelection()).getFirstElement())) {
                        return;
                    }
                    EditorPresentationAspectPart.this.editEntry();
                }
            }
        });
        this.updateEnablement();
        this.showIds(false);
    }

    private void showIds(boolean show) {
        this.fShowIds = show;
        this.fPresentationViewer.refresh();
    }

    private boolean showIds() {
        return this.fShowIds || this.fIdToggle;
    }

    private boolean isHeaderTab(AbstractPresentationDescriptor descriptor) {
        return descriptor instanceof TabDescriptor && "internalHeader".equals(this.fTabLayouts.get(descriptor.getElementId()));
    }

    private boolean validDuplicateSelection() {
        if (((IStructuredSelection)this.fPresentationViewer.getSelection()).size() != 1) {
            return false;
        }
        Object entry = ((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        return entry instanceof SectionDescriptor || entry instanceof TabDescriptor;
    }

    private boolean validAddPresentationSelection() {
        if (((IStructuredSelection)this.fPresentationViewer.getSelection()).size() != 1) {
            return false;
        }
        Object entry = ((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        return entry instanceof PresentationDescriptor || entry instanceof SectionDescriptor;
    }

    private boolean validAddSectionSelection() {
        if (((IStructuredSelection)this.fPresentationViewer.getSelection()).size() != 1) {
            return false;
        }
        Object entry = ((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        return entry instanceof TabDescriptor && (!this.isHeaderTab((AbstractPresentationDescriptor)entry) || this.fPresentationsMap.get(((TabDescriptor)entry).getElementId()) == null || this.fPresentationsMap.get(((TabDescriptor)entry).getElementId()).isEmpty());
    }

    private boolean isAShared(AbstractPresentationDescriptor desc) {
        if (desc instanceof SectionDescriptor) {
            return this.fSectionDependencyCache.get(desc.getElementId()).size() > 1;
        }
        if (desc instanceof TabDescriptor) {
            return this.fEditorDependencyCache.get(desc.getElementId()).size() > 1;
        }
        return false;
    }

    private boolean isInShared(AbstractPresentationDescriptor desc) {
        if (desc instanceof PresentationDescriptor) {
            SectionDescriptor section = (SectionDescriptor)this.fParents.get(desc);
            if (this.fSectionDependencyCache.get(section.getElementId()).size() > 1) {
                return true;
            }
            desc = section;
        }
        if (desc instanceof SectionDescriptor) {
            TabDescriptor tab = (TabDescriptor)this.fParents.get(desc);
            return this.fEditorDependencyCache.get(tab.getElementId()).size() > 1;
        }
        return false;
    }

    private boolean isInUnlocked(AbstractPresentationDescriptor desc) {
        if (desc instanceof PresentationDescriptor) {
            return this.fUnlockedPresentations.contains(this.fParents.get(desc).getElementId());
        }
        if (desc instanceof SectionDescriptor) {
            return this.fUnlockedSections.contains(this.fParents.get(desc).getElementId());
        }
        return false;
    }

    private boolean isAUnlocked(AbstractPresentationDescriptor desc) {
        if (desc instanceof SectionDescriptor) {
            return this.fUnlockedPresentations.contains(desc.getElementId());
        }
        if (desc instanceof TabDescriptor) {
            return this.fUnlockedSections.contains(desc.getElementId());
        }
        return false;
    }

    private void moveUp(AbstractPresentationDescriptor desc) {
        if (!this.checkInDependency(desc)) {
            return;
        }
        List<AbstractPresentationDescriptor> entries = this.getParentEntries(desc);
        int current = entries.indexOf(desc);
        int previous = this.getPreviousIndex(entries, desc);
        entries.set(current, entries.get(previous));
        entries.set(previous, desc);
        this.fPresentationViewer.refresh();
    }

    private int getPreviousIndex(List<AbstractPresentationDescriptor> entries, AbstractPresentationDescriptor desc) {
        int current = entries.indexOf(desc);
        int previous = current - 1;
        while (previous >= 0 && !entries.get(previous).getClass().equals(desc.getClass())) {
            --previous;
        }
        return previous;
    }

    private int getNextIndex(List<AbstractPresentationDescriptor> entries, AbstractPresentationDescriptor desc) {
        int current = entries.indexOf(desc);
        int next = current + 1;
        while (next < entries.size() && !entries.get(next).getClass().equals(desc.getClass())) {
            ++next;
        }
        return next;
    }

    private void moveDown(AbstractPresentationDescriptor desc) {
        if (!this.checkInDependency(desc)) {
            return;
        }
        List<AbstractPresentationDescriptor> entries = this.getParentEntries(desc);
        int current = entries.indexOf(desc);
        int next = this.getNextIndex(entries, desc);
        entries.set(current, entries.get(next));
        entries.set(next, desc);
        this.fPresentationViewer.refresh();
    }

    private boolean checkInDependency(AbstractPresentationDescriptor desc) {
        if (this.isInShared(desc) && !this.isInUnlocked(desc)) {
            if (desc instanceof PresentationDescriptor) {
                String message = Messages.EditorPresentationAspectPart_SECTION_IN_LOCKED;
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorPresentationAspectPart_LOCKED_PRESENTATION, (String)message)) {
                    this.unlockInSharing(desc);
                    return true;
                }
            } else if (desc instanceof SectionDescriptor) {
                String message = Messages.EditorPresentationAspectPart_TAB_IN_LOCKED;
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorPresentationAspectPart_LOCKED_SECTION, (String)message)) {
                    this.unlockInSharing(desc);
                    return true;
                }
            } else if (desc instanceof TabDescriptor) {
                String message = Messages.EditorPresentationAspectPart_EDITOR_IN_LOCKED;
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorPresentationAspectPart_LOCKED_TAB, (String)message)) {
                    this.unlockInSharing(desc);
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkADependency(AbstractPresentationDescriptor desc) {
        if (this.isAShared(desc) && !this.isAUnlocked(desc)) {
            if (desc instanceof PresentationDescriptor) {
                String message = Messages.EditorPresentationAspectPart_PRESENTATION_LOCKED;
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorPresentationAspectPart_LOCKED_PRESENTATION, (String)message)) {
                    this.unlockASharing(desc);
                    return true;
                }
            } else if (desc instanceof SectionDescriptor) {
                String message = Messages.EditorPresentationAspectPart_SECTION_LOCKED;
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorPresentationAspectPart_LOCKED_SECTION, (String)message)) {
                    this.unlockASharing(desc);
                    return true;
                }
            } else if (desc instanceof TabDescriptor) {
                String message = Messages.EditorPresentationAspectPart_TAB_LOCKED;
                if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EditorPresentationAspectPart_LOCKED_TAB, (String)message)) {
                    this.unlockASharing(desc);
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void addPresentation() {
        AbstractPresentationDescriptor section;
        AbstractPresentationDescriptor selected = (AbstractPresentationDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        int index = -1;
        if (selected instanceof PresentationDescriptor) {
            section = this.fParents.get(selected);
            index = this.fPresentationsMap.get(section.getElementId()).indexOf(selected);
        } else {
            section = selected;
        }
        if (!this.checkADependency(section)) {
            return;
        }
        this.showIds(true);
        AddEditPresentationDialog d = new AddEditPresentationDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_ADD_PRESENTATION_TITLE, null, null, null, null, new HashMap<String, String>(), this.getKinds(), this.computeAlreadyExistingAttributes(), this.fAttributes, this.fResourceManager);
        if (d.open() == 0) {
            String id = d.getId();
            EditorPresentation.Attribute att = d.getAttribute();
            String kind = d.getKind();
            String label = d.getLabel();
            Identifier<IAttribute> ident = null;
            if (att != null) {
                ident = att.getIdentifier();
            }
            PresentationDescriptor desc = new PresentationDescriptor(section.getElementId(), id, kind, label, ident, d.getProperties());
            if (this.fPresentationsMap.get(section.getElementId()) == null) {
                this.fPresentationsMap.put(section.getElementId(), new ArrayList());
                if (!this.fSectionIds.contains(section.getElementId())) {
                    this.fSectionIds.add(section.getElementId());
                }
            }
            if (index > -1) {
                this.fPresentationsMap.get(section.getElementId()).add(index + 1, (AbstractPresentationDescriptor)desc);
            } else {
                this.fPresentationsMap.get(section.getElementId()).add((AbstractPresentationDescriptor)desc);
            }
            this.setDirty();
            this.fPresentationViewer.refresh();
            this.fPresentationViewer.expandToLevel((Object)desc, 3);
            this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
        }
        this.showIds(false);
    }

    private List<EditorPresentation.Attribute> computeAlreadyExistingAttributes() {
        HashSet<Identifier> configuredAttributeIds = new HashSet<Identifier>();
        List<AbstractPresentationDescriptor> tabs = this.fPresentationsMap.get(this.fEPresentation.getIdentifier());
        if (tabs != null) {
            for (AbstractPresentationDescriptor tab : tabs) {
                List<AbstractPresentationDescriptor> sections;
                if (!(tab instanceof TabDescriptor) || (sections = this.fPresentationsMap.get(tab.getElementId())) == null) continue;
                for (AbstractPresentationDescriptor section : sections) {
                    List<AbstractPresentationDescriptor> presentations;
                    if (!(section instanceof SectionDescriptor) || (presentations = this.fPresentationsMap.get(section.getElementId())) == null) continue;
                    for (AbstractPresentationDescriptor presentation : presentations) {
                        Identifier attributeId;
                        if (!(presentation instanceof PresentationDescriptor) || (attributeId = ((PresentationDescriptor)presentation).getAttributeId()) == null) continue;
                        configuredAttributeIds.add(attributeId);
                    }
                }
            }
        }
        ArrayList<EditorPresentation.Attribute> preferred = new ArrayList<EditorPresentation.Attribute>();
        for (EditorPresentation.Attribute a : this.fAttributes) {
            if (configuredAttributeIds.contains(a.getIdentifier())) continue;
            preferred.add(a);
        }
        return preferred;
    }

    private boolean addSection() {
        TabDescriptor tab = (TabDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        if (!this.checkADependency((AbstractPresentationDescriptor)tab)) {
            return false;
        }
        this.showIds(true);
        boolean isHeader = this.isHeaderTab((AbstractPresentationDescriptor)tab);
        AddEditExistingCreateNewSectionDialog d = new AddEditExistingCreateNewSectionDialog(Display.getCurrent().getActiveShell(), isHeader ? Messages.EditorPresentationAspectPart_ADD_HEADER_SECTION : Messages.EditorPresentationAspectPart_ADD_SECTION_TITLE, null, null, null, null, this.fSectionIds, WorkItemEditorTabs.getLayoutSlots(this.fTabLayouts.get(tab.getElementId())), this.fResourceManager);
        if (isHeader) {
            d.setHeader(true);
        }
        boolean created = false;
        if (d.open() == 0) {
            SectionDescriptor desc = new SectionDescriptor(d.getSectionId(), isHeader ? "none" : d.getTitel(), d.getSlot(), d.getProperties());
            if (d.isCreate()) {
                this.fSectionIds.add(desc.getElementId());
                if (this.fPresentationsMap.get(desc.getElementId()) == null) {
                    this.fPresentationsMap.put(desc.getElementId(), new ArrayList());
                }
            }
            if (this.fPresentationsMap.get(tab.getElementId()) == null) {
                this.fPresentationsMap.put(tab.getElementId(), new ArrayList());
                if (!this.fTabIds.contains(tab.getElementId())) {
                    this.fTabIds.add(tab.getElementId());
                }
            }
            this.fPresentationsMap.get(tab.getElementId()).add((AbstractPresentationDescriptor)desc);
            if (this.fSectionDependencyCache.get(desc.getElementId()) == null) {
                this.fSectionDependencyCache.put(desc.getElementId(), new HashSet());
            }
            this.fSectionDependencyCache.get(desc.getElementId()).add(tab);
            this.setDirty();
            this.fPresentationViewer.refresh();
            this.fPresentationViewer.expandToLevel((Object)desc, 2);
            this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
            created = true;
        }
        this.showIds(false);
        return created;
    }

    private void addHeader() {
        TabDescriptor header = new TabDescriptor(String.valueOf(this.fEPresentation.getIdentifier()) + "." + "internalHeader", "none", new HashMap());
        this.fTabLayouts.put(header.getElementId(), "internalHeader");
        this.fTabIds.add(header.getElementId());
        if (this.fPresentationsMap.get(header.getElementId()) == null) {
            this.fPresentationsMap.put(header.getElementId(), new ArrayList());
        }
        if (this.fPresentationsMap.get(this.fEPresentation.getIdentifier()) == null) {
            this.fPresentationsMap.put(this.fEPresentation.getIdentifier(), new ArrayList());
        }
        this.fPresentationsMap.get(this.fEPresentation.getIdentifier()).add(0, (AbstractPresentationDescriptor)header);
        if (this.fEditorDependencyCache.get(header.getElementId()) == null) {
            this.fEditorDependencyCache.put(header.getElementId(), new HashSet());
        }
        this.fEditorDependencyCache.get(header.getElementId()).add(this.fEPresentation.getIdentifier());
        this.setDirty();
        this.fAddHeader.setEnabled(false);
        this.fPresentationViewer.refresh();
        this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)header), true);
        if (!this.addSection()) {
            this.removeEntry();
        }
    }

    private void addTab() {
        this.showIds(true);
        AddEditExistingCreateNewTabDialog d = new AddEditExistingCreateNewTabDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_ADD_TAB_TITLE, null, null, null, null, this.fTabIds, this.fResourceManager);
        if (d.open() == 0) {
            TabDescriptor tab = new TabDescriptor(d.getTabId(), d.getTitle(), d.getProperties());
            this.fTabLayouts.put(tab.getElementId(), d.getTabLayout());
            if (d.isCreate()) {
                this.fTabIds.add(tab.getElementId());
                if (this.fPresentationsMap.get(tab.getElementId()) == null) {
                    this.fPresentationsMap.put(tab.getElementId(), new ArrayList());
                }
            }
            if (this.fPresentationsMap.get(this.fEPresentation.getIdentifier()) == null) {
                this.fPresentationsMap.put(this.fEPresentation.getIdentifier(), new ArrayList());
            }
            this.fPresentationsMap.get(this.fEPresentation.getIdentifier()).add((AbstractPresentationDescriptor)tab);
            if (this.fEditorDependencyCache.get(tab.getElementId()) == null) {
                this.fEditorDependencyCache.put(tab.getElementId(), new HashSet());
            }
            this.fEditorDependencyCache.get(tab.getElementId()).add(this.fEPresentation.getIdentifier());
            this.setDirty();
            this.fPresentationViewer.refresh();
            this.fPresentationViewer.expandToLevel((Object)tab, 1);
            this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)tab), true);
        }
        this.showIds(false);
    }

    private void editEntry() {
        AbstractPresentationDescriptor selected = (AbstractPresentationDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        if (!this.checkInDependency(selected)) {
            return;
        }
        this.showIds(true);
        if (selected instanceof PresentationDescriptor) {
            PresentationDescriptor desc = (PresentationDescriptor)selected;
            AddEditPresentationDialog d = new AddEditPresentationDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_EDIT_PRESENTATION_TITLE, desc.getId(), this.findAttribute(desc), desc.getKind(), desc.getLabel(), desc.getProperties(), this.getKinds(), this.computeAlreadyExistingAttributes(), this.fAttributes, this.fResourceManager);
            if (d.open() == 0) {
                Map<String, String> properties;
                if (!AspectEditorUtil.equals(desc.getId(), d.getId())) {
                    desc.setId(d.getId());
                    this.setDirty();
                }
                EditorPresentation.Attribute att = d.getAttribute();
                Identifier<IAttribute> ident = null;
                if (att != null) {
                    ident = att.getIdentifier();
                }
                if (!AspectEditorUtil.equals(desc.getAttributeId(), ident)) {
                    desc.setAttributeId(ident);
                    this.setDirty();
                }
                if (!AspectEditorUtil.equals(desc.getKind(), d.getKind())) {
                    desc.setKind(d.getKind());
                    this.setDirty();
                }
                if (!AspectEditorUtil.equals(desc.getLabel(), d.getLabel())) {
                    desc.setLabel(d.getLabel());
                    this.setDirty();
                }
                if (!AspectEditorUtil.equalMaps(properties = d.getProperties(), desc.getProperties())) {
                    desc.setProperties(properties);
                    this.setDirty();
                }
                this.fPresentationViewer.refresh();
            }
        } else if (selected instanceof SectionDescriptor) {
            SectionDescriptor desc = (SectionDescriptor)selected;
            AbstractPresentationDescriptor tab = this.fParents.get(desc);
            boolean isHeader = this.isHeaderTab(tab);
            AddEditExistingCreateNewSectionDialog d = new AddEditExistingCreateNewSectionDialog(Display.getCurrent().getActiveShell(), isHeader ? Messages.EditorPresentationAspectPart_EDIT_HEADER_SECTION : Messages.EditorPresentationAspectPart_EDIT_SECTION_TITLE, desc.getElementId(), desc.getTitle(), desc.getSlot(), desc.getProperties(), this.fSectionIds, WorkItemEditorTabs.getLayoutSlots(this.fTabLayouts.get(tab.getElementId())), this.fResourceManager);
            if (isHeader) {
                d.setHeader(true);
            }
            if (d.open() == 0) {
                Map<String, String> properties;
                if (!isHeader && !AspectEditorUtil.equals(d.getTitel(), desc.getTitle())) {
                    desc.setTitle(d.getTitel());
                    this.setDirty();
                } else if (isHeader) {
                    desc.setTitle("none");
                }
                if (!isHeader && !AspectEditorUtil.equals(d.getSlot(), desc.getSlot())) {
                    desc.setSlot(d.getSlot());
                    this.setDirty();
                }
                if (!AspectEditorUtil.equalMaps(properties = d.getProperties(), desc.getProperties())) {
                    desc.setProperties(properties);
                    this.setDirty();
                }
                this.fPresentationViewer.refresh();
            }
        } else if (selected instanceof TabDescriptor) {
            TabDescriptor desc = (TabDescriptor)selected;
            AddEditExistingCreateNewTabDialog d = new AddEditExistingCreateNewTabDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_EDIT_TAB_TITLE, desc.getElementId(), desc.getTitle(), this.fTabLayouts.get(desc.getElementId()), desc.getProperties(), this.fTabIds, this.fResourceManager);
            if (d.open() == 0) {
                Map<String, String> properties;
                if (!AspectEditorUtil.equals(d.getTitle(), desc.getTitle())) {
                    desc.setTitle(d.getTitle());
                    this.setDirty();
                }
                if (!AspectEditorUtil.equals(this.fTabLayouts.get(desc.getElementId()), d.getTabLayout())) {
                    this.fTabLayouts.put(desc.getElementId(), d.getTabLayout());
                    this.setDirty();
                }
                if (!AspectEditorUtil.equalMaps(properties = d.getProperties(), desc.getProperties())) {
                    desc.setProperties(properties);
                    this.setDirty();
                }
                this.fPresentationViewer.refresh();
            }
        }
        this.showIds(false);
    }

    private void removeEntry() {
        AbstractPresentationDescriptor single = null;
        AbstractPresentationDescriptor parent = null;
        if (((IStructuredSelection)this.fPresentationViewer.getSelection()).size() == 1) {
            single = (AbstractPresentationDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        }
        AbstractPresentationDescriptor affectedHeaderTab = null;
        ArrayList list = new ArrayList(((IStructuredSelection)this.fPresentationViewer.getSelection()).toList());
        for (AbstractPresentationDescriptor selected : list) {
            ArrayList sList;
            if (!this.checkInDependency(selected)) continue;
            if (this.isHeaderTab(selected) && (sList = new ArrayList(this.fPresentationsMap.get(selected.getElementId()))) != null && sList.size() > 0) {
                for (AbstractPresentationDescriptor hs : sList) {
                    this.removeDescriptor(hs);
                }
            }
            if (this.fParents.get(selected) != null && this.isHeaderTab(this.fParents.get(selected))) {
                affectedHeaderTab = this.fParents.get(selected);
            }
            if (single != null && this.fParents.get(selected) != null) {
                parent = this.fParents.get(selected);
            }
            this.removeDescriptor(selected);
        }
        if (affectedHeaderTab != null) {
            this.removeDescriptor(affectedHeaderTab);
        }
        this.setDirty();
        this.fPresentationViewer.refresh();
        if (parent != null) {
            this.fPresentationViewer.setSelection((ISelection)new StructuredSelection(parent), true);
        }
    }

    private void removeDescriptor(AbstractPresentationDescriptor descriptor) {
        List<AbstractPresentationDescriptor> entries = this.getParentEntries(descriptor);
        entries.remove(descriptor);
        if (descriptor instanceof SectionDescriptor) {
            this.fSectionDependencyCache.get(descriptor.getElementId()).remove(this.fParents.get(descriptor));
        } else if (descriptor instanceof TabDescriptor) {
            this.fEditorDependencyCache.get(descriptor.getElementId()).remove(this.fEPresentation.getIdentifier());
            if (this.isHeaderTab(descriptor)) {
                this.fTabIds.remove(descriptor.getElementId());
                this.fTabLayouts.remove(descriptor.getElementId());
                this.fPresentationsMap.remove(descriptor.getElementId());
                if (this.fPresentationsMap.get(this.fEPresentation.getIdentifier()) != null) {
                    this.fPresentationsMap.get(this.fEPresentation.getIdentifier()).remove(descriptor);
                }
                this.fAddHeader.setEnabled(true);
            }
        }
    }

    private void duplicateEntry() {
        AbstractPresentationDescriptor selected = (AbstractPresentationDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
        if (selected instanceof SectionDescriptor) {
            SectionDescriptor sec = (SectionDescriptor)selected;
            TabDescriptor tab = (TabDescriptor)this.fParents.get(sec);
            if (tab == null) {
                return;
            }
            if (!this.checkInDependency((AbstractPresentationDescriptor)sec)) {
                return;
            }
            if (this.isHeaderTab((AbstractPresentationDescriptor)tab)) {
                this.showIds(true);
                DuplicateEntryIdSelectionDialog d = new DuplicateEntryIdSelectionDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_DUP_HEADER, Messages.EditorPresentationAspectPart_SECTION_ID_EXISTS, Messages.EditorPresentationAspectPart_ENTER_ID, this.fSectionIds, this.fResourceManager);
                if (d.open() == 0) {
                    int index;
                    List<AbstractPresentationDescriptor> toDuplicate;
                    String id = d.getId();
                    SectionDescriptor desc = new SectionDescriptor(id, sec.getTitle(), sec.getSlot(), (Map)(sec.getProperties() != null ? new HashMap(sec.getProperties()) : new HashMap()));
                    this.fSectionIds.add(id);
                    if (this.fPresentationsMap.get(desc.getElementId()) == null) {
                        this.fPresentationsMap.put(desc.getElementId(), new ArrayList());
                    }
                    if ((toDuplicate = this.fPresentationsMap.get(sec.getElementId())) != null) {
                        List<AbstractPresentationDescriptor> toFill = this.fPresentationsMap.get(desc.getElementId());
                        for (AbstractPresentationDescriptor a : toDuplicate) {
                            if (!(a instanceof PresentationDescriptor)) continue;
                            toFill.add(a);
                        }
                    }
                    if ((index = this.getNextIndex(this.fPresentationsMap.get(tab.getElementId()), (AbstractPresentationDescriptor)sec)) > -1) {
                        this.fPresentationsMap.get(tab.getElementId()).add(index, (AbstractPresentationDescriptor)desc);
                    } else {
                        this.fPresentationsMap.get(tab.getElementId()).add((AbstractPresentationDescriptor)desc);
                    }
                    if (this.fSectionDependencyCache.get(desc.getElementId()) == null) {
                        this.fSectionDependencyCache.put(desc.getElementId(), new HashSet());
                    }
                    this.fSectionDependencyCache.get(desc.getElementId()).add(tab);
                    this.setDirty();
                    List<AbstractPresentationDescriptor> entries = this.getParentEntries((AbstractPresentationDescriptor)sec);
                    entries.remove(sec);
                    this.fSectionDependencyCache.get(sec.getElementId()).remove(this.fParents.get(sec));
                    this.fPresentationViewer.refresh();
                    this.fPresentationViewer.expandToLevel((Object)desc, 2);
                    this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
                }
                this.showIds(false);
            } else {
                this.showIds(true);
                DuplicateEntryIdSelectionDialog d = new DuplicateEntryIdSelectionDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_DUPLICATE_SECTION, Messages.EditorPresentationAspectPart_SECTION_ID_EXISTS, Messages.EditorPresentationAspectPart_ENTER_DUP_SECTION_ID, this.fSectionIds, this.fResourceManager);
                if (d.open() == 0) {
                    int index;
                    List<AbstractPresentationDescriptor> toDuplicate;
                    String id = d.getId();
                    SectionDescriptor desc = new SectionDescriptor(id, sec.getTitle(), sec.getSlot(), (Map)(sec.getProperties() != null ? new HashMap(sec.getProperties()) : new HashMap()));
                    this.fSectionIds.add(id);
                    if (this.fPresentationsMap.get(desc.getElementId()) == null) {
                        this.fPresentationsMap.put(desc.getElementId(), new ArrayList());
                    }
                    if ((toDuplicate = this.fPresentationsMap.get(sec.getElementId())) != null) {
                        List<AbstractPresentationDescriptor> toFill = this.fPresentationsMap.get(desc.getElementId());
                        for (AbstractPresentationDescriptor a : toDuplicate) {
                            if (!(a instanceof PresentationDescriptor)) continue;
                            toFill.add(a);
                        }
                    }
                    if ((index = this.getNextIndex(this.fPresentationsMap.get(tab.getElementId()), (AbstractPresentationDescriptor)sec)) > -1) {
                        this.fPresentationsMap.get(tab.getElementId()).add(index, (AbstractPresentationDescriptor)desc);
                    } else {
                        this.fPresentationsMap.get(tab.getElementId()).add((AbstractPresentationDescriptor)desc);
                    }
                    if (this.fSectionDependencyCache.get(desc.getElementId()) == null) {
                        this.fSectionDependencyCache.put(desc.getElementId(), new HashSet());
                    }
                    this.fSectionDependencyCache.get(desc.getElementId()).add(tab);
                    this.setDirty();
                    this.fPresentationViewer.refresh();
                    this.fPresentationViewer.expandToLevel((Object)desc, 2);
                    this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
                }
                this.showIds(false);
            }
        } else if (selected instanceof TabDescriptor) {
            TabDescriptor tab = (TabDescriptor)selected;
            if (!this.checkInDependency((AbstractPresentationDescriptor)tab)) {
                return;
            }
            this.showIds(true);
            DuplicateEntryIdSelectionDialog d = new DuplicateEntryIdSelectionDialog(Display.getCurrent().getActiveShell(), Messages.EditorPresentationAspectPart_DUPLICATE_TAB, Messages.EditorPresentationAspectPart_TAB_ID_EXISTS, Messages.EditorPresentationAspectPart_ENTER_DUP_TAB_ID, this.fTabIds, this.fResourceManager);
            if (d.open() == 0) {
                int index;
                List<AbstractPresentationDescriptor> toDuplicate;
                String id = d.getId();
                TabDescriptor desc = new TabDescriptor(id, tab.getTitle(), (Map)(tab.getProperties() != null ? new HashMap(tab.getProperties()) : new HashMap()));
                this.fTabIds.add(id);
                String tabLayout = this.fTabLayouts.get(tab.getElementId());
                if (tabLayout != null) {
                    this.fTabLayouts.put(desc.getElementId(), tabLayout);
                }
                if (this.fPresentationsMap.get(desc.getElementId()) == null) {
                    this.fPresentationsMap.put(id, new ArrayList());
                }
                if ((toDuplicate = this.fPresentationsMap.get(tab.getElementId())) != null) {
                    List<AbstractPresentationDescriptor> toFill = this.fPresentationsMap.get(desc.getElementId());
                    for (AbstractPresentationDescriptor a : toDuplicate) {
                        if (!(a instanceof SectionDescriptor)) continue;
                        toFill.add(a);
                        Set<TabDescriptor> dep = this.fSectionDependencyCache.get(a.getElementId());
                        if (dep == null) {
                            this.fSectionDependencyCache.put(a.getElementId(), new HashSet());
                        }
                        this.fSectionDependencyCache.get(a.getElementId()).add(desc);
                    }
                }
                if ((index = this.getNextIndex(this.fPresentationsMap.get(this.fEPresentation.getIdentifier()), (AbstractPresentationDescriptor)tab)) > -1) {
                    this.fPresentationsMap.get(this.fEPresentation.getIdentifier()).add(index, (AbstractPresentationDescriptor)desc);
                } else {
                    this.fPresentationsMap.get(this.fEPresentation.getIdentifier()).add((AbstractPresentationDescriptor)desc);
                }
                if (this.fEditorDependencyCache.get(desc.getElementId()) == null) {
                    this.fEditorDependencyCache.put(desc.getElementId(), new HashSet());
                }
                this.fEditorDependencyCache.get(desc.getElementId()).add(this.fEPresentation.getIdentifier());
                this.setDirty();
                this.fPresentationViewer.refresh();
                this.fPresentationViewer.expandToLevel((Object)desc, 1);
                this.fPresentationViewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
            }
            this.showIds(false);
        }
    }

    private void unlockInSharing(AbstractPresentationDescriptor desc) {
        if (desc instanceof PresentationDescriptor) {
            if (this.isInShared(desc)) {
                this.fUnlockedPresentations.add(this.fParents.get(desc).getElementId());
            }
        } else if (desc instanceof SectionDescriptor && this.isInShared(desc)) {
            this.fUnlockedSections.add(this.fParents.get(desc).getElementId());
        }
        this.fPresentationViewer.refresh();
    }

    private void unlockASharing(AbstractPresentationDescriptor desc) {
        if (desc instanceof SectionDescriptor) {
            if (this.isAShared(desc)) {
                this.fUnlockedPresentations.add(desc.getElementId());
            }
        } else if (desc instanceof TabDescriptor && this.isAShared(desc)) {
            this.fUnlockedSections.add(desc.getElementId());
        }
        this.fPresentationViewer.refresh();
    }

    private List<String> getKinds() {
        ArrayList<String> kinds = new ArrayList<String>(PresentationsManager.getPresentations());
        kinds.remove("com.ibm.team.workitem.kind.internal.linksSummary");
        return kinds;
    }

    private void updateMoveButtons(Button moveUp, Button moveDown) {
        boolean moveUpEnabled = false;
        if (((IStructuredSelection)this.fPresentationViewer.getSelection()).size() == 1) {
            AbstractPresentationDescriptor desc = (AbstractPresentationDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
            List<AbstractPresentationDescriptor> entries = this.getParentEntries(desc);
            if (this.getPreviousIndex(entries, desc) > -1) {
                moveUpEnabled = true;
            }
            if (this.isHeaderTab(desc)) {
                moveUpEnabled = false;
            }
        }
        moveUp.setEnabled(moveUpEnabled);
        boolean moveDownEnabled = false;
        if (((IStructuredSelection)this.fPresentationViewer.getSelection()).size() == 1) {
            AbstractPresentationDescriptor desc = (AbstractPresentationDescriptor)((IStructuredSelection)this.fPresentationViewer.getSelection()).getFirstElement();
            List<AbstractPresentationDescriptor> entries = this.getParentEntries(desc);
            if (this.getNextIndex(entries, desc) < entries.size()) {
                moveDownEnabled = true;
            }
            if (this.isHeaderTab(desc)) {
                moveDownEnabled = false;
            }
        }
        moveDown.setEnabled(moveDownEnabled);
    }

    private List<AbstractPresentationDescriptor> getParentEntries(AbstractPresentationDescriptor desc) {
        AbstractPresentationDescriptor p = this.fParents.get(desc);
        List<AbstractPresentationDescriptor> entries = p != null ? this.fPresentationsMap.get(p.getElementId()) : this.fPresentationsMap.get(this.fEPresentation.getIdentifier());
        return entries;
    }

    private void updateEnablement() {
        if (this.fPresentationViewer != null && !this.fPresentationViewer.getControl().isDisposed()) {
            this.fPresentationViewer.getControl().setEnabled(this.fEPresentation != null);
            this.fAddTab.setEnabled(this.fEPresentation != null);
            boolean hasHeader = false;
            if (this.fEPresentation != null && this.fPresentationsMap.get(this.fEPresentation.getIdentifier()) != null) {
                for (AbstractPresentationDescriptor desc : this.fPresentationsMap.get(this.fEPresentation.getIdentifier())) {
                    if (!this.isHeaderTab(desc)) continue;
                    hasHeader = true;
                    break;
                }
            }
            this.fAddHeader.setEnabled(!hasHeader);
            this.fIdToobleButton.setEnabled(this.fEPresentation != null);
        }
    }

    private void initializeDependencyCache() {
        this.fSectionDependencyCache = new HashMap<String, Set<TabDescriptor>>();
        this.fEditorDependencyCache = new HashMap<String, Set<String>>();
        this.fUnlockedPresentations = new HashSet<String>();
        this.fUnlockedSections = new HashSet<String>();
        for (String editorId : this.fEditorIds) {
            this.initializeEditorDependency(editorId);
        }
    }

    void initializeEditorDependency(String editorId) {
        if (this.fPresentationsMap.get(editorId) != null) {
            for (AbstractPresentationDescriptor tab : this.fPresentationsMap.get(editorId)) {
                if (!(tab instanceof TabDescriptor)) continue;
                if (this.fEditorDependencyCache.get(tab.getElementId()) == null) {
                    this.fEditorDependencyCache.put(tab.getElementId(), new HashSet());
                }
                this.fEditorDependencyCache.get(tab.getElementId()).add(editorId);
                if (this.fPresentationsMap.get(tab.getElementId()) == null) continue;
                for (AbstractPresentationDescriptor section : this.fPresentationsMap.get(tab.getElementId())) {
                    if (!(section instanceof SectionDescriptor)) continue;
                    if (this.fSectionDependencyCache.get(section.getElementId()) == null) {
                        this.fSectionDependencyCache.put(section.getElementId(), new HashSet());
                    }
                    this.fSectionDependencyCache.get(section.getElementId()).add((TabDescriptor)tab);
                }
            }
        }
    }

    void cleanUpEditorDependency(String editorId) {
        for (Map.Entry<String, Set<String>> entry : this.fEditorDependencyCache.entrySet()) {
            if (!entry.getValue().contains(editorId)) continue;
            entry.getValue().remove(editorId);
        }
    }

    public void setRequiredListsAndMaps(Map<String, List<AbstractPresentationDescriptor>> presentationsMap, List<String> editorIds, List<String> tabIds, Map<String, String> tabLayouts, List<String> sectionIds, List<EditorPresentation.Attribute> attributes) {
        this.fPresentationsMap = presentationsMap;
        this.fEditorIds = editorIds;
        this.fTabIds = tabIds;
        this.fTabLayouts = tabLayouts;
        this.fSectionIds = sectionIds;
        this.fAttributes = new ArrayList<EditorPresentation.Attribute>();
        for (EditorPresentation.Attribute a : attributes) {
            if (WorkItemAttributes.STATE.equals(a.getIdentifier()) || WorkItemAttributes.RESOLUTION.equals(a.getIdentifier()) || WorkItem.START_DATE_PROPERTY.equals(a.getIdentifier().getStringIdentifier())) continue;
            this.fAttributes.add(a);
        }
        this.initializeDependencyCache();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setInput(Object input) {
        if (input instanceof EditorPresentation) {
            this.fEPresentation = (EditorPresentation)input;
            this.fPresentationViewer.setInput((Object)this.fEPresentation);
        } else {
            this.fEPresentation = null;
            this.fPresentationViewer.setInput(null);
        }
        this.updateEnablement();
        this.fPresentationViewer.expandToLevel(2);
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private EditorPresentation.Attribute findAttribute(PresentationDescriptor desc) {
        EditorPresentation.Attribute attribute = null;
        if (desc.getAttributeId() != null) {
            for (EditorPresentation.Attribute a : this.fAttributes) {
                if (!a.getIdentifier().equals((Object)desc.getAttributeId())) continue;
                attribute = a;
                break;
            }
        }
        return attribute;
    }

    private Color getCellForeground(AbstractPresentationDescriptor desc) {
        return this.isInShared(desc) ? (this.isInUnlocked(desc) ? PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(SHAREDUNLOCKED_COLOR) : Display.getDefault().getSystemColor(18)) : Display.getDefault().getSystemColor(24);
    }

    private static void createPropertiesControl(Composite parent, final Map<String, String> properties) {
        Composite props = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.verticalIndent = 5;
        props.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        props.setLayout((Layout)layout);
        Label l = new Label(props, 0);
        l.setText(Messages.EditorPresentationAspectPart_PROPERTIES_LABEL);
        l.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Table t = new Table(props, 68354);
        t.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 6;
        data.widthHint = 280;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(140);
        c.setResizable(true);
        c.setText(KEY_LABEL);
        c = new TableColumn(t, 0);
        c.setWidth(140);
        c.setResizable(true);
        c.setText(VALUE_LABEL);
        final TableViewer propertiesViewer = new TableViewer(t);
        propertiesViewer.setColumnProperties(new String[]{KEY_LABEL, VALUE_LABEL});
        propertiesViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Map.Entry) {
                    if (columnIndex == 0) {
                        return (String)((Map.Entry)element).getKey();
                    }
                    if (columnIndex == 1) {
                        return (String)((Map.Entry)element).getValue();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Set) {
                    return ((Set)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        propertiesViewer.setInput(properties.entrySet());
        propertiesViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                KeyValuePairDialog dialog = new KeyValuePairDialog((IShellProvider)new SameShellProvider((Control)propertiesViewer.getControl().getShell()));
                Map.Entry firstElement = null;
                if (propertiesViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection structured = (IStructuredSelection)propertiesViewer.getSelection();
                    firstElement = (Map.Entry)structured.getFirstElement();
                    dialog.setInitialKeyValue(firstElement);
                }
                dialog.create();
                dialog.getShell().setText(Messages.EditorPresentationAspectPart_EDIT_PROPERTIES);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    String key = dialog.getKey();
                    if (firstElement != null) {
                        properties.remove(firstElement.getKey());
                    }
                    if (key != null) {
                        String value = dialog.getValue();
                        if (value == null) {
                            value = "";
                        }
                        if (key.length() > 0 || value.length() > 0) {
                            properties.put(key, value);
                        }
                    }
                    propertiesViewer.refresh();
                }
            }
        });
        t.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    KeyValuePairDialog dialog = new KeyValuePairDialog((IShellProvider)new SameShellProvider((Control)propertiesViewer.getControl().getShell()));
                    Map.Entry firstElement = null;
                    if (propertiesViewer.getSelection() instanceof IStructuredSelection) {
                        IStructuredSelection structured = (IStructuredSelection)propertiesViewer.getSelection();
                        firstElement = (Map.Entry)structured.getFirstElement();
                        dialog.setInitialKeyValue(firstElement);
                    }
                    dialog.create();
                    dialog.getShell().setText(Messages.EditorPresentationAspectPart_EDIT_PROPERTIES);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        String key = dialog.getKey();
                        if (firstElement != null) {
                            properties.remove(firstElement.getKey());
                        }
                        if (key != null) {
                            String value = dialog.getValue();
                            if (value == null) {
                                value = "";
                            }
                            if (key.length() > 0 || value.length() > 0) {
                                properties.put(key, value);
                            }
                        }
                        propertiesViewer.refresh();
                    }
                }
            }
        });
        Composite buttonBar = new Composite(props, 0);
        data = new GridData(4, 4, false, true);
        data.verticalIndent = t.getHeaderHeight();
        buttonBar.setLayoutData((Object)data);
        layout = new GridLayout();
        buttonBar.setLayout((Layout)layout);
        Button addButton = new Button(buttonBar, 0x800000);
        addButton.setText("+");
        addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                properties.put(KEY_LABEL, VALUE_LABEL);
                propertiesViewer.refresh();
                for (Map.Entry entry : properties.entrySet()) {
                    if (!KEY_LABEL.equals(entry.getKey()) || !VALUE_LABEL.equals(entry.getValue())) continue;
                    propertiesViewer.editElement(entry, 0);
                    break;
                }
            }
        });
        final Button removeButton = new Button(buttonBar, 0x800000);
        removeButton.setText("-");
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Map.Entry entry : ((IStructuredSelection)propertiesViewer.getSelection()).toList()) {
                    properties.remove(entry.getKey());
                }
                propertiesViewer.refresh();
            }
        });
        propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!propertiesViewer.getSelection().isEmpty());
            }
        });
        propertiesViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)t), new TextCellEditor((Composite)t)});
        propertiesViewer.setColumnProperties(new String[]{KEY_LABEL, VALUE_LABEL});
        ICellModifier modifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (element instanceof Map.Entry) {
                    if (property.equals(KEY_LABEL)) {
                        return ((Map.Entry)element).getKey();
                    }
                    if (property.equals(VALUE_LABEL)) {
                        return ((Map.Entry)element).getValue();
                    }
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if (!(element instanceof Map.Entry) || !(value instanceof String)) {
                    return;
                }
                Map.Entry entry = (Map.Entry)element;
                if (property.equals(KEY_LABEL)) {
                    properties.remove(entry.getKey());
                    properties.put((String)value, (String)entry.getValue());
                } else if (property.equals(VALUE_LABEL)) {
                    properties.put((String)entry.getKey(), (String)value);
                }
                propertiesViewer.refresh();
            }
        };
        propertiesViewer.setCellModifier(modifier);
        if (!"gtk".equals(SWT.getPlatform())) {
            Utils.updateColumnWidths((Table)propertiesViewer.getTable(), (int[])new int[]{1, 1});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddEditExistingCreateNewSectionDialog
    extends ProcessAttachmentIconSelectionDialog {
        private DecoratedCombo fSectionsCombo;
        private Text fTitleField;
        private List<String> fSections;
        private String fTitle;
        private String fSlot;
        private String fSectionId;
        private String fCreateId;
        private Map<String, String> fProperties = new HashMap<String, String>();
        private List<String> fSlots;
        private boolean fCreate;
        private Text fIdField;
        private Button fExistingButton;
        private Button fNewButton;
        private boolean fIsHeader = false;

        protected AddEditExistingCreateNewSectionDialog(Shell parentShell, String title, String sectionid, String sectionTitle, String slot, Map<String, String> properties, List<String> sections, Set<String> slots, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fTitle = sectionTitle;
            this.fSlot = slot;
            this.fSectionId = sectionid;
            if (sections == null) {
                this.fSections = new ArrayList<String>();
            } else {
                this.fSections = new ArrayList<String>(sections);
                Collections.sort(this.fSections);
            }
            this.fProperties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
            this.fSlots = slots == null ? new ArrayList<String>() : new ArrayList<String>(slots);
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    if ((AddEditExistingCreateNewSectionDialog.this.fTitle == null || "".equals(AddEditExistingCreateNewSectionDialog.this.fTitle)) && !AddEditExistingCreateNewSectionDialog.this.fIsHeader) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_TITLE_EMPTY);
                    }
                    if (AddEditExistingCreateNewSectionDialog.this.fCreate) {
                        if (AddEditExistingCreateNewSectionDialog.this.fCreateId == null || "".equals(AddEditExistingCreateNewSectionDialog.this.fCreateId)) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_SECTION_EMPTY);
                        }
                        if (AddEditExistingCreateNewSectionDialog.this.fCreateId.split("\\s").length > 1) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_NO_WHITESPACES);
                        }
                        if (AddEditExistingCreateNewSectionDialog.this.fSections.contains(AddEditExistingCreateNewSectionDialog.this.fCreateId)) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_SAME_SECTION_ID);
                        }
                    } else if (AddEditExistingCreateNewSectionDialog.this.fSectionId == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_NO_SECTION);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        public void setHeader(boolean header) {
            this.fIsHeader = true;
        }

        public String getSlot() {
            return this.fSlot;
        }

        public String getTitel() {
            return this.fTitle;
        }

        public boolean isCreate() {
            return this.fCreate;
        }

        public String getSectionId() {
            if (this.fCreate) {
                return this.fCreateId;
            }
            return this.fSectionId;
        }

        public Map<String, String> getProperties() {
            return this.fProperties;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = null;
            if (!this.fIsHeader) {
                l = new Label(parent, 0);
                l.setText(Messages.EditorPresentationAspectPart_TITLE_LABEL);
                l.setLayoutData((Object)new GridData());
                this.fTitleField = new Text(parent, 2048);
                if (this.fTitle != null) {
                    this.fTitleField.setText(this.fTitle);
                }
                this.fTitleField.setLayoutData((Object)new GridData(4, 4, true, false));
                this.fTitleField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AddEditExistingCreateNewSectionDialog.this.fTitle = AddEditExistingCreateNewSectionDialog.this.fTitleField.getText().trim();
                        AddEditExistingCreateNewSectionDialog.this.validate();
                    }
                });
                l = new Label(parent, 0);
                l.setText(Messages.EditorPresentationAspectPart_SLOT_LABEL);
                l.setLayoutData((Object)new GridData());
                final DecoratedCombo slotCombo = new DecoratedCombo(parent, 8, 4);
                AspectEditorUtil.adaptCombo(slotCombo.getCombo());
                slotCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
                slotCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object o) {
                        if (o instanceof String) {
                            return WorkItemEditorTabs.getSlotName((String)o);
                        }
                        return null;
                    }
                });
                slotCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object slot = slotCombo.getValue();
                        if (NONE.equals(slot)) {
                            AddEditExistingCreateNewSectionDialog.this.fSlot = null;
                        } else {
                            AddEditExistingCreateNewSectionDialog.this.fSlot = (String)slot;
                        }
                        AddEditExistingCreateNewSectionDialog.this.validate();
                    }
                });
                Object[] valueSet = new Object[this.fSlots.size() + 1];
                valueSet[0] = NONE;
                int i = 1;
                while (i <= this.fSlots.size()) {
                    valueSet[i] = this.fSlots.get(i - 1);
                    ++i;
                }
                slotCombo.setValueSet(valueSet);
                if (this.fSlot == null) {
                    slotCombo.setValue((Object)NONE);
                } else {
                    slotCombo.setValue((Object)this.fSlot);
                }
            }
            if (this.fSectionId != null) {
                l = new Label(parent, 0);
                l.setText(Messages.EditorPresentationAspectPart_SECTION_LABEL);
                l.setLayoutData((Object)new GridData());
                l = new Label(parent, 2048);
                l.setText(this.fSectionId);
                l.setLayoutData((Object)new GridData(4, 4, true, false));
            } else {
                Group g = new Group(parent, 0);
                g.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                GridLayout layout = new GridLayout(2, false);
                g.setLayout((Layout)layout);
                g.setText(Messages.EditorPresentationAspectPart_SECTION);
                this.fNewButton = new Button((Composite)g, 16);
                this.fNewButton.setText(Messages.EditorPresentationAspectPart_CREATE_SECTION);
                this.fNewButton.setLayoutData((Object)new GridData());
                this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddEditExistingCreateNewSectionDialog.this.fCreate = true;
                        AddEditExistingCreateNewSectionDialog.this.updateSelection(AddEditExistingCreateNewSectionDialog.this.fCreate);
                        AddEditExistingCreateNewSectionDialog.this.validate();
                    }
                });
                this.fIdField = new Text((Composite)g, 2048);
                this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
                this.fIdField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AddEditExistingCreateNewSectionDialog.this.fCreateId = AddEditExistingCreateNewSectionDialog.this.fIdField.getText().trim();
                        AddEditExistingCreateNewSectionDialog.this.validate();
                    }
                });
                this.fExistingButton = new Button((Composite)g, 16);
                this.fExistingButton.setText(Messages.EditorPresentationAspectPart_REUSE_SECTION);
                this.fExistingButton.setLayoutData((Object)new GridData());
                this.fExistingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddEditExistingCreateNewSectionDialog.this.fCreate = false;
                        AddEditExistingCreateNewSectionDialog.this.updateSelection(AddEditExistingCreateNewSectionDialog.this.fCreate);
                        AddEditExistingCreateNewSectionDialog.this.validate();
                    }
                });
                this.fSectionsCombo = new DecoratedCombo((Composite)g, 8, 4);
                AspectEditorUtil.adaptCombo(this.fSectionsCombo.getCombo());
                this.fSectionsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
                this.fSectionsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object o) {
                        if (o instanceof String) {
                            return (String)o;
                        }
                        return null;
                    }
                });
                this.fSectionsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object section = AddEditExistingCreateNewSectionDialog.this.fSectionsCombo.getValue();
                        if (NONE.equals(section)) {
                            AddEditExistingCreateNewSectionDialog.this.fSectionId = null;
                        } else {
                            AddEditExistingCreateNewSectionDialog.this.fSectionId = (String)section;
                        }
                        AddEditExistingCreateNewSectionDialog.this.validate();
                    }
                });
                Object[] valueSet = new Object[this.fSections.size() + 1];
                valueSet[0] = NONE;
                int i = 1;
                while (i <= this.fSections.size()) {
                    valueSet[i] = this.fSections.get(i - 1);
                    ++i;
                }
                this.fSectionsCombo.setValueSet(valueSet);
                if (this.fSectionId == null) {
                    this.fSectionsCombo.setValue((Object)NONE);
                } else {
                    this.fSectionsCombo.setValue((Object)this.fSectionId);
                }
                this.updateSelection(this.fCreate);
            }
            EditorPresentationAspectPart.createPropertiesControl(parent, this.fProperties);
        }

        private void updateSelection(boolean create) {
            this.fSectionsCombo.getCombo().setEnabled(!create);
            this.fExistingButton.setSelection(!create);
            this.fIdField.setEnabled(create);
            this.fNewButton.setSelection(create);
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddEditExistingCreateNewTabDialog
    extends ProcessAttachmentIconSelectionDialog {
        private DecoratedCombo fTabsCombo;
        private List<String> fTabs;
        private String fTitle;
        private String fLayout;
        private String fTabId;
        private String fCreateId;
        private Map<String, String> fProperties = new HashMap<String, String>();
        private boolean fCreate;
        private Text fIdField;
        private Button fExistingButton;
        private Button fNewButton;

        protected AddEditExistingCreateNewTabDialog(Shell parentShell, String title, String tabId, String tabTitle, String tabLayout, Map<String, String> properties, List<String> tabs, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fTitle = tabTitle;
            this.fLayout = tabLayout;
            this.fTabId = tabId;
            if (tabs == null) {
                this.fTabs = new ArrayList<String>();
            } else {
                this.fTabs = new ArrayList<String>(tabs);
                Collections.sort(this.fTabs);
            }
            this.fProperties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    if (AddEditExistingCreateNewTabDialog.this.fTitle == null || "".equals(AddEditExistingCreateNewTabDialog.this.fTitle)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_TITLE_EMPTY);
                    }
                    if (AddEditExistingCreateNewTabDialog.this.fLayout == null || "".equals(AddEditExistingCreateNewTabDialog.this.fLayout)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_LAYOUT_EMPTY);
                    }
                    if (AddEditExistingCreateNewTabDialog.this.fCreate) {
                        if (AddEditExistingCreateNewTabDialog.this.fCreateId == null || "".equals(AddEditExistingCreateNewTabDialog.this.fCreateId)) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_ID_EMPTY);
                        }
                        if (AddEditExistingCreateNewTabDialog.this.fCreateId.split("\\s").length > 1) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_NO_WHITESPACES);
                        }
                        if (AddEditExistingCreateNewTabDialog.this.fTabs.contains(AddEditExistingCreateNewTabDialog.this.fCreateId)) {
                            return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_SAME_TAB_ID);
                        }
                    } else if (AddEditExistingCreateNewTabDialog.this.fTabId == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_NO_TAB);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        public String getTabLayout() {
            return this.fLayout;
        }

        public String getTitle() {
            return this.fTitle;
        }

        public String getTabId() {
            if (this.fCreate) {
                return this.fCreateId;
            }
            return this.fTabId;
        }

        public boolean isCreate() {
            return this.fCreate;
        }

        public Map<String, String> getProperties() {
            return this.fProperties;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.EditorPresentationAspectPart_TITLE_LABEL);
            l.setLayoutData((Object)new GridData());
            final Text titleField = new Text(parent, 2048);
            if (this.fTitle != null) {
                titleField.setText(this.fTitle);
            }
            titleField.setLayoutData((Object)new GridData(4, 4, true, false));
            titleField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditExistingCreateNewTabDialog.this.fTitle = titleField.getText().trim();
                    AddEditExistingCreateNewTabDialog.this.validate();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.EditorPresentationAspectPart_LAYOUT_LABEL);
            l.setLayoutData((Object)new GridData());
            final DecoratedCombo layoutCombo = new DecoratedCombo(parent, 8, 4);
            AspectEditorUtil.adaptCombo(layoutCombo.getCombo());
            layoutCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            layoutCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return WorkItemEditorTabs.getLayoutDisplayName((String)o);
                    }
                    return null;
                }
            });
            layoutCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object layout = layoutCombo.getValue();
                    if (NONE.equals(layout)) {
                        AddEditExistingCreateNewTabDialog.this.fLayout = null;
                    } else {
                        AddEditExistingCreateNewTabDialog.this.fLayout = (String)layout;
                    }
                    AddEditExistingCreateNewTabDialog.this.validate();
                }
            });
            ArrayList<String> layoutIds = new ArrayList<String>(WorkItemEditorTabs.getTabLayouts());
            Collections.sort(layoutIds);
            Object[] valueSet = new Object[WorkItemEditorTabs.getTabLayouts().size() + 1];
            valueSet[0] = NONE;
            int i = 1;
            while (i <= layoutIds.size()) {
                valueSet[i] = layoutIds.get(i - 1);
                ++i;
            }
            layoutCombo.setValueSet(valueSet);
            if (this.fLayout == null) {
                layoutCombo.setValue((Object)NONE);
            } else {
                layoutCombo.setValue((Object)this.fLayout);
            }
            if (this.fTabId != null) {
                l = new Label(parent, 0);
                l.setText(Messages.EditorPresentationAspectPart_TAB_LABEL);
                l.setLayoutData((Object)new GridData());
                l = new Label(parent, 2048);
                l.setText(this.fTabId);
                l.setLayoutData((Object)new GridData(4, 4, true, false));
            } else {
                Group g = new Group(parent, 0);
                g.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                GridLayout layout = new GridLayout(2, false);
                g.setLayout((Layout)layout);
                g.setText(Messages.EditorPresentationAspectPart_TAB);
                this.fNewButton = new Button((Composite)g, 16);
                this.fNewButton.setText(Messages.EditorPresentationAspectPart_CREATE_TAB);
                this.fNewButton.setLayoutData((Object)new GridData());
                this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddEditExistingCreateNewTabDialog.this.fCreate = true;
                        AddEditExistingCreateNewTabDialog.this.updateSelection(AddEditExistingCreateNewTabDialog.this.fCreate);
                        AddEditExistingCreateNewTabDialog.this.validate();
                    }
                });
                this.fIdField = new Text((Composite)g, 2048);
                this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
                this.fIdField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        AddEditExistingCreateNewTabDialog.this.fCreateId = AddEditExistingCreateNewTabDialog.this.fIdField.getText().trim();
                        AddEditExistingCreateNewTabDialog.this.validate();
                    }
                });
                this.fExistingButton = new Button((Composite)g, 16);
                this.fExistingButton.setText(Messages.EditorPresentationAspectPart_REUSE_TAB);
                this.fExistingButton.setLayoutData((Object)new GridData());
                this.fExistingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AddEditExistingCreateNewTabDialog.this.fCreate = false;
                        AddEditExistingCreateNewTabDialog.this.updateSelection(AddEditExistingCreateNewTabDialog.this.fCreate);
                        AddEditExistingCreateNewTabDialog.this.validate();
                    }
                });
                this.fTabsCombo = new DecoratedCombo((Composite)g, 8, 4);
                AspectEditorUtil.adaptCombo(this.fTabsCombo.getCombo());
                this.fTabsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
                this.fTabsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object o) {
                        if (o instanceof String) {
                            return (String)o;
                        }
                        return null;
                    }
                });
                this.fTabsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object section = AddEditExistingCreateNewTabDialog.this.fTabsCombo.getValue();
                        if (NONE.equals(section)) {
                            AddEditExistingCreateNewTabDialog.this.fTabId = null;
                        } else {
                            AddEditExistingCreateNewTabDialog.this.fTabId = (String)section;
                        }
                        AddEditExistingCreateNewTabDialog.this.validate();
                    }
                });
                valueSet = new Object[this.fTabs.size() + 1];
                valueSet[0] = NONE;
                int i2 = 1;
                while (i2 <= this.fTabs.size()) {
                    valueSet[i2] = this.fTabs.get(i2 - 1);
                    ++i2;
                }
                this.fTabsCombo.setValueSet(valueSet);
                if (this.fTabId == null) {
                    this.fTabsCombo.setValue((Object)NONE);
                } else {
                    this.fTabsCombo.setValue((Object)this.fTabId);
                }
                this.updateSelection(this.fCreate);
            }
            EditorPresentationAspectPart.createPropertiesControl(parent, this.fProperties);
        }

        private void updateSelection(boolean create) {
            this.fTabsCombo.getCombo().setEnabled(!create);
            this.fExistingButton.setSelection(!create);
            this.fIdField.setEnabled(create);
            this.fNewButton.setSelection(create);
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddEditPresentationDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fIdField;
        private DecoratedCombo fKindsCombo;
        private DecoratedCombo fAKindsCombo;
        private DecoratedCombo fAttributeCombo;
        private String fId;
        private Kind fKind;
        private Kind fAKind;
        private String fLabel;
        private boolean fIsAttribute = true;
        private EditorPresentation.Attribute fAttribute;
        private List<Kind> fKinds;
        private List<EditorPresentation.Attribute> fAllAttributes;
        private Map<String, String> fProperties;
        private List<EditorPresentation.Attribute> fIdenticallyNamedAttributes;
        private List<EditorPresentation.Attribute> fNotAlreadyExistingAttributes;
        private boolean fShowArchived = false;
        private boolean fShowAlreadyConfigured = false;
        private ToolBarManager fToolbarManager;

        protected AddEditPresentationDialog(Shell parentShell, String dialogTitle, String id, EditorPresentation.Attribute attribute, String kind, String label, Map<String, String> properties, List<String> kinds, List<EditorPresentation.Attribute> notAlreadyExistingAttributes, List<EditorPresentation.Attribute> allAttributes, ResourceManager resourceManager) {
            super(parentShell, dialogTitle, null, null, resourceManager);
            this.fId = id;
            if (kind != null) {
                this.fKind = new Kind(kind, PresentationsManager.getDisplayName(kind));
            }
            this.fKinds = new ArrayList<Kind>();
            if (kinds != null) {
                for (String k : kinds) {
                    if (this.fKind != null && k.equals(this.fKind.getId())) {
                        this.fKinds.add(this.fKind);
                        continue;
                    }
                    this.fKinds.add(new Kind(k, PresentationsManager.getDisplayName(k)));
                }
            }
            Collections.sort(this.fKinds, new Comparator<Kind>(){

                @Override
                public int compare(Kind o1, Kind o2) {
                    return Collator.getInstance().compare(o1.getName(), o2.getName());
                }
            });
            this.fLabel = label;
            this.fAttribute = attribute;
            if (attribute == null && kind != null) {
                this.fIsAttribute = false;
            }
            Comparator<EditorPresentation.Attribute> attributeComparator = new Comparator<EditorPresentation.Attribute>(){

                @Override
                public int compare(EditorPresentation.Attribute o1, EditorPresentation.Attribute o2) {
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return Collator.getInstance().compare(o1.getDisplayName(), o2.getDisplayName());
                }
            };
            this.fNotAlreadyExistingAttributes = notAlreadyExistingAttributes != null ? new ArrayList<EditorPresentation.Attribute>(notAlreadyExistingAttributes) : new ArrayList<EditorPresentation.Attribute>();
            if (this.fAttribute != null) {
                this.fNotAlreadyExistingAttributes.add(this.fAttribute);
            }
            Collections.sort(this.fNotAlreadyExistingAttributes, attributeComparator);
            if (allAttributes != null) {
                this.fAllAttributes = new ArrayList<EditorPresentation.Attribute>(allAttributes);
                Collections.sort(this.fAllAttributes, attributeComparator);
            } else {
                this.fAllAttributes = new ArrayList<EditorPresentation.Attribute>();
            }
            this.fIdenticallyNamedAttributes = this.findIdenticallyNamedAttributes(this.fAllAttributes);
            this.fProperties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    if (AddEditPresentationDialog.this.fIsAttribute && AddEditPresentationDialog.this.fAttribute == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_MUST_SELECT_ATTRIBUTE);
                    }
                    if (AddEditPresentationDialog.this.fIsAttribute ? AddEditPresentationDialog.this.fAKind == null : !AddEditPresentationDialog.this.fIsAttribute && AddEditPresentationDialog.this.fKind == null) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_MUST_SELECT_KIND);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        private List<EditorPresentation.Attribute> findIdenticallyNamedAttributes(List<EditorPresentation.Attribute> attributes) {
            ArrayList<EditorPresentation.Attribute> identicallyNamed = new ArrayList<EditorPresentation.Attribute>();
            int i = 0;
            while (i < attributes.size() - 1) {
                if (attributes.get(i).getDisplayName().equals(attributes.get(i + 1).getDisplayName())) {
                    identicallyNamed.add(attributes.get(i));
                    identicallyNamed.add(attributes.get(i + 1));
                }
                ++i;
            }
            return identicallyNamed;
        }

        public String getId() {
            if ("".equals(this.fId)) {
                return null;
            }
            return this.fId;
        }

        public EditorPresentation.Attribute getAttribute() {
            if (this.fIsAttribute) {
                return this.fAttribute;
            }
            return null;
        }

        public String getKind() {
            if (this.fIsAttribute) {
                if (this.fAKind == null) {
                    return null;
                }
                return this.fAKind.getId();
            }
            if (this.fKind == null) {
                return null;
            }
            return this.fKind.getId();
        }

        public String getLabel() {
            if ("".equals(this.fLabel)) {
                return null;
            }
            return this.fLabel;
        }

        public Map<String, String> getProperties() {
            return this.fProperties;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            final ArrayList<Control> attControls = new ArrayList<Control>();
            final ArrayList<Control> kControls = new ArrayList<Control>();
            Button attr = new Button(parent, 16);
            attr.setText(Messages.EditorPresentationAspectPart_ATTRIBUTE);
            attr.setSelection(this.fIsAttribute);
            attr.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddEditPresentationDialog.this.fIsAttribute = true;
                    AddEditPresentationDialog.this.updateEnablement(attControls, kControls);
                    AddEditPresentationDialog.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            attr.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            Label l = new Label(parent, 0);
            attControls.add((Control)l);
            l.setText(Messages.EditorPresentationAspectPart_ATTRIBUTE_LABEL);
            GridData data = new GridData();
            data.horizontalIndent = 21;
            l.setLayoutData((Object)data);
            Composite filteredCombo = new Composite(parent, 0);
            filteredCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            filteredCombo.setLayout((Layout)layout);
            this.fAttributeCombo = new DecoratedCombo(filteredCombo, 8, 4);
            attControls.add((Control)this.fAttributeCombo.getCombo());
            AspectEditorUtil.adaptCombo(this.fAttributeCombo.getCombo());
            this.fAttributeCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fAttributeCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    if (o instanceof EditorPresentation.Attribute) {
                        if (AddEditPresentationDialog.this.fIdenticallyNamedAttributes.contains(o)) {
                            return NLS.bind((String)Messages.EditorPresentationAspectPart_NAME_ID, (Object)((EditorPresentation.Attribute)o).getDisplayName(), (Object[])new Object[]{((EditorPresentation.Attribute)o).getIdentifier().getStringIdentifier()});
                        }
                        return ((EditorPresentation.Attribute)o).getDisplayName();
                    }
                    return null;
                }
            });
            this.fAttributeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object attribute = AddEditPresentationDialog.this.fAttributeCombo.getValue();
                    if (NONE.equals(attribute)) {
                        AddEditPresentationDialog.this.fAttribute = null;
                    } else {
                        AddEditPresentationDialog.this.fAttribute = (EditorPresentation.Attribute)attribute;
                    }
                    AddEditPresentationDialog.this.updateAttributeKindValueSet();
                    AddEditPresentationDialog.this.validate();
                }
            });
            Action archived = new Action(Messages.EditorPresentationAspectPart_SHOW_ARCHIVED, 2){

                public void run() {
                    AddEditPresentationDialog.this.fShowArchived = !AddEditPresentationDialog.this.fShowArchived;
                    AddEditPresentationDialog.this.updateAttributeValueSet();
                }
            };
            Action alreadyConfigured = new Action(Messages.EditorPresentationAspectPart_SHOW_ALREADY_CONFIGURED, 2){

                public void run() {
                    AddEditPresentationDialog.this.fShowAlreadyConfigured = !AddEditPresentationDialog.this.fShowAlreadyConfigured;
                    AddEditPresentationDialog.this.updateAttributeValueSet();
                }
            };
            final Menu menu = new Menu((Control)filteredCombo);
            new ActionContributionItem((IAction)alreadyConfigured).fill(menu, -1);
            new ActionContributionItem((IAction)archived).fill(menu, -1);
            this.fToolbarManager = new ToolBarManager(0x800000);
            final IMenuCreator creator = new IMenuCreator(){

                public Menu getMenu(Control parent) {
                    return menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }

                public void dispose() {
                    menu.dispose();
                }
            };
            Action button = new Action(Messages.EditorPresentationAspectPart_FILTERS, 4){

                public IMenuCreator getMenuCreator() {
                    return creator;
                }

                public ImageDescriptor getImageDescriptor() {
                    return ImagePool.FILTER_ICON;
                }
            };
            this.fToolbarManager.add((IAction)button);
            ToolBar toolbar = this.fToolbarManager.createControl(filteredCombo);
            toolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            l = new Label(parent, 0);
            attControls.add((Control)l);
            l.setText(Messages.EditorPresentationAspectPart_KIND_LABEL);
            data = new GridData();
            data.horizontalIndent = 21;
            l.setLayoutData((Object)data);
            this.fAKindsCombo = new DecoratedCombo(parent, 8, 4);
            attControls.add((Control)this.fAKindsCombo.getCombo());
            AspectEditorUtil.adaptCombo(this.fAKindsCombo.getCombo());
            this.fAKindsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            this.fAKindsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    if (o instanceof Kind) {
                        return ((Kind)o).getName();
                    }
                    return null;
                }
            });
            this.fAKindsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object kind = AddEditPresentationDialog.this.fAKindsCombo.getValue();
                    if (NONE.equals(kind)) {
                        AddEditPresentationDialog.this.fAKind = null;
                    } else {
                        AddEditPresentationDialog.this.fAKind = (Kind)kind;
                    }
                    AddEditPresentationDialog.this.validate();
                }
            });
            Object[] valueSet = new Object[this.fKinds.size() + 1];
            valueSet[0] = NONE;
            int i = 1;
            while (i <= this.fKinds.size()) {
                valueSet[i] = this.fKinds.get(i - 1);
                ++i;
            }
            this.fAKindsCombo.setValueSet(valueSet);
            if (this.fKind == null || !this.fIsAttribute) {
                this.fAKindsCombo.setValue((Object)NONE);
            } else {
                this.fAKindsCombo.setValue((Object)this.fKind);
            }
            this.updateAttributeValueSet();
            Button kind = new Button(parent, 16);
            kind.setText(Messages.EditorPresentationAspectPart_PRESENTATION);
            kind.setSelection(!this.fIsAttribute);
            kind.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            kind.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddEditPresentationDialog.this.fIsAttribute = false;
                    AddEditPresentationDialog.this.updateEnablement(attControls, kControls);
                    AddEditPresentationDialog.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            l = new Label(parent, 0);
            kControls.add((Control)l);
            l.setText(Messages.EditorPresentationAspectPart_KIND_LABEL);
            data = new GridData();
            data.horizontalIndent = 21;
            l.setLayoutData((Object)data);
            this.fKindsCombo = new DecoratedCombo(parent, 8, 4);
            kControls.add((Control)this.fKindsCombo.getCombo());
            AspectEditorUtil.adaptCombo(this.fKindsCombo.getCombo());
            this.fKindsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            this.fKindsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    if (o instanceof Kind) {
                        return ((Kind)o).getName();
                    }
                    return null;
                }
            });
            this.fKindsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object kind = AddEditPresentationDialog.this.fKindsCombo.getValue();
                    if (NONE.equals(kind)) {
                        AddEditPresentationDialog.this.fKind = null;
                    } else {
                        AddEditPresentationDialog.this.fKind = (Kind)kind;
                    }
                    AddEditPresentationDialog.this.validate();
                }
            });
            ArrayList<Kind> values = new ArrayList<Kind>();
            for (Kind k : this.fKinds) {
                if (PresentationsManager.needsAttribute(k.getId())) continue;
                values.add(k);
            }
            valueSet = new Object[values.size() + 1];
            valueSet[0] = NONE;
            int i2 = 1;
            for (Kind k : values) {
                valueSet[i2] = k;
                ++i2;
            }
            this.fKindsCombo.setValueSet(valueSet);
            if (this.fKind == null || this.fIsAttribute) {
                this.fKindsCombo.setValue((Object)NONE);
            } else {
                this.fKindsCombo.setValue((Object)this.fKind);
            }
            for (Control c : kControls) {
                c.setEnabled(false);
            }
            Composite spacer = new Composite(parent, 0);
            data = new GridData(4, 4, false, false, 2, 1);
            data.heightHint = 10;
            spacer.setLayoutData((Object)data);
            l = new Label(parent, 0);
            l.setText(Messages.EditorPresentationAspectPart_LABEL_LABEL);
            final Text label = new Text(parent, 2048);
            if (this.fLabel != null) {
                label.setText(this.fLabel);
            }
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            label.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditPresentationDialog.this.fLabel = label.getText().trim();
                }
            });
            l = new Label(parent, 0);
            l.setText(Messages.EditorPresentationAspectPart_ID_OPTIONAL_LABEL);
            data = new GridData();
            l.setLayoutData((Object)data);
            this.fIdField = new Text(parent, 2048);
            if (this.fId != null) {
                this.fIdField.setText(this.fId);
            }
            this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fIdField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddEditPresentationDialog.this.fId = AddEditPresentationDialog.this.fIdField.getText().trim();
                }
            });
            EditorPresentationAspectPart.createPropertiesControl(parent, this.fProperties);
            this.updateEnablement(attControls, kControls);
        }

        private void updateAttributeValueSet() {
            ArrayList<EditorPresentation.Attribute> aValues = new ArrayList<EditorPresentation.Attribute>();
            List<EditorPresentation.Attribute> attributes = this.fShowAlreadyConfigured ? this.fAllAttributes : this.fNotAlreadyExistingAttributes;
            for (EditorPresentation.Attribute a : attributes) {
                if (PresentationsManager.getPossibleKinds(a.getAttributeType()).isEmpty() && AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)a.getAttributeType()) == null || !this.fShowArchived && a.isCustomAttribute() && !a.isConfiguredInSpec()) continue;
                aValues.add(a);
            }
            Object[] valueSet = new Object[aValues.size() + 1];
            valueSet[0] = NONE;
            int i = 1;
            for (EditorPresentation.Attribute a : aValues) {
                valueSet[i] = a;
                ++i;
            }
            this.fAttributeCombo.setValueSet(valueSet);
            if (this.fAttribute == null) {
                this.fAttributeCombo.setValue((Object)NONE);
            } else {
                this.fAttributeCombo.setValue((Object)this.fAttribute);
            }
        }

        private void updateEnablement(List<Control> attControls, List<Control> kControls) {
            for (Control c : attControls) {
                c.setEnabled(this.fIsAttribute);
            }
            for (Control c : kControls) {
                c.setEnabled(!this.fIsAttribute);
            }
            if (this.fIsAttribute) {
                this.updateAttributeKindValueSet();
            }
        }

        private void updateAttributeKindValueSet() {
            ArrayList<Kind> values = new ArrayList<Kind>();
            if (this.fAttribute != null) {
                Set<String> kinds = PresentationsManager.getPossibleKinds(this.fAttribute.getAttributeType());
                String defaultK = AttributeTypePresentationIdBindingManager.getAttributeTypePresentationId((String)this.fAttribute.getAttributeType());
                Kind defaultKind = null;
                for (Kind k : this.fKinds) {
                    if (!kinds.contains(k.getId())) continue;
                    values.add(k);
                    if (defaultK == null || !defaultK.equals(k.getId())) continue;
                    defaultKind = k;
                }
                values.add(new Kind("com.ibm.team.workitem.kind.special.doNotShow", PresentationsManager.getDisplayName("com.ibm.team.workitem.kind.special.doNotShow")));
                this.fAKindsCombo.setValueSet((Object[])values.toArray(new Kind[values.size()]));
                if (!values.contains(this.fAKindsCombo.getValue())) {
                    if (defaultKind != null) {
                        this.fAKindsCombo.setValue((Object)defaultKind);
                    } else {
                        this.fAKindsCombo.setValue((Object)NONE);
                    }
                }
                this.fAKindsCombo.getCombo().setEnabled(!values.isEmpty());
            } else {
                this.fAKindsCombo.getCombo().setEnabled(false);
                this.fAKindsCombo.setValue((Object)NONE);
            }
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Control area = super.createDialogArea(parent);
            if (this.fKind != null || this.fAttribute != null || this.fId != null) {
                this.validate();
            }
            return area;
        }

        @Override
        public boolean close() {
            this.fToolbarManager.dispose();
            return super.close();
        }

        private static class Kind {
            private String fId;
            private String fName;

            public Kind(String id, String name) {
                this.fId = id;
                this.fName = name;
            }

            public String getId() {
                return this.fId;
            }

            public String getName() {
                return this.fName;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DuplicateEntryIdSelectionDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fIdField;
        private String fId;
        private List<String> fAllElements;
        private String fEnterIdMessage;

        public DuplicateEntryIdSelectionDialog(Shell parentShell, String title, final String idExistsMessage, String enterIdMessage, List<String> allElements, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fAllElements = new ArrayList<String>(allElements);
            this.fEnterIdMessage = enterIdMessage;
            this.setValidator(new ProcessAttachmentIconSelectionDialog.IDialogValidator(){

                public IStatus isValid() {
                    if (DuplicateEntryIdSelectionDialog.this.fId == null || "".equals(DuplicateEntryIdSelectionDialog.this.fId)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_EMPTY_ID);
                    }
                    if (DuplicateEntryIdSelectionDialog.this.fId.split("\\s").length > 1) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.EditorPresentationAspectPart_NO_WHITESPACES);
                    }
                    if (DuplicateEntryIdSelectionDialog.this.fAllElements.contains(DuplicateEntryIdSelectionDialog.this.fId)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", idExistsMessage);
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        public String getId() {
            return this.fId.trim();
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Composite message = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            message.setLayout((Layout)layout);
            message.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Label msg = new Label(message, 64);
            msg.setText(this.fEnterIdMessage);
            msg.setLayoutData((Object)new GridData());
            Label l = new Label(parent, 0);
            l.setText(Messages.EditorPresentationAspectPart_ID_LABEL);
            l.setLayoutData((Object)new GridData());
            this.fIdField = new Text(parent, 2048);
            if (this.fId != null) {
                this.fIdField.setText(this.fId);
            }
            this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fIdField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DuplicateEntryIdSelectionDialog.this.fId = DuplicateEntryIdSelectionDialog.this.fIdField.getText().trim();
                    DuplicateEntryIdSelectionDialog.this.validate();
                }
            });
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }
}

