/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.BindingTarget;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentationManager;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.EditorIdBinding;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.editorpresentation.WorkitemTypeEditorIdBindingManager;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorIdBindingAspectEditor
extends AbstractWorkItemAspectEditor {
    private static final String EDITORPRESENTATIONS = "com.ibm.team.workitem.editor.configuration.presentations";
    private static String NO_ELEMENTS = Messages.EditorIdBindingAspectEditor_NO_ELEMENTS;
    private static final String NONE = NLS.bind((String)Messages.DEFAULT, (Object)"com.ibm.team.workitem.editor.default", (Object[])new Object[0]);
    private static final AbstractWorkItemAspectEditor.IAspectMessageProvider MESSAGE_PROVIDER = new AbstractWorkItemAspectEditor.IAspectMessageProvider(){

        public String getChooseMessage() {
            return Messages.EditorIdBindingAspectEditor_CHOOSE_TYPE_TO_EDIT;
        }

        public String getSameIdMessage() {
            return Messages.EditorIdBindingAspectEditor_SAME_ID_EXISTS;
        }

        public String getEnterIdMessage() {
            return Messages.EditorIdBindingAspectEditor_ENTER_ID_;
        }
    };
    private EditorIdBinding.Type fType;
    private Map<BindingTarget, DecoratedCombo> fCombos = new HashMap<BindingTarget, DecoratedCombo>();
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<BindingTarget> fTargets;
    private List<EditorIdBinding> fAllBindings;
    private List<String> fEditorIds;
    private List<String> fTabIds;
    private List<String> fSectionIds;

    public EditorIdBindingAspectEditor(String dataId) {
        super(dataId);
        this.setHelpContextId("com.ibm.team.workitem.ide.ui.editor_id_binding_aspect_editor");
    }

    @Override
    protected void commit(List<? extends ModeledElement> elements, IMemento memento) {
        WorkitemTypeEditorIdBindingManager.writeEditorIdBindings(memento, this.fAllBindings);
    }

    @Override
    protected void createEditorArea(Composite parent, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginTop = 10;
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        for (final BindingTarget t : this.fTargets) {
            Composite comp = toolkit.createComposite(parent);
            layout = new GridLayout();
            layout.marginWidth = 0;
            comp.setLayout((Layout)layout);
            Label l = toolkit.createLabel(comp, t.getDisplayName());
            GridData data = new GridData(16384, 4, false, false);
            l.setLayoutData((Object)data);
            final DecoratedCombo combo = new DecoratedCombo(comp, 8, 1);
            toolkit.adapt((Control)combo.getCombo(), true, false);
            data = new GridData(16384, 4, false, false);
            combo.getLayoutControl().setLayoutData((Object)data);
            combo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return (String)element;
                }

                public Image getImage(Object element) {
                    if ("tab".equals(t.getElementType())) {
                        return JazzResources.getImage((ResourceManager)EditorIdBindingAspectEditor.this.fResourceManager, (ImageDescriptor)ImagePool.TAB, null);
                    }
                    if ("section".equals(t.getElementType())) {
                        return JazzResources.getImage((ResourceManager)EditorIdBindingAspectEditor.this.fResourceManager, (ImageDescriptor)ImagePool.SECTION, null);
                    }
                    if ("editor".equals(t.getElementType())) {
                        return JazzResources.getImage((ResourceManager)EditorIdBindingAspectEditor.this.fResourceManager, (ImageDescriptor)ImagePool.EDITOR, null);
                    }
                    return null;
                }
            });
            combo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EditorIdBinding binding;
                    String value = (String)combo.getValue();
                    if (Messages.EditorIdBindingAspectEditor_NONE_ELEMENT.equals(value) || NONE.equals(value)) {
                        value = null;
                    }
                    if (!AspectEditorUtil.equals(value, (binding = EditorIdBindingAspectEditor.this.findBinding(t, EditorIdBindingAspectEditor.this.fType)).getEditorId())) {
                        binding.setEditorId(value);
                        EditorIdBindingAspectEditor.this.setDirty();
                    }
                }
            });
            this.fCombos.put(t, combo);
        }
    }

    @Override
    protected ModeledElement createNewElement() {
        return null;
    }

    @Override
    protected boolean canAdd() {
        return false;
    }

    @Override
    protected void inputChanged(ModeledElement newElement) {
        this.fType = (EditorIdBinding.Type)newElement;
        this.updateComboValues();
    }

    private EditorIdBinding findBinding(BindingTarget target, EditorIdBinding.Type type) {
        List<EditorIdBinding> bindings = this.findBindings(target);
        for (EditorIdBinding binding : bindings) {
            if (!binding.getType().equals(type)) continue;
            return binding;
        }
        return null;
    }

    private List<EditorIdBinding> findBindings(BindingTarget target) {
        ArrayList<EditorIdBinding> values = new ArrayList<EditorIdBinding>();
        for (EditorIdBinding binding : this.fAllBindings) {
            if (!AspectEditorUtil.equals(binding.getTarget(), target.getTargetId())) continue;
            values.add(binding);
        }
        return values;
    }

    private void updateComboValues() {
        for (BindingTarget t : this.fTargets) {
            String value;
            DecoratedCombo combo = this.fCombos.get(t);
            if (combo == null) continue;
            ArrayList<String> values = new ArrayList<String>(this.findValues(t));
            if (values.isEmpty()) {
                values.add(NO_ELEMENTS);
                combo.getCombo().setEnabled(false);
            } else {
                values.add(0, "editor".equals(t.getElementType()) ? NONE : Messages.EditorIdBindingAspectEditor_NONE_ELEMENT);
                combo.getCombo().setEnabled(true);
            }
            EditorIdBinding current = this.findBinding(t, this.fType);
            String string = value = "editor".equals(t.getElementType()) ? NONE : Messages.EditorIdBindingAspectEditor_NONE_ELEMENT;
            if (current != null) {
                for (String v : values) {
                    if (current.getEditorId() == null || !current.getEditorId().equals(v)) continue;
                    value = v;
                }
            }
            combo.setValueSet(values.toArray());
            combo.setValue((Object)value);
        }
    }

    private List<String> findValues(BindingTarget target) {
        if ("tab".equals(target.getElementType())) {
            return this.fTabIds;
        }
        if ("editor".equals(target.getElementType())) {
            return this.fEditorIds;
        }
        if ("section".equals(target.getElementType())) {
            return this.fSectionIds;
        }
        return Collections.emptyList();
    }

    private void readExistingPresentationIds() {
        ArrayList<String> editorIds = new ArrayList<String>();
        ArrayList<String> tabIds = new ArrayList<String>();
        ArrayList<String> sectionIds = new ArrayList<String>();
        ModelElement enumElement = this.getSite().getConfigurationData(EDITORPRESENTATIONS);
        if (enumElement != null) {
            for (ModelElement element : enumElement.getChildElements()) {
                String sectionId;
                String editorId;
                if ("editor".equals(element.getName()) && (editorId = element.getAttribute("id")) != null) {
                    editorIds.add(editorId);
                }
                if ("tab".equals(element.getName())) {
                    String tabId = element.getAttribute("id");
                    String layout = element.getAttribute("layout");
                    if (tabId != null && !"internalHeader".equals(layout)) {
                        tabIds.add(tabId);
                    }
                }
                if (!"section".equals(element.getName()) || (sectionId = element.getAttribute("id")) == null) continue;
                sectionIds.add(sectionId);
            }
        }
        this.fEditorIds = editorIds;
        this.fTabIds = tabIds;
        this.fSectionIds = sectionIds;
    }

    @Override
    protected void doDispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    @Override
    protected List<? extends ModeledElement> readElements(ModelElement configurationElement) {
        this.readExistingPresentationIds();
        this.fTargets = EditorPresentationManager.getBindingTargets();
        List<EditorIdBinding.Type> types = WorkitemTypeEditorIdBindingManager.readWorkItemTypes(this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes"));
        List<EditorIdBinding> bindings = WorkitemTypeEditorIdBindingManager.readEditorIdBindings(configurationElement, types);
        for (BindingTarget target : this.fTargets) {
            for (EditorIdBinding.Type t : types) {
                boolean found = false;
                for (EditorIdBinding binding : bindings) {
                    if (!t.equals(binding.getType()) || !AspectEditorUtil.equals(target.getTargetId(), binding.getTarget())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                bindings.add(new EditorIdBinding(target.getTargetId(), t, null));
            }
            if ("editor".equals(target.getElementType())) {
                for (EditorIdBinding binding : bindings) {
                    if (!AspectEditorUtil.equals(target.getTargetId(), binding.getTarget()) || binding.getEditorId() == null || this.fEditorIds.contains(binding.getEditorId())) continue;
                    this.fEditorIds.add(binding.getEditorId());
                }
                continue;
            }
            if ("tab".equals(target.getElementType())) {
                for (EditorIdBinding binding : bindings) {
                    if (!AspectEditorUtil.equals(target.getTargetId(), binding.getTarget()) || binding.getEditorId() == null || this.fTabIds.contains(binding.getEditorId())) continue;
                    this.fTabIds.add(binding.getEditorId());
                }
                continue;
            }
            if (!"section".equals(target.getElementType())) continue;
            for (EditorIdBinding binding : bindings) {
                if (!AspectEditorUtil.equals(target.getTargetId(), binding.getTarget()) || binding.getEditorId() == null || this.fSectionIds.contains(binding.getEditorId())) continue;
                this.fSectionIds.add(binding.getEditorId());
            }
        }
        Collections.sort(this.fEditorIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        Collections.sort(this.fTabIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        Collections.sort(this.fSectionIds, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        this.fAllBindings = bindings;
        return types;
    }

    @Override
    protected AbstractWorkItemAspectEditor.IAspectMessageProvider getMessageProvider() {
        return MESSAGE_PROVIDER;
    }
}

