/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking;

import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.ApprovalTracking;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ApprovalTrackingPart
extends TeamFormPart {
    private TreeViewer fApprovalViewer;
    private IDirtyStateTracker fTracker;
    private ApprovalTracking fTracking;
    private static final String APPROVAL_LABEL = Messages.ApprovalTrackingPart_APPROVAL_LABEL;
    private static final String ACTION_LABEL = Messages.ApprovalTrackingPart_ACTION_LABEL;
    private static final String NONE = Messages.ApprovalTrackingPart_NONE;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private IProcessContainerWorkingCopy fContainer;
    private ApprovalTracking.ApprovalTrackingChangeListener fListener = new ApprovalTracking.ApprovalTrackingChangeListener(){

        public void approvalTrackingChanged(final ApprovalTracking.ApprovalTrackingChangeEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ApprovalTrackingPart.this.fApprovalViewer.refresh();
                    if (e.getChanged() != null) {
                        ApprovalTrackingPart.this.fApprovalViewer.setSelection((ISelection)new StructuredSelection(e.getChanged()));
                        ApprovalTrackingPart.this.fApprovalViewer.getTree().setFocus();
                    }
                }
            });
        }
    };

    ApprovalTrackingPart(IProcessContainerWorkingCopy processContainer, IDirtyStateTracker tracker) {
        this.fContainer = processContainer;
        this.fTracker = tracker;
    }

    private void setDirty() {
        this.fTracker.setDirty();
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite viewer = new Composite(parent, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = new Composite(parent, 0);
        GridData data = new GridData(16384, 1, false, false);
        buttonBar.setLayoutData((Object)data);
        this.createViewer(viewer, buttonBar);
    }

    private void createViewer(Composite viewer, Composite buttonBar) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        viewer.setLayout((Layout)layout);
        Tree t = new Tree(viewer, 67586);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = t.getItemHeight() * 14;
        t.setLayoutData((Object)data);
        TreeColumn c = new TreeColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(APPROVAL_LABEL);
        c = new TreeColumn(t, 0);
        c.setWidth(180);
        c.setResizable(true);
        c.setText(ACTION_LABEL);
        this.fApprovalViewer = new TreeViewer(t);
        this.fApprovalViewer.setColumnProperties(new String[]{APPROVAL_LABEL, ACTION_LABEL});
        this.fApprovalViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ApprovalTracking.TrackingEntry) {
                    ApprovalTracking.TrackingEntry entry = (ApprovalTracking.TrackingEntry)element;
                    if (cell.getColumnIndex() == 0) {
                        cell.setText(entry.getApprovalTarget() != null ? entry.getApprovalTarget().getDisplayName() : null);
                        cell.setImage(this.getImage(element, entry.getApprovalTarget().getIconURL().toString()));
                    } else if (cell.getColumnIndex() == 1) {
                        cell.setText(entry.getWFAction() != null ? entry.getWFAction().getName() : null);
                        cell.setForeground(Display.getDefault().getSystemColor(24));
                        if (entry.getWFAction() != null && entry.getWFAction().getIcon() != null) {
                            cell.setImage(this.getImage(element, entry.getWFAction().getIcon()));
                        }
                    }
                }
                if (element instanceof StateEntry) {
                    if (cell.getColumnIndex() == 0) {
                        cell.setText(((StateEntry)element).getState().getDisplayName());
                        cell.setImage(this.getImage(element, ((StateEntry)element).getState().getIconURL().toString()));
                    } else if (cell.getColumnIndex() == 1) {
                        cell.setText(Messages.ApprovalTrackingPart_NONE_CELL_ENTRY);
                        cell.setForeground(Display.getDefault().getSystemColor(18));
                        cell.setImage(null);
                    }
                }
                if (element instanceof IApprovalType && cell.getColumnIndex() == 0) {
                    cell.setText(((IApprovalType)element).getDisplayName());
                    cell.setImage(this.getImage(element, ((IApprovalType)element).getIconURL().toString()));
                }
            }

            private Image getImage(final Object element, String iconPath) {
                return AspectEditorUtil.getImage(ApprovalTrackingPart.this.fContainer, iconPath, ApprovalTrackingPart.this.fResourceManager, new Runnable(){

                    public void run() {
                        this.fireChanged(element);
                    }
                });
            }

            private void fireChanged(Object element) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
            }
        });
        this.fApprovalViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            private ApprovalTracking.TrackingEntry getEntry(IApprovalType type, IApprovalState state) {
                for (ApprovalTracking.TrackingEntry e : ApprovalTrackingPart.this.fTracking.getEntries()) {
                    if (!e.getApprovalType().getIdentifier().equals(type.getIdentifier()) || !e.getApprovalTarget().getIdentifier().equals(state.getIdentifier())) continue;
                    return e;
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IApprovalType) {
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (IApprovalState state : WorkItemApprovals.getStates()) {
                        ApprovalTracking.TrackingEntry e = this.getEntry((IApprovalType)parentElement, state);
                        if (e != null) {
                            result.add(e);
                            continue;
                        }
                        result.add(new StateEntry((IApprovalType)parentElement, state));
                    }
                    return result.toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof ApprovalTracking.TrackingEntry) {
                    return ((ApprovalTracking.TrackingEntry)element).getApprovalType();
                }
                if (element instanceof StateEntry) {
                    return ((StateEntry)element).getType();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return WorkItemApprovals.getTypes().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        layout = new GridLayout();
        layout.marginTop = this.fApprovalViewer.getTree().getHeaderHeight();
        buttonBar.setLayout((Layout)layout);
        final Button removeEntry = toolkit.createButton(buttonBar, Messages.ApprovalTrackingPart_CLEAR, 0x800000);
        removeEntry.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        removeEntry.setEnabled(false);
        removeEntry.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean removedAny = false;
                for (Object o : ((IStructuredSelection)ApprovalTrackingPart.this.fApprovalViewer.getSelection()).toList()) {
                    if (!(o instanceof ApprovalTracking.TrackingEntry)) continue;
                    ApprovalTrackingPart.this.fTracking.removeEntry((ApprovalTracking.TrackingEntry)o);
                    removedAny = true;
                }
                if (removedAny) {
                    ApprovalTrackingPart.this.setDirty();
                }
            }
        });
        final Button editEnumeration = toolkit.createButton(buttonBar, Messages.ApprovalTrackingPart_EDIT, 0x800000);
        editEnumeration.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        editEnumeration.setEnabled(false);
        editEnumeration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApprovalTrackingPart.this.editEntry();
            }
        });
        this.fApprovalViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeEntry.setEnabled(ApprovalTrackingPart.this.validRemoveSelection());
                editEnumeration.setEnabled(ApprovalTrackingPart.this.validEditSelection());
            }
        });
        this.fApprovalViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ApprovalTrackingPart.this.validEditSelection()) {
                    ApprovalTrackingPart.this.editEntry();
                }
            }
        });
        this.updateEnablement();
        Utils.updateColumnWidths((Tree)this.fApprovalViewer.getTree(), (int[])new int[]{-1, 1});
    }

    private boolean validRemoveSelection() {
        for (Object o : ((IStructuredSelection)this.fApprovalViewer.getSelection()).toList()) {
            if (!(o instanceof ApprovalTracking.TrackingEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean validEditSelection() {
        if (((IStructuredSelection)this.fApprovalViewer.getSelection()).size() != 1) {
            return false;
        }
        return ((IStructuredSelection)this.fApprovalViewer.getSelection()).getFirstElement() instanceof ApprovalTracking.TrackingEntry || ((IStructuredSelection)this.fApprovalViewer.getSelection()).getFirstElement() instanceof StateEntry;
    }

    private void editEntry() {
        EditEntryDialog d;
        Object selected = ((IStructuredSelection)this.fApprovalViewer.getSelection()).getFirstElement();
        IApprovalType type = null;
        IApprovalState state = null;
        WFWorkflow.WFAction action = null;
        if (selected instanceof StateEntry) {
            type = ((StateEntry)selected).getType();
            state = ((StateEntry)selected).getState();
        }
        ApprovalTracking.TrackingEntry entry = null;
        if (selected instanceof ApprovalTracking.TrackingEntry) {
            entry = (ApprovalTracking.TrackingEntry)selected;
            type = entry.getApprovalType();
            state = entry.getApprovalTarget();
            action = entry.getWFAction();
        }
        if ((d = new EditEntryDialog(Display.getCurrent().getActiveShell(), Messages.ApprovalTrackingPart_EDIT_TRACKING, type, state, action, this.fTracking.getWorkflow().getActions(), this.fResourceManager)).open() == 0) {
            WFWorkflow.WFAction act = d.getAction();
            if (act == null && entry != null) {
                this.fTracking.removeEntry(entry);
                this.setDirty();
                return;
            }
            if (act != null && entry != null) {
                if (!act.equals(entry.getWFAction())) {
                    entry.setWFAction(act);
                    this.setDirty();
                }
                return;
            }
            if (entry == null && act != null) {
                ApprovalTracking approvalTracking = this.fTracking;
                approvalTracking.getClass();
                entry = approvalTracking.new ApprovalTracking.TrackingEntry(type, state);
                entry.setWFAction(act);
                this.fTracking.addEntry(entry);
                this.setDirty();
            }
        }
    }

    private void updateEnablement() {
        if (this.fApprovalViewer != null && !this.fApprovalViewer.getControl().isDisposed()) {
            this.fApprovalViewer.getControl().setEnabled(this.fTracking != null);
        }
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setInput(Object input) {
        if (this.fTracking != null) {
            this.fTracking.removeListener(this.fListener);
        }
        if (input instanceof ApprovalTracking) {
            this.fTracking = (ApprovalTracking)input;
            this.fApprovalViewer.setInput((Object)this.fTracking);
            this.fTracking.addListener(this.fListener);
        } else {
            this.fTracking = null;
            this.fApprovalViewer.setInput(null);
        }
        this.updateEnablement();
        this.fApprovalViewer.expandAll();
    }

    public void dispose() {
        if (this.fTracking != null) {
            this.fTracking.removeListener(this.fListener);
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditEntryDialog
    extends ProcessAttachmentIconSelectionDialog {
        private IApprovalType fType;
        private IApprovalState fTarget;
        private WFWorkflow.WFAction fAction;
        private List<WFWorkflow.WFAction> fActions;
        private DecoratedCombo fActionsCombo;

        protected EditEntryDialog(Shell parentShell, String dialogTitle, IApprovalType type, IApprovalState target, WFWorkflow.WFAction action, List<WFWorkflow.WFAction> actions, ResourceManager resourceManager) {
            super(parentShell, dialogTitle, null, null, resourceManager);
            this.fType = type;
            this.fTarget = target;
            this.fAction = action;
            this.fActions = actions != null ? new ArrayList<WFWorkflow.WFAction>(actions) : new ArrayList<WFWorkflow.WFAction>();
        }

        public WFWorkflow.WFAction getAction() {
            return this.fAction;
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.ApprovalTrackingPart_APPROVAL_TYPE);
            l.setLayoutData((Object)new GridData());
            String t = this.fType.getDisplayName();
            if (t == null) {
                t = NONE;
            }
            Label typeField = new Label(parent, 2048);
            typeField.setText(t);
            typeField.setLayoutData((Object)new GridData(4, 4, true, false));
            l = new Label(parent, 0);
            l.setText(Messages.ApprovalTrackingPart_APPROVAL_TARGET);
            l.setLayoutData((Object)new GridData());
            String s = this.fTarget.getDisplayName();
            if (s == null) {
                s = NONE;
            }
            Label stateField = new Label(parent, 2048);
            stateField.setText(s);
            stateField.setLayoutData((Object)new GridData(4, 4, true, false));
            l = new Label(parent, 0);
            l.setText(Messages.ApprovalTrackingPart_WORKFLOW_ACTION);
            l.setLayoutData((Object)new GridData());
            this.fActionsCombo = new DecoratedCombo(parent, 8, 4);
            AspectEditorUtil.adaptCombo(this.fActionsCombo.getCombo());
            this.fActionsCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 4, true, false));
            this.fActionsCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object o) {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    if (o instanceof WFWorkflow.WFAction) {
                        return ((WFWorkflow.WFAction)o).getName();
                    }
                    return null;
                }
            });
            Object[] values = new Object[this.fActions.size() + 1];
            values[0] = NONE;
            int i = 1;
            while (i <= this.fActions.size()) {
                values[i] = this.fActions.get(i - 1);
                ++i;
            }
            this.fActionsCombo.setValueSet(values);
            if (this.fAction == null) {
                this.fActionsCombo.setValue((Object)NONE);
            } else {
                this.fActionsCombo.setValue((Object)this.fAction);
            }
            this.fActionsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object o = EditEntryDialog.this.fActionsCombo.getValue();
                    if (NONE.equals(o)) {
                        EditEntryDialog.this.fAction = null;
                    } else if (o instanceof WFWorkflow.WFAction) {
                        EditEntryDialog.this.fAction = (WFWorkflow.WFAction)o;
                    }
                }
            });
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }

    private static class StateEntry {
        IApprovalType fType;
        IApprovalState fState;

        public StateEntry(IApprovalType type, IApprovalState state) {
            this.fType = type;
            this.fState = state;
        }

        public IApprovalType getType() {
            return this.fType;
        }

        public IApprovalState getState() {
            return this.fState;
        }
    }
}

