/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor.approvaltracking;

import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.workflow.WFWorkflow;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovalTracking
extends ModeledElement {
    private String fId;
    private List<ApprovalTrackingChangeListener> fListeners = new ArrayList<ApprovalTrackingChangeListener>();
    private List<TrackingEntry> fEntries = new ArrayList<TrackingEntry>();
    private WFWorkflow fWorkflow;

    ApprovalTracking(String id, WFWorkflow workflow) {
        this.fId = id;
        this.fWorkflow = workflow;
    }

    @Override
    public String getIdentifier() {
        return this.fId;
    }

    @Override
    public String getName() {
        if (this.fWorkflow != null) {
            return this.fWorkflow.getName();
        }
        return this.fId;
    }

    public WFWorkflow getWorkflow() {
        return this.fWorkflow;
    }

    public void addEntry(TrackingEntry entry) {
        this.fEntries.add(entry);
        this.notifyListeners(entry);
    }

    public void removeEntry(TrackingEntry entry) {
        this.fEntries.remove(entry);
        this.notifyListeners(entry);
    }

    public List<TrackingEntry> getEntries() {
        return this.fEntries;
    }

    public void notifyListeners(Object changed) {
        ApprovalTrackingChangeEvent event = new ApprovalTrackingChangeEvent(changed);
        for (ApprovalTrackingChangeListener listener : this.fListeners) {
            listener.approvalTrackingChanged(event);
        }
    }

    public void addListener(ApprovalTrackingChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ApprovalTrackingChangeListener listener) {
        this.fListeners.remove(listener);
    }

    public static class ApprovalTrackingChangeEvent {
        Object fChanged;

        ApprovalTrackingChangeEvent(Object changed) {
            this.fChanged = changed;
        }

        public Object getChanged() {
            return this.fChanged;
        }
    }

    public static interface ApprovalTrackingChangeListener {
        public void approvalTrackingChanged(ApprovalTrackingChangeEvent var1);
    }

    public class TrackingEntry {
        private IApprovalType fApprovalType;
        private IApprovalState fApprovalTarget;
        private WFWorkflow.WFAction fWFAction;

        TrackingEntry(IApprovalType approvalType, IApprovalState approvalTarget) {
            this.fApprovalType = approvalType;
            this.fApprovalTarget = approvalTarget;
        }

        public void setWFAction(WFWorkflow.WFAction wfAction) {
            this.fWFAction = wfAction;
            ApprovalTracking.this.notifyListeners(this);
        }

        public IApprovalType getApprovalType() {
            return this.fApprovalType;
        }

        public IApprovalState getApprovalTarget() {
            return this.fApprovalTarget;
        }

        public WFWorkflow.WFAction getWFAction() {
            return this.fWFAction;
        }
    }
}

