/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.ide.ui.AbstractDynamicActionProvider;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.AbstractWorkItemDynamicActionProvider;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemDynamicActionProvider
extends AbstractDynamicActionProvider {
    public AbstractDynamicActionProvider.DynamicAction[] computeActions(IPath actionPath, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = this.findModel();
        List<IAttribute> attributes = this.findAttributes(monitor);
        IAuditableCommon auditableCommon = (IAuditableCommon)this.getTeamRepository().getClientLibrary(IAuditableClient.class);
        LocalizationContext context = LocalizationContext.createUserContext((IAuditableCommon)auditableCommon, (IProgressMonitor)monitor);
        AbstractWorkItemDynamicActionProvider<AbstractDynamicActionProvider.DynamicAction> delegate = new AbstractWorkItemDynamicActionProvider<AbstractDynamicActionProvider.DynamicAction>(model, attributes, context){

            protected AbstractDynamicActionProvider.DynamicAction createDynamicAction(String id, String name, String description) {
                return new AbstractDynamicActionProvider.DynamicAction((AbstractDynamicActionProvider)WorkItemDynamicActionProvider.this, id, name, description);
            }
        };
        List actions = delegate.computeActions(actionPath, null);
        return actions.toArray(new AbstractDynamicActionProvider.DynamicAction[actions.size()]);
    }

    private ProcessSpecificationModel findModel() {
        IDocument specification = this.getProcessContainer().getProcessSpecification();
        if (specification == null) {
            return null;
        }
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        model.initialize(specification);
        return model;
    }

    private List<IAttribute> findAttributes(IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessArea processArea;
        IProcessContainerWorkingCopy container = this.getProcessContainer();
        if (container instanceof IProcessAreaWorkingCopy && (processArea = ((IProcessAreaWorkingCopy)container).getUnderlyingProcessArea()) != null) {
            ITeamRepository teamRepository = this.getTeamRepository();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            return workItemClient.findAttributes(processArea.getProjectArea(), monitor);
        }
        return Collections.emptyList();
    }
}

