/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.process.client.workingcopies.IProcessAttachmentsWorkingCopy;
import com.ibm.team.process.client.workingcopies.IWorkingCopyListener;
import com.ibm.team.process.client.workingcopies.WorkingCopyChangeEvent;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.ResourceLocation;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AbstractWorkItemAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IPrefixProvider;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ProcessAttachmentIconSelectionDialog
extends Dialog {
    private Label fIcon;
    private TableViewer fIconViewer;
    private ItemHandleAwareHashSet<IProcessAttachmentHandle> fFiles;
    private IPrefixProvider fPrefixProvider;
    private ResourceManager fResourceManager;
    private String fIconUrl;
    private String fTitle;
    private Label fErrorText;
    private Label fErrorIcon;
    private IDialogValidator fValidator;
    private IWorkingCopyListener fIconListener = new MinimalisticIconListener();
    private static final String NAME_LABEL = Messages.ProcessAttachmentIconSelectionDialog_NAME_LABEL;
    private static final String ICON_LABEL = Messages.ProcessAttachmentIconSelectionDialog_ICON_LABEL;
    private static int LOWER_BOUND_X = 350;
    private static int LOWER_BOUND_Y = 150;
    private static int UPPER_BOUND_X = 600;
    private static int UPPER_BOUND_Y = 600;
    private Button fClearIcon;

    protected ProcessAttachmentIconSelectionDialog(Shell parentShell, String title, String iconUrl, IPrefixProvider prefixProvider, ResourceManager resourceManager) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fPrefixProvider = prefixProvider;
        this.fResourceManager = resourceManager;
        this.fIconUrl = iconUrl;
    }

    public void setValidator(IDialogValidator validator) {
        IDialogValidator old = this.fValidator;
        this.fValidator = validator;
        if (old != null) {
            this.validate();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        int x = Math.max(initialSize.x + 20, LOWER_BOUND_X);
        x = Math.min(x + 20, UPPER_BOUND_X);
        int y = Math.max(initialSize.y, LOWER_BOUND_Y);
        y = Math.min(y, UPPER_BOUND_Y);
        return new Point(x, y);
    }

    public void validate() {
        if (this.fErrorText != null && !this.fErrorText.isDisposed()) {
            IStatus status = Status.OK_STATUS;
            if (this.fValidator != null) {
                status = this.fValidator.isValid();
            }
            if (status.getSeverity() == 4) {
                this.fErrorText.setText(status.getMessage());
                this.fErrorText.getParent().getParent().layout();
                this.fErrorIcon.setImage(this.fResourceManager.createImage(ImagePool.ERROR_ICON));
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(false);
                }
            } else if (status.getSeverity() == 2) {
                this.fErrorText.setText(status.getMessage());
                this.fErrorText.getParent().getParent().layout();
                this.fErrorIcon.setImage(this.fResourceManager.createImage(ImagePool.WARN_ICON));
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(true);
                }
            } else if (status.getSeverity() == 1) {
                this.fErrorText.setText(status.getMessage());
                this.fErrorText.getParent().getParent().layout();
                this.fErrorIcon.setImage(this.fResourceManager.createImage(ImagePool.INFO_ICON));
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(true);
                }
            } else {
                this.fErrorText.setText("");
                this.fErrorText.getParent().getParent().layout();
                this.fErrorIcon.setImage(null);
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(true);
                }
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite allContent = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 3;
        allContent.setLayout((Layout)layout);
        allContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createUpperDialogPart(allContent);
        this.createIconDialogPart(allContent);
        Composite error = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        error.setLayout((Layout)layout);
        error.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fErrorIcon = new Label(error, 0);
        GridData data = new GridData(4, 128, false, false);
        data.widthHint = 18;
        this.fErrorIcon.setLayoutData((Object)data);
        this.fErrorText = new Label(error, 64);
        this.fErrorText.setText("\n\n");
        this.fErrorText.setLayoutData((Object)new GridData(4, 4, true, false));
        ProcessAttachmentIconSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createUpperDialogPart(Composite parent) {
    }

    protected void createIconDialogPart(Composite parent) {
        Label i = new Label(parent, 0);
        i.setText(Messages.ProcessAttachmentIconSelectionDialog_ICON);
        i.setLayoutData((Object)new GridData());
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fIcon = new Label(buttons, 2048);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.widthHint = 18;
        this.fIcon.setLayoutData((Object)data);
        this.fIcon.setBackground(this.fIcon.getDisplay().getSystemColor(1));
        this.setIcon(false);
        this.fClearIcon = new Button(buttons, 0x800000);
        this.fClearIcon.setText(Messages.ProcessAttachmentIconSelectionDialog_CLEAR_ICON);
        this.fClearIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessAttachmentIconSelectionDialog.this.fIconUrl = null;
                ProcessAttachmentIconSelectionDialog.this.fIconViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                ProcessAttachmentIconSelectionDialog.this.setIcon(true);
            }
        });
        this.fClearIcon.setLayoutData((Object)new GridData());
        this.fClearIcon.setEnabled(this.fIconUrl != null);
        Button uploadIcon = new Button(buttons, 0x800000);
        uploadIcon.setText(Messages.ProcessAttachmentIconSelectionDialog_ADD_ICONS);
        uploadIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AspectEditorUtil.addProcessAttachement(ProcessAttachmentIconSelectionDialog.this.getParentShell(), ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getProcessContainer().getProcessAttachments(), ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getIconPrefix());
            }
        });
        uploadIcon.setLayoutData((Object)new GridData(131072, 4, true, false));
        Composite viewer = new Composite(parent, 0);
        viewer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        layout = new GridLayout();
        layout.marginWidth = 0;
        viewer.setLayout((Layout)layout);
        this.createIconViewer(viewer);
        this.fPrefixProvider.getProcessContainer().getProcessAttachments().addWorkingCopyListener(this.fIconListener);
    }

    protected Control createButtonBar(Composite parent) {
        Button button;
        Control c = super.createButtonBar(parent);
        if (this.fValidator != null && this.fValidator.isValid().getSeverity() == 4 && (button = this.getButton(0)) != null && !button.isDisposed()) {
            button.setEnabled(false);
        }
        return c;
    }

    private void setIcon(boolean notifyClient) {
        if (this.fIconUrl != null) {
            try {
                this.fIcon.setImage(AspectEditorUtil.getImage(this.fPrefixProvider.getProcessContainer(), this.fIconUrl, this.fResourceManager, new Runnable(){

                    public void run() {
                        if (ProcessAttachmentIconSelectionDialog.this.fIcon != null && !ProcessAttachmentIconSelectionDialog.this.fIcon.isDisposed()) {
                            ProcessAttachmentIconSelectionDialog.this.fIcon.setImage(AspectEditorUtil.getImage(ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getProcessContainer(), ProcessAttachmentIconSelectionDialog.this.fIconUrl, ProcessAttachmentIconSelectionDialog.this.fResourceManager, null));
                        }
                    }
                }));
            }
            catch (Exception exception) {}
        } else {
            this.fIcon.setImage(null);
        }
        if (this.fClearIcon != null && !this.fClearIcon.isDisposed()) {
            this.fClearIcon.setEnabled(this.fIconUrl != null);
        }
        if (notifyClient) {
            this.iconChanged();
        }
    }

    protected void iconChanged() {
    }

    public String getIconUrl() {
        return this.fIconUrl;
    }

    public boolean close() {
        if (this.fPrefixProvider != null) {
            this.fPrefixProvider.getProcessContainer().getProcessAttachments().removeWorkingCopyListener(this.fIconListener);
        }
        return super.close();
    }

    private void createIconViewer(Composite parent) {
        Table t = new Table(parent, 67584);
        GridData data = new GridData(4, 4, true, true, 4, 1);
        data.heightHint = t.getItemHeight() * 6;
        t.setLayoutData((Object)data);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(25);
        c.setResizable(true);
        c = new TableColumn(t, 0);
        c.setWidth(150);
        c.setResizable(true);
        c.setText(NAME_LABEL);
        this.fIconViewer = new TableViewer(t);
        this.fIconViewer.setColumnProperties(new String[]{ICON_LABEL, NAME_LABEL});
        this.fIconViewer.setLabelProvider((IBaseLabelProvider)new AspectEditorUtil.IconLabelProvider(this.fPrefixProvider, 1, 0, this.fResourceManager));
        this.fIconViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ProcessAttachmentIconSelectionDialog.this.fFiles.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fIconViewer.setSorter((ViewerSorter)new AspectEditorUtil.ProcessAttachmentSorter());
        this.fIconViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProcessAttachmentHandle img = (IProcessAttachmentHandle)((IStructuredSelection)ProcessAttachmentIconSelectionDialog.this.fIconViewer.getSelection()).getFirstElement();
                if (img != null) {
                    try {
                        ProcessAttachmentIconSelectionDialog.this.fIconUrl = ResourceLocation.createRelativeProcessAttachmentURI((String)ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath(img)).toString();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        ProcessAttachmentIconSelectionDialog.this.fIconUrl = null;
                    }
                } else {
                    ProcessAttachmentIconSelectionDialog.this.fIconUrl = null;
                }
                ProcessAttachmentIconSelectionDialog.this.setIcon(true);
            }
        });
        this.populateIconViewer();
        if (this.fIconUrl != null) {
            try {
                for (IProcessAttachmentHandle file : this.fFiles) {
                    if (!this.fIconUrl.equals(ResourceLocation.createRelativeProcessAttachmentURI((String)this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath(file)).toString())) continue;
                    this.fIconViewer.setSelection((ISelection)new StructuredSelection((Object)file));
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void populateIconViewer() {
        IProcessAttachmentsWorkingCopy workingCopy = this.fPrefixProvider.getProcessContainer().getProcessAttachments();
        IProcessAttachmentHandle[] handles = workingCopy.getAttachments();
        this.fFiles = new ItemHandleAwareHashSet();
        IProcessAttachmentHandle[] iProcessAttachmentHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessAttachmentHandle handle = iProcessAttachmentHandleArray[n2];
            String path = workingCopy.getPath(handle);
            if (path.startsWith(this.fPrefixProvider.getIconPrefix())) {
                this.fFiles.add((Object)handle);
            }
            ++n2;
        }
        if (!this.fIconViewer.getControl().isDisposed()) {
            this.fIconViewer.setInput(this.fFiles);
        }
    }

    public static interface IDialogValidator {
        public IStatus isValid();
    }

    private final class MinimalisticIconListener
    implements IWorkingCopyListener {
        private FoundationUIJob fPopulateJob = new FoundationUIJob(Messages.ProcessAttachmentIconSelectionDialog_REFRESH_ICONS){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                ProcessAttachmentIconSelectionDialog.this.populateIconViewer();
                return Status.OK_STATUS;
            }
        };

        private MinimalisticIconListener() {
        }

        private void scheduleJob() {
            if (!this.fPopulateJob.isSystem()) {
                this.fPopulateJob.setSystem(true);
            }
            this.fPopulateJob.schedule(500L);
        }

        public void workingCopyChanged(WorkingCopyChangeEvent event) {
            if (ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getProcessContainer().getProcessAttachments() != event.getSource()) {
                return;
            }
            String property = event.getProperty();
            if (property == null) {
                return;
            }
            if (property.startsWith("processAttachments")) {
                if ("processAttachments.change".equals(property)) {
                    this.scheduleJob();
                    return;
                }
                if ("processAttachments.update".equals(property)) {
                    IProcessItemHandle[] newValues = (IProcessItemHandle[])event.getNewValue();
                    boolean affected = false;
                    IProcessItemHandle[] iProcessItemHandleArray = newValues;
                    int n = newValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessItemHandle newIcon = iProcessItemHandleArray[n2];
                        if (ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath((IProcessAttachmentHandle)newIcon).startsWith(ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getIconPrefix())) {
                            affected = true;
                            break;
                        }
                        ++n2;
                    }
                    if (affected) {
                        this.scheduleJob();
                    }
                    return;
                }
                if ("processAttachments.add".equals(property)) {
                    IProcessItemHandle[] newValues = (IProcessItemHandle[])event.getNewValue();
                    boolean affected = false;
                    IProcessItemHandle[] iProcessItemHandleArray = newValues;
                    int n = newValues.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IProcessItemHandle newIcon = iProcessItemHandleArray[n3];
                        if (ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getProcessContainer().getProcessAttachments().getPath((IProcessAttachmentHandle)newIcon).startsWith(ProcessAttachmentIconSelectionDialog.this.fPrefixProvider.getIconPrefix()) && newIcon instanceof IProcessAttachmentHandle) {
                            affected = true;
                        }
                        ++n3;
                    }
                    if (affected) {
                        this.scheduleJob();
                    }
                    return;
                }
                if ("processAttachments.delete".equals(property)) {
                    this.scheduleJob();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModeledElementIdSelectionDialog
    extends ProcessAttachmentIconSelectionDialog {
        private Text fIdField;
        private String fId;
        private List<ModeledElement> fAllElements;
        private AbstractWorkItemAspectEditor.IAspectMessageProvider fMessageProvider;

        public ModeledElementIdSelectionDialog(Shell parentShell, String title, AbstractWorkItemAspectEditor.IAspectMessageProvider messageProvider, List<? extends ModeledElement> allElements, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fAllElements = new ArrayList<ModeledElement>(allElements);
            this.fMessageProvider = messageProvider;
            this.setValidator(new IDialogValidator(){

                public IStatus isValid() {
                    if (ModeledElementIdSelectionDialog.this.fId == null || "".equals(ModeledElementIdSelectionDialog.this.fId)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ProcessAttachmentIconSelectionDialog_EMPTY_ID);
                    }
                    if (ModeledElementIdSelectionDialog.this.fId.split("\\s").length > 1) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ProcessAttachmentIconSelectionDialog_WHITESPACES);
                    }
                    if (ModeledElementIdSelectionDialog.this.checkIdLength() && !AspectEditorUtil.isValidLength(ModeledElementIdSelectionDialog.this.fId, 250 - ModeledElementIdSelectionDialog.this.getMaxPrefixLength() - 5)) {
                        return new Status(4, "com.ibm.team.workitem.ide.ui", NLS.bind((String)Messages.ProcessAttachmentIconSelectionDialog_ID_TOO_LONG, (Object)(250 - ModeledElementIdSelectionDialog.this.getMaxPrefixLength() - 5), (Object[])new Object[0]));
                    }
                    for (ModeledElement s : ModeledElementIdSelectionDialog.this.fAllElements) {
                        if (!ModeledElementIdSelectionDialog.this.fId.equals(s.getIdentifier())) continue;
                        return new Status(4, "com.ibm.team.workitem.ide.ui", ModeledElementIdSelectionDialog.this.fMessageProvider.getSameIdMessage());
                    }
                    return Status.OK_STATUS;
                }
            });
        }

        protected boolean checkIdLength() {
            return false;
        }

        protected int getMaxPrefixLength() {
            return 0;
        }

        @Override
        protected void iconChanged() {
            this.validate();
        }

        public String getId() {
            return this.fId.trim();
        }

        @Override
        protected void createUpperDialogPart(Composite parent) {
            Composite message = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            message.setLayout((Layout)layout);
            message.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Label msg = new Label(message, 64);
            msg.setText(this.fMessageProvider.getEnterIdMessage());
            msg.setLayoutData((Object)new GridData());
            Label l = new Label(parent, 0);
            l.setText(Messages.ProcessAttachmentIconSelectionDialog_ID);
            l.setLayoutData((Object)new GridData());
            this.fIdField = new Text(parent, 2048);
            if (this.fId != null) {
                this.fIdField.setText(this.fId);
            }
            this.fIdField.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fIdField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ModeledElementIdSelectionDialog.this.fId = ModeledElementIdSelectionDialog.this.fIdField.getText().trim();
                    ModeledElementIdSelectionDialog.this.validate();
                }
            });
        }

        @Override
        protected void createIconDialogPart(Composite parent) {
        }
    }
}

