/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.aspecteditor;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.IDirtyStateTracker;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.Messages;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkItemAspectEditor
extends ProcessAspectEditor
implements IDirtyStateTracker {
    private static final String NO_ELEMENTS = Messages.AbstractWorkItemAspectEditor_NO_ELEMENTS;
    private List<ModeledElement> fElements;
    private Composite fContainer;
    private DecoratedCombo fCombo;
    private String fConfigurationDataId;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private String fHelpContextId = null;
    private Button fDuplicateButton;
    private Button fRemoveButton;

    public AbstractWorkItemAspectEditor(String dataId) {
        this.fConfigurationDataId = dataId;
    }

    public final void dispose() {
        this.doDispose();
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.init();
    }

    private void init() {
        this.fElements = new ArrayList<ModeledElement>(this.readElements(this.getAspect().getConfigurationElement()));
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.fContainer = new Composite(parent, 0);
        parent.setLayout((Layout)new FillLayout());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        Label l = toolkit.createLabel(this.fContainer, this.getMessageProvider().getChooseMessage());
        l.setLayoutData((Object)new GridData(16384, 4, false, false));
        Composite elements = toolkit.createComposite(this.fContainer);
        elements.setLayoutData((Object)new GridData(4, 4, true, false));
        int nOfCol = 1;
        if (this.canAdd()) {
            ++nOfCol;
        }
        if (this.canDuplicate()) {
            ++nOfCol;
        }
        if (this.canRemove()) {
            ++nOfCol;
        }
        layout = new GridLayout(nOfCol, false);
        layout.marginWidth = 0;
        layout.marginBottom = 5;
        elements.setLayout((Layout)layout);
        this.fCombo = new DecoratedCombo(elements, 8, 4);
        toolkit.adapt((Control)this.fCombo.getCombo(), true, false);
        this.fCombo.getLayoutControl().setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof ModeledElement) {
                    String name = ((ModeledElement)element).getName();
                    if (name == null || "".equals(name.trim())) {
                        name = ((ModeledElement)element).getIdentifier();
                    }
                    return name;
                }
                return super.getText(element);
            }
        });
        this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o = AbstractWorkItemAspectEditor.this.fCombo.getValue();
                if (o instanceof ModeledElement) {
                    AbstractWorkItemAspectEditor.this.inputChanged((ModeledElement)o);
                } else {
                    AbstractWorkItemAspectEditor.this.inputChanged(null);
                }
            }
        });
        if (this.canAdd()) {
            Button createNew = toolkit.createButton(elements, Messages.AbstractWorkItemAspectEditor_ADD, 0x800000);
            createNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModeledElement element = AbstractWorkItemAspectEditor.this.createNewElement();
                    if (element != null) {
                        AbstractWorkItemAspectEditor.this.fElements.add(element);
                        AbstractWorkItemAspectEditor.this.fCombo.setValueSet(AbstractWorkItemAspectEditor.this.fElements.toArray());
                        AbstractWorkItemAspectEditor.this.fCombo.setValue((Object)element);
                        if (AbstractWorkItemAspectEditor.this.fElements.size() == 1) {
                            AbstractWorkItemAspectEditor.this.fCombo.getCombo().setEnabled(true);
                        }
                        AbstractWorkItemAspectEditor.this.updateButtonEnablement();
                        AbstractWorkItemAspectEditor.this.fCombo.getLayoutControl().getParent().layout();
                        AbstractWorkItemAspectEditor.this.setDirty();
                    }
                }
            });
            createNew.setLayoutData((Object)new GridData(16384, 4, false, false));
        }
        if (this.canDuplicate()) {
            this.fDuplicateButton = toolkit.createButton(elements, Messages.AbstractWorkItemAspectEditor_DUPLICATE, 0x800000);
            this.fDuplicateButton.setEnabled(false);
            this.fDuplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModeledElement element = AbstractWorkItemAspectEditor.this.duplicateElement((ModeledElement)AbstractWorkItemAspectEditor.this.fCombo.getValue());
                    if (element != null) {
                        AbstractWorkItemAspectEditor.this.fElements.add(element);
                        AbstractWorkItemAspectEditor.this.fCombo.setValueSet(AbstractWorkItemAspectEditor.this.fElements.toArray());
                        AbstractWorkItemAspectEditor.this.fCombo.setValue((Object)element);
                        AbstractWorkItemAspectEditor.this.updateButtonEnablement();
                        AbstractWorkItemAspectEditor.this.fCombo.getLayoutControl().getParent().layout();
                        AbstractWorkItemAspectEditor.this.setDirty();
                    }
                }
            });
            this.fDuplicateButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        }
        if (this.canRemove()) {
            this.fRemoveButton = toolkit.createButton(elements, Messages.AbstractWorkItemAspectEditor_REMOVE, 0x800000);
            this.fRemoveButton.setEnabled(false);
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModeledElement element = (ModeledElement)AbstractWorkItemAspectEditor.this.fCombo.getValue();
                    if (AbstractWorkItemAspectEditor.this.removeElement(element)) {
                        int index = AbstractWorkItemAspectEditor.this.fElements.indexOf(element) - 1;
                        if (index < 0) {
                            index = 0;
                        }
                        AbstractWorkItemAspectEditor.this.fElements.remove(element);
                        AbstractWorkItemAspectEditor.this.fCombo.setValueSet(AbstractWorkItemAspectEditor.this.fElements.toArray());
                        if (AbstractWorkItemAspectEditor.this.fElements.size() > index) {
                            AbstractWorkItemAspectEditor.this.fCombo.setValue(AbstractWorkItemAspectEditor.this.fElements.get(index));
                        } else if (AbstractWorkItemAspectEditor.this.fElements.size() > 0) {
                            AbstractWorkItemAspectEditor.this.fCombo.setValue(AbstractWorkItemAspectEditor.this.fElements.get(0));
                        } else {
                            AbstractWorkItemAspectEditor.this.fCombo.setValue((Object)NO_ELEMENTS);
                            AbstractWorkItemAspectEditor.this.fCombo.getCombo().setEnabled(false);
                        }
                        AbstractWorkItemAspectEditor.this.updateButtonEnablement();
                        AbstractWorkItemAspectEditor.this.fCombo.getLayoutControl().getParent().layout();
                        AbstractWorkItemAspectEditor.this.setDirty();
                    }
                }
            });
            this.fRemoveButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        }
        Composite editorContent = toolkit.createComposite(this.fContainer);
        editorContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createEditorArea(editorContent, toolkit);
        this.updateCombo();
        this.updateButtonEnablement();
        if (this.fHelpContextId != null) {
            HelpContextIds.hookHelpListener((Control)parent, this.fHelpContextId);
        }
    }

    private void updateCombo() {
        this.fCombo.setValueSet(this.fElements.toArray());
        if (this.fElements == null || this.fElements.isEmpty()) {
            this.fCombo.setValue((Object)NO_ELEMENTS);
            this.fCombo.getCombo().setEnabled(false);
        } else {
            Object selected = this.fCombo.getValue();
            boolean set = false;
            if (selected instanceof ModeledElement) {
                for (ModeledElement el : this.fElements) {
                    if (!el.getIdentifier().equals(((ModeledElement)selected).getIdentifier())) continue;
                    this.fCombo.setValue((Object)el);
                    set = true;
                    break;
                }
            }
            if (!set) {
                this.fCombo.setValue((Object)this.fElements.get(0));
            }
            this.fCombo.getCombo().setEnabled(true);
        }
        this.fCombo.getLayoutControl().getParent().layout();
    }

    public void revert() {
        this.init();
        this.updateCombo();
        this.setDirty(false);
    }

    private void updateButtonEnablement() {
        Object[] valueSet;
        if (this.canDuplicate() && this.fDuplicateButton != null && !this.fDuplicateButton.isDisposed()) {
            valueSet = this.fCombo.getValueSet();
            this.fDuplicateButton.setEnabled(valueSet.length > 0 && !(valueSet[0] instanceof String));
        }
        if (this.canRemove() && this.fRemoveButton != null && !this.fRemoveButton.isDisposed()) {
            valueSet = this.fCombo.getValueSet();
            this.fRemoveButton.setEnabled(valueSet.length > 0 && !(valueSet[0] instanceof String));
        }
    }

    public IProcessContainerWorkingCopy getProcessContainerWorkingCopy() {
        return this.getAspect().getProcessContainerWorkingCopy();
    }

    protected ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    protected List<? extends ModeledElement> getAllElements() {
        return this.fElements;
    }

    @Override
    public void setDirty() {
        super.setDirty();
    }

    protected void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
    }

    protected void updateComboLabels() {
        if (this.fElements != null && !this.fCombo.getCombo().isDisposed()) {
            this.fCombo.setValueSet(this.fElements.toArray());
        }
    }

    protected boolean canDuplicate() {
        return false;
    }

    protected ModeledElement duplicateElement(ModeledElement original) {
        return null;
    }

    protected boolean canRemove() {
        return false;
    }

    protected boolean canAdd() {
        return true;
    }

    protected boolean removeElement(ModeledElement element) {
        return false;
    }

    protected abstract List<? extends ModeledElement> readElements(ModelElement var1);

    protected abstract void inputChanged(ModeledElement var1);

    protected abstract void createEditorArea(Composite var1, FormToolkit var2);

    protected abstract void doDispose();

    protected abstract ModeledElement createNewElement();

    protected abstract IAspectMessageProvider getMessageProvider();

    public final boolean saveState(IMemento memento) {
        memento.putString("id", this.fConfigurationDataId);
        String namespace = this.getAspect().getSchemaNamespaceURI();
        if (namespace != null) {
            memento.putString("xmlns", namespace);
        }
        this.commit(this.fElements, memento);
        return true;
    }

    protected abstract void commit(List<? extends ModeledElement> var1, IMemento var2);

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    public static interface IAspectMessageProvider {
        public String getChooseMessage();

        public String getSameIdMessage();

        public String getEnterIdMessage();
    }
}

