/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.actions;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.StyledEditingAction;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.actions.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.net.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ReferenceWorkItemAction
extends StyledEditingAction {
    public static final String REFERENCE_WORK_ITEM = "com.ibm.magnolia.edit.referenceworkitem";

    public ReferenceWorkItemAction() {
        this(null, null);
    }

    public ReferenceWorkItemAction(IWorkbenchPart part, ISourceViewer sourceViewer) {
        this(Messages.ReferenceWorkItemAction_INSERT_WORKITEM, Messages.ReferenceWorkItemAction_INSERT_REFERENCE_TO_WORKITEM, REFERENCE_WORK_ITEM, null, part, sourceViewer);
    }

    private ReferenceWorkItemAction(String text, String tooltip, String cmdId, ImageDescriptor image, IWorkbenchPart part, ISourceViewer sourceViewer) {
        super(text, cmdId, image, sourceViewer);
        this.setToolTipText(tooltip);
        this.setPart(part);
        this.update();
    }

    public void update() {
        this.setEnabled(this.canRun());
    }

    public void run() {
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        WorkItemEditorInput input = (WorkItemEditorInput)((IEditorPart)this.getPart()).getEditorInput();
        IWorkItemHandle handle = WorkItemSelectionDialog.getWorkItem((Shell)this.getPart().getSite().getShell(), (IProjectAreaHandle)input.getWorkingCopy().getWorkItem().getProjectArea());
        if (handle == null) {
            return;
        }
        try {
            URI uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)handle.getOrigin()), (IItemHandle)handle);
            String label = this.createLabel(handle, false);
            this.pasteReference(label, uri);
        }
        catch (TeamRepositoryException x) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.ReferenceWorkItemAction_EXCEPTION_RESOLVING_WORKITEM, x);
        }
    }

    public String createLabel(IWorkItemHandle handle, boolean isSentenceBegin) throws TeamRepositoryException {
        String typeName;
        IWorkItem workItem;
        ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IWorkItemType type = workItemClient.findWorkItemType((workItem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE, null)).getProjectArea(), workItem.getWorkItemType(), null);
        String string = typeName = type != null ? type.getDisplayName() : workItem.getWorkItemType();
        if (!isSentenceBegin) {
            typeName = typeName.toLowerCase();
        }
        return String.valueOf(typeName) + " " + workItem.getId();
    }

    private boolean canRun() {
        if (!(this.getPart() instanceof IEditorPart)) {
            return false;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return false;
        }
        if (!(sourceViewer.getDocument() instanceof IStyledDocument)) {
            return false;
        }
        if (!(sourceViewer.getSelectionProvider().getSelection() instanceof ITextSelection)) {
            return false;
        }
        if (!sourceViewer.isEditable()) {
            return false;
        }
        IEditorInput input = ((IEditorPart)this.getPart()).getEditorInput();
        return input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved();
    }

    private void pasteReference(String label, URI uri) {
        try {
            ITextSelection textSelection = (ITextSelection)this.getSourceViewer().getSelectionProvider().getSelection();
            int offset = textSelection.getOffset();
            IStyledDocument document = (IStyledDocument)this.getSourceViewer().getDocument();
            document.replaceHTML(offset, textSelection.getLength(), XMLString.createFromXMLText((String)("<a href=\"" + uri.toString() + "\">" + label + "</a>")));
            this.getSourceViewer().getSelectionProvider().setSelection((ISelection)new TextSelection(offset + label.length(), 0));
        }
        catch (BadLocationException x) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.ReferenceWorkItemAction_EXCEPTION_INSERTING_REFERENCES, x);
        }
    }
}

