/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.actions;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.internal.rest.IAttachmentRestService;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CopyAttachmentToClipboardAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (action != null) {
            action.setEnabled(this.isEnabled(selection));
        }
    }

    private boolean isEnabled(ISelection selection) {
        return selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty();
    }

    public void run(IAction action) {
        InternalUIUpdaterJob job = new InternalUIUpdaterJob(Messages.CopyAttachmentToClipboardAction_COPY_TO_CLIPBOARD){
            private List<IAttachment> fData;
            {
                this.fData = new ArrayList<IAttachment>();
            }

            public boolean needsRunInBackground() {
                IStructuredSelection selection = (IStructuredSelection)CopyAttachmentToClipboardAction.this.fSelection;
                for (IAttachmentHandle attachmentHandle : selection) {
                    ITeamRepository teamRepository = (ITeamRepository)attachmentHandle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IAttachment attachment = (IAttachment)auditableClient.findCachedAuditable((IAuditableHandle)attachmentHandle, IAttachment.DEFAULT_PROFILE);
                    if (attachment == null) {
                        return true;
                    }
                    this.fData.add(attachment);
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)CopyAttachmentToClipboardAction.this.fSelection;
                    Iterator iter = selection.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            return Status.OK_STATUS;
                        }
                        IAttachmentHandle attachmentHandle = (IAttachmentHandle)iter.next();
                        ITeamRepository teamRepository = (ITeamRepository)attachmentHandle.getOrigin();
                        IStatus status = FoundationUIUtils.validateRepository((ITeamRepository)teamRepository, (boolean)true, (IProgressMonitor)monitor);
                        if (!status.isOK()) {
                            return status;
                        }
                        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                        IAttachment attachment = (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)attachmentHandle, IAttachment.DEFAULT_PROFILE, monitor);
                        if (attachment == null) {
                            return null;
                        }
                        this.fData.add(attachment);
                    }
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", 0, Messages.CopyAttachmentToClipboardAction_EXCEPTION_RESOLVING_ATTACHMENT, (Throwable)x);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                Iterator iterator = ((IStructuredSelection)CopyAttachmentToClipboardAction.this.fSelection).iterator();
                StringBuffer buffer = new StringBuffer();
                StringBuffer htmlBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    IAttachmentHandle attachmentHandle = (IAttachmentHandle)iterator.next();
                    ITeamRepository teamRepository = (ITeamRepository)attachmentHandle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IAttachment attachment = (IAttachment)auditableClient.findCachedAuditable((IAuditableHandle)attachmentHandle, IAttachment.DEFAULT_PROFILE);
                    if (attachment == null) continue;
                    try {
                        String link = CopyAttachmentToClipboardAction.this.getLink(teamRepository, attachment);
                        buffer.append(CopyAttachmentToClipboardAction.this.getLabel(attachment, link));
                        if (iterator.hasNext()) {
                            buffer.append("\r\n");
                        }
                        htmlBuffer.append("<a itemId=\"");
                        htmlBuffer.append(attachment.getItemId().getUuidValue());
                        htmlBuffer.append("\" href=\"");
                        htmlBuffer.append(link);
                        htmlBuffer.append("\">");
                        htmlBuffer.append(CopyAttachmentToClipboardAction.this.getHTMLLabel(attachment));
                        htmlBuffer.append("</a>");
                        if (!iterator.hasNext()) continue;
                        htmlBuffer.append("<br/>");
                    }
                    catch (IllegalStateException e) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.CopyAttachmentToClipboardAction_ERROR_CREATING_URL, e);
                    }
                    catch (TeamRepositoryException e) {
                        WorkItemIDEUIPlugin.getDefault().log(Messages.CopyAttachmentToClipboardAction_ERROR_CREATING_URL, e);
                    }
                }
                Clipboard cb = new Clipboard(CopyAttachmentToClipboardAction.this.fWorkbenchPart.getSite().getShell().getDisplay());
                try {
                    cb.setContents(new Object[]{buffer.toString(), Utils.escapeForHTMLTransfer((String)htmlBuffer.toString())}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
                }
                finally {
                    cb.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        job.run();
    }

    private String getLink(ITeamRepository repository, IAttachment attachment) throws IllegalStateException, TeamRepositoryException {
        Location location = Location.namedLocation((IItem)attachment, (String)this.getRepositoryURI(repository), null, (String)IAttachmentRestService.class.getName());
        return location.toAbsoluteUri().toString();
    }

    protected String getRepositoryURI(ITeamRepository repository) {
        String publicUriRoot = repository.publicUriRoot();
        if (publicUriRoot != null) {
            return publicUriRoot;
        }
        return repository.getRepositoryURI();
    }

    protected String getLabel(IAttachment attachment, String link) {
        IDomainAdapter domainAdapter = DomainAdapterUtils.getDomainAdapter((Object)attachment);
        if (domainAdapter != null) {
            return domainAdapter.generateTitle((Object)attachment);
        }
        return XMLString.createFromXMLText((String)this.getHTMLLabel(attachment)).getPlainText();
    }

    protected String getHTMLLabel(IAttachment attachment) {
        return String.valueOf(XMLString.createFromPlainText((String)attachment.getName()).getXMLText()) + " (" + WorkItemTextUtilities.getAttachmentId((IAttachment)attachment) + ")";
    }

    private static class InternalUIUpdaterJob
    extends UIUpdaterJob {
        public InternalUIUpdaterJob(String name) {
            super(name);
        }

        public boolean needsRunInBackground() {
            return true;
        }

        public void run() {
            if (this.needsRunInBackground()) {
                this.schedule();
            } else {
                this.runInUI(null);
            }
        }
    }
}

