/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.core.internal.EMFStorageHelper;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.DefaultHyperlinkHandler;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.SharedFormColors;
import com.ibm.team.workitem.ide.ui.internal.history.CategorySelectionHistoryManager;
import com.ibm.team.workitem.ide.ui.internal.history.IntervalSelectionHistoryManager;
import com.ibm.team.workitem.ide.ui.internal.models.ModelsFactory;
import com.ibm.team.workitem.ide.ui.internal.models.WorkItemIDEUIModel;
import com.ibm.team.workitem.ide.ui.internal.models.impl.WorkItemIDEUIModelImpl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.ControlPresentationBindingRegistry;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WorkItemIDEUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.workitem.ide.ui";
    private static final String MID_SHADOW = "com.ibm.team.workitem.ide.ui.MID_SHADOW";
    private static final String DARK_SHADOW = "com.ibm.team.workitem.ide.ui.DARK_SHADOW";
    @Deprecated
    public static final String DROP_DOWN_IMAGE_KEY = "dropdown";
    @Deprecated
    public static final String UNKNOWN_IMAGE_KEY = "unknown";
    private static WorkItemIDEUIPlugin fgPlugin;
    private static final String MODEL_FILENAME = "data2.xml";
    private ResourceManager fResourceManager;
    private SharedFormColors fSharedFormColors;
    private WorkItemIDEUIModel fModel;
    private final Object fModelLock = new Object();
    private final Object fPreferenceStoreLock = new Object();
    private WorkItemEditorToolkit fWorkItemEditorToolkit;

    public WorkItemIDEUIPlugin() {
        fgPlugin = this;
    }

    public static WorkItemIDEUIPlugin getDefault() {
        return fgPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        if (this.fWorkItemEditorToolkit != null) {
            this.fWorkItemEditorToolkit.doDispose();
            this.fWorkItemEditorToolkit = null;
        }
        if (this.fSharedFormColors != null) {
            this.fSharedFormColors.dispose();
            this.fSharedFormColors = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        CategorySelectionHistoryManager.writeHistories();
        IntervalSelectionHistoryManager.writeHistories();
        Object object = this.fModelLock;
        synchronized (object) {
            try {
                EMFStorageHelper.storeModel((URI)EMFStorageHelper.getModelURI((String)PLUGIN_ID, (String)MODEL_FILENAME), (EObject)((WorkItemIDEUIModelImpl)this.getModel()));
            }
            catch (IOException e) {
                this.log(Messages.WorkItemIDEUIPlugin_COULD_NOT_STORE_HISTORY_MODEL, e);
            }
            this.fModel = null;
        }
        ControlPresentationBindingRegistry.getInstance().stop();
        super.stop(context);
        fgPlugin = null;
    }

    public ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public static ImageDescriptor getImageDescriptor(String pathRelativeToPlugin) {
        ImageDescriptor id = WorkItemIDEUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)pathRelativeToPlugin);
        JazzResources.registerPath((ImageDescriptor)id, (String)PLUGIN_ID, (String)pathRelativeToPlugin);
        return id;
    }

    public static Image getImage(ImageDescriptor imageDesc) {
        return JazzResources.getImageWithDefault((ResourceManager)WorkItemIDEUIPlugin.getDefault().getResourceManager(), (ImageDescriptor)imageDesc);
    }

    public void log(String message, Throwable exception) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, message, exception));
    }

    public void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public FormColors getSharedFormColors(Display display) {
        if (this.fSharedFormColors == null) {
            this.fSharedFormColors = new SharedFormColors();
        }
        return this.fSharedFormColors.getFormColors(display);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(FileHelper.SHOW_ATTACHMENT_WARNING_DIALOG, true);
        store.setDefault(DefaultHyperlinkHandler.SHOW_EXTERNAL_OPEN_WARNING_DIALOG, true);
        store.setDefault("com.ibm.team.workitem.ide.ui.CategorySelectionHistory.size", 8);
        store.setDefault("com.ibm.team.workitem.ide.ui.IntervalSelectionHistory.size", 8);
        store.setDefault("com.ibm.team.workitem.ide.ui.editor.autosubscribe", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPreferenceStore getPreferenceStore() {
        IPreferenceStore store;
        Object object = this.fPreferenceStoreLock;
        synchronized (object) {
            store = super.getPreferenceStore();
        }
        return store;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        registry.put("search", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/etool16/search.gif"));
        registry.put(DROP_DOWN_IMAGE_KEY, ImagePool.DROPDOWN);
        registry.put(UNKNOWN_IMAGE_KEY, ImagePool.STATE_UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemIDEUIModel getModel() {
        Object object = this.fModelLock;
        synchronized (object) {
            if (this.fModel == null) {
                this.fModel = (WorkItemIDEUIModel)EMFStorageHelper.loadModel((URI)EMFStorageHelper.getModelURI((String)PLUGIN_ID, (String)MODEL_FILENAME));
                if (this.fModel == null) {
                    this.fModel = ModelsFactory.eINSTANCE.createWorkItemIDEUIModel();
                }
            }
            return this.fModel;
        }
    }

    public FormToolkit getWorkItemEditorToolkit() {
        if (this.fWorkItemEditorToolkit == null) {
            this.fWorkItemEditorToolkit = new WorkItemEditorToolkit(WorkItemIDEUIPlugin.getDefault().getSharedFormColors(Display.getDefault()));
            this.fWorkItemEditorToolkit.markShared();
        }
        return this.fWorkItemEditorToolkit;
    }

    public Color getMidShadow() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(MID_SHADOW);
    }

    public Color getDarkShadow() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(DARK_SHADOW);
    }
}

