/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal;

import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.PropertyUtil;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ItemURI;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.Messages;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LinkLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IViewerLabelProvider,
IFontProvider {
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Font fLinkTypeFont;
    private StandardLabelProvider fStandardLabelProvider;
    private Map<IReference, Object> fElementMap = new WeakHashMap<IReference, Object>();

    public LinkLabelProvider() {
        this.fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fStandardLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] elements = event.getElements();
                if (elements != null) {
                    HashSet<Object> mappedElements = new HashSet<Object>();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        mappedElements.addAll(this.findMappedElements(element));
                        ++n2;
                    }
                    if (!mappedElements.isEmpty()) {
                        LinkLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)LinkLabelProvider.this, mappedElements.toArray()));
                    }
                } else {
                    LinkLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)LinkLabelProvider.this));
                }
            }

            private List<Object> findMappedElements(Object element) {
                ArrayList<Object> mappedElements = new ArrayList<Object>();
                if (element instanceof IEndPointDescriptor || element instanceof IReference) {
                    mappedElements.add(element);
                } else {
                    for (Map.Entry entry : LinkLabelProvider.this.fElementMap.entrySet()) {
                        IReference key;
                        if (!element.equals(entry.getValue()) || (key = (IReference)entry.getKey()) == null) continue;
                        mappedElements.add(key);
                    }
                }
                return mappedElements;
            }
        });
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IItemReference reference;
        IItemHandle handle;
        if (element instanceof IEndPointDescriptor) {
            IEndPointDescriptor referenceType = (IEndPointDescriptor)element;
            ImageDescriptor descriptor = WorkItemUI.getImageDescriptor((URL)referenceType.getIcon());
            return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
        }
        if (element instanceof IReference) {
            IReference reference2 = (IReference)element;
            Object object = this.resolve(reference2);
            if (object != null) {
                ViewerLabel label = new ViewerLabel(null, null);
                this.fStandardLabelProvider.updateLabel(label, object);
                Image image = label.getImage();
                if (image != null) {
                    return image;
                }
            } else if (reference2.isURIReference()) {
                IEndPointDescriptor referenceType = reference2.getLink().getThisEndpointDescriptor(reference2);
                ImageDescriptor descriptor = WorkItemUI.getImageDescriptor((URL)referenceType.getIcon());
                return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
            }
        }
        ImageDescriptor descriptor = null;
        if (element instanceof IReference && ((IReference)element).isItemReference() && (handle = (reference = (IItemReference)element).getReferencedItem()) instanceof IAttachmentHandle) {
            descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(reference.getComment());
        }
        if (descriptor == null) {
            if (element instanceof IReference) {
                reference = (IReference)element;
                IEndPointDescriptor referenceType = reference.getLink().getThisEndpointDescriptor((IReference)reference);
                descriptor = WorkItemUI.getImageDescriptor((URL)referenceType.getIcon());
            } else {
                descriptor = ImagePool.UNKNOWN;
            }
        }
        return JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, descriptor);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IEndPointDescriptor) {
            return ((IEndPointDescriptor)element).getDisplayName();
        }
        if (element instanceof IReference) {
            String comment;
            Object object = this.resolve((IReference)element);
            if (object != null) {
                EStructuralFeature feature;
                EObject eObject;
                ViewerLabel label = new ViewerLabel(null, null);
                this.fStandardLabelProvider.updateLabel(label, object);
                String text = label.getText();
                if (text != null) {
                    return text;
                }
                if (object instanceof EObject && "BuildResult".equals((eObject = (EObject)object).eClass().getName()) && (feature = PropertyUtil.getFeature((EObject)eObject, (String)"label")) != null) {
                    return (String)PropertyUtil.get((EObject)eObject, (String)"label");
                }
            }
            if ((comment = ((IReference)element).getComment()) != null && comment.length() > 0) {
                return comment;
            }
            if (((IReference)element).isURIReference()) {
                return ((IURIReference)element).getURI().toString();
            }
            return Messages.LinkLabelProvider_NO_LABEL_FOUND;
        }
        return element.toString();
    }

    public Font getFont(Object element) {
        Object object;
        if (element instanceof IEndPointDescriptor) {
            if (this.fLinkTypeFont == null) {
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] data = defaultFont.getFontData();
                int i = 0;
                while (i < data.length) {
                    data[i].setStyle(1);
                    ++i;
                }
                this.fLinkTypeFont = new Font((Device)Display.getCurrent(), data);
            }
            return this.fLinkTypeFont;
        }
        if (element instanceof IReference && (object = this.resolve((IReference)element)) != null) {
            ViewerLabel viewerLabel = new ViewerLabel(null, null);
            this.fStandardLabelProvider.updateLabel(viewerLabel, object);
            return viewerLabel.getFont();
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public void updateLabel(ViewerLabel label, Object element) {
        Object object;
        if (element instanceof IReference && (object = this.resolve((IReference)element)) != null) {
            this.fStandardLabelProvider.updateLabel(label, object);
        }
        if (label.getImage() == null) {
            label.setImage(this.getColumnImage(element, 0));
        }
        if (label.getText() == null || "".equals(label.getText())) {
            label.setText(this.getColumnText(element, 0));
        }
        if (label.getFont() == null) {
            label.setFont(this.getFont(element));
        }
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        if (this.fLinkTypeFont != null) {
            this.fLinkTypeFont.dispose();
            this.fLinkTypeFont = null;
        }
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        this.clearListeners();
    }

    private Object resolve(IReference reference) {
        Object target = null;
        if (reference.isItemReference()) {
            target = ((IItemReference)reference).getReferencedItem();
        } else if (reference.isURIReference()) {
            boolean named = false;
            try {
                named = Location.location((URI)((IURIReference)reference).getURI()).isNamed();
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {}
            if (!named || Display.getCurrent() == null) {
                try {
                    ILink link = reference.getLink();
                    if (link != null && link.getOrigin() instanceof ITeamRepository) {
                        ITeamRepository teamRepository = (ITeamRepository)link.getOrigin();
                        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                        target = ItemURI.resolveItemHandle((IAuditableCommon)auditableClient, (URI)((IURIReference)reference).getURI());
                    } else {
                        target = URIService.resolveItemHandle((URI)((IURIReference)reference).getURI());
                    }
                    if (target == null) {
                        target = Hyperlinks.resolve((URI)((IURIReference)reference).getURI(), null, null);
                    }
                }
                catch (TeamRepositoryException x) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.LinkLabelProvider_EXCEPTION_RETRIEVING_HANDLE_FROM_URI, x);
                }
                catch (CoreException coreException) {}
            }
        }
        if (target instanceof IAuditableHandle) {
            IAuditableClient auditableClient;
            IAuditable cached;
            IAuditableHandle handle = (IAuditableHandle)target;
            ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
            if (teamRepository == null && reference.getLink() != null) {
                teamRepository = (ITeamRepository)reference.getLink().getOrigin();
            }
            if ((cached = (auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class)).findCachedAuditable(handle, ItemProfile.createProfile((IItemType)handle.getItemType(), (Collection)Collections.EMPTY_LIST))) != null) {
                target = cached;
            }
        }
        if (target != null) {
            this.fElementMap.put(reference, target);
        }
        return target;
    }
}

