/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowDescriptor;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowManager;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowState;
import com.ibm.team.workitem.common.internal.workflow.InternalWorkflowKeys;
import com.ibm.team.workitem.common.internal.workflow.Messages;
import com.ibm.team.workitem.common.internal.workflow.WorkflowException;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultWorkflow
implements IWorkflowDescriptor,
InternalWorkflowKeys {
    private static final String CLASS = "class";
    public static final String WORKFLOW = "workflow";
    private static final String START_ACTION_ID = "startActionId";
    private String fPluginId;
    private String fId;
    private String fName;
    private String fStartActionId;
    private String fResolveActionId;
    private String fReopenActionId;
    private Map<String, State> fStates = new HashMap<String, State>();
    private ArrayList<State> fStates2 = new ArrayList();
    private Map<String, Action> fActions = new HashMap<String, Action>();
    private ArrayList<Action> fActions2 = new ArrayList();
    private Map<String, Resolution> fResolutions = new HashMap<String, Resolution>();
    private ArrayList<Resolution> fResolutions2 = new ArrayList();

    public DefaultWorkflow(InputStream inputStream) throws WorkflowException {
        this(inputStream, null);
    }

    public DefaultWorkflow(InputStream inputStream, String pluginId) throws WorkflowException {
        this.fPluginId = pluginId;
        InputStreamReader r = new InputStreamReader(inputStream);
        this.readXML(r, null);
    }

    public DefaultWorkflow(IProcessConfigurationElement element) {
        this.init(element);
    }

    public String getId() {
        return this.fId;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public Object getName() {
        return this.fName;
    }

    public IWorkflowState createWorkflowState() throws WorkflowException {
        return new WorkflowState();
    }

    public static IWorkflowState getWorkflow(IWorkflowManager workflowManager, IProjectAreaHandle projectArea, String workflowId) throws WorkflowException {
        Assert.isNotNull((Object)workflowId);
        IWorkflowDescriptor workflowDescriptor = ((WorkflowManager)workflowManager).getWorkflowDescriptor(projectArea, workflowId, false, null);
        IWorkflowState wf = null;
        if (workflowDescriptor != null) {
            wf = workflowDescriptor.createWorkflowState();
        }
        return wf;
    }

    public void getWorkflowInfo(IMemento memento) {
        memento.putString("id", this.fId);
        if (this.fName != null) {
            memento.putString("name", this.fName);
        }
        if (this.fPluginId != null) {
            memento.putString("pluginId", this.fPluginId);
        }
        if (this.fResolveActionId != null) {
            memento.putString("resolveActionId", this.fResolveActionId);
        }
        if (this.fReopenActionId != null) {
            memento.putString("reopenActionId", this.fReopenActionId);
        }
        if (this.fStartActionId != null) {
            memento.putString(START_ACTION_ID, this.fStartActionId);
        }
        for (Action a : this.fActions2) {
            a.getMemento2(memento);
        }
        for (State st : this.fStates2) {
            st.getMemento2(memento);
        }
        for (Resolution r : this.fResolutions2) {
            r.getMemento(memento);
        }
    }

    private void init(IProcessConfigurationElement element) {
        IProcessConfigurationElement[] children = element.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IProcessConfigurationElement workflow = children[i];
                if (WORKFLOW.equals(workflow.getName())) {
                    this.fName = workflow.getAttribute("name");
                    this.fStartActionId = workflow.getAttribute(START_ACTION_ID);
                    this.fResolveActionId = workflow.getAttribute("resolveActionId");
                    this.fReopenActionId = workflow.getAttribute("reopenActionId");
                    IProcessConfigurationElement[] children2 = workflow.getChildren();
                    if (children2 != null) {
                        IProcessConfigurationElement node2;
                        int j = 0;
                        while (j < children2.length) {
                            node2 = children2[j];
                            if ("resolution".equals(node2.getName())) {
                                this.getResolution(node2);
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < children2.length) {
                            node2 = children2[j];
                            if ("action".equals(node2.getName())) {
                                this.getAction(node2);
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < children2.length) {
                            String id;
                            node2 = children2[j];
                            if ("state".equals(node2.getName()) && (id = node2.getAttribute("id")) != null) {
                                State s = new State(node2);
                                this.fStates.put(id, s);
                                this.fStates2.add(s);
                            }
                            ++j;
                        }
                    }
                    return;
                }
                ++i;
            }
        }
    }

    private void readXML(Reader reader, String baseDir) throws WorkflowException {
        String errorMessage = null;
        Exception exception = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            if (baseDir != null) {
                source.setSystemId(baseDir);
            }
            Document document = parser.parse(source);
            NodeList list = document.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Element workflow;
                Node node = list.item(i);
                if (node instanceof Element && WORKFLOW.equals((workflow = (Element)node).getTagName())) {
                    Element element;
                    Node node2;
                    this.fName = workflow.getAttribute("name");
                    this.fStartActionId = workflow.getAttribute(START_ACTION_ID);
                    this.fResolveActionId = workflow.getAttribute("resolveActionId");
                    this.fReopenActionId = workflow.getAttribute("reopenActionId");
                    NodeList list2 = workflow.getChildNodes();
                    int j = 0;
                    while (j < list2.getLength()) {
                        node2 = list2.item(j);
                        if (node2 instanceof Element && "resolution".equals((element = (Element)node2).getTagName())) {
                            this.getResolution(element);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < list2.getLength()) {
                        node2 = list2.item(j);
                        if (node2 instanceof Element && "action".equals((element = (Element)node2).getTagName())) {
                            this.getAction(element);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < list2.getLength()) {
                        String id;
                        node2 = list2.item(j);
                        if (node2 instanceof Element && "state".equals((element = (Element)node2).getTagName()) && (id = element.getAttribute("id")) != null) {
                            State s = new State(element);
                            this.fStates.put(id, s);
                            this.fStates2.add(s);
                        }
                        ++j;
                    }
                    return;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            exception = e;
            errorMessage = Messages.getString("DefaultWorkflow.PARSER_ERROR");
        }
        catch (IOException e) {
            exception = e;
            errorMessage = Messages.getString("DefaultWorkflow.IO_ERROR");
        }
        catch (SAXException e) {
            exception = e;
            errorMessage = Messages.getString("DefaultWorkflow.FORMAT_ERROR");
        }
        String problemText = null;
        if (exception != null) {
            problemText = exception.getMessage();
        }
        if (problemText == null || problemText.length() == 0) {
            problemText = errorMessage != null ? errorMessage : Messages.getString("DefaultWorkflow.NO_ELEMENT_ERROR");
        }
        throw new WorkflowException(problemText, exception);
    }

    private Action getAction(IProcessConfigurationElement element) {
        String id = element.getAttribute("id");
        Action a = this.fActions.get(id);
        if (a == null) {
            a = new Action(element);
            this.fActions.put(id, a);
            this.fActions2.add(a);
        }
        return a;
    }

    private Action getAction(Element element) {
        String id = element.getAttribute("id");
        Action a = this.fActions.get(id);
        if (a == null) {
            a = new Action(element);
            this.fActions.put(id, a);
            this.fActions2.add(a);
        }
        return a;
    }

    private Resolution getResolution(IProcessConfigurationElement element) {
        String id = element.getAttribute("id");
        Resolution r = this.fResolutions.get(id);
        if (r == null) {
            r = new Resolution(element);
            this.fResolutions.put(id, r);
            this.fResolutions2.add(r);
        }
        return r;
    }

    private Resolution getResolution(Element element) {
        String id = element.getAttribute("id");
        Resolution r = this.fResolutions.get(id);
        if (r == null) {
            r = new Resolution(element);
            this.fResolutions.put(id, r);
            this.fResolutions2.add(r);
        }
        return r;
    }

    private class Action {
        String fId;
        String fName;
        String fIcon;
        String fNewState;
        String fClass;
        Map<String, Resolution> fResolutions = new HashMap<String, Resolution>();
        ArrayList<String> fResolutions2 = new ArrayList();

        Action(Element element) {
            String className;
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            String state = element.getAttribute("state");
            if (state.trim().length() > 0) {
                this.fNewState = state;
            }
            if ((className = element.getAttribute(DefaultWorkflow.CLASS)).trim().length() > 0) {
                this.fClass = className;
            }
            NodeList resolutions = element.getElementsByTagName("resolution");
            int i = 0;
            while (i < resolutions.getLength()) {
                Node node = resolutions.item(i);
                if (node instanceof Element) {
                    Element e = (Element)node;
                    Resolution r = DefaultWorkflow.this.getResolution(e);
                    String id = e.getAttribute("id");
                    if (id != null && r != null) {
                        this.fResolutions.put(id, r);
                        this.fResolutions2.add(id);
                    }
                }
                ++i;
            }
        }

        Action(IProcessConfigurationElement element) {
            IProcessConfigurationElement[] resolutions;
            String className;
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            String state = element.getAttribute("state");
            if (state.trim().length() > 0) {
                this.fNewState = state;
            }
            if ((className = element.getAttribute(DefaultWorkflow.CLASS)) != null && className.trim().length() > 0) {
                this.fClass = className;
            }
            if ((resolutions = element.getChildren()) != null) {
                int i = 0;
                while (i < resolutions.length) {
                    IProcessConfigurationElement node = resolutions[i];
                    if ("resolution".equals(node.getName())) {
                        Resolution r = DefaultWorkflow.this.getResolution(node);
                        String id = node.getAttribute("id");
                        if (id != null && r != null) {
                            this.fResolutions.put(id, r);
                            this.fResolutions2.add(id);
                        }
                    }
                    ++i;
                }
            }
        }

        void getMemento(IMemento parent) {
            IMemento action = parent.createChild("action");
            action.putString("id", this.fId);
            action.putString("name", this.fName);
            action.putString("icon", this.fIcon);
        }

        void getMemento2(IMemento parent) {
            IMemento action = parent.createChild("action");
            action.putString("id", this.fId);
            action.putString("name", this.fName);
            action.putString("icon", this.fIcon);
            action.putString("state", this.fNewState);
            String[] resolutionIds = this.getResolutionIds();
            int j = 0;
            while (j < resolutionIds.length) {
                IMemento memento = action.createChild("resolution");
                memento.putString("id", resolutionIds[j]);
                ++j;
            }
        }

        String getId() {
            return this.fId;
        }

        String getNewState() {
            return this.fNewState;
        }

        public String[] getResolutionIds() {
            return this.fResolutions2.toArray(new String[this.fResolutions2.size()]);
        }
    }

    private class Resolution {
        String fId;
        String fName;
        String fIcon;

        Resolution(Element element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
        }

        public Resolution(IProcessConfigurationElement element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
        }

        public void getMemento(IMemento parent) {
            IMemento resolution = parent.createChild("resolution");
            resolution.putString("id", this.fId);
            resolution.putString("name", this.fName);
            resolution.putString("icon", this.fIcon);
        }

        public String getId() {
            return this.fId;
        }
    }

    private class State {
        String fId;
        String fName;
        String fIcon;
        String fGroup;
        int fShowResolution;
        Map<String, Action> fActions = new HashMap<String, Action>();
        ArrayList<String> fActions2 = new ArrayList();

        State(Element element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            this.fGroup = element.getAttribute("group");
            String s = element.getAttribute("showResolution");
            if (s != null && "true".equals(s)) {
                this.fShowResolution = 1;
            }
            NodeList actions = element.getElementsByTagName("action");
            int i = 0;
            while (i < actions.getLength()) {
                Node node = actions.item(i);
                if (node instanceof Element) {
                    Element e = (Element)node;
                    Action a = DefaultWorkflow.this.getAction(e);
                    String id = e.getAttribute("id");
                    if (id != null && a != null) {
                        this.fActions.put(id, a);
                        this.fActions2.add(id);
                    }
                }
                ++i;
            }
        }

        State(IProcessConfigurationElement element) {
            IProcessConfigurationElement[] actions;
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            this.fGroup = element.getAttribute("group");
            String s = element.getAttribute("showResolution");
            if (s != null && "true".equals(s)) {
                this.fShowResolution = 1;
            }
            if ((actions = element.getChildren()) != null) {
                int i = 0;
                while (i < actions.length) {
                    IProcessConfigurationElement node = actions[i];
                    if ("action".equals(node.getName())) {
                        Action a = DefaultWorkflow.this.getAction(node);
                        String id = node.getAttribute("id");
                        if (id != null && a != null) {
                            this.fActions.put(id, a);
                            this.fActions2.add(id);
                        }
                    }
                    ++i;
                }
            }
        }

        public void getMemento(IMemento parent) {
            IMemento stat = parent.createChild("state");
            stat.putString("id", this.fId);
            stat.putString("name", this.fName);
            stat.putString("icon", this.fIcon);
            stat.putInteger("showResolution", this.fShowResolution);
        }

        public void getMemento2(IMemento parent) {
            IMemento stat = parent.createChild("state");
            stat.putString("id", this.fId);
            stat.putString("name", this.fName);
            stat.putString("icon", this.fIcon);
            if (this.fGroup != null) {
                stat.putString("group", this.fGroup);
            }
            stat.putInteger("showResolution", this.fShowResolution);
            String[] actionIds = this.getActionIds();
            int j = 0;
            while (j < actionIds.length) {
                IMemento memento = stat.createChild("action");
                memento.putString("id", actionIds[j]);
                ++j;
            }
        }

        String getId() {
            return this.fId;
        }

        String run(String actionId, WorkflowState wfs) throws WorkflowException {
            Action action = this.fActions.get(actionId);
            if (action == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.NO_ACTION_IN_STATE"), (Object)actionId, (Object[])new Object[]{this.fId}));
            }
            return action.getNewState();
        }

        public String[] getActionIds() {
            return this.fActions2.toArray(new String[this.fActions2.size()]);
        }
    }

    private class WorkflowState
    implements IWorkflowState {
        private String fStateId;

        public WorkflowState() throws WorkflowException {
            if (DefaultWorkflow.this.fStartActionId == null) {
                throw new WorkflowException(Messages.getString("DefaultWorkflow.WORKFLOW_HAS_NO_START_ACTION"));
            }
            Action action = (Action)DefaultWorkflow.this.fActions.get(DefaultWorkflow.this.fStartActionId);
            if (action == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.UNKNOWN_ACTION"), (Object)DefaultWorkflow.this.fStartActionId, (Object[])new Object[0]));
            }
            this.fStateId = action.getNewState();
        }

        public String getStateId() {
            return this.fStateId;
        }

        public void setStateId(String id) {
            this.fStateId = id;
        }

        public String getStartActionId() {
            return DefaultWorkflow.this.fStartActionId;
        }

        public void doAction(String stateId, String actionId) throws WorkflowException {
            State state;
            if (stateId != null && !stateId.equals(this.fStateId)) {
                this.fStateId = stateId;
            }
            if ((state = (State)DefaultWorkflow.this.fStates.get(this.fStateId)) == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.ILLEGAL_STATE"), (Object)this.fStateId, (Object[])new Object[0]));
            }
            if (DefaultWorkflow.this.fActions.get(actionId) == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.UNKNOWN_STATE"), (Object)actionId, (Object[])new Object[0]));
            }
            String newState = state.run(actionId, this);
            if (newState != null) {
                this.fStateId = newState;
            }
        }
    }
}

