/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import java.util.AbstractList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingItemList<E extends IItemHandle>
extends AbstractList<E> {
    private final List<E> fDelegate;
    private final Mode fMode;

    public DelegatingItemList(List<E> delegate, Mode mode) {
        Assert.isNotNull(delegate);
        this.fDelegate = delegate;
        this.fMode = mode;
    }

    public List<E> getDelegate() {
        return this.fDelegate;
    }

    @Override
    public E get(int index) {
        return (E)((IItemHandle)this.fDelegate.get(index));
    }

    @Override
    public int size() {
        return this.fDelegate.size();
    }

    @Override
    public boolean add(E o) {
        if (this.fMode == Mode.SET && this.contains(o)) {
            return false;
        }
        return this.fDelegate.add(o);
    }

    @Override
    public E remove(int index) {
        return (E)((IItemHandle)this.fDelegate.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IItemHandle) {
            boolean contained = false;
            IItemHandle itemHandle = (IItemHandle)o;
            ListIterator<E> iterator = this.fDelegate.listIterator();
            while (iterator.hasNext()) {
                if (!itemHandle.sameItemId((IItemHandle)iterator.next())) continue;
                iterator.remove();
                contained = true;
            }
            return contained;
        }
        return this.fDelegate.remove(o);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof IItemHandle) {
            IItemHandle itemHandle = (IItemHandle)o;
            ListIterator<E> iterator = this.fDelegate.listIterator();
            while (iterator.hasNext()) {
                if (!itemHandle.sameItemId((IItemHandle)iterator.next())) continue;
                return iterator.previousIndex();
            }
        }
        return this.fDelegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof IItemHandle) {
            IItemHandle itemHandle = (IItemHandle)o;
            ListIterator<E> iterator = this.fDelegate.listIterator(this.size());
            while (iterator.hasPrevious()) {
                if (!itemHandle.sameItemId((IItemHandle)iterator.previous())) continue;
                return iterator.nextIndex();
            }
        }
        return this.fDelegate.indexOf(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        LIST,
        SET;

    }
}

