/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.presentations;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.query.presentations.InternalControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.query.presentations.Messages;
import com.ibm.team.workitem.common.internal.query.presentations.QueryEditorPresentation;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.query.IQueryType;
import com.ibm.team.workitem.common.query.QueryTypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEditorPresentationManager
extends CacheHelper {
    private static final String CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.query.editor.configuration";
    private static final String ELEMENT_QUERY_TYPE = "query-type";
    private static final String ELEMENT_PRESENTATIONS = "presentations";
    private static final String ELEMENT_PRESENTATION = "presentation";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_ATTRIBUTE_ID = "attributeId";
    private static final String ATTRIBUTE_TYPE_ID = "typeId";
    private static final String ATTRIBUTE_KIND = "kind";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_VALUE = "value";
    private Map<UUID, Map<String, QueryEditorPresentation>> fCachedConfigurations = Collections.synchronizedMap(new HashMap());

    public QueryEditorPresentationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public QueryEditorPresentation getConfiguration(IProjectAreaHandle projectArea, IQueryType type, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, QueryEditorPresentation> configuration = this.fCachedConfigurations.get(projectArea.getItemId());
        return configuration != null ? configuration.get(type.getIdentifier()) : new QueryEditorPresentation(type, Collections.<InternalControlPresentationDescriptor>emptyList());
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectArea, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCachedConfigurations.remove(projectArea.getItemId());
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)projectArea, monitor);
        IProcessConfigurationData processConfiguration = process.findProcessConfiguration(CONFIGURATION_DATA_POINT, monitor);
        if (processConfiguration != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = processConfiguration.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
                if (ELEMENT_QUERY_TYPE.equals(configurationElement.getName())) {
                    this.handleQueryType(configurationElement, projectArea);
                }
                ++n2;
            }
        }
    }

    private void handleQueryType(IProcessConfigurationElement queryTypeElement, IProjectAreaHandle projectArea) {
        String typeId = queryTypeElement.getAttribute(ATTRIBUTE_ID);
        IQueryType queryType = this.getQueryType(typeId);
        if (queryType == null) {
            String error = NLS.bind((String)Messages.getString("QueryEditorPresentationManager.UNKOWN_QUERY_TYPE"), (Object)typeId, (Object[])new Object[0]);
            this.log(error);
            return;
        }
        List<InternalControlPresentationDescriptor> controlPresentations = Collections.emptyList();
        IProcessConfigurationElement[] iProcessConfigurationElementArray = queryTypeElement.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
            if (ELEMENT_PRESENTATIONS.equals(configurationElement.getName())) {
                controlPresentations = this.handlePresentations(configurationElement, projectArea, queryType);
            }
            ++n2;
        }
        QueryEditorPresentation presentation = new QueryEditorPresentation(queryType, controlPresentations);
        Map<String, QueryEditorPresentation> configuration = this.fCachedConfigurations.get(projectArea.getItemId());
        if (configuration == null) {
            configuration = new HashMap<String, QueryEditorPresentation>();
            this.fCachedConfigurations.put(projectArea.getItemId(), configuration);
        }
        configuration.put(queryType.getIdentifier(), presentation);
    }

    private List<InternalControlPresentationDescriptor> handlePresentations(IProcessConfigurationElement presentationsElement, IProjectAreaHandle projectArea, IQueryType queryType) {
        ArrayList<InternalControlPresentationDescriptor> descriptors = new ArrayList<InternalControlPresentationDescriptor>();
        IProcessConfigurationElement[] iProcessConfigurationElementArray = presentationsElement.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalControlPresentationDescriptor descriptor;
            IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
            if (ELEMENT_PRESENTATION.equals(configurationElement.getName()) && (descriptor = this.handlePresentation(configurationElement, projectArea, queryType)) != null) {
                descriptors.add(descriptor);
            }
            ++n2;
        }
        return descriptors;
    }

    private InternalControlPresentationDescriptor handlePresentation(IProcessConfigurationElement presentationElement, IProjectAreaHandle projectArea, IQueryType queryType) {
        String attributeId = presentationElement.getAttribute(ATTRIBUTE_ATTRIBUTE_ID);
        String typeId = presentationElement.getAttribute(ATTRIBUTE_TYPE_ID);
        String presentationId = presentationElement.getAttribute(ATTRIBUTE_KIND);
        String attributeIdentifier = null;
        if (attributeId != null) {
            IQueryableAttribute attribute = this.findQueryableAttribute(attributeId, projectArea, queryType);
            if (attribute == null) {
                String error = NLS.bind((String)Messages.getString("QueryEditorPresentationManager.UNKNOWN_ATTRIBUTE"), (Object)attributeId, (Object[])new Object[0]);
                this.log(error);
                return null;
            }
            attributeIdentifier = QueryableAttributePath.createPathString(attribute);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        IProcessConfigurationElement[] iProcessConfigurationElementArray = presentationElement.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement configurationElement = iProcessConfigurationElementArray[n2];
            if (ELEMENT_PROPERTY.equals(configurationElement.getName())) {
                this.handleProperty(configurationElement, properties);
            }
            ++n2;
        }
        return new InternalControlPresentationDescriptor(attributeIdentifier, typeId, presentationId, properties);
    }

    private void handleProperty(IProcessConfigurationElement propertyElement, Map<String, String> properties) {
        String key = propertyElement.getAttribute(ATTRIBUTE_KEY);
        String value = propertyElement.getAttribute(ATTRIBUTE_VALUE);
        if (key == null || value == null) {
            this.log(Messages.getString("QueryEditorPresentationManager.MISSING_KEY_VALUE"));
            return;
        }
        properties.put(key, value);
    }

    private IQueryType getQueryType(String typeId) {
        if (typeId == null) {
            return null;
        }
        return QueryTypeRegistry.getQueryType(typeId);
    }

    private IQueryableAttribute findQueryableAttribute(String attributeId, IProjectAreaHandle projectArea, IQueryType type) {
        String[] path = QueryableAttributePath.createPath(attributeId);
        if (path[0].length() == 0) {
            return null;
        }
        Identifier<IAttribute> identifier = Identifier.create(IAttribute.class, path[0]);
        String rootAttributeId = WorkItemAttributes.getAttributeId(identifier);
        try {
            IQueryableAttributeFactory factory = QueryableAttributes.getFactory(type.getQueryItemType());
            IQueryableAttribute root = factory.findAttribute(projectArea, rootAttributeId, this.getAuditableCommon(), null);
            if (path.length > 1) {
                return QueryableAttributePath.getAttribute(root, QueryableAttributePath.removeFirstSegment(path));
            }
            return root;
        }
        catch (TeamRepositoryException e) {
            String error = NLS.bind((String)Messages.getString("QueryEditorPresentationManager.ERROR_RESOLVING_ATTRIBUTE"), (Object)attributeId, (Object[])new Object[0]);
            WorkItemCommonPlugin.log(error, (Exception)((Object)e));
            return null;
        }
    }

    private void log(String message) {
        WorkItemCommonPlugin.log(message, null);
    }
}

