/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.query.QueryCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IQueryResult;
import com.ibm.team.workitem.common.query.IResolvedResult;
import com.ibm.team.workitem.common.query.IResult;
import com.ibm.team.workitem.common.query.ResultSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvingQueryResultIterator<T extends IAuditable>
implements IQueryResult<IResolvedResult<T>> {
    private final ItemProfile<T> fProfile;
    private final QueryCommon fQueryCommon;
    private final IQueryResult<IResult> fDelegate;
    private Iterator<IResolvedResult<T>> fIterator;

    ResolvingQueryResultIterator(QueryCommon queryCommon, IQueryResult<IResult> resultIterator, ItemProfile<T> profile) {
        this.fDelegate = resultIterator;
        this.fProfile = profile;
        this.fQueryCommon = queryCommon;
    }

    @Override
    public void setStartIndex(int startIndex) {
        this.fDelegate.setStartIndex(startIndex);
    }

    @Override
    public int getStartIndex() {
        return this.fDelegate.getStartIndex();
    }

    @Override
    public void setPageSize(int size) {
        this.fDelegate.setPageSize(size);
    }

    @Override
    public void setPageSizeIncrement(int increment) {
        this.fDelegate.setPageSizeIncrement(increment);
    }

    @Override
    public void setLimit(int limit) {
        this.fDelegate.setLimit(limit);
    }

    @Override
    public int getLimit() {
        return this.fDelegate.getLimit();
    }

    @Override
    public boolean hasNext(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.hasNext();
    }

    @Override
    public IResolvedResult<T> next(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.next();
    }

    @Override
    public List<IResolvedResult<T>> nextPage(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        ArrayList<IResolvedResult<T>> list = new ArrayList<IResolvedResult<T>>();
        while (this.fIterator.hasNext()) {
            list.add(this.fIterator.next());
        }
        return list;
    }

    @Override
    public ResultSize getResultSize(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fDelegate.getResultSize(monitor);
    }

    @Override
    public int getTotalSize(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fDelegate.getTotalSize(monitor);
    }

    @Override
    public UUID getToken(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fDelegate.getToken(monitor);
    }

    private void update(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fIterator == null || !this.fIterator.hasNext()) {
            List<IResult> page = this.fDelegate.nextPage(monitor);
            this.fIterator = this.createIterator(page, monitor);
        }
    }

    protected Iterator<IResolvedResult<T>> createIterator(List<IResult> page, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IAuditableHandle> handles = new ArrayList<IAuditableHandle>(page.size());
        HashMap<UUID, IResult> resultMap = new HashMap<UUID, IResult>();
        for (IResult result : page) {
            IItemHandle handle = result.getItem();
            if (!(handle instanceof IAuditableHandle)) continue;
            handles.add((IAuditableHandle)handle);
            resultMap.put(handle.getItemId(), result);
        }
        List<T> resolved = this.fQueryCommon.resolveAuditables(handles, this.fProfile, monitor);
        ArrayList<ResolvedResult<IAuditable>> resolvedResults = new ArrayList<ResolvedResult<IAuditable>>(resolved.size());
        for (IAuditable item : resolved) {
            double score = ((IResult)resultMap.get(item.getItemId())).getScore();
            resolvedResults.add(new ResolvedResult<IAuditable>(item, score));
        }
        return resolvedResults.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedResult<T>
    implements IResolvedResult<T> {
        private final T fItem;
        private final double fScore;

        public ResolvedResult(T item, double score) {
            this.fItem = item;
            this.fScore = score;
        }

        @Override
        public T getItem() {
            return this.fItem;
        }

        @Override
        public double getScore() {
            return this.fScore;
        }
    }
}

