/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProviderConfiguration {
    private static final String VALUE_PROVIDER = "valueProvider";
    private static final String VALUE_SET_PROVIDER = "valueSetProvider";
    private static final String DEFAULT_VALUE_PROVIDER = "defaultValueProvider";
    public static final String PROVIDER_ID = "providerId";
    public static List<String> PROVIDERS = Arrays.asList("valueProvider", "valueSetProvider", "defaultValueProvider");
    private final Map<String, IConfiguration> fConfigurations = new HashMap<String, IConfiguration>();

    public ProviderConfiguration(IConfiguration ... configurations) {
        IConfiguration[] iConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            this.addConfiguration(configuration);
            ++n2;
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        this.fConfigurations.put(configuration.getName(), configuration);
    }

    public IConfiguration getValueProviderConfiguration() {
        return this.fConfigurations.get(VALUE_PROVIDER);
    }

    public IConfiguration getValueSetProviderConfiguration() {
        return this.fConfigurations.get(VALUE_SET_PROVIDER);
    }

    public IConfiguration getDefaultValueProviderConfiguration() {
        return this.fConfigurations.get(DEFAULT_VALUE_PROVIDER);
    }
}

