/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDefaultCategoryProvider
implements IDefaultValueProvider<ICategory> {
    @Override
    public ICategory getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategoryHandle category;
        IConfiguration value = configuration.getChild("value");
        if (value == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultCategoryProvider.VALUE_NOT_PRESENT"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultCategoryProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        String path = value.getString("content");
        if (path == null || "".equals(path.trim())) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultCategoryProvider.VALUE_NOT_PRESENT"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultCategoryProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((category = workItemCommon.findCategoryByNamePath(attribute.getProjectArea(), Arrays.asList(path.split("/")), monitor)) == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultCategoryProvider.INVALID_PATH"), (Object)path, (Object[])new Object[]{workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultCategoryProvider.NONE_WORK_ITEM"), attribute.getDisplayName()}));
        }
        return workItemCommon.getAuditableCommon().resolveAuditable(category, ICategory.DEFAULT_PROFILE, monitor);
    }
}

