/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.IWorkItemConfiguration;
import com.ibm.team.workitem.common.internal.StateGroups;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessConfigurationManager
extends CacheHelper
implements IWorkItemConfiguration {
    private static final String PROGRESS_MODE_ASPECT_ID = "com.ibm.team.apt.configuration.workItemProgressMode";
    private static final String PROGRESS_MODE_ELEMENT_NAME = "name";
    private static final String ESTIMATE_OUTPUT_FORMAT = "estimateOutputFormat";
    private static final String HOURS_OUTPUT_FORMAT = "Hours";
    private static final String ESTIMATION_MODE = "estimationMode";
    private static final String PROGRESS_MODE_TIME_REMAINING_NAME = "TimeRemaining";
    private static final String WORK_ITEM_CONFIGURATION_ASPECT_ID = "com.ibm.team.workitem.configuration";
    private static final String ELEMENT_CONFIGURATION = "configuration";
    private static final String ATTR_CONFIGURATION_ID = "id";
    private static final String OSLC_TYPES_CFG_ID = "com.ibm.team.workitem.configuration.oslc.types";
    private static final String ATTR_OSLC_TYPE_ID = "oslcTypeId";
    private static final String ATTR_WORKITEM_TYPE_ID = "workItemTypeId";
    private Map<UUID, EstimateConfiguration> fEstimateConfiguration = new HashMap<UUID, EstimateConfiguration>();
    private Map<UUID, Map<String, String>> fOSLCTypeBindings = new HashMap<UUID, Map<String, String>>();
    private Map<UUID, StateGroups> fStateGroups = new HashMap<UUID, StateGroups>();

    public ProcessConfigurationManager(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public boolean usesTimeRemaining(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        EstimateConfiguration estimateConfiguration = this.fEstimateConfiguration.get(projectArea.getItemId());
        return estimateConfiguration != null && estimateConfiguration.useTimeRemaining();
    }

    public boolean usesHourOutputFormat(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        EstimateConfiguration estimateConfiguration = this.fEstimateConfiguration.get(projectArea.getItemId());
        return estimateConfiguration != null && estimateConfiguration.useHourOutputForma();
    }

    @Override
    public String getOSLCTypeBinding(IProjectAreaHandle projectArea, String oslcTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        Map<String, String> bindings = this.fOSLCTypeBindings.get(projectArea.getItemId());
        return bindings != null ? bindings.get(oslcTypeId) : null;
    }

    @Override
    public StateGroups getStateGroups(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        StateGroups stateGroups = this.fStateGroups.get(projectArea.getItemId());
        if (stateGroups == null) {
            stateGroups = new StateGroups();
            this.fStateGroups.put(projectArea.getItemId(), stateGroups);
        }
        return stateGroups;
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommonProcess process = auditableCommon.getProcess((IProcessAreaHandle)projectAreaHandle, monitor);
        this.fEstimateConfiguration.put(projectAreaHandle.getItemId(), this.readEstimateConfiguration(process, monitor));
        this.updateWorkItemConfiguration(process, monitor);
    }

    private void updateWorkItemConfiguration(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationData data = process.findProcessConfiguration(WORK_ITEM_CONFIGURATION_ASPECT_ID, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        if (data == null) {
            return;
        }
        IProcessConfigurationElement[] iProcessConfigurationElementArray = data.getElements();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
            if (ELEMENT_CONFIGURATION.equals(element.getName())) {
                String id = element.getAttribute(ATTR_CONFIGURATION_ID);
                UUID projectAreaItemId = process.getProjectArea().getItemId();
                if (OSLC_TYPES_CFG_ID.equals(id)) {
                    Map<String, String> bindings = this.readOSLCTypeBinding(element);
                    this.fOSLCTypeBindings.put(projectAreaItemId, bindings);
                } else if ("com.ibm.team.workitem.configuration.stateGroups".equals(id)) {
                    StateGroups stateGroups = StateGroups.readFromProcessConfiguration(element);
                    this.fStateGroups.put(projectAreaItemId, stateGroups);
                }
            }
            ++n2;
        }
    }

    private Map<String, String> readOSLCTypeBinding(IProcessConfigurationElement element) {
        HashMap<String, String> bindings = new HashMap<String, String>();
        IProcessConfigurationElement[] iProcessConfigurationElementArray = element.getChildren();
        int n = iProcessConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessConfigurationElement binding = iProcessConfigurationElementArray[n2];
            String oslcId = binding.getAttribute(ATTR_OSLC_TYPE_ID);
            String workItemId = binding.getAttribute(ATTR_WORKITEM_TYPE_ID);
            bindings.put(oslcId, workItemId);
            ++n2;
        }
        return bindings;
    }

    private EstimateConfiguration readEstimateConfiguration(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessConfigurationData data = process.findProcessConfiguration(PROGRESS_MODE_ASPECT_ID, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        String progressMode = null;
        String outputFormat = null;
        if (data != null) {
            IProcessConfigurationElement[] elements;
            IProcessConfigurationElement[] iProcessConfigurationElementArray = elements = data.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (ESTIMATION_MODE.equals(element.getName())) {
                    progressMode = element.getAttribute(PROGRESS_MODE_ELEMENT_NAME);
                } else if (ESTIMATE_OUTPUT_FORMAT.equals(element.getName())) {
                    outputFormat = element.getAttribute(PROGRESS_MODE_ELEMENT_NAME);
                }
                ++n2;
            }
        }
        return new EstimateConfiguration(progressMode, outputFormat);
    }

    private static class EstimateConfiguration {
        private String fProgressMode;
        private String fOutputFormat;

        public EstimateConfiguration(String progressMode, String outputFormat) {
            this.fProgressMode = progressMode;
            this.fOutputFormat = outputFormat;
        }

        public boolean useTimeRemaining() {
            return ProcessConfigurationManager.PROGRESS_MODE_TIME_REMAINING_NAME.equals(this.fProgressMode);
        }

        public boolean useHourOutputForma() {
            return ProcessConfigurationManager.HOURS_OUTPUT_FORMAT.equals(this.fOutputFormat);
        }
    }
}

