/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeCache
extends CacheHelper {
    private AuditableCache.ScopedItemTypeCache<IAttribute> fAttributeCache = new AuditableCache.ScopedItemTypeCache(IAttribute.ITEM_TYPE, IAttribute.PROJECT_AREA_PROPERTY);

    public AttributeCache(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public IAttribute findAttribute(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IAttribute> attributes = this.findAttributes(projectArea, monitor);
        for (IAttribute attribute : attributes) {
            if (!identifier.equals(attribute.getIdentifier())) continue;
            return attribute;
        }
        ItemQueryIterator<IAttributeHandle> iter = WorkItemQueries.attributeByIdentifier(this.getAuditableCommon(), projectArea, identifier);
        if (iter.hasNext(monitor)) {
            IAttributeHandle attributeHandle = iter.next(monitor);
            IAttribute attribute = this.getAuditableCommon().resolveAuditable(attributeHandle, IAttribute.FULL_PROFILE, monitor);
            this.fAttributeCache.cache(attribute);
            return attribute;
        }
        return null;
    }

    public List<IAttribute> findAttributes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        List<IAttribute> attributes = this.fAttributeCache.getAll((IAuditableHandle)projectArea, IAttribute.FULL_PROFILE);
        return attributes != null ? attributes : Collections.emptyList();
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemQueryIterator<IAttributeHandle> iter = WorkItemQueries.attributesByProjectArea(auditableCommon, projectAreaHandle);
        List<IAttribute> attributes = auditableCommon.resolveAuditablesPermissionAware(iter.toList(monitor), IAttribute.FULL_PROFILE, monitor);
        this.fAttributeCache.cacheAll(attributes, IAttribute.FULL_PROFILE);
    }

    AuditableCache.IItemTypeCache<IAttribute> getCache() {
        return this.fAttributeCache;
    }
}

