/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.AbstractSimilarityExpression;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class SimilarityExpression
extends AbstractSimilarityExpression {
    private static final long serialVersionUID = 1L;
    private String fSummary;
    private String fDescription;
    private IWorkItemHandle fWorkItemHandle;

    public static SimilarityExpression createSimilarityExpression(IWorkItem workItem) {
        Assert.isNotNull((Object)workItem);
        String summary = workItem.getHTMLSummary().getPlainText();
        String description = SimilarityExpression.getText(workItem);
        return new SimilarityExpression(summary, description, (IWorkItemHandle)workItem.getItemHandle());
    }

    private static String getText(IWorkItem workItem) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(workItem.getHTMLDescription().getPlainText());
        buffer.append('\n');
        IComments comments = workItem.getComments();
        IComment[] contents = comments.getContents();
        int i = 0;
        while (i < contents.length) {
            IComment comment = contents[i];
            buffer.append(comment.getHTMLContent().getPlainText());
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public SimilarityExpression(String summary, String description, IWorkItemHandle handle) {
        Assert.isNotNull((Object)summary);
        Assert.isNotNull((Object)description);
        this.fSummary = summary;
        this.fDescription = description;
        this.fWorkItemHandle = handle;
    }

    public SimilarityExpression() {
    }

    public String getSummary() {
        return this.fSummary;
    }

    public String getContent() {
        return this.fDescription;
    }

    public IWorkItemHandle getItemHandle() {
        return this.fWorkItemHandle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimilarityExpression)) {
            return false;
        }
        SimilarityExpression expr = (SimilarityExpression)obj;
        return this.fSummary.equals(expr.fSummary) && this.fDescription.equals(expr.fDescription);
    }

    public int hashCode() {
        return this.fSummary.hashCode() ^ this.fDescription.hashCode();
    }

    public void init(IPersistableElement element, ISerializationContext context) throws SerializationException {
        this.fSummary = element.getAttribute("summary");
        this.fDescription = element.getAttribute("desc");
        if (element.hasAttribute("itemId")) {
            UUID itemId = UUID.valueOf((String)element.getAttribute("itemId"));
            this.fWorkItemHandle = this.createHandle(context, itemId);
        }
    }

    public void saveState(IPersistableElement element) throws SerializationException {
        IPersistableElement similarContent = element.createChild("similarContent");
        similarContent.setAttribute("summary", this.fSummary);
        similarContent.setAttribute("desc", this.fDescription);
        if (this.fWorkItemHandle != null) {
            similarContent.setAttribute("itemId", this.fWorkItemHandle.getItemId().getUuidValue());
        }
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        visitor.visit(this, monitor);
    }
}

