/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.calm;

import com.ibm.team.workitem.common.calm.AbstractServiceDocument;
import com.ibm.team.workitem.common.calm.CALMDocument;
import com.ibm.team.workitem.common.calm.CALMLinkType;
import com.ibm.team.workitem.common.calm.PickerDescription;
import java.text.MessageFormat;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequirementsManagerServiceDocument
extends AbstractServiceDocument {
    public RequirementsManagerServiceDocument(String xmlContent) throws CALMDocument.DocumentParseException {
        super(xmlContent);
    }

    public String getLinkService() throws CALMDocument.DocumentParseException {
        String queryString = "/oslc_rm:ServiceDescriptor/oslc_rm:links/oslc_rm:LinkCreationServices/oslc_rm:linkFactory/@rdf:resource";
        return this.getText(queryString);
    }

    public PickerDescription getRequirementPicker() throws CALMDocument.DocumentParseException {
        return this.getPickerDescription(CALMLinkType.IMPLEMENTS_REQUIREMENT);
    }

    public PickerDescription getRequirementsCollectionPicker() throws CALMDocument.DocumentParseException {
        return this.getPickerDescription(CALMLinkType.IMPLEMENTS_REQUIREMENT_COLLECTION);
    }

    public PickerDescription getPickerDescription(String resourceType, String pickerId) throws CALMDocument.DocumentParseException {
        NodeList nodes;
        String selectionDialogName = resourceType.equals("oslc_rm:requirements") ? "oslc_rm:SelectionDialog" : "oslc_rm:CollectionSelectionDialog";
        String queryString = "/oslc_rm:ServiceDescriptor/" + resourceType + "/" + selectionDialogName;
        if (pickerId != null) {
            queryString = String.valueOf(queryString) + MessageFormat.format("[@calm:id=''{0}'']", pickerId);
        }
        if ((nodes = this.getNodes(queryString)).getLength() == 1) {
            Node item = nodes.item(0);
            String pickerURL = this.getText("oslc_rm:widget/@rdf:resource", item);
            String pickerTitle = this.getText("dc:title", item);
            String hintWidth = this.getText("oslc_rm:widthHint", item);
            String hintHeight = this.getText("oslc_rm:heightHint", item);
            if (pickerURL.length() > 0 && pickerTitle.length() > 0 && hintWidth.length() > 0 && hintHeight.length() > 0) {
                return new PickerDescription(pickerTitle, pickerURL, hintWidth, hintHeight, "oslc_rm");
            }
        }
        return null;
    }
}

