/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.calm;

import com.ibm.team.workitem.common.calm.AbstractServiceDocument;
import com.ibm.team.workitem.common.calm.CALMDocument;
import com.ibm.team.workitem.common.calm.CALMLinkType;
import com.ibm.team.workitem.common.calm.PickerDescription;
import java.text.MessageFormat;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QualityManagerServiceDocument
extends AbstractServiceDocument {
    public QualityManagerServiceDocument(String xmlContent) throws CALMDocument.DocumentParseException {
        super(xmlContent);
    }

    public PickerDescription getTestCasePicker() throws CALMDocument.DocumentParseException {
        return this.getPickerDescription(CALMLinkType.TESTED_BY_TEST_CASE);
    }

    public PickerDescription getPickerDescription(String resourceType, String pickerId) throws CALMDocument.DocumentParseException {
        NodeList nodes;
        String queryString = "/oslc_qm:ServiceDescriptor/" + resourceType + "/oslc_qm:selectionDialog";
        if (pickerId != null) {
            queryString = String.valueOf(queryString) + MessageFormat.format("[@calm:id=''{0}'']", pickerId);
        }
        if ((nodes = this.getNodes(queryString)).getLength() == 1) {
            Node item = nodes.item(0);
            String pickerURL = this.getText("oslc_qm:url", item);
            String pickerTitle = this.getText("dc:title", item);
            String hintWidth = this.getText("@oslc_qm:hintWidth", item);
            String hintHeight = this.getText("@oslc_qm:hintHeight", item);
            if (pickerURL.length() > 0 && pickerTitle.length() > 0 && hintWidth.length() > 0 && hintHeight.length() > 0) {
                return new PickerDescription(pickerTitle, pickerURL, hintWidth, hintHeight, "oslc_qm");
            }
        }
        return null;
    }
}

