/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.util.AuditableBatchResolver;
import com.ibm.team.workitem.client.internal.util.WorkItemEventResolver;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.SetAttributeType;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ListChangeDetails;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedWorkItem {
    private IWorkItem fWorkItem;
    private Map<String, Object> fValues;
    private Map<String, Object> fNullValues = new HashMap<String, Object>();
    private Map<UUID, IContributor> fResolvedCommenters = new HashMap<UUID, IContributor>();
    private IWorkItemListener fInternalListener = new InternalListener();
    private boolean fIsResolved;
    private final boolean fRequireCustomAttributes;

    public static List<ResolvedWorkItem> resolve(List<IWorkItem> workItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workItems.isEmpty()) {
            return Collections.emptyList();
        }
        ITeamRepository teamRepository = (ITeamRepository)workItems.get(0).getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        AuditableBatchResolver resolver = new AuditableBatchResolver(workItemClient);
        ArrayList<ResolvedWorkItem> resolvedWorkItems = new ArrayList<ResolvedWorkItem>(workItems.size());
        for (IWorkItem workItem : workItems) {
            ResolvedWorkItem resolved = new ResolvedWorkItem(workItem, false);
            if (workItem.getOrigin() == teamRepository) {
                resolved.collect(resolver, monitor);
            } else {
                resolved.resolve(monitor);
            }
            resolvedWorkItems.add(resolved);
        }
        resolver.resolve(monitor);
        for (ResolvedWorkItem resolved : resolvedWorkItems) {
            resolved.updateValues(resolver, monitor);
        }
        return resolvedWorkItems;
    }

    public ResolvedWorkItem(IWorkItem workItem) {
        this(workItem, true);
    }

    private ResolvedWorkItem(IWorkItem workItem, boolean requireCustomAttributes) {
        this.fWorkItem = workItem;
        this.fRequireCustomAttributes = requireCustomAttributes;
    }

    public IWorkItem getWorkItem() {
        return this.fWorkItem;
    }

    public Object getValue(IAttribute attribute) {
        Assert.isTrue((boolean)this.isResolved());
        return this.getValue(attribute.getIdentifier());
    }

    public Object getValue(String attributeIdentifier) {
        Assert.isTrue((boolean)this.isResolved());
        Assert.isTrue((boolean)this.fValues.containsKey(attributeIdentifier));
        return this.fValues.get(attributeIdentifier);
    }

    public Object getNullValue(IAttribute attribute) {
        return this.getNullValue(attribute.getIdentifier());
    }

    public Object getNullValue(String attributeIdentifier) {
        Assert.isTrue((boolean)this.isResolved());
        Assert.isTrue((boolean)this.fNullValues.containsKey(attributeIdentifier));
        return this.fNullValues.get(attributeIdentifier);
    }

    public boolean contains(IAttribute attribute) {
        return this.contains(attribute.getIdentifier());
    }

    public boolean contains(String attributeIdentifier) {
        Assert.isTrue((boolean)this.isResolved());
        return this.fValues.containsKey(attributeIdentifier);
    }

    public List<IAttribute> getAttributes() {
        Assert.isTrue((boolean)this.isResolved());
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        attributes.addAll(this.getBuiltInAttributes());
        attributes.addAll(this.getCustomAttributes());
        return attributes;
    }

    public IAttribute findAttribute(Identifier<IAttribute> propertyIdentifier) {
        return this.findAttribute(WorkItemAttributes.getAttributeId(propertyIdentifier));
    }

    public IAttribute findAttribute(String identifier) {
        Assert.isTrue((boolean)this.isResolved());
        for (IAttribute attribute : this.getBuiltInAttributes()) {
            if (!attribute.getIdentifier().equals(identifier)) continue;
            return attribute;
        }
        for (IAttribute attribute : this.getCustomAttributes()) {
            if (!attribute.getIdentifier().equals(identifier)) continue;
            return attribute;
        }
        return null;
    }

    public IWorkflowInfo getWorkflowInfo() {
        return (IWorkflowInfo)this.getValue(WorkItemEventResolver.WORKFLOW_INFO_PROPERTY);
    }

    public IContributor getResolvedCommenter(IContributorHandle contributorHandle) {
        return this.fResolvedCommenters.get(contributorHandle.getItemId());
    }

    private List<IAttribute> getBuiltInAttributes() {
        return (List)this.getValue(WorkItemEventResolver.BUILT_IN_ATTRIBUTES_PROPERTY);
    }

    private List<IAttribute> getCustomAttributes() {
        return (List)this.getValue(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY);
    }

    public void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isResolved()) {
            return;
        }
        ITeamRepository teamRepository = (ITeamRepository)this.fWorkItem.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        AuditableBatchResolver resolver = new AuditableBatchResolver(workItemClient);
        this.collect(resolver, monitor);
        resolver.resolve(monitor);
        this.updateValues(resolver, monitor);
    }

    private void collect(AuditableBatchResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)this.fWorkItem.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IWorkItem workItem = this.fWorkItem;
        if (!workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) || this.fRequireCustomAttributes && !workItem.isPropertySet(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY)) {
            IWorkItemWorkingCopyManager workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
            workingCopyManager.connect((IWorkItemHandle)workItem, (ItemProfile<IWorkItem>)ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY}), monitor);
            workingCopyManager.disconnect((IWorkItemHandle)workItem);
        }
        ArrayList<Object> attributes = new ArrayList<Object>();
        List<IAttribute> builtInAttributes = resolver.resolveAttributes(workItem.getProjectArea(), workItemClient.findBuiltInAttributes(workItem.getProjectArea(), monitor), monitor);
        List customAttributes = workItem.isPropertySet(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY) ? resolver.resolveAttributes(workItem.getProjectArea(), workItem.getCustomAttributes(), monitor) : Collections.emptyList();
        attributes.addAll(builtInAttributes);
        attributes.addAll(customAttributes);
        IWorkflowInfo workflowInfo = workItemClient.findWorkflowInfo(workItem, monitor);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(WorkItemEventResolver.BUILT_IN_ATTRIBUTES_PROPERTY, new ArrayList<IAttribute>(builtInAttributes));
        values.put(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY, new ArrayList(customAttributes));
        values.put(WorkItemEventResolver.WORKFLOW_INFO_PROPERTY, workflowInfo);
        for (IAttribute iAttribute : attributes) {
            if (!this.fWorkItem.isAttributeSet(iAttribute)) continue;
            Object value = this.fWorkItem.getValue(iAttribute);
            if (value instanceof List) {
                for (Object object : (List)value) {
                    this.add(resolver, iAttribute, object);
                }
                continue;
            }
            this.add(resolver, iAttribute, value);
        }
        this.fValues = values;
    }

    private void updateValues(AuditableBatchResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.isResolved()) {
            return;
        }
        ITeamRepository teamRepository = (ITeamRepository)this.fWorkItem.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        ArrayList attributes = new ArrayList();
        attributes.addAll((List)this.fValues.get(WorkItemEventResolver.BUILT_IN_ATTRIBUTES_PROPERTY));
        attributes.addAll((List)this.fValues.get(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY));
        for (IAttribute attribute : attributes) {
            if (!this.fWorkItem.isAttributeSet(attribute)) continue;
            Object value = this.fWorkItem.getValue(attribute);
            if ("comments".equals(attribute.getAttributeType())) {
                List comments = (List)value;
                for (IComment comment : comments) {
                    if (comment.getCreator() == null) continue;
                    IContributor creator = (IContributor)this.get(resolver, comment.getCreator());
                    if (creator == null) {
                        creator = (IContributor)resolver.resolveAuditable((IAuditableHandle)comment.getCreator(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    }
                    this.fResolvedCommenters.put(creator.getItemId(), creator);
                }
            } else if (value instanceof List) {
                this.fValues.put(attribute.getIdentifier(), this.get(resolver, (List)value));
            } else if (AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
                IEnumeration<? extends ILiteral> enumeration = resolver.resolveEnumeration(attribute, monitor);
                ILiteral literal = value != null ? enumeration.findEnumerationLiteral((Identifier)value) : null;
                this.fValues.put(attribute.getIdentifier(), literal != null ? literal : value);
            } else {
                this.fValues.put(attribute.getIdentifier(), this.get(resolver, value));
            }
            this.fNullValues.put(attribute.getIdentifier(), attribute.getNullValue((IAuditableCommon)auditableClient, monitor));
        }
        this.fIsResolved = true;
    }

    public boolean isResolved() {
        return this.fIsResolved;
    }

    public IWorkItemListener getWorkItemListener() {
        return this.fInternalListener;
    }

    private void add(AuditableBatchResolver resolver, IAttribute attribute, Object value) {
        if (value instanceof IAuditableHandle) {
            IAuditableHandle handle = (IAuditableHandle)value;
            ItemProfile profile = null;
            AttributeType type = AttributeTypes.getAttributeType((String)attribute.getAttributeType());
            if (type instanceof SetAttributeType) {
                profile = ((SetAttributeType)type).getDefaultProfile();
            }
            if (profile == null || !profile.getItemType().equals(handle.getItemType())) {
                profile = ItemProfile.createFullProfile((IItemType)handle.getItemType());
            }
            resolver.add(profile, handle);
        } else if (value instanceof IComment) {
            IComment comment = (IComment)value;
            resolver.add(ItemProfile.CONTRIBUTOR_DEFAULT, (IAuditableHandle)comment.getCreator());
        }
    }

    private List<Object> get(AuditableBatchResolver resolver, List<?> list) {
        ArrayList<Object> resolved = new ArrayList<Object>();
        for (Object object : list) {
            resolved.add(this.get(resolver, object));
        }
        return resolved;
    }

    private Object get(AuditableBatchResolver resolver, Object value) {
        return value instanceof IAuditableHandle ? resolver.get((IAuditableHandle)value) : value;
    }

    private class InternalListener
    implements IWorkItemListener {
        private InternalListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!ResolvedWorkItem.this.isResolved() || !event.affects((IWorkItemHandle)ResolvedWorkItem.this.fWorkItem)) {
                return;
            }
            String[] stringArray = event.getChangedAttributes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                ChangeDetails changeDetails = event.getAttributeChangeDetails(identifier, ChangeDetails.class);
                if (changeDetails != null) {
                    ResolvedWorkItem.this.fValues.put(identifier, changeDetails.getNewValue());
                } else {
                    ListChangeDetails listDetails = event.getAttributeChangeDetails(identifier, ListChangeDetails.class);
                    if (listDetails != null) {
                        ArrayList list;
                        Object value = null;
                        if (ResolvedWorkItem.this.contains(identifier)) {
                            value = ResolvedWorkItem.this.getValue(identifier);
                        }
                        if (!(value instanceof List)) {
                            list = new ArrayList();
                            ResolvedWorkItem.this.fValues.put(identifier, list);
                        } else {
                            list = (ArrayList)value;
                        }
                        for (Object element : listDetails.getRemoved()) {
                            list.remove(element);
                        }
                        for (Object element : listDetails.getAdded()) {
                            list.add(element);
                        }
                    }
                }
                ++n2;
            }
            ListChangeDetails customAttributes = event.getAttributeChangeDetails(IWorkItem.CUSTOM_ATTRIBUTES_PROPERTY, ListChangeDetails.class);
            if (customAttributes != null) {
                HashSet<String> removed = new HashSet<String>();
                for (Object element : customAttributes.getRemoved()) {
                    removed.add(((IAttribute)element).getIdentifier());
                }
                for (Object element : customAttributes.getAdded()) {
                    String identifier = ((IAttribute)element).getIdentifier();
                    removed.remove(identifier);
                    if (!ResolvedWorkItem.this.fValues.containsKey(identifier)) {
                        ResolvedWorkItem.this.fValues.put(identifier, null);
                    }
                    if (ResolvedWorkItem.this.fNullValues.containsKey(identifier)) continue;
                    ResolvedWorkItem.this.fNullValues.put(identifier, null);
                }
                for (String identifier : removed) {
                    ResolvedWorkItem.this.fValues.remove(identifier);
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

