/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemPropertyTester
extends PropertyTester {
    private static final String WORK_ITEM_TYPE_CATEGORY_PROPERTY = "workItemTypeCategory";
    private static final String WORK_ITEM_PROPERTY_PROPERTY = "workItemProperty";
    private static final String WORK_ITEM_HAS_PROPERTY = "workItemHasProperty";
    private static final String WORK_ITEM_ATTRIBUTE_PROPERTY = "workItemAttribute";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ((WORK_ITEM_PROPERTY_PROPERTY.equals(property) || WORK_ITEM_ATTRIBUTE_PROPERTY.equals(property)) && args.length > 0 && args[0] instanceof String) {
            try {
                return this.evaluateAttribute(expectedValue, (WorkItemWorkingCopy)receiver, (String)args[0], null);
            }
            catch (TeamRepositoryException x) {
                throw new RuntimeException(x);
            }
        }
        if (WORK_ITEM_HAS_PROPERTY.equals(property) && expectedValue instanceof Boolean) {
            try {
                return this.hasAttribute((WorkItemWorkingCopy)receiver, (String)args[0], (Boolean)expectedValue);
            }
            catch (TeamRepositoryException x) {
                throw new RuntimeException(x);
            }
        }
        if (WORK_ITEM_TYPE_CATEGORY_PROPERTY.equals(property) && expectedValue instanceof String) {
            try {
                return this.hasTypeCategory((WorkItemWorkingCopy)receiver, (String)expectedValue);
            }
            catch (TeamRepositoryException x) {
                throw new RuntimeException(x);
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean evaluateAttribute(Object expectedValue, WorkItemWorkingCopy workingCopy, String attributeName, IProgressMonitor monitor) throws TeamRepositoryException {
        if (attributeName != null) {
            IWorkItemClient workItemClient = (IWorkItemClient)workingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            Object value = workingCopy.getWorkItem().getValue(workItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), attributeName, monitor));
            return this.equals(expectedValue, value);
        }
        return false;
    }

    private boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    private boolean hasTypeCategory(WorkItemWorkingCopy workingCopy, String category) throws TeamRepositoryException {
        IWorkItem workItem;
        IWorkItemClient workItemClient = (IWorkItemClient)workingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        IWorkItemType workItemType = workItemClient.findWorkItemType((workItem = workingCopy.getWorkItem()).getProjectArea(), workItem.getWorkItemType(), null);
        if (workItemType == null) {
            return false;
        }
        return category.equals(workItemType.getCategory());
    }

    private boolean hasAttribute(WorkItemWorkingCopy receiver, String attributeIdentifier, Boolean expectedValue) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)receiver.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        IAttribute resolveAttribute = workItemClient.findAttribute(receiver.getWorkItem().getProjectArea(), attributeIdentifier, null);
        if (resolveAttribute != null) {
            return receiver.getWorkItem().hasAttribute(resolveAttribute) == expectedValue.booleanValue();
        }
        return false;
    }
}

