/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.IQueryListener;
import com.ibm.team.workitem.client.QueryChangeEvent;
import com.ibm.team.workitem.client.QueryExecutionStateChangeEvent;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.client.internal.Messages;
import com.ibm.team.workitem.client.internal.query.QueryDescriptorWorkingCopyManager;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopyManager;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IQueryRepositoryService;
import com.ibm.team.workitem.common.internal.query.IExportDescriptor;
import com.ibm.team.workitem.common.internal.query.QueryCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryClient
extends QueryCommon
implements IQueryClient {
    private final IClientLibraryContext fContext;
    private IQueryDescriptorWorkingCopyManager fWorkingCopyManager;
    private QueryEventSource fEventSource = new QueryEventSource();
    private IAuditableClient fAuditableClient;

    public QueryClient(IClientLibraryContext context) {
        super((ICommonServiceContext)new ClientServiceContext(context));
        this.fContext = context;
        this.fContext.teamRepository().itemManager().addItemChangeListener(IQueryDescriptor.ITEM_TYPE, (ISharedItemChangeListener)this.fEventSource);
    }

    public IQueryDescriptor save(IQueryDescriptor descriptorWorkingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryDescriptor saved = super.save(descriptorWorkingCopy, monitor);
        if (descriptorWorkingCopy.isNewItem()) {
            this.fEventSource.queueEvent(new QueryChangeEvent((IEventSource)this.fEventSource, "com.ibm.team.workitem.query.event.QueryCreated", saved));
        }
        return (IQueryDescriptor)this.fContext.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(saved)).get(0);
    }

    public IOperationReport delete(IQueryDescriptorHandle queryDescriptorHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor = this.getMonitor(monitor);
            monitor.beginTask(Messages.QueryClient_DELETE_QUERY, 10);
            IOperationReport report = super.delete(queryDescriptorHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.fContext.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(queryDescriptorHandle));
            IOperationReport iOperationReport = report;
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    public List<IExportDescriptor> fetchExportDescriptors(IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List<IExportDescriptor>>(){

            public List<IExportDescriptor> run(IProgressMonitor progress) throws TeamRepositoryException {
                IQueryRepositoryService service = QueryClient.this.getService(IQueryRepositoryService.class);
                return Arrays.asList(service.fetchExportDescriptors());
            }
        }, monitor);
    }

    public IAuditableCommon getAuditableCommon() {
        if (this.fAuditableClient == null) {
            this.fAuditableClient = (IAuditableClient)this.fContext.teamRepository().getClientLibrary(IAuditableClient.class);
        }
        return this.fAuditableClient;
    }

    protected IOperationReport executeProcessRunnable(ProcessRunnable runnable, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessClientService processClient = (IProcessClientService)this.fContext.teamRepository().getClientLibrary(IProcessClientService.class);
        return processClient.execute(runnable, name, monitor);
    }

    protected <T> T getService(Class<T> serviceInterface) {
        return (T)this.fContext.getServiceInterface(serviceInterface);
    }

    public <T extends IAuditable> List<T> resolveAuditables(List<? extends IAuditableHandle> handles, ItemProfile<T> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        List resolved = super.resolveAuditables(handles, profile, monitor);
        List<IAuditableHandle> stale = this.getHandlesToRefresh(handles, resolved);
        ((IAuditableClient)this.getAuditableCommon()).fetchCurrentAuditables(stale, profile, monitor);
        return resolved;
    }

    protected void notifyExecutionDone(Object executable, int totalCount) {
        this.fEventSource.queueEvent(new QueryExecutionStateChangeEvent((IEventSource)this.fEventSource, "com.ibm.team.workitem.query.event.ExecutionDone", executable, totalCount));
    }

    private List<IAuditableHandle> getHandlesToRefresh(List<? extends IAuditableHandle> handles, List<? extends IAuditable> resolved) {
        ArrayList<IAuditableHandle> toRefresh = new ArrayList<IAuditableHandle>(handles.size());
        HashMap<UUID, IAuditable> map = new HashMap<UUID, IAuditable>(resolved.size());
        for (IAuditable iAuditable : resolved) {
            map.put(iAuditable.getItemId(), iAuditable);
        }
        for (IAuditableHandle iAuditableHandle : handles) {
            IAuditable resolvedAuditable = (IAuditable)map.get(iAuditableHandle.getItemId());
            if (resolvedAuditable == null || iAuditableHandle.getStateId() == null || resolvedAuditable.getStateId() == null || iAuditableHandle.getStateId().equals((Object)resolvedAuditable.getStateId())) continue;
            toRefresh.add(iAuditableHandle);
        }
        return toRefresh;
    }

    @Override
    public void addQueryListener(Object category, IQueryListener listener) {
        this.fEventSource.addGenericListener(category, listener);
    }

    @Override
    public void removeQueryListener(Object category, IQueryListener listener) {
        this.fEventSource.removeGenericListener(category, listener);
    }

    @Override
    public IQueryDescriptorWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            this.fWorkingCopyManager = new QueryDescriptorWorkingCopyManager(this.fContext.teamRepository());
        }
        return this.fWorkingCopyManager;
    }

    private IProgressMonitor getMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    private static class QueryEventSource
    extends EventSource
    implements ISharedItemChangeListener {
        private QueryEventSource() {
        }

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                if (event.getBeforeState() == null) {
                    this.queueEvent(new QueryChangeEvent((IEventSource)this, "com.ibm.team.workitem.query.event.QueryAdded", (IQueryDescriptor)event.getSharedItem()));
                    continue;
                }
                if (event.getAfterState() == null) {
                    this.queueEvent(new QueryChangeEvent((IEventSource)this, "com.ibm.team.workitem.query.event.QueryDeleted", (IQueryDescriptor)event.getSharedItem()));
                    continue;
                }
                this.queueEvent(new QueryChangeEvent((IEventSource)this, "com.ibm.team.workitem.query.event.QueryChanged", (IQueryDescriptor)event.getAfterState(), (IQueryDescriptor)event.getBeforeState()));
            }
        }
    }
}

