/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.internal.repository.rcp.tar.TarEntry;
import com.ibm.team.internal.repository.rcp.tar.TarOutputStream;
import com.ibm.team.scm.client.importz.IChangeSetFileReader;
import com.ibm.team.scm.client.importz.IChangeSetFileWriter;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.ChangeSetBuffer;
import com.ibm.team.scm.client.importz.internal.DerivedChangeSetComparator;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.internal.utils.TimerUtil;
import com.ibm.team.scm.client.importz.spi.DerivedImportChangeSet;
import com.ibm.team.scm.client.importz.spi.LogCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LogCacheMerger {
    public static final String LOG_FILENAME = "LOG.txt.gz";
    private final DerivedChangeSetComparator comparator;

    public LogCacheMerger(DerivedChangeSetComparator comparator) {
        this.comparator = comparator;
    }

    public void mergeLogFiles(LogCache cache, IMigrationFactory factory, IProgressMonitor monitor) throws IOException {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        if (monitor == null) {
            throw new IllegalArgumentException();
        }
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        TimerUtil.startTimer();
        cache.writeCurrentEntries();
        List<File> files = cache.getStoredFiles();
        if (files.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.LogCacheMerger_0, (int)(files.size() - 1));
        while (files.size() > 1) {
            File f1 = files.remove(0);
            File f2 = files.remove(0);
            File result = this.merge(f1, f2, factory, (IProgressMonitor)progress.newChild(1));
            DebugUtils.deleteTempFile(f1);
            DebugUtils.deleteTempFile(f2);
            files.add(result);
        }
        File merged = files.get(0);
        File result = this.cleanUpMerge(merged, factory);
        if (result != merged) {
            files.add(result);
            DebugUtils.deleteTempFile(merged);
            files.remove(0);
        }
        TimerUtil.log("Merge Sort took: " + TimerUtil.logTimer());
        TarOutputStream tar_out = cache.getTarOutputStream();
        this.addLogToArchive(result, tar_out);
        DebugUtils.deleteTempFile(result);
        monitor.done();
    }

    protected void addLogToArchive(File result, TarOutputStream tar_out) throws IOException, FileNotFoundException {
        this.addIndexFileToArchive(result, tar_out);
    }

    private void addIndexFileToArchive(File result, TarOutputStream tar_out) throws IOException, FileNotFoundException {
        tar_out.putNextEntry(new TarEntry(LOG_FILENAME, 420L, 0L, 0L, 0L, 0L, 48, "", "", "", 0L, 0L, 0L, 0L), (InputStream)new FileInputStream(result), TarOutputStream.gzipFilter);
    }

    protected File merge(File f1, File f2, IMigrationFactory factory, IProgressMonitor monitor) throws IOException {
        File result = DebugUtils.createTempFile("result");
        boolean success = false;
        IChangeSetFileReader r1 = null;
        IChangeSetFileReader r2 = null;
        try {
            r1 = factory.createChangeSetFileReader(f1);
            r2 = factory.createChangeSetFileReader(f2);
            monitor.beginTask(SCMImportMessages.LogCacheMerger_6, 200);
            IChangeSetFileWriter resultWriter = factory.createChangeSetFileWriter(r1);
            resultWriter.startWrite(result);
            this.merge(r1, r2, resultWriter);
            resultWriter.closeWrite();
            success = true;
        }
        finally {
            if (!success) {
                DebugUtils.deleteTempFile(result);
            }
            if (r1 != null) {
                r1.close();
            }
            if (r2 != null) {
                r2.close();
            }
        }
        monitor.done();
        return result;
    }

    protected void merge(IChangeSetFileReader reader1, IChangeSetFileReader reader2, IChangeSetFileWriter resultWriter) throws IOException {
        ChangeSetBuffer r1Buffer = new ChangeSetBuffer(reader1);
        ChangeSetBuffer r2Buffer = new ChangeSetBuffer(reader2);
        this.merge(r1Buffer, r2Buffer, resultWriter);
    }

    private void merge(ChangeSetBuffer r1Buffer, ChangeSetBuffer r2Buffer, IChangeSetFileWriter resultWriter) throws IOException {
        while (true) {
            DerivedImportChangeSet cs;
            r1Buffer.primeBuffer();
            r2Buffer.primeBuffer();
            if (r1Buffer.isEmpty() && r2Buffer.isEmpty()) break;
            if (!r1Buffer.isEmpty()) {
                cs = r1Buffer.getFirst();
                this.walkBuffers(cs, r1Buffer, r2Buffer);
            }
            if (!r2Buffer.isEmpty()) {
                cs = r2Buffer.getFirst();
                this.walkBuffers(cs, r1Buffer, r2Buffer);
            }
            if (r1Buffer.isEmpty()) {
                cs = r2Buffer.removeFirst();
                this.write(resultWriter, cs);
                continue;
            }
            if (r2Buffer.isEmpty()) {
                cs = r1Buffer.removeFirst();
                this.write(resultWriter, cs);
                continue;
            }
            DerivedImportChangeSet cs1 = r1Buffer.getFirst();
            DerivedImportChangeSet cs2 = r2Buffer.getFirst();
            if (this.getChangeSetComparator().compare(cs1, cs2) < 0) {
                r1Buffer.removeFirst();
                this.write(resultWriter, cs1);
                continue;
            }
            r2Buffer.removeFirst();
            this.write(resultWriter, cs2);
        }
    }

    protected final DerivedChangeSetComparator getChangeSetComparator() {
        return this.comparator;
    }

    private void walkBuffers(DerivedImportChangeSet cs, ChangeSetBuffer buffer1, ChangeSetBuffer buffer2) throws IOException {
        buffer2.fillBuffer(cs);
        buffer1.resetOffset();
        buffer2.resetOffset();
        boolean modified1 = true;
        boolean modified2 = true;
        do {
            boolean walkBuffer1 = modified2;
            boolean walkBuffer2 = modified1;
            modified1 = false;
            modified2 = false;
            if (walkBuffer1) {
                modified1 = buffer1.walkBuffer(cs);
            }
            if (!walkBuffer2) continue;
            modified2 = buffer2.walkBuffer(cs);
        } while (modified1 || modified2);
    }

    private void write(IChangeSetFileWriter resultWriter, DerivedImportChangeSet changeSet) throws IOException {
        if (!changeSet.isEmpty()) {
            resultWriter.writeElement(changeSet);
        }
    }

    protected File cleanUpMerge(File result, IMigrationFactory factory) throws IOException {
        return result;
    }
}

