/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.internal.repository.rcp.tar.TarFile;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ImportData
implements IImportData {
    private static final Object NOT_FOUND = new Object();
    private Map<String, Object> contributors;
    private HashMap<String, String> authorToContributorMap = new HashMap();
    private File archiveFile;
    private TarFile tar;
    private String postImportBaselineName;
    private String encoding;
    private boolean importOverExisting;

    public IContributorHandle getContributor(ITeamRepository teamRepository, String authorId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.contributors == null) {
            return null;
        }
        Object object = this.contributors.get(authorId);
        if (object instanceof IContributorHandle) {
            return (IContributorHandle)object;
        }
        if (object == NOT_FOUND) {
            return null;
        }
        String contributorId = this.getContributorId(authorId);
        if (contributorId != null) {
            IContributorManager manager = teamRepository.contributorManager();
            try {
                IContributor handle = manager.fetchContributorByUserId(contributorId, monitor);
                this.contributors.put(authorId, handle);
                return handle;
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        this.contributors.put(authorId, NOT_FOUND);
        return null;
    }

    protected String getContributorId(String authorId) {
        if (this.authorToContributorMap.containsKey(authorId)) {
            return this.authorToContributorMap.get(authorId);
        }
        return authorId;
    }

    public void setContributorMappingEnablement(boolean enable) {
        if (enable && this.contributors == null) {
            this.contributors = new HashMap<String, Object>();
        } else if (!enable && this.contributors != null) {
            this.contributors = null;
        }
    }

    public void mapAuthorToContributor(String authorId, String contributorId) {
        this.authorToContributorMap.put(authorId, contributorId);
    }

    public void addAuthorMapping(String authorId, String contributorId, IContributor contributor) {
        this.setContributorMappingEnablement(true);
        if (contributor != null) {
            this.authorToContributorMap.put(authorId, contributorId);
            this.contributors.put(authorId, contributor);
        }
    }

    public boolean openArchive(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.tar != null) {
            return false;
        }
        if (monitor != null) {
            monitor.subTask(NLS.bind((String)SCMImportMessages.ImportData_0, (Object)this.archiveFile.getAbsolutePath()));
        }
        try {
            this.tar = new TarFile(this.archiveFile);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)SCMImportMessages.ImportData_1, (Object)this.archiveFile.getAbsolutePath()), (Throwable)e);
        }
        return true;
    }

    protected final boolean internalOpenArchive(IProgressMonitor monitor) throws IOException {
        if (this.tar != null) {
            return false;
        }
        if (monitor != null) {
            monitor.subTask(NLS.bind((String)SCMImportMessages.ImportData_2, (Object)this.archiveFile.getAbsolutePath()));
        }
        this.tar = new TarFile(this.archiveFile);
        return true;
    }

    public void closeArchive() {
        if (this.tar != null) {
            try {
                this.tar.close();
            }
            catch (IOException iOException) {}
            this.tar = null;
        }
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    public void setArchiveFile(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public InputStream getArchiveInputStream(String archivePath) throws IOException {
        if (this.tar == null) {
            throw new IOException(NLS.bind((String)SCMImportMessages.ImportData_3, (Object)this.archiveFile.getAbsolutePath()));
        }
        InputStream stream = this.tar.getInputStream(archivePath);
        if (stream == null) {
            throw new IOException(NLS.bind((String)SCMImportMessages.ImportData_4, (Object)archivePath));
        }
        try {
            return new GZIPInputStream(stream, 8192);
        }
        catch (IOException e) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        catch (RuntimeException e) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
    }

    public boolean hasArchivedContentFor(String name) throws IOException {
        if (this.tar == null) {
            return false;
        }
        return this.tar.getEntry(name) != null;
    }

    public TarFile getTarFile() {
        return this.tar;
    }

    public int getArchiveSize() {
        if (this.tar != null) {
            return this.tar.size();
        }
        return 0;
    }

    public String getPostImportBaselineName() {
        return this.postImportBaselineName;
    }

    public void setPostImportBaselineName(String postImportBaselineName) {
        this.postImportBaselineName = postImportBaselineName;
    }

    public String getWorkspaceEncoding() {
        return this.encoding;
    }

    public void setWorkspaceEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isImportOverExisting() {
        return this.importOverExisting;
    }

    public void setImportOverExisting(boolean importOverExisting) {
        this.importOverExisting = importOverExisting;
    }
}

