/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.scm.client.importz.IFileProperties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;

public class FileProperties
implements IFileProperties {
    private static final String NULL_ENCODING = "null";
    private final FileLineDelimiter lineDelimiter;
    private final String contentType;
    private final boolean executable;
    private final String encoding;

    public FileProperties(FileLineDelimiter lineDelimiter, String contentType, String encoding, boolean executable) {
        Assert.isNotNull((Object)lineDelimiter);
        Assert.isNotNull((Object)contentType);
        this.lineDelimiter = lineDelimiter;
        this.contentType = contentType;
        this.encoding = encoding;
        this.executable = executable;
    }

    public FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.contentType);
        if (this.encoding == null) {
            dataOutputStream.writeUTF(NULL_ENCODING);
        } else {
            dataOutputStream.writeUTF(this.encoding);
        }
        dataOutputStream.writeInt(this.getValue(this.lineDelimiter));
        dataOutputStream.writeBoolean(this.executable);
    }

    private int getValue(FileLineDelimiter lineDelimiter) {
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
            return 1;
        }
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
            return 2;
        }
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
            return 3;
        }
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
            return 4;
        }
        return 0;
    }

    private static FileLineDelimiter getLineDelimiter(int value) {
        switch (value) {
            case 1: {
                return FileLineDelimiter.LINE_DELIMITER_LF;
            }
            case 2: {
                return FileLineDelimiter.LINE_DELIMITER_CR;
            }
            case 3: {
                return FileLineDelimiter.LINE_DELIMITER_CRLF;
            }
            case 4: {
                return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
            }
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public static FileProperties loadFrom(DataInputStream dataInputStream) throws IOException {
        String contentType = dataInputStream.readUTF();
        String encoding = dataInputStream.readUTF();
        int ldi = dataInputStream.readInt();
        boolean executable = dataInputStream.readBoolean();
        return new FileProperties(FileProperties.getLineDelimiter(ldi), contentType, encoding.equals(NULL_ENCODING) ? null : encoding, executable);
    }

    public boolean isText() {
        return this.getContentType().startsWith("text");
    }
}

