/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.scm.client.importz.IChangeSetFileReader;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.spi.ChangeSetFileWriter;
import com.ibm.team.scm.client.importz.spi.FileProperties;
import com.ibm.team.scm.client.importz.spi.IgnoreFileChange;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import com.ibm.team.scm.client.importz.spi.ImportChangeSet;
import com.ibm.team.scm.client.importz.spi.ImportData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ChangeSetFileReader
implements IChangeSetFileReader {
    private BufferedReader reader;
    private boolean directoriesSignificant;

    public static IChangeSetFileReader createLogFileReader(IImportData importData) throws IOException {
        ImportData id = (ImportData)importData;
        ChangeSetFileReader reader = new ChangeSetFileReader();
        String logFile = "changes.txt.gz";
        InputStream in = id.getArchiveInputStream(logFile);
        try {
            if (in == null) {
                throw new IOException(NLS.bind((String)SCMImportMessages.ChangeSetFileReader_0, (Object)logFile));
            }
            reader.startRead(new InputStreamReader(in));
            return reader;
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }

    public boolean getDirectoriesSignificant() {
        return this.directoriesSignificant;
    }

    public IImportChangeSet next(IProgressMonitor monitor) throws IOException {
        return this.readNext();
    }

    protected IImportChangeSet readNext() throws IOException {
        BufferedReader reader = this.getReader();
        String nextLine = this.nextLine(reader);
        while (nextLine != null && nextLine.trim().length() == 0) {
            nextLine = this.nextLine(reader);
        }
        if (nextLine == null) {
            return null;
        }
        ImportChangeSet currentChangeSet = this.readChangeSetProperties(nextLine, reader);
        nextLine = this.nextLine(reader);
        String countString = this.getValue("Change-count: ", nextLine);
        int count = Integer.parseInt(countString);
        while (count-- > 0) {
            String afterPath;
            String beforePath;
            FileLineDelimiter lineDelimiter;
            String ignorePattern;
            nextLine = this.nextLine(reader);
            String path = this.getValue("Path: ", nextLine);
            String kind = this.getValue("Kind: ", reader.readLine());
            int status = this.parseKind(kind);
            nextLine = reader.readLine();
            String fromPath = this.getValue("From-path: ", nextLine);
            if (fromPath != null) {
                nextLine = reader.readLine();
            }
            boolean isIgnoreFileChange = false;
            String archivePath = this.getValue("Archive-path: ", nextLine);
            if (archivePath != null) {
                nextLine = reader.readLine();
            }
            if ((archivePath = this.getValue("Ignore-pattern-file: ", nextLine)) != null) {
                isIgnoreFileChange = true;
                nextLine = reader.readLine();
            }
            if ((ignorePattern = this.getValue("Ignore-pattern: ", nextLine)) != null) {
                isIgnoreFileChange = true;
                nextLine = reader.readLine();
            }
            boolean hasFileProperty = false;
            String eol = this.getValue("Line-delimiter: ", nextLine);
            if (eol == null) {
                lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
            } else {
                hasFileProperty = true;
                nextLine = reader.readLine();
                lineDelimiter = this.toLineDelimiter(eol);
            }
            String contentType = this.getValue("Content-type: ", nextLine);
            if (contentType == null) {
                contentType = "text/plain";
            } else {
                hasFileProperty = true;
                nextLine = reader.readLine();
            }
            String encoding = this.getValue("Character-encoding: ", nextLine);
            if (encoding != null) {
                hasFileProperty = true;
                nextLine = reader.readLine();
            }
            String executable = this.getValue("Executable: ", nextLine);
            boolean isExecutable = false;
            if (executable != null) {
                hasFileProperty = true;
                isExecutable = Boolean.valueOf(executable);
                nextLine = reader.readLine();
            }
            String revision = this.getValue("Revision: ", nextLine);
            if ((status & 0x20) > 0) {
                beforePath = path;
                afterPath = null;
            } else {
                afterPath = path;
                beforePath = fromPath != null ? fromPath : ((status & 0x10) == 0 ? path : null);
            }
            FileProperties properties = null;
            if (hasFileProperty || kind.indexOf("file") != -1) {
                properties = new FileProperties(lineDelimiter == null ? FileLineDelimiter.LINE_DELIMITER_NONE : lineDelimiter, contentType == null ? "text/plain" : contentType, encoding, isExecutable);
            }
            if (isIgnoreFileChange) {
                currentChangeSet.add(new IgnoreFileChange(status, revision, beforePath, afterPath, ignorePattern, archivePath));
                continue;
            }
            if (archivePath == null) {
                archivePath = ImportChange.getArchivePath(status, afterPath, revision);
            }
            currentChangeSet.add(new ImportChange(status, revision, beforePath, afterPath, archivePath, properties));
        }
        return currentChangeSet;
    }

    private FileLineDelimiter toLineDelimiter(String value) {
        if (value == null) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        if (value.equals("platform")) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        if (value.equals("crlf")) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if (value.equals("lf")) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if (value.equals("cr")) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    private ImportChangeSet readChangeSetProperties(String previousLine, BufferedReader reader) throws IOException {
        String revision = this.getValue("Revision: ", previousLine);
        String dateString = revision != null ? reader.readLine() : previousLine;
        Date date = ChangeSetFileWriter.parseDate(this.getValue("Date: ", dateString));
        String author = this.getValue("Author: ", reader.readLine());
        String commentLinesString = this.getValue("Comment-lines: ", reader.readLine());
        int commentLines = Integer.parseInt(commentLinesString);
        StringBuffer buffer = new StringBuffer();
        while (commentLines-- > 0) {
            String lines = reader.readLine();
            buffer.append(lines);
            if (commentLines <= 0) continue;
            buffer.append('\n');
        }
        String comment = buffer.toString();
        ImportChangeSet currentChangeSet = new ImportChangeSet(revision, date, comment, author);
        return currentChangeSet;
    }

    private int parseKind(String kind) {
        int status = 0;
        status = kind.indexOf("file") != -1 ? (status |= 1) : (kind.indexOf("folder") != -1 ? (status |= 2) : (status |= 0));
        if (kind.indexOf("add") != -1) {
            status |= 0x10;
        } else if (kind.indexOf("delete") != -1) {
            status |= 0x20;
        } else if (kind.indexOf("change") != -1) {
            status |= 0x40;
        }
        if (kind.indexOf("move") != -1) {
            status |= 0x200;
        }
        if (kind.indexOf("content") != -1) {
            status |= 0x100;
        }
        return status;
    }

    private String nextLine(BufferedReader reader) throws IOException {
        String nextLine = reader.readLine();
        if (nextLine != null && nextLine.length() == 0) {
            nextLine = reader.readLine();
        }
        return nextLine;
    }

    private String getValue(String pathPrefix, String nextLine) {
        if (nextLine.startsWith(pathPrefix)) {
            return nextLine.substring(pathPrefix.length());
        }
        return null;
    }

    public final void startRead(Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        this.reader = new BufferedReader(reader);
        this.readHeader();
    }

    protected void readHeader() throws IOException {
        this.verifyVersion();
        this.initializeDirectoriesSignificantFlag();
    }

    private void verifyVersion() throws IOException {
        String line = this.reader.readLine();
        String result = this.getValue("Change-set-archive-version: ", line);
        if (result == null) {
            throw new IOException(SCMImportMessages.ChangeSetFileReader_1);
        }
        if (!result.trim().equals("1")) {
            throw new IOException(NLS.bind((String)SCMImportMessages.ChangeSetFileReader_2, (Object)result));
        }
    }

    private void initializeDirectoriesSignificantFlag() throws IOException {
        String line = this.reader.readLine();
        String result = this.getValue("Directories-significant: ", line);
        this.directoriesSignificant = result == null || !result.equals("false");
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public BufferedReader getReader() {
        return this.reader;
    }
}

