/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.spi;

import com.ibm.team.internal.repository.rcp.tar.TarEntry;
import com.ibm.team.internal.repository.rcp.tar.TarOutputStream;
import com.ibm.team.scm.client.importz.IChangeSetArchiveCreator;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.spi.ChangeSetFileWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public abstract class ChangeSetArchiveCreator
implements IChangeSetArchiveCreator {
    private TarOutputStream tarStream;
    private File tempLogFile;
    private ChangeSetFileWriter writer;
    private final IMigrationFactory migrationFactory;

    public ChangeSetArchiveCreator(IMigrationFactory migrationFactory) {
        this.migrationFactory = migrationFactory;
    }

    public IMigrationFactory getMigrationFactory() {
        return this.migrationFactory;
    }

    protected void openArchive(File file) throws IOException {
        try {
            file.createNewFile();
            this.tarStream = new TarOutputStream(file);
        }
        finally {
            if (this.tarStream == null) {
                file.delete();
            }
        }
    }

    protected void closeArchive() throws IOException {
        try {
            this.archiveLogFile();
        }
        catch (Throwable throwable) {
            try {
                if (this.tarStream != null) {
                    this.tarStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (this.tarStream != null) {
                this.tarStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void initializeChangeSetFileWriter() throws IOException {
        this.tempLogFile = DebugUtils.createTempFile("changes.txt.gz");
        this.writer = this.migrationFactory.createChangeSetFileWriter(this.tempLogFile);
    }

    protected void archiveContents(String archivePath, File file, Date date) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        try {
            this.archiveContents(archivePath, stream, file.length(), date);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    protected void archiveContents(String archivePath, InputStream stream, long length, Date date) throws IOException {
        InputStream contents = null;
        try {
            if (archivePath != null) {
                TarEntry entry = this.getTarEntry(archivePath, date.getTime(), length);
                contents = new BufferedInputStream(stream);
                this.addTarEntry(entry, contents);
            }
        }
        catch (Throwable throwable) {
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            } else {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (contents != null) {
            try {
                contents.close();
            }
            catch (IOException iOException) {}
        } else {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private TarEntry getTarEntry(String path, long timestamp, long length) {
        long seconds = timestamp / 1000L;
        return new TarEntry(path, 420L, 0L, 0L, length, seconds, 48, "", "", "", 0L, 0L, seconds, seconds);
    }

    private void addTarEntry(TarEntry entry, InputStream contents) throws IOException {
        this.tarStream.putNextEntry(entry, contents, TarOutputStream.gzipFilter);
    }

    private void archiveLogFile() throws IOException {
        if (this.tempLogFile == null) {
            this.initializeChangeSetFileWriter();
        }
        if (this.tempLogFile != null) {
            this.writer.closeWrite();
            this.archiveContents("changes.txt.gz", this.tempLogFile, new Date());
            DebugUtils.deleteTempFile(this.tempLogFile);
        }
    }

    protected void writeChangeSet(IImportChangeSet changeSet) throws IOException {
        if (this.tempLogFile == null) {
            this.initializeChangeSetFileWriter();
        }
        this.writer.writeElement(changeSet);
    }
}

