/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ProgressMonitorOutputStream
extends FilterOutputStream {
    private IProgressMonitor monitor;
    private long bytesTotal;
    private int updateIncrement;
    private long bytesWritten;
    private long nextUpdate;

    public ProgressMonitorOutputStream(OutputStream out, long bytesTotal, int updateIncrement, IProgressMonitor monitor) {
        super(out);
        this.bytesTotal = bytesTotal;
        this.updateIncrement = updateIncrement;
        this.nextUpdate = updateIncrement;
        this.monitor = monitor;
        this.update(true);
    }

    public void write(int b) throws IOException {
        super.write(b);
        ++this.bytesWritten;
        this.update(false);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len);
            this.bytesWritten += (long)len;
            this.update(false);
        }
        catch (InterruptedIOException e) {
            this.bytesWritten += (long)e.bytesTransferred;
            this.update(false);
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.update(true);
        }
    }

    private void update(boolean force) {
        if (force || this.bytesWritten >= this.nextUpdate) {
            if (this.bytesWritten >= this.nextUpdate) {
                this.nextUpdate = this.bytesWritten + (long)this.updateIncrement;
            }
            this.updateMonitor(this.bytesWritten, this.bytesTotal, this.monitor);
        }
    }

    protected abstract void updateMonitor(long var1, long var3, IProgressMonitor var5);
}

