/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.utils;

import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.utils.ProgressMonitorOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ImportProgressMonitorOutputStream
extends ProgressMonitorOutputStream {
    private int progress;
    private IProgressMonitor monitor;

    public ImportProgressMonitorOutputStream(OutputStream out, long bytesTotal, int updateIncrement, IProgressMonitor monitor) {
        super(out, bytesTotal, updateIncrement, monitor);
        this.monitor = monitor;
        monitor.beginTask(SCMImportMessages.ImportProgressMonitorOutputStream_0, 100);
    }

    protected void updateMonitor(long bytesRead, long size, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int percent = (int)(bytesRead * 100L / size);
        monitor.worked(percent - this.progress);
        this.progress = percent;
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.monitor.done();
        }
    }
}

