/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.utils;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.internal.utils.IFileTree;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTree
implements IFileTree {
    private FolderEntry root;
    private final IWorkspaceConnection workspace;
    private final IComponent component;
    private boolean alwaysInitialize = DebugUtils.ALWAYS_INITIALIZE_IMPORT_TREE;

    public FileTree(IWorkspaceConnection workspace, IComponent component) {
        this.workspace = workspace;
        this.component = component;
    }

    private AbstractEntry getEntry(String path) {
        String segmentName;
        String nextSegment;
        AbstractEntry lastEntry = this.root;
        int index = 0;
        if (index <= path.length() - 1 && path.charAt(index) == '/') {
            ++index;
        }
        if ((nextSegment = PathUtils.getNextSegment((int)index, (String)path)) != null) {
            index += nextSegment.length();
        }
        while ((segmentName = nextSegment) != null) {
            FolderEntry parent;
            if (index <= path.length() - 1 && path.charAt(index) == '/') {
                ++index;
            }
            if ((nextSegment = PathUtils.getNextSegment((int)index, (String)path)) != null) {
                index += nextSegment.length();
            }
            if ((parent = lastEntry).areChildrenKnown()) {
                AbstractEntry entry = (AbstractEntry)parent.children.get(segmentName);
                if (entry == null) {
                    return null;
                }
                if (!entry.isContainer() && nextSegment != null) {
                    return null;
                }
                lastEntry = entry;
                continue;
            }
            return null;
        }
        return lastEntry;
    }

    @Override
    public IVersionableHandle getItemHandle(String path) {
        AbstractEntry entry = this.getEntry(path);
        if (entry != null) {
            return entry.getItemHandle();
        }
        return null;
    }

    @Override
    public IVersionable getItem(String path) {
        IVersionable item;
        AbstractEntry entry = this.getEntry(path);
        if (entry != null && (item = entry.getItem()) != null) {
            return item;
        }
        throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_1, (Object)path));
    }

    @Override
    public boolean hasChildren(String parentPath) {
        AbstractEntry entry = this.getEntry(parentPath);
        if (entry.isContainer()) {
            return ((FolderEntry)entry).hasChildren();
        }
        return false;
    }

    private void internalRemoveEntry(AbstractEntry entry) {
        FolderEntry parent = entry.getParent();
        parent.remove(entry.getName());
    }

    @Override
    public IVersionable move(String beforePath, String afterPath) {
        AbstractEntry entry = this.getEntry(beforePath);
        if (entry == null) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_4, (Object)beforePath, (Object)afterPath));
        }
        FolderEntry parent = entry.getParent();
        IVersionable item = entry.getItem();
        if (item == null) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_5, (Object)beforePath, (Object)afterPath));
        }
        parent.remove(item.getName());
        AbstractEntry newParent = this.getEntry(PathUtils.getParentFolderPath((String)afterPath));
        if (newParent == null) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_6, (Object)beforePath, (Object)afterPath));
        }
        if (newParent instanceof FolderEntry) {
            FolderEntry np = (FolderEntry)newParent;
            entry.setName(PathUtils.getBaseName((String)afterPath));
            item.setName(entry.getName());
            item.setParent((IFolderHandle)np.getItemHandle());
            np.add(entry);
            return item;
        }
        throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_7, (Object)beforePath, (Object)afterPath));
    }

    private IVersionable createItem(String path, boolean isFolder) {
        String parentPath = PathUtils.getParentFolderPath((String)path);
        AbstractEntry entry = this.getEntry(parentPath);
        if (entry == null || entry.getItemHandle() == null) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_2, (Object)path));
        }
        if (!entry.isContainer()) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_3, (Object)path));
        }
        FolderEntry parentEntry = (FolderEntry)entry;
        AbstractEntry child = parentEntry.createChild(PathUtils.getBaseName((String)path), isFolder);
        return child.getItem();
    }

    @Override
    public IFileItem createFile(String path) {
        IVersionable item = this.createItem(path, false);
        return (IFileItem)item;
    }

    @Override
    public IFolder createFolder(String path) {
        IVersionable item = this.createItem(path, true);
        return (IFolder)item;
    }

    @Override
    public IVersionable remove(String path) {
        AbstractEntry entry = this.getEntry(path);
        if (entry != null) {
            this.removeEntry(entry);
            return entry.getItem();
        }
        return null;
    }

    private void removeEntry(AbstractEntry entry) {
        FolderEntry folderEntry;
        if (entry instanceof FolderEntry && (folderEntry = (FolderEntry)entry).areChildrenKnown() && folderEntry.hasChildren()) {
            Collection<AbstractEntry> children = folderEntry.getChildren();
            for (AbstractEntry child : children) {
                this.removeEntry(child);
            }
        }
        this.internalRemoveEntry(entry);
    }

    @Override
    public void prepareForChanges(List<IImportChange> changes, boolean fetchDeepForAdds, boolean directoriesSignificant, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(changes.size() * 2));
            if (this.root == null || this.isAlwaysInitialize()) {
                progress.setWorkRemaining(40 + changes.size() * 2);
                this.init(progress.newChild(20));
            }
            HashMap<UUID, AbstractEntry> entriesToUpdate = new HashMap<UUID, AbstractEntry>();
            if (fetchDeepForAdds && !directoriesSignificant) {
                this.fetchDescendants(this.root, true, entriesToUpdate, progress);
            } else {
                PrechangePathMap prechangeMap = new PrechangePathMap();
                for (IImportChange change : changes) {
                    this.updateTree(change, fetchDeepForAdds, prechangeMap, entriesToUpdate, progress.newChild(2));
                }
            }
            this.fetchItems(entriesToUpdate, progress);
        }
        finally {
            monitor.done();
        }
    }

    private void fetchItems(Map<UUID, AbstractEntry> entriesToUpdate, SubMonitor progress) throws TeamRepositoryException, ItemNotFoundException, ComponentNotInWorkspaceException {
        if (entriesToUpdate.size() > 0) {
            ArrayList<IVersionableHandle> versionableItems = new ArrayList<IVersionableHandle>();
            for (AbstractEntry entry : entriesToUpdate.values()) {
                if (entry.getItem() != null) continue;
                versionableItems.add(entry.getItemHandle());
            }
            if (versionableItems.size() > 0) {
                List result = this.getConfiguration().fetchCompleteItems(versionableItems, (IProgressMonitor)progress);
                for (Object object : result) {
                    IVersionable v = (IVersionable)object;
                    AbstractEntry entry = entriesToUpdate.get(v.getItemId());
                    entry.setItem(v);
                    entry.prepareForChange();
                }
            }
        }
    }

    private void init(SubMonitor progress) throws TeamRepositoryException {
        progress.setWorkRemaining(100);
        IFolder root = this.getConfiguration().completeRootFolder((IProgressMonitor)progress.newChild(50));
        if (root == null) {
            throw new TeamRepositoryException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_10, (Object[])new Object[]{this.workspace.getName(), this.component.getName()}));
        }
        this.root = new FolderEntry("", null, (IVersionableHandle)((IFolder)root.getWorkingCopy()));
        HashMap<UUID, AbstractEntry> entriesToUpdate = new HashMap<UUID, AbstractEntry>();
        this.fetchChildren(this.root, entriesToUpdate, progress.newChild(30));
        this.fetchItems(entriesToUpdate, progress.newChild(20));
    }

    private IConfiguration getConfiguration() throws ItemNotFoundException, ComponentNotInWorkspaceException {
        return this.workspace.configuration((IComponentHandle)this.component);
    }

    private void fetchChildren(FolderEntry folderEntry, Map<UUID, AbstractEntry> entriesToUpdate, SubMonitor progress) throws TeamRepositoryException {
        Map handlesMap = this.getConfiguration().childEntries((IFolderHandle)folderEntry.getItemHandle(), (IProgressMonitor)progress);
        folderEntry.setChildren(handlesMap);
        Collection<AbstractEntry> children = folderEntry.getChildren();
        for (AbstractEntry entry : children) {
            entriesToUpdate.put(entry.getItemHandle().getItemId(), entry);
        }
    }

    private void updateTree(IImportChange change, boolean fetchDeepForAdds, PrechangePathMap prechangeMap, Map<UUID, AbstractEntry> entriesToUpdate, SubMonitor progress) throws TeamRepositoryException {
        String beforePath = prechangeMap.getBeforePath(change);
        String afterPath = change.getAfterPath();
        if (change.getItemType() == 2) {
            AbstractEntry entry;
            if (beforePath != null) {
                this.resolveFolder(beforePath, true, entriesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
            if (afterPath != null && (entry = this.resolveFolder(afterPath, false, entriesToUpdate, (IProgressMonitor)progress.newChild(1))) != null && fetchDeepForAdds && entry instanceof FolderEntry && (change.getKind() == 16 || change.getKind() == 64 && (change.getFlags() & 0x200) != 0)) {
                this.fetchDescendants((FolderEntry)entry, false, entriesToUpdate, progress);
            }
        } else if (change.getItemType() == 1) {
            if (beforePath != null) {
                this.resolveFile(beforePath, true, entriesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
            if (afterPath != null) {
                this.resolveFile(afterPath, false, entriesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
        } else if (change.getItemType() == 0) {
            if (beforePath != null) {
                this.resolvePath(beforePath, true, entriesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
            if (afterPath != null) {
                this.resolvePath(afterPath, false, entriesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
        }
        if (beforePath == null && change.getKind() == 16) {
            beforePath = prechangeMap.findPrechangePath(afterPath);
            this.resolvePath(beforePath, false, entriesToUpdate, (IProgressMonitor)progress.newChild(1));
        }
    }

    private void fetchDescendants(FolderEntry entry, boolean alwaysRecurse, Map<UUID, AbstractEntry> entriesToUpdate, SubMonitor progress) throws TeamRepositoryException {
        boolean recurse = alwaysRecurse;
        if (!entry.areChildrenKnown()) {
            this.fetchChildren(entry, entriesToUpdate, progress.newChild(1));
            recurse = true;
        }
        if (recurse) {
            Collection<AbstractEntry> children = entry.getChildren();
            for (AbstractEntry childEntry : children) {
                if (!(childEntry instanceof FolderEntry)) continue;
                FolderEntry childFolder = (FolderEntry)childEntry;
                this.fetchDescendants(childFolder, alwaysRecurse, entriesToUpdate, progress.newChild(1));
            }
        }
    }

    private AbstractEntry resolveFile(String path, boolean errorOnFailure, Map<UUID, AbstractEntry> entriesToUpdate, IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractEntry entry = this.resolvePath(path, errorOnFailure, entriesToUpdate, monitor);
        if (entry instanceof FileEntry) {
            return (FileEntry)entry;
        }
        if (errorOnFailure) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_21, (Object)path));
        }
        return null;
    }

    private AbstractEntry resolveFolder(String path, boolean errorOnFailure, Map<UUID, AbstractEntry> entriesToUpdate, IProgressMonitor monitor) throws TeamRepositoryException {
        AbstractEntry entry = this.resolvePath(path, errorOnFailure, entriesToUpdate, monitor);
        if (!(entry instanceof FolderEntry) && errorOnFailure) {
            throw new IllegalStateException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_22, (Object)path));
        }
        return entry;
    }

    private AbstractEntry resolvePath(String path, boolean errorOnFailure, Map<UUID, AbstractEntry> entriesToUpdate, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractEntry entry = this.getEntry(path);
        if (entry == null || entry.getItemHandle() == null) {
            AbstractEntry childEntry;
            String name = PathUtils.getBaseName((String)path);
            String parentPath = PathUtils.getParentFolderPath((String)path);
            AbstractEntry parent = this.resolveFolder(parentPath, errorOnFailure, entriesToUpdate, (IProgressMonitor)progress.newChild(50));
            if (parent == null || !(parent instanceof FolderEntry)) {
                return null;
            }
            FolderEntry parentFolder = (FolderEntry)parent;
            if (!parentFolder.areChildrenKnown()) {
                this.fetchChildren(parentFolder, entriesToUpdate, progress.newChild(20));
            }
            if ((childEntry = parentFolder.getChild(name)) == null) {
                if (errorOnFailure) {
                    throw new IllegalStateException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_23, (Object)path));
                }
                return null;
            }
            entry = childEntry;
        }
        monitor.done();
        return entry;
    }

    public boolean isAlwaysInitialize() {
        return this.alwaysInitialize;
    }

    public void setAlwaysInitialize(boolean alwaysInitialize) {
        this.alwaysInitialize = alwaysInitialize;
    }

    @Override
    public Collection<String> getChildNames(String path) {
        AbstractEntry entry = this.getEntry(path);
        if (entry.isContainer()) {
            return ((FolderEntry)entry).getChildNames();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean areChilrenKnown(String path) {
        AbstractEntry entry = this.getEntry(path);
        if (entry instanceof FolderEntry) {
            FolderEntry folder = (FolderEntry)entry;
            return folder.areChildrenKnown();
        }
        return false;
    }

    private static abstract class AbstractEntry {
        private String name;
        private FolderEntry parent;
        private IVersionableHandle itemHandle;

        public String getName() {
            return this.name;
        }

        public AbstractEntry(String name, FolderEntry parent, IVersionableHandle itemHandle) {
            this.name = name;
            this.parent = parent;
            this.itemHandle = itemHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }

        public IVersionable getItem() {
            if (this.itemHandle instanceof IVersionable) {
                return (IVersionable)this.itemHandle;
            }
            return null;
        }

        public void setItem(IVersionable item) {
            this.itemHandle = item;
        }

        public String getPath() {
            if (this.parent == null) {
                return this.name;
            }
            return String.valueOf(this.parent.getPath()) + "/" + this.name;
        }

        public abstract boolean isContainer();

        public FolderEntry getParent() {
            return this.parent;
        }

        public void setParent(FolderEntry parent) {
            this.parent = parent;
        }

        public void prepareForChange() {
            IVersionable item = this.getItem();
            if (item != null) {
                this.setItem((IVersionable)item.getWorkingCopy());
            }
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class FileEntry
    extends AbstractEntry {
        public FileEntry(String name, FolderEntry parent, IVersionableHandle item) {
            super(name, parent, item);
        }

        public boolean isContainer() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderEntry
    extends AbstractEntry {
        private Map<String, AbstractEntry> children;

        public FolderEntry(String name, FolderEntry parent, IVersionableHandle item) {
            super(name, parent, item);
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        protected Collection<AbstractEntry> setChildren(Map<String, IVersionableHandle> handlesMap) {
            this.children = new LinkedHashMap<String, AbstractEntry>();
            if (handlesMap != null) {
                for (Map.Entry<String, IVersionableHandle> entry : handlesMap.entrySet()) {
                    AbstractEntry childEntry = this.createEntry(entry.getKey(), entry.getValue());
                    this.children.put(childEntry.getName(), childEntry);
                }
            }
            return this.children.values();
        }

        public boolean hasChildren() {
            this.ensureChildrenKnown();
            return !this.children.isEmpty();
        }

        private void ensureChildrenKnown() {
            if (this.children == null) {
                throw new IllegalStateException(NLS.bind((String)SCMImportMessages.FileTree_0, (Object)this.getPath()));
            }
        }

        public void remove(String name) {
            this.ensureChildrenKnown();
            AbstractEntry entry = this.children.get(name);
            if (entry != null) {
                this.children.remove(name);
                entry.setParent(null);
            }
        }

        public AbstractEntry getChild(String name) {
            this.ensureChildrenKnown();
            return this.children.get(name);
        }

        public void add(AbstractEntry entry) {
            this.ensureChildrenKnown();
            this.children.put(entry.getName(), entry);
            entry.setParent(this);
        }

        public AbstractEntry createChild(String name, boolean isFolder) {
            Object child = isFolder ? (IFolder)IFolder.ITEM_TYPE.createItem() : (IFileItem)IFileItem.ITEM_TYPE.createItem();
            child.setName(name);
            child.setParent((IFolderHandle)this.getItemHandle());
            AbstractEntry entry = this.createEntry(name, (IVersionableHandle)child);
            if (entry instanceof FolderEntry) {
                FolderEntry folderEntry = (FolderEntry)entry;
                folderEntry.setChildren(null);
            }
            this.add(entry);
            return entry;
        }

        public AbstractEntry createEntry(String name, IVersionableHandle child) {
            if (child instanceof IFolderHandle) {
                FolderEntry folderEntry = new FolderEntry(name, this, child);
                return folderEntry;
            }
            return new FileEntry(name, this, child);
        }

        public Collection<AbstractEntry> getChildren() {
            this.ensureChildrenKnown();
            return new ArrayList<AbstractEntry>(this.children.values());
        }

        public boolean areChildrenKnown() {
            return this.children != null;
        }

        public Collection<String> getChildNames() {
            this.ensureChildrenKnown();
            return this.children.keySet();
        }
    }

    private static class PrechangePathMap {
        Map<String, String> pathBackMap = new HashMap<String, String>();

        private PrechangePathMap() {
        }

        public String getBeforePath(IImportChange change) {
            String beforePath = this.findPrechangePath(change.getBeforePath());
            if (beforePath != null && (change.getFlags() & 0x200) > 0) {
                this.recordPathChange(change, beforePath);
            }
            return beforePath;
        }

        private void recordPathChange(IImportChange change, String beforePath) {
            this.pathBackMap.put(change.getAfterPath(), beforePath);
        }

        public String findPrechangePath(String beforePath) {
            if (beforePath == null) {
                return null;
            }
            for (Map.Entry<String, String> entry : this.pathBackMap.entrySet()) {
                if (!PathUtils.isParentFolder((String)entry.getKey(), (String)beforePath)) continue;
                String rest = PathUtils.getRelativePath((String)entry.getKey(), (String)beforePath);
                return PathUtils.appendPath((String)entry.getValue(), (String)rest);
            }
            return beforePath;
        }
    }
}

