/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.ui.operations.FileSystemUIOperation;
import com.ibm.team.foundation.common.internal.util.TeamFoundationException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.scm.client.importz.IChangeSetArchiveImporter;
import com.ibm.team.scm.client.importz.IChangeSetFileReader;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.CreateArchiveOperation;
import com.ibm.team.scm.client.importz.internal.IChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.ImportArchiveOperation;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMapping;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMappingArea;
import com.ibm.team.scm.client.importz.internal.ui.AuthorMappingWizard;
import com.ibm.team.scm.client.importz.internal.ui.FetchContributorsFunction;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.spi.ImportData;
import com.ibm.team.scm.common.IComponent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOperation
extends FileSystemUIOperation {
    private IChangeArchiveStatistics stats;
    private final ImportConfiguration configuration;
    private final IMigrationFactory factory;
    private final IImportData importData;
    private final String name;
    private boolean promptForContributors = false;

    public static void recordAuthorMappings(Collection<Author2ContributorMapping> authorMappings, ImportData data) {
        for (Author2ContributorMapping mapping : authorMappings) {
            data.addAuthorMapping(mapping.getAuthorId(), mapping.getContributorId(), mapping.getContributor());
        }
    }

    public ImportOperation(String name, IMigrationFactory factory, IImportData importData, ImportConfiguration configuration) {
        this.name = name;
        this.factory = factory;
        this.importData = importData;
        this.configuration = configuration;
        this.initializeData();
    }

    public ImportOperation(String name, IMigrationFactory migrationFactory, ImportConfiguration configuration) {
        this(name, migrationFactory, new ImportData(), configuration);
    }

    protected void initializeData() {
        String property = (String)this.configuration.getProperty("PromptForAuthrMappings");
        boolean noMapping = property != null && property.equals("none");
        boolean mappingsProvided = property != null && property.equals("provided");
        boolean prompt = property == null || property.equals("prompt");
        ImportData data = (ImportData)this.getImportData();
        if (noMapping) {
            data.setContributorMappingEnablement(false);
        } else if (mappingsProvided) {
            ImportOperation.recordAuthorMappings(this.getConfiguration().getAuthorMappings(), data);
        } else if (prompt) {
            this.promptForContributors = true;
        }
        data.setPostImportBaselineName(this.configuration.getPostImportBaselineName());
        Object importOverExisting = this.configuration.getProperty("com.ibm.team.scm.client.importz.internal.ui.reconcileWithExisting");
        if (importOverExisting instanceof Boolean) {
            Boolean b = (Boolean)importOverExisting;
            data.setImportOverExisting(this.configuration.getComponent() != null && b != false);
        }
        data.setWorkspaceEncoding(this.configuration.getDefaultEncoding());
    }

    public void filesystemRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemClientException {
        block12: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)SCMImportMessages.ImportOperation_0, (Object)this.getFactory().getName()), (int)(this.configuration.isImportIntoWorkspace() ? 100 : 50));
            try {
                ((ImportData)this.getImportData()).setArchiveFile(this.configuration.getArchiveFile());
                if (this.configuration.isImportFromArchive()) {
                    this.importIntoWorkspace(this.getFactory(), this.getImportData(), progress.newChild(100));
                    break block12;
                }
                try {
                    this.createArchive(this.getFactory(), this.getImportData(), progress.newChild(50));
                    if (progress.isCanceled()) {
                        return;
                    }
                    if (this.configuration.isImportIntoWorkspace()) {
                        this.importIntoWorkspace(this.getFactory(), this.getImportData(), progress.newChild(50));
                    }
                }
                finally {
                    if (this.configuration.isDeleteArchiveFile()) {
                        DebugUtils.deleteTempFile(((ImportData)this.getImportData()).getArchiveFile());
                    }
                }
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
            catch (TeamRepositoryException e) {
                if (TeamFoundationException.isExpected((Throwable)e)) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                }
                throw e;
            }
        }
    }

    protected void createArchive(IMigrationFactory factory, IImportData importData, SubMonitor progress) throws TeamRepositoryException {
        CreateArchiveOperation createArchive = new CreateArchiveOperation(factory, importData);
        createArchive.run((IProgressMonitor)progress);
    }

    protected void importIntoWorkspace(IMigrationFactory factory, IImportData importData, SubMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        boolean closeArchive = false;
        try {
            ImportArchiveOperation importArchiveOp;
            monitor.beginTask(null, 100);
            closeArchive = importData.openArchive((IProgressMonitor)monitor.newChild(1));
            if (this.isOkToPrompt()) {
                this.promptToConfigureArchiveImport(importData, Author2ContributorMappingArea.hasJazzAdminPermissions(this.configuration.getRepository()), monitor.newChild(1));
            }
            if (this.isAutoMapUsers()) {
                this.performAutoMapOfUsers((IProgressMonitor)monitor.newChild(1));
            }
            IComponent component = this.configuration.getComponent((IProgressMonitor)monitor.newChild(3));
            monitor.setTaskName(NLS.bind((String)SCMImportMessages.ImportOperation_3, (Object)this.configuration.getSourceRepositoryKind(), (Object)component.getName()));
            IChangeSetArchiveImporter importer = factory.createArchiveImporter(importData, this.configuration.getWorkspaceConnection(), component);
            importer.performImport((IProgressMonitor)monitor.newChild(95));
            if (importer instanceof ImportArchiveOperation && (importArchiveOp = (ImportArchiveOperation)importer).getStats() != null) {
                this.setStats(importArchiveOp.getStats());
                if (importArchiveOp.getStats().getChangeSetCount() == 0) {
                    this.handleNoChanges();
                }
            }
        }
        finally {
            if (closeArchive) {
                importData.closeArchive();
            }
            monitor.done();
        }
    }

    protected void performAutoMapOfUsers(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                Set<String> authors = this.extractAuthorsFromArchiveFile(this.importData, (IProgressMonitor)progress.newChild(25));
                if (!authors.isEmpty()) {
                    Collection<Author2ContributorMapping> mappings = this.createMappings(authors);
                    Map<Author2ContributorMapping, Author2ContributorMapping> result = FetchContributorsFunction.fetchContributors(this.configuration.getRepository(), mappings, (IProgressMonitor)progress.newChild(25));
                    this.configuration.setAuthorMappings(result.values());
                    Author2ContributorMappingArea.createContributors(this.configuration.getRepository(), this.configuration.getAuthorMappings(), (IProgressMonitor)progress.newChild(50));
                    ImportOperation.recordAuthorMappings(this.configuration.getAuthorMappings(), (ImportData)this.importData);
                }
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof TeamRepositoryException) {
                    throw (TeamRepositoryException)targetException;
                }
                throw new TeamRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new TeamRepositoryException((Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean isAutoMapUsers() {
        String property = (String)this.configuration.getProperty("PromptForAuthrMappings");
        return property != null && property.equals("auto");
    }

    protected void handleNoChanges() {
        if (this.isOkToPrompt()) {
            JFaceUtils.showMessage((String)SCMImportMessages.ImportOperation_1, (String)SCMImportMessages.ImportOperation_2, (int)2);
        }
    }

    private void setStats(IChangeArchiveStatistics stats) {
        this.stats = stats;
    }

    public IChangeArchiveStatistics getStats() {
        return this.stats;
    }

    public IMigrationFactory getFactory() {
        return this.factory;
    }

    public IImportData getImportData() {
        return this.importData;
    }

    public ImportConfiguration getConfiguration() {
        return this.configuration;
    }

    protected boolean isOkToPrompt() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPromptForContributors() {
        return this.promptForContributors;
    }

    protected void promptToConfigureArchiveImport(final IImportData importData, final boolean isAdmin, SubMonitor monitor) throws TeamRepositoryException {
        if (this.shouldPromptForAuthorMappings((IProgressMonitor)monitor)) {
            try {
                Set<String> authors = this.extractAuthorsFromArchiveFile(importData, (IProgressMonitor)monitor);
                if (!authors.isEmpty()) {
                    Collection<Author2ContributorMapping> mappings = this.createMappings(authors);
                    Map<Author2ContributorMapping, Author2ContributorMapping> result = FetchContributorsFunction.fetchContributors(this.configuration.getRepository(), mappings, (IProgressMonitor)monitor);
                    ImportOperation.recordAuthorMappings(result.values(), (ImportData)importData);
                    this.configuration.setAuthorMappings(result.values());
                    final boolean[] ok = new boolean[]{true};
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ok[0] = ImportOperation.this.promptForAuthorMappings(importData, isAdmin);
                        }
                    });
                    if (!ok[0]) {
                        throw new OperationCanceledException();
                    }
                }
            }
            catch (IOException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
        }
    }

    private Collection<Author2ContributorMapping> createMappings(Set<String> authors) {
        ArrayList<Author2ContributorMapping> result = new ArrayList<Author2ContributorMapping>();
        for (String string : authors) {
            result.add(new Author2ContributorMapping(string, string));
        }
        return result;
    }

    protected boolean promptForAuthorMappings(IImportData importData, boolean isAdmin) {
        AuthorMappingWizard wizard = new AuthorMappingWizard(this.getConfiguration(), importData, isAdmin);
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        int result = dialog.open();
        return result == 0;
    }

    protected Set<String> extractAuthorsFromArchiveFile(IImportData importData, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        boolean closeArchive = false;
        try {
            closeArchive = importData.openArchive(monitor);
            IChangeSetFileReader reader = this.factory.createChangeSetFileReader(importData);
            try {
                IImportChangeSet changeSet;
                HashSet<String> authors = new HashSet<String>();
                while ((changeSet = reader.next(monitor)) != null) {
                    authors.add(changeSet.getAuthor());
                }
                HashSet<String> hashSet = authors;
                reader.close();
                return hashSet;
            }
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
        }
        finally {
            if (closeArchive) {
                importData.closeArchive();
            }
        }
    }

    protected boolean shouldPromptForAuthorMappings(IProgressMonitor monitor) {
        boolean isAdmin;
        ITeamRepository repository;
        Object property = this.getConfiguration().getProperty("PromptForAuthrMappings");
        if (property == null && (repository = this.configuration.getRepository()) != null && !(isAdmin = Author2ContributorMappingArea.hasJazzAdminPermissions(repository))) {
            return false;
        }
        return property == null || property.equals("prompt");
    }
}

