/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ImportLoggingHelper {
    public static final String PLUGIN_ID = "com.ibm.team.scm.client.importz";

    public static void logException(String title, Throwable t) {
        if (t instanceof CoreException) {
            StatusUtil.log((IStatus)new MultiStatus(PLUGIN_ID, 4, new IStatus[]{((CoreException)t).getStatus()}, title, t));
        } else {
            StatusUtil.log((IStatus)new Status(4, PLUGIN_ID, 0, String.valueOf(title) + ": " + (t.getLocalizedMessage() == null ? "" : t.getLocalizedMessage()), t));
        }
    }

    public static void displayError(String title, Throwable t) {
        String message;
        ImportLoggingHelper.logException(title, t);
        String string = message = t.getLocalizedMessage() == null ? SCMImportMessages.ImportLoggingHelper_3 : t.getLocalizedMessage();
        if (message.length() > 500) {
            message = String.valueOf(message.substring(0, 500)) + "...";
        }
        ImportLoggingHelper.doDisplayError(title, message);
    }

    public static void displayError(String title, String message) {
        StatusUtil.log((IStatus)new Status(4, PLUGIN_ID, 0, String.valueOf(title) + ": " + message, null));
        ImportLoggingHelper.doDisplayError(title, message);
    }

    private static void doDisplayError(String title, String message) {
        JFaceUtils.showMessage((String)title, (String)message, (int)4);
    }
}

