/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMapping;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportConfiguration {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String PLUGIN_ID = "com.ibm.team.scm.client.importz";
    public static final String IMPORT_INTO_WORKSPACE = "importIntoWorkspace";
    public static final String IMPORT_FULL_HISTORY = "importFullHistory";
    public static final String DELETE_ARCHIVE_FILE = "deleteArchiveFile";
    public static final String ARCHIVE_FILENAME = "archiveFilename";
    public static final String SINGLE_FOLDER_SELECTED = "singleFolderSelected";
    public static final String MAP_FOLDER_TO_COMPONENT = "mapFolderToComponent";
    public static final String POST_IMPORT_BASELINE_NAME = "postImportBaselineName";
    public static final String TEAM_REPOSITORY_PROPERTY = "teamReposiotry";
    public static final String DEFAULT_ENCODING_PROPERTY = "defaultEncoding";
    private boolean importIntoWorkspace = true;
    private boolean fullHistory = true;
    private String filename;
    private boolean deleteArchiveFile = true;
    private boolean importFromArchive;
    private ListenerList listeners = new ListenerList(1);
    private ITeamRepository repository;
    private String workspaceName;
    private IComponent component;
    private IWorkspaceConnection workspaceConnection;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private File file;
    private final String sourceRepositoryKind;
    private Collection<Author2ContributorMapping> authorMappings;
    private boolean incrementalBaselinesSupported;
    private boolean createIncrementalBaselines;

    public ImportConfiguration(String sourceRepositoryKind, boolean importFromArchive) {
        this.sourceRepositoryKind = sourceRepositoryKind;
        this.importFromArchive = importFromArchive;
        if (importFromArchive) {
            this.deleteArchiveFile = false;
        }
        this.setDefaultEncoding(DEFAULT_ENCODING);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)list[i];
            listener.propertyChange(new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue));
            ++i;
        }
    }

    public boolean isImportIntoWorkspace() {
        return this.importIntoWorkspace;
    }

    public void setImportIntoWorkspace(boolean importIntoWorkspace) {
        if (this.importIntoWorkspace != importIntoWorkspace) {
            this.importIntoWorkspace = importIntoWorkspace;
            this.firePropertyChange(IMPORT_INTO_WORKSPACE, !importIntoWorkspace, importIntoWorkspace);
        }
        if (!importIntoWorkspace) {
            this.setDeleteArchiveFile(false);
        }
    }

    public boolean isImportFullHistory() {
        return this.fullHistory;
    }

    public void setImportFullHistory(boolean fullHistory) {
        if (this.fullHistory != fullHistory) {
            this.fullHistory = fullHistory;
            this.firePropertyChange(IMPORT_FULL_HISTORY, !fullHistory, fullHistory);
        }
    }

    public String getArchiveFilename() {
        return this.filename;
    }

    public File getArchiveFile() throws IOException {
        if (this.filename == null || this.isDeleteArchiveFile() && !this.isImportFromArchive()) {
            if (this.file == null) {
                this.file = DebugUtils.createTempFile("importArchive");
            }
            return this.file;
        }
        return new File(this.getArchiveFilename());
    }

    public void setArchiveFilename(String filename) {
        if (this.filename == null || !this.filename.equals(filename)) {
            String oldName = this.filename;
            this.filename = filename;
            this.firePropertyChange(ARCHIVE_FILENAME, oldName, filename);
        }
    }

    public boolean isDeleteArchiveFile() {
        return this.deleteArchiveFile;
    }

    public void setDeleteArchiveFile(boolean deleteArchiveFile) {
        if (deleteArchiveFile) {
            Assert.isTrue((!this.isImportFromArchive() ? 1 : 0) != 0, (String)SCMImportMessages.ImportConfiguration_6);
        }
        if (this.deleteArchiveFile != deleteArchiveFile) {
            this.deleteArchiveFile = deleteArchiveFile;
            this.firePropertyChange(DELETE_ARCHIVE_FILE, !deleteArchiveFile, deleteArchiveFile);
        }
    }

    public boolean canDeleteArchive() {
        return this.isImportFullHistory() && this.isImportIntoWorkspace() && !this.isImportFromArchive();
    }

    public boolean isImportFromArchive() {
        return this.importFromArchive;
    }

    public void setImportFromArchive(boolean importFromArchive) {
        this.importFromArchive = importFromArchive;
    }

    public IStatus validateState() {
        String filename = this.getArchiveFilename();
        if (this.isImportFromArchive()) {
            if (filename == null) {
                return new Status(4, PLUGIN_ID, 0, SCMImportMessages.ImportConfiguration_7, null);
            }
            File file = new File(filename);
            if (!file.exists()) {
                return new Status(4, PLUGIN_ID, 0, NLS.bind((String)SCMImportMessages.ImportConfiguration_8, (Object)filename), null);
            }
        } else if (filename != null && !this.isDeleteArchiveFile()) {
            if (filename.length() == 0) {
                return new Status(4, PLUGIN_ID, 0, SCMImportMessages.ImportConfiguration_9, null);
            }
            File file = new File(filename);
            File parent = file.getParentFile();
            if (parent == null) {
                return new Status(4, PLUGIN_ID, 0, SCMImportMessages.ImportConfiguration_10, null);
            }
            if (!parent.exists()) {
                return new Status(4, PLUGIN_ID, 0, NLS.bind((String)SCMImportMessages.ImportConfiguration_11, (Object)filename), null);
            }
            if (!parent.isDirectory()) {
                return new Status(4, PLUGIN_ID, 0, NLS.bind((String)SCMImportMessages.ImportConfiguration_12, (Object)filename), null);
            }
            if (file.exists()) {
                if (file.isDirectory()) {
                    return new Status(4, PLUGIN_ID, 0, NLS.bind((String)SCMImportMessages.ImportConfiguration_13, (Object)filename), null);
                }
                return new Status(2, PLUGIN_ID, 0, NLS.bind((String)SCMImportMessages.ImportConfiguration_14, (Object)filename), null);
            }
        }
        return Status.OK_STATUS;
    }

    public void setRepository(ITeamRepository repository) {
        if (this.repository != repository) {
            ITeamRepository oldRepository = this.repository;
            this.repository = repository;
            this.firePropertyChange(TEAM_REPOSITORY_PROPERTY, oldRepository, repository);
        }
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setTargetComponent(IWorkspaceConnection workspaceConnection, IComponent component) {
        Assert.isNotNull((Object)workspaceConnection);
        Assert.isNotNull((Object)component);
        this.component = component;
        this.workspaceConnection = workspaceConnection;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }

    public boolean isAllowSync() {
        return false;
    }

    public IComponent getComponent(IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isImportIntoWorkspace()) {
            return null;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
        if (this.workspaceConnection == null) {
            IComponent component;
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
            progress.subTask(NLS.bind((String)SCMImportMessages.ImportConfiguration_15, (Object)this.getWorkspaceName()));
            this.workspaceConnection = wm.createWorkspace((IContributorHandle)this.getRepository().loggedInContributor(), this.getWorkspaceName(), "", (IProgressMonitor)progress.newChild(15));
            this.component = component = wm.createComponent(this.getWorkspaceName(), (IAuditableHandle)this.getRepository().loggedInContributor(), (IProgressMonitor)progress.newChild(15));
            this.workspaceConnection.addComponent((IComponentHandle)component, false, (IProgressMonitor)progress.newChild(10));
        }
        return this.component;
    }

    public void setProperty(String key, Object value) {
        Object oldValue = this.getProperty(key);
        if (oldValue != value) {
            if (oldValue != null && value != null && oldValue.equals(value)) {
                return;
            }
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
            this.firePropertyChange(key, oldValue, value);
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object object = this.getProperty(key);
        if (object == null) {
            return defaultValue;
        }
        return object;
    }

    public String getSourceRepositoryKind() {
        return this.sourceRepositoryKind;
    }

    public void setAuthorMappings(Collection<Author2ContributorMapping> authorMappings) {
        this.authorMappings = authorMappings;
    }

    public Collection<Author2ContributorMapping> getAuthorMappings() {
        return this.authorMappings;
    }

    public String getPostImportBaselineName() {
        return (String)this.getProperty(POST_IMPORT_BASELINE_NAME);
    }

    public void setPostImportBaselineName(String name) {
        this.setProperty(POST_IMPORT_BASELINE_NAME, name);
    }

    public boolean isIncrementalBaselinesSupported() {
        return this.incrementalBaselinesSupported;
    }

    public void setIncrementalBaselinesSupported(boolean incrementalBaselinesSupported) {
        this.incrementalBaselinesSupported = incrementalBaselinesSupported;
    }

    public boolean isCreateIncrementalBaselines() {
        return this.createIncrementalBaselines;
    }

    public void setCreateIncrementalBaselines(boolean createIncrementalBaselines) {
        this.createIncrementalBaselines = createIncrementalBaselines;
    }

    public String getDefaultEncoding() {
        return (String)this.getProperty(DEFAULT_ENCODING_PROPERTY);
    }

    public void setDefaultEncoding(String encoding) {
        this.setProperty(DEFAULT_ENCODING_PROPERTY, encoding);
    }

    public boolean isMapFolderToComponent() {
        return (Boolean)this.getProperty(MAP_FOLDER_TO_COMPONENT, Boolean.FALSE);
    }

    public void setMapFolderToComponent(boolean mapFolderToComponent) {
        this.setProperty(MAP_FOLDER_TO_COMPONENT, mapFolderToComponent);
    }

    public boolean isSingleFolderSelected() {
        return (Boolean)this.getProperty(SINGLE_FOLDER_SELECTED, Boolean.FALSE);
    }

    public void setSingleFolderSelected(boolean singleFolderSelected) {
        this.setProperty(SINGLE_FOLDER_SELECTED, singleFolderSelected);
    }
}

