/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FetchContributorsFunction
extends SlowFunction<Author2ContributorMapping, Author2ContributorMapping> {
    private final ITeamRepository repository;

    public FetchContributorsFunction(ITeamRepository repository, ISetWithListeners<Author2ContributorMapping> domain, IOperationRunner runner) {
        super(domain, runner, Display.getCurrent(), false);
        Assert.isNotNull((Object)repository);
        this.repository = repository;
    }

    protected Map<Author2ContributorMapping, Author2ContributorMapping> doFetch(Collection<Author2ContributorMapping> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        return FetchContributorsFunction.fetchContributors(this.repository, toFetch, reporter);
    }

    public static Map<Author2ContributorMapping, Author2ContributorMapping> fetchContributors(ITeamRepository repository, Collection<Author2ContributorMapping> toFetch, IProgressMonitor reporter) {
        HashMap<Author2ContributorMapping, Author2ContributorMapping> result = new HashMap<Author2ContributorMapping, Author2ContributorMapping>();
        HashMap<String, ArrayList<Author2ContributorMapping>> fetch = new HashMap<String, ArrayList<Author2ContributorMapping>>();
        for (Author2ContributorMapping mapping : toFetch) {
            result.put(mapping, mapping);
            if (mapping.getContributor() != null) continue;
            ArrayList<Author2ContributorMapping> list = (ArrayList<Author2ContributorMapping>)fetch.get(mapping.getContributorId());
            if (list == null) {
                list = new ArrayList<Author2ContributorMapping>(1);
                fetch.put(mapping.getContributorId(), list);
            }
            list.add(mapping);
        }
        if (!fetch.isEmpty()) {
            Collection<IContributor> contributors = FetchContributorsFunction.fetchContributorsById(repository, fetch.keySet(), reporter);
            for (IContributor contributor : contributors) {
                List list = (List)fetch.get(contributor.getUserId());
                if (list == null) continue;
                for (Author2ContributorMapping mapping : list) {
                    mapping.setContributor(contributor);
                }
            }
        }
        return result;
    }

    private static Collection<IContributor> fetchContributorsById(ITeamRepository repository, Set<String> contributorIds, IProgressMonitor reporter) {
        ArrayList<IContributor> result = new ArrayList<IContributor>(contributorIds.size());
        IContributorManager contributorManager = repository.contributorManager();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)reporter, (String)SCMImportMessages.FetchContributorsFunction_0, (int)(contributorIds.size() * 100));
        for (String id : contributorIds) {
            try {
                IContributor contributor = contributorManager.fetchContributorByUserId(id, (IProgressMonitor)monitor.newChild(100));
                if (contributor == null) continue;
                result.add(contributor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)"com.ibm.team.scm.client.importz", (Throwable)e);
            }
        }
        return result;
    }

    protected Author2ContributorMapping getDefaultValue() {
        return null;
    }

    protected String getOperationName() {
        return SCMImportMessages.FetchContributorsFunction_2;
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }
}

