/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractOptionsArea;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class BaselineOptions
extends AbstractOptionsArea {
    private ImportConfiguration configuration;
    private Group baselineGroup;
    private Label nameLabel;
    private Text nameText;
    private Button createButton;

    public BaselineOptions(Composite parent, ImportConfiguration configuration) {
        this.configuration = configuration;
        this.baselineGroup = this.createGroup(parent, SCMImportMessages.BaselineOptions_0, 2);
        this.nameLabel = new Label((Composite)this.baselineGroup, 0);
        this.nameLabel.setText(SCMImportMessages.BaselineOptions_1);
        this.nameLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.nameText = new Text((Composite)this.baselineGroup, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = BaselineOptions.this.nameText.getText();
                if (name.length() == 0) {
                    name = null;
                }
                BaselineOptions.this.configuration.setPostImportBaselineName(name);
            }
        });
        if (configuration.isIncrementalBaselinesSupported()) {
            this.createButton = new Button((Composite)this.baselineGroup, 32);
            this.createButton.setText(SCMImportMessages.BaselineOptions_2);
            this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaselineOptions.this.configuration.setCreateIncrementalBaselines(BaselineOptions.this.createButton.getSelection());
                }
            });
            GridDataFactory.defaultsFor((Control)this.createButton).grab(true, false).span(2, 1).applyTo((Control)this.createButton);
        }
    }

    public void initControls() {
        super.initControls();
        String name = this.configuration.getPostImportBaselineName();
        if (name == null) {
            name = "";
        }
        this.nameText.setText(name);
        if (this.createButton != null) {
            this.createButton.setSelection(this.configuration.isCreateIncrementalBaselines());
        }
    }

    protected void updateEnablements() {
        boolean enabled = this.isEnabled();
        this.nameLabel.setEnabled(enabled);
        this.nameText.setEnabled(enabled);
        if (this.createButton != null) {
            this.createButton.setEnabled(enabled);
        }
    }
}

