/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.service.IPermissionService;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SetTransformer;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractOptionsArea;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMapping;
import com.ibm.team.scm.client.importz.internal.ui.FetchContributorsFunction;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import com.ibm.team.scm.client.importz.internal.ui.ImportLoggingHelper;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Author2ContributorMappingArea
extends AbstractOptionsArea {
    private SimpleTableViewer<Author2ContributorMapping> viewer;
    private Author2ContributorSet input;
    private FetchContributorsFunction fetchFunction;
    private boolean canAdd;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private final ImportConfiguration configuration;
    private Composite composite;
    private ContributorIdLabelProvider labelUpdater;
    private ContributorConversion contributorUpdater;
    private IRunnableContext runnableContext;
    private Button loadButton;
    private Button saveButton;
    private Button createButton;

    private static boolean hasMappingToLoggedInUser(IContributor loggedInContributor, Collection<Author2ContributorMapping> mappings) {
        for (Author2ContributorMapping mapping : mappings) {
            IContributor contributor = mapping.getContributor();
            if (contributor == null || !contributor.sameItemId((IItemHandle)loggedInContributor) || loggedInContributor.getUserId().equals(mapping.getAuthorId())) continue;
            return true;
        }
        return false;
    }

    public static boolean promptForSuspectMappings(Shell shell, IContributor loggedInContributor, Collection<Author2ContributorMapping> mappings, String repoType) {
        if (Author2ContributorMappingArea.hasMappingToLoggedInUser(loggedInContributor, mappings)) {
            return MessageDialog.openConfirm((Shell)shell, (String)SCMImportMessages.Author2ContributorMappingArea_0, (String)NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_1, (Object)repoType));
        }
        return true;
    }

    public Author2ContributorMappingArea(Composite parent, ImportConfiguration configuration, boolean canAdd, IRunnableContext runnableContext, IOperationRunner operationRunner) {
        this.configuration = configuration;
        this.canAdd = canAdd;
        this.runnableContext = runnableContext;
        this.composite = new Composite(parent, 0);
        this.viewer = new SimpleTableViewer(this.composite, 68354, (Preferences)this.getConfigPrefs(), null);
        this.input = new Author2ContributorSet(configuration.getAuthorMappings());
        this.viewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Author2ContributorMappingArea.this.updateEnablements();
            }
        });
        new ConvertColumn(this.viewer, NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_2, (Object)configuration.getSourceRepositoryKind()), 100, (IConversion)new IConversion<Author2ContributorMapping, String>(){

            public String createAdapter(Author2ContributorMapping source) {
                return source.getAuthorId();
            }
        });
        this.contributorUpdater = new ContributorConversion((ISetWithListeners<Author2ContributorMapping>)this.input);
        new ConvertColumn(this.viewer, SCMImportMessages.Author2ContributorMappingArea_3, 150, (IDynamicFunction)this.contributorUpdater);
        this.labelUpdater = new ContributorIdLabelProvider();
        new LabelColumn(this.viewer, SCMImportMessages.Author2ContributorMappingArea_4, 100, (IViewerLabelProvider)this.labelUpdater);
        GridDataFactory.defaultsFor((Control)this.viewer.getTable()).grab(true, true).applyTo((Control)this.viewer.getTable());
        Composite buttons = new Composite(this.composite, 0);
        this.createButtons(buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(this.composite);
        this.updateEnablements();
    }

    public void linkInputToViewer(ITeamRepository repository, IOperationRunner operationRunner) {
        if (this.fetchFunction == null || !this.fetchFunction.getRepository().getId().equals((Object)repository.getId())) {
            this.fetchFunction = new FetchContributorsFunction(repository, (ISetWithListeners<Author2ContributorMapping>)this.input, operationRunner);
            this.viewer.setInput(this.fetchFunction.getRange());
            this.updateEnablements();
        }
    }

    @Override
    protected void updateEnablements() {
        boolean enabled = this.isEnabled();
        if (this.addButton != null) {
            this.addButton.setEnabled(enabled);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enabled && !this.viewer.getSelection().isEmpty());
        }
        this.editButton.setEnabled(enabled && !this.viewer.getSelection().isEmpty());
        this.createButton.setEnabled(enabled && !this.input.getElements().isEmpty());
        this.loadButton.setEnabled(enabled);
        this.saveButton.setEnabled(enabled && !this.input.getElements().isEmpty());
        this.viewer.getTable().setEnabled(enabled);
        this.getControl().setEnabled(enabled);
    }

    private void createButtons(Composite buttons) {
        GridDataFactory gdFactory = GridDataFactory.swtDefaults().align(4, 128);
        if (this.canAdd) {
            this.addButton = new Button(buttons, 8);
            this.addButton.setText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_5, (Object)this.configuration.getSourceRepositoryKind()));
            this.addButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Author2ContributorMappingArea.this.addAuthor();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            gdFactory.applyTo((Control)this.addButton);
        }
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(SCMImportMessages.Author2ContributorMappingArea_6);
        this.editButton.setToolTipText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_7, (Object)this.configuration.getSourceRepositoryKind()));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingArea.this.editAuthors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gdFactory.applyTo((Control)this.editButton);
        this.createButton = new Button(buttons, 8);
        this.createButton.setText(SCMImportMessages.Author2ContributorMappingArea_25);
        this.createButton.setToolTipText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_26, (Object)this.configuration.getSourceRepositoryKind()));
        this.createButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingArea.this.createContributors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gdFactory.applyTo((Control)this.createButton);
        this.removeButton = new Button(buttons, 8);
        if (this.canAdd) {
            this.removeButton.setText(SCMImportMessages.Author2ContributorMappingArea_8);
            this.removeButton.setToolTipText(SCMImportMessages.Author2ContributorMappingArea_9);
        } else {
            this.removeButton.setText(SCMImportMessages.Author2ContributorMappingArea_27);
            this.removeButton.setToolTipText(SCMImportMessages.Author2ContributorMappingArea_28);
        }
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingArea.this.removeAuthors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gdFactory.applyTo((Control)this.removeButton);
        this.loadButton = new Button(buttons, 8);
        this.loadButton.setText(SCMImportMessages.Author2ContributorMappingArea_10);
        this.loadButton.setToolTipText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_11, (Object)this.configuration.getSourceRepositoryKind()));
        gdFactory.applyTo((Control)this.loadButton);
        this.loadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingArea.this.loadFromFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.saveButton = new Button(buttons, 8);
        this.saveButton.setText(SCMImportMessages.Author2ContributorMappingArea_12);
        this.saveButton.setToolTipText(NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_13, (Object)this.configuration.getSourceRepositoryKind()));
        gdFactory.applyTo((Control)this.saveButton);
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Author2ContributorMappingArea.this.saveToFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void saveToFile() {
        FileDialog dialog = new FileDialog(this.composite.getShell(), 8192);
        String fileName = dialog.open();
        if (fileName != null) {
            PrintStream out = null;
            try {
                try {
                    out = new PrintStream(new FileOutputStream(fileName));
                    this.input.write(out);
                }
                catch (IOException e) {
                    JFaceUtils.showError((String)SCMImportMessages.Author2ContributorMappingArea_14, (String)NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_15, (Object)fileName), (Throwable)e);
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    protected void loadFromFile() {
        FileDialog dialog = new FileDialog(this.composite.getShell(), 4096);
        String fileName = dialog.open();
        if (fileName != null) {
            try {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    this.input.load(in);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                JFaceUtils.showError((String)SCMImportMessages.Author2ContributorMappingArea_16, (String)NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_17, (Object)fileName), (Throwable)e);
            }
            this.updateEnablements();
        }
    }

    protected void editAuthors() {
        TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.editButton.getShell(), this.getTeamRepository(), Collections.EMPTY_LIST, false);
        int result = dialog.open();
        if (result == 0) {
            try {
                IContributorHandle handle;
                IContributor c;
                Object element = dialog.getFirstResult();
                if (element instanceof IContributor) {
                    IContributor contributor = (IContributor)element;
                    this.updateContributor(contributor);
                } else if (element instanceof IContributorHandle && (c = this.fetchContributor(handle = (IContributorHandle)element)) != null) {
                    this.updateContributor(c);
                }
                this.updateEnablements();
            }
            catch (InvocationTargetException e) {
                ImportLoggingHelper.displayError(SCMImportMessages.Author2ContributorMappingArea_18, e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private IContributor fetchContributor(final IContributorHandle handle) throws InvocationTargetException, InterruptedException {
        final IContributor[] contributor = new IContributor[1];
        this.runnableContext.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    contributor[0] = Author2ContributorMappingArea.this.fetchContributor(handle, monitor);
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        return contributor[0];
    }

    private IContributor fetchContributor(IContributorHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IContributor)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)handle, 0, monitor);
    }

    private IContributor fetchContributorFor(final String userId) throws InvocationTargetException, InterruptedException {
        final IContributor[] contributor = new IContributor[1];
        this.runnableContext.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    contributor[0] = Author2ContributorMappingArea.this.getTeamRepository().contributorManager().fetchContributorByUserId(userId, null);
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        return contributor[0];
    }

    private void updateContributor(IContributor contributor) {
        IStructuredSelection selection = this.viewer.getSelection();
        List list = selection.toList();
        for (Object object : list) {
            if (!(object instanceof Author2ContributorMapping)) continue;
            Author2ContributorMapping mapping = (Author2ContributorMapping)object;
            mapping.setContributor(contributor);
        }
        this.updateElements(list);
    }

    protected void createContributors() {
        IStructuredSelection selection = this.viewer.getSelection();
        List<Author2ContributorMapping> list = selection.isEmpty() ? this.input.getElements() : selection.toList();
        ArrayList<Author2ContributorMapping> result = new ArrayList<Author2ContributorMapping>(list.size());
        for (Author2ContributorMapping object : list) {
            Author2ContributorMapping mapping;
            if (!(object instanceof Author2ContributorMapping) || (mapping = object).getContributor() != null) continue;
            result.add(mapping);
        }
        if (!result.isEmpty()) {
            this.createContributors(result);
        }
    }

    private void updateElements(List list) {
        this.labelUpdater.fireLabelChange(list);
        this.contributorUpdater.fireEvent(list);
    }

    private ITeamRepository getTeamRepository() {
        return this.configuration.getRepository();
    }

    protected void removeAuthors() {
        List list = this.viewer.getSelection().toList();
        if (this.canAdd) {
            this.input.remove(list);
        } else {
            for (Object object : list) {
                if (!(object instanceof Author2ContributorMapping)) continue;
                Author2ContributorMapping mapping = (Author2ContributorMapping)object;
                mapping.setContributor(null);
            }
            this.updateElements(list);
        }
        this.updateEnablements();
    }

    protected void addAuthor() {
        InputDialog dialog = new InputDialog(this.editButton.getShell(), NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_19, (Object)this.getSourceRepositoryKind()), NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_20, (Object)this.getSourceRepositoryKind()), "", new IInputValidator(){

            public String isValid(String newText) {
                int i = 0;
                while (i < newText.length()) {
                    char c = newText.charAt(i);
                    if (Character.isWhitespace(c)) {
                        return SCMImportMessages.Author2ContributorMappingArea_22;
                    }
                    ++i;
                }
                if (Author2ContributorMappingArea.this.input.getMapping(newText) != null) {
                    return NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_23, (Object)newText);
                }
                return null;
            }
        });
        int result = dialog.open();
        if (result == 0) {
            IContributor contributor;
            String author = dialog.getValue();
            try {
                contributor = this.fetchContributorFor(author);
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof ItemNotFoundException)) {
                    ImportLoggingHelper.displayError(NLS.bind((String)SCMImportMessages.Author2ContributorMappingArea_24, (Object)author), e);
                }
                contributor = null;
            }
            catch (InterruptedException interruptedException) {
                contributor = null;
            }
            this.input.addAuthor(author, contributor);
            Author2ContributorMapping mapping = this.input.getMapping(author);
            this.viewer.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)mapping));
            this.updateEnablements();
        }
    }

    private String getSourceRepositoryKind() {
        return this.configuration.getSourceRepositoryKind();
    }

    public Control getControl() {
        return this.composite;
    }

    public ISetWithListeners<Author2ContributorMapping> getAuthorMappings() {
        return this.input;
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.scm.client.importz/" + this.getClass().getName());
        return result;
    }

    public void ensureAuthorIdsAreAvailable(Collection<String> authorsForSelectedFolders) {
        ArrayList<Author2ContributorMapping> toAdd = new ArrayList<Author2ContributorMapping>();
        for (String authorId : authorsForSelectedFolders) {
            if (this.input.containsAuthor(authorId)) continue;
            toAdd.add(new Author2ContributorMapping(authorId, authorId));
        }
        this.input.addAll(toAdd);
    }

    /*
     * Loose catch block
     */
    protected void createContributors(final List<Author2ContributorMapping> mappings) {
        block9: {
            try {
                try {
                    this.runnableContext.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Author2ContributorMappingArea.createContributors(Author2ContributorMappingArea.this.getTeamRepository(), mappings, monitor);
                        }
                    });
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.updateElements(mappings);
                }
                catch (InvocationTargetException e) {
                    ImportLoggingHelper.displayError(SCMImportMessages.Author2ContributorMappingArea_31, e.getTargetException());
                    this.updateElements(mappings);
                }
                catch (InterruptedException interruptedException) {
                    this.updateElements(mappings);
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.updateElements(mappings);
            }
        }
    }

    public static final void createContributors(ITeamRepository reposiory, Collection<Author2ContributorMapping> mappings, IProgressMonitor monitor) throws InvocationTargetException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.Author2ContributorMappingArea_29, (int)(mappings.size() * 100));
        try {
            for (Author2ContributorMapping mapping : mappings) {
                if (mapping.getContributor() != null) continue;
                IContributor contributor = (IContributor)IContributor.ITEM_TYPE.createItem((Object)reposiory);
                contributor.setName(mapping.getContributorId());
                contributor.setEmailAddress(SCMImportMessages.Author2ContributorMappingArea_30);
                contributor.setUserId(mapping.getContributorId());
                mapping.setContributor(reposiory.contributorManager().saveContributor(contributor, (IProgressMonitor)progress.newChild(100)));
            }
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static boolean hasJazzAdminPermissions(ITeamRepository repository) {
        IPermissionService permissionService = (IPermissionService)((IClientLibraryContext)repository).getServiceInterface(IPermissionService.class);
        try {
            permissionService.assertPermission("JazzAdmins");
            return true;
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Author2ContributorSet
    extends AbstractSetWithListeners<Author2ContributorMapping> {
        private List<Author2ContributorMapping> elements = new ArrayList<Author2ContributorMapping>();

        public Author2ContributorSet(Collection<Author2ContributorMapping> authorMappings) {
            if (authorMappings != null) {
                for (Author2ContributorMapping author2ContributorMapping : authorMappings) {
                    this.elements.add(author2ContributorMapping);
                }
            }
        }

        protected Collection<Author2ContributorMapping> computeElements() {
            return this.elements;
        }

        public void remove(List list) {
            ArrayList<Author2ContributorMapping> removed = new ArrayList<Author2ContributorMapping>(list.size());
            for (Object object : list) {
                if (!(object instanceof Author2ContributorMapping)) continue;
                Author2ContributorMapping mapping = (Author2ContributorMapping)object;
                this.elements.remove(mapping);
                removed.add(mapping);
            }
            this.fireCollectionRemoved(removed);
        }

        public void addAuthor(String author, IContributor contributor) {
            Author2ContributorMapping mapping = new Author2ContributorMapping(author, contributor);
            this.elements.add(mapping);
            this.fireAdded(mapping);
        }

        public Author2ContributorMapping getMapping(String author) {
            if (author.length() == 0) {
                return null;
            }
            for (Author2ContributorMapping mapping : this.elements) {
                if (!mapping.getAuthorId().equals(author)) continue;
                return mapping;
            }
            return null;
        }

        public void addAll(List<Author2ContributorMapping> toAdd) {
            if (toAdd.isEmpty()) {
                return;
            }
            this.elements.addAll(toAdd);
            this.fireCollectionAdded(toAdd);
        }

        public boolean containsAuthor(String authorId) {
            return this.getAuthor(authorId) != null;
        }

        public Author2ContributorMapping getAuthor(String authorId) {
            for (Author2ContributorMapping mapping : this.elements) {
                if (!mapping.getAuthorId().equals(authorId)) continue;
                return mapping;
            }
            return null;
        }

        public void write(PrintStream out) {
            for (Author2ContributorMapping mapping : this.elements) {
                mapping.write(out);
            }
        }

        public void load(BufferedReader in) throws IOException {
            String line;
            final HashMap<String, Author2ContributorMapping> loaded = new HashMap<String, Author2ContributorMapping>();
            while ((line = in.readLine()) != null) {
                Author2ContributorMapping mapping = Author2ContributorMapping.createFrom(line);
                loaded.put(mapping.getAuthorId(), mapping);
            }
            try {
                Author2ContributorMappingArea.this.runnableContext.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        FetchContributorsFunction.fetchContributors(Author2ContributorMappingArea.this.configuration.getRepository(), loaded.values(), monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
            ArrayList<Author2ContributorMapping> added = new ArrayList<Author2ContributorMapping>();
            ArrayList<Author2ContributorMapping> changed = new ArrayList<Author2ContributorMapping>();
            for (Map.Entry entry : loaded.entrySet()) {
                Author2ContributorMapping mapping = (Author2ContributorMapping)entry.getValue();
                Author2ContributorMapping existing = this.getAuthor(mapping.getAuthorId());
                if (existing == null) {
                    this.elements.add(mapping);
                    added.add(mapping);
                    continue;
                }
                if (!existing.getContributorId().equals(mapping.getContributorId())) {
                    existing.setContributorId(mapping.getContributorId());
                    existing.setContributor(mapping.getContributor());
                    changed.add(existing);
                    continue;
                }
                if (existing.getContributor() != null) continue;
                existing.setContributor(mapping.getContributor());
                changed.add(existing);
            }
            if (!added.isEmpty()) {
                this.fireCollectionAdded(added);
            }
            if (!changed.isEmpty()) {
                Author2ContributorMappingArea.this.updateElements(changed);
            }
        }

        public List<Author2ContributorMapping> getElements() {
            return this.elements;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ContributorConversion
    extends SetTransformer<Author2ContributorMapping, ContributorWrapper> {
        public ContributorConversion(ISetWithListeners<Author2ContributorMapping> domain) {
            super(domain, true);
        }

        public final void fireEvent(Collection elementsThatChanged) {
            HashMap<Author2ContributorMapping, ContributorWrapper> newResults = new HashMap<Author2ContributorMapping, ContributorWrapper>();
            for (Object next : elementsThatChanged) {
                if (!(next instanceof Author2ContributorMapping)) continue;
                Author2ContributorMapping mapping = (Author2ContributorMapping)next;
                newResults.put(mapping, this.doComputeResult(mapping));
            }
            this.reportResults(newResults);
        }

        protected ContributorWrapper doComputeResult(Author2ContributorMapping element) {
            IContributor contributor = element.getContributor();
            if (contributor == null) {
                return null;
            }
            return new ContributorWrapper(contributor);
        }
    }

    private final class ContributorIdLabelProvider
    extends BaseLabelProvider {
        private ContributorIdLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            Author2ContributorMapping mapping;
            IContributor contributor;
            if (element instanceof Author2ContributorMapping && ((contributor = (mapping = (Author2ContributorMapping)element).getContributor()) != null || !mapping.getContributorId().equals(mapping.getAuthorId()))) {
                label.setText(mapping.getContributorId());
            }
        }

        public void fireLabelChange(Collection changed) {
            this.fireChangeEvent(changed);
        }
    }
}

