/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.repository.common.IContributor;
import java.io.PrintStream;
import org.eclipse.core.runtime.Assert;

public class Author2ContributorMapping {
    private final String authorId;
    private String contributorId;
    private IContributor contributor;

    public Author2ContributorMapping(String author, IContributor contributor) {
        this(author, contributor == null ? author : contributor.getUserId());
        this.contributor = contributor;
    }

    public Author2ContributorMapping(String authorId, String contributorId) {
        Assert.isNotNull((Object)authorId);
        Assert.isNotNull((Object)contributorId);
        this.authorId = authorId;
        this.contributorId = contributorId;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public String getContributorId() {
        return this.contributorId;
    }

    public void setContributor(IContributor contributor) {
        if (contributor == null) {
            this.contributor = null;
            this.contributorId = this.authorId;
        } else {
            this.contributor = contributor;
            this.contributorId = contributor.getUserId();
        }
    }

    public IContributor getContributor() {
        return this.contributor;
    }

    public void write(PrintStream out) {
        out.print(this.authorId);
        if (!this.contributorId.equals(this.authorId)) {
            out.print(",");
            out.print(this.contributorId);
        }
        out.println();
    }

    public static Author2ContributorMapping createFrom(String line) {
        if ((line = line.trim()).length() > 0) {
            String contributorId;
            String authorId;
            int index = line.indexOf(44);
            if (index == -1) {
                authorId = line;
                contributorId = line;
            } else {
                authorId = line.substring(0, index).trim();
                contributorId = line.substring(index + 1).trim();
            }
            return new Author2ContributorMapping(authorId, contributorId);
        }
        return null;
    }

    public void setContributorId(String contributorId) {
        if (!this.contributorId.equals(contributorId)) {
            this.contributorId = contributorId;
            this.contributor = null;
        }
    }
}

