/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.AbstractOptionsArea;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ArchiveFileOptions
extends AbstractOptionsArea {
    private Text filenameText;
    private Group fileGroup;
    private final ImportConfiguration configuration;
    private Button useTempArchiveOption;
    private Button useCustomFileOption;
    private Button browseButton;
    private Label filenameLabel;

    public ArchiveFileOptions(Composite parent, final ImportConfiguration configuration) {
        this.configuration = configuration;
        this.fileGroup = this.createGroup(parent, SCMImportMessages.ArchiveFileOptions_0, 3);
        if (!configuration.isImportFromArchive()) {
            this.useTempArchiveOption = new Button((Composite)this.fileGroup, 16);
            this.useTempArchiveOption.setText(SCMImportMessages.ArchiveFileOptions_1);
            GridData data = new GridData(4, 4, true, false);
            data.horizontalSpan = 3;
            this.useTempArchiveOption.setLayoutData((Object)data);
            this.useTempArchiveOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    configuration.setDeleteArchiveFile(ArchiveFileOptions.this.useTempArchiveOption.getSelection());
                }
            });
            this.useCustomFileOption = new Button((Composite)this.fileGroup, 16);
            this.useCustomFileOption.setText(SCMImportMessages.ArchiveFileOptions_2);
            data = new GridData(4, 4, true, false);
            data.horizontalSpan = 3;
            this.useCustomFileOption.setLayoutData((Object)data);
            this.useCustomFileOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    configuration.setDeleteArchiveFile(ArchiveFileOptions.this.useTempArchiveOption.getSelection());
                }
            });
        }
        this.filenameLabel = new Label((Composite)this.fileGroup, 0);
        this.filenameLabel.setText(SCMImportMessages.ArchiveFileOptions_3);
        this.filenameLabel.setLayoutData((Object)new GridData(4, 2, false, false));
        this.filenameText = new Text((Composite)this.fileGroup, 2052);
        this.filenameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.filenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                configuration.setArchiveFilename(ArchiveFileOptions.this.filenameText.getText());
            }
        });
        this.browseButton = new Button((Composite)this.fileGroup, 8);
        this.browseButton.setText(SCMImportMessages.ArchiveFileOptions_4);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveFileOptions.this.promptForFile();
            }
        });
        this.browseButton.setLayoutData((Object)new GridData(4, 4, false, false));
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("deleteArchiveFile") && !configuration.isDeleteArchiveFile() && ArchiveFileOptions.this.useTempArchiveOption.getSelection()) {
                    ArchiveFileOptions.this.useTempArchiveOption.setSelection(false);
                    ArchiveFileOptions.this.useCustomFileOption.setSelection(true);
                }
                ArchiveFileOptions.this.updateEnablements();
            }
        };
        configuration.addPropertyChangeListener(propertyChangeListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                configuration.removePropertyChangeListener(propertyChangeListener);
            }
        });
        this.updateEnablements();
    }

    public void initControls() {
        this.filenameText.setText(this.configuration.getArchiveFilename());
        if (this.useTempArchiveOption != null) {
            this.useTempArchiveOption.setSelection(this.configuration.isDeleteArchiveFile());
            this.useCustomFileOption.setSelection(!this.configuration.isDeleteArchiveFile());
        }
    }

    protected void updateEnablements() {
        this.enableGroup(this.fileGroup, this.isEnabled() && this.configuration.isImportFullHistory());
        if (this.isEnabled() && this.configuration.isImportFullHistory() && this.useTempArchiveOption != null) {
            if (this.configuration.isDeleteArchiveFile()) {
                this.filenameLabel.setEnabled(false);
                this.filenameText.setEnabled(false);
                this.browseButton.setEnabled(false);
            } else if (!this.configuration.isImportIntoWorkspace()) {
                this.useTempArchiveOption.setEnabled(false);
            }
        }
    }

    private void promptForFile() {
        FileDialog dialog = new FileDialog(this.fileGroup.getShell(), this.configuration.isImportFromArchive() ? 4096 : 8192);
        dialog.setFileName(this.filenameText.getText());
        dialog.setFilterExtensions(new String[]{"*.tar"});
        dialog.setFilterNames(new String[]{SCMImportMessages.ArchiveFileOptions_6});
        String path = dialog.open();
        if (path != null) {
            this.filenameText.setText(path);
        }
    }
}

